/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.collect.Maps;
import java.util.HashMap;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.entity.EntityRendererRegister;
import net.narutomod.entity.EntityScalableProjectile;
import net.narutomod.event.EventSetBlocks;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureAoeCommand;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntitySuitonShark
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 193;
    public static final int ENTITYID_RANGED = 194;

    public EntitySuitonShark(ElementsNarutomodMod instance) {
        super(instance, 453);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "suiton_shark"), 193).name("suiton_shark").tracker(64, 3, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        new Renderer().register();
    }

    public static class Renderer
    extends EntityRendererRegister {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void register() {
            RenderingRegistry.registerEntityRenderingHandler(EC.class, renderManager -> new RenderCustom(renderManager));
        }

        @SideOnly(value=Side.CLIENT)
        public class ModelShark
        extends ModelBase {
            private final ModelRenderer body;
            private final ModelRenderer head;
            private final ModelRenderer foreHead;
            private final ModelRenderer jaw;
            private final ModelRenderer tail;
            private final ModelRenderer tailFin;
            private final ModelRenderer tailFinUpper;
            private final ModelRenderer tailFinLower;
            private final ModelRenderer backFin;
            private final ModelRenderer leftFin;
            private final ModelRenderer rightFin;

            public ModelShark() {
                this.field_78090_t = 64;
                this.field_78089_u = 64;
                this.body = new ModelRenderer((ModelBase)this);
                this.body.func_78793_a(0.0f, 0.0f, -5.0f);
                this.body.field_78804_l.add(new ModelBox(this.body, 0, 0, -4.0f, -7.0f, 0.0f, 8, 7, 13, 0.0f, false));
                this.head = new ModelRenderer((ModelBase)this);
                this.head.func_78793_a(0.0f, -3.0f, 0.0f);
                this.body.func_78792_a(this.head);
                this.foreHead = new ModelRenderer((ModelBase)this);
                this.foreHead.func_78793_a(0.0f, -3.5f, 0.0f);
                this.head.func_78792_a(this.foreHead);
                this.setRotationAngle(this.foreHead, 0.1745f, 0.0f, 0.0f);
                this.foreHead.field_78804_l.add(new ModelBox(this.foreHead, 19, 20, -4.0f, 0.0f, -6.0f, 8, 4, 6, 0.0f, false));
                this.jaw = new ModelRenderer((ModelBase)this);
                this.jaw.func_78793_a(0.0f, 1.5f, 0.25f);
                this.head.func_78792_a(this.jaw);
                this.jaw.field_78804_l.add(new ModelBox(this.jaw, 29, 0, -3.5f, -1.5f, -4.75f, 7, 2, 5, 0.0f, false));
                this.tail = new ModelRenderer((ModelBase)this);
                this.tail.func_78793_a(0.0f, -3.5f, 13.0f);
                this.body.func_78792_a(this.tail);
                this.tail.field_78804_l.add(new ModelBox(this.tail, 0, 20, -2.0f, -2.5f, -1.0f, 4, 5, 11, 0.0f, false));
                this.tailFin = new ModelRenderer((ModelBase)this);
                this.tailFin.func_78793_a(0.0f, -0.5f, 8.0f);
                this.tail.func_78792_a(this.tailFin);
                this.tailFinUpper = new ModelRenderer((ModelBase)this);
                this.tailFinUpper.func_78793_a(0.0f, -1.0f, 1.0f);
                this.tailFin.func_78792_a(this.tailFinUpper);
                this.setRotationAngle(this.tailFinUpper, -0.6109f, 0.0f, 0.0f);
                this.tailFinUpper.field_78804_l.add(new ModelBox(this.tailFinUpper, 0, 20, -0.5f, -6.9924f, -1.1743f, 1, 8, 3, 0.0f, false));
                this.tailFinLower = new ModelRenderer((ModelBase)this);
                this.tailFinLower.func_78793_a(0.0f, 1.0f, 1.0f);
                this.tailFin.func_78792_a(this.tailFinLower);
                this.setRotationAngle(this.tailFinLower, 0.5236f, 0.0f, 0.0f);
                this.tailFinLower.field_78804_l.add(new ModelBox(this.tailFinLower, 0, 36, -0.5f, -1.4924f, -1.0403f, 1, 6, 3, 0.0f, false));
                this.backFin = new ModelRenderer((ModelBase)this);
                this.backFin.func_78793_a(0.0f, -6.0f, 6.0f);
                this.body.func_78792_a(this.backFin);
                this.setRotationAngle(this.backFin, -0.5236f, 0.0f, 0.0f);
                this.backFin.field_78804_l.add(new ModelBox(this.backFin, 0, 0, -0.5f, -7.75f, -1.5f, 1, 8, 4, 0.0f, false));
                this.leftFin = new ModelRenderer((ModelBase)this);
                this.leftFin.func_78793_a(3.0f, -3.0f, 8.0f);
                this.body.func_78792_a(this.leftFin);
                this.setRotationAngle(this.leftFin, 0.9599f, 0.0f, 1.8675f);
                this.leftFin.field_78804_l.add(new ModelBox(this.leftFin, 32, 34, 0.0f, -4.0f, -1.5f, 1, 4, 7, 0.0f, false));
                this.rightFin = new ModelRenderer((ModelBase)this);
                this.rightFin.func_78793_a(-3.0f, -3.0f, 8.0f);
                this.body.func_78792_a(this.rightFin);
                this.setRotationAngle(this.rightFin, 0.9599f, 0.0f, -1.8675f);
                this.rightFin.field_78804_l.add(new ModelBox(this.rightFin, 32, 34, -1.0f, -4.0f, -1.5f, 1, 4, 7, 0.0f, false));
            }

            public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
                this.body.func_78785_a(f5);
            }

            public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
                modelRenderer.field_78795_f = x;
                modelRenderer.field_78796_g = y;
                modelRenderer.field_78808_h = z;
            }

            public void func_78087_a(float f, float f1, float f2, float f3, float f4, float f5, Entity e) {
                super.func_78087_a(f, f1, f2, f3, f4, f5, e);
                this.tail.field_78796_g = MathHelper.func_76134_b((float)(f * 0.6662f)) * 0.4f * f1;
                this.tailFin.field_78796_g = MathHelper.func_76134_b((float)(f * 0.6662f)) * 0.4f * f1;
                this.foreHead.field_78795_f = 0.1745f - f4 * 0.4363f;
                this.jaw.field_78795_f = f4 * 0.5236f;
            }
        }

        @SideOnly(value=Side.CLIENT)
        public class RenderCustom
        extends Render<EC> {
            private final ResourceLocation TEXTURE;
            private final ModelShark model;

            public RenderCustom(RenderManager renderManager) {
                super(renderManager);
                this.TEXTURE = new ResourceLocation("narutomod:textures/shark.png");
                this.model = new ModelShark();
                this.field_76989_e = 0.5f;
            }

            public void doRender(EC entity, double x, double y, double z, float yaw, float pt) {
                float f5 = entity.getPrevLSA() + (entity.getLSA() - entity.getPrevLSA()) * pt;
                float f6 = entity.getLS() - entity.getLSA() * (1.0f - pt);
                this.model.func_78087_a(f6, f5, (float)entity.field_70173_aa + pt, 0.0f, entity.getMOA(), 0.0625f, entity);
                this.func_180548_c(entity);
                GlStateManager.func_179094_E();
                float scale = entity.getEntityScale();
                GlStateManager.func_179137_b((double)x, (double)y, (double)z);
                GlStateManager.func_179114_b((float)(-entity.field_70126_B - MathHelper.func_76142_g((float)(entity.field_70177_z - entity.field_70126_B)) * pt), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * pt - 180.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179140_f();
                this.model.func_78088_a(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                GlStateManager.func_179145_e();
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }

            protected ResourceLocation getEntityTexture(EC entity) {
                return this.TEXTURE;
            }
        }
    }

    public static class EC
    extends EntityScalableProjectile.Base {
        private static final DataParameter<Float> PREVLSA = EntityDataManager.func_187226_a(EC.class, (DataSerializer)DataSerializers.field_187193_c);
        private static final DataParameter<Float> LSA = EntityDataManager.func_187226_a(EC.class, (DataSerializer)DataSerializers.field_187193_c);
        private static final DataParameter<Float> LS = EntityDataManager.func_187226_a(EC.class, (DataSerializer)DataSerializers.field_187193_c);
        private static final DataParameter<Float> MOUTHOPENAMOUNT = EntityDataManager.func_187226_a(EC.class, (DataSerializer)DataSerializers.field_187193_c);
        private final int wait = 30;
        private final int mouthOpenTime = 20;
        private float fullScale;
        private Entity target;
        private float health;

        public EC(World a) {
            super(a);
            this.setOGSize(1.0f, 0.5f);
            this.setWaterSlowdown(1.0f);
            this.field_70178_ae = true;
        }

        public EC(EntityLivingBase shooter, float power) {
            super(shooter);
            this.setOGSize(1.0f, 0.5f);
            this.setWaitPosition();
            this.setEntityScale(0.2f);
            this.fullScale = power;
            this.health = power * 20.0f;
            this.setWaterSlowdown(1.0f);
            this.field_70178_ae = true;
        }

        @Override
        protected void func_70088_a() {
            super.func_70088_a();
            this.func_184212_Q().func_187214_a(PREVLSA, (Object)Float.valueOf(0.0f));
            this.func_184212_Q().func_187214_a(LSA, (Object)Float.valueOf(0.0f));
            this.func_184212_Q().func_187214_a(LS, (Object)Float.valueOf(0.0f));
            this.func_184212_Q().func_187214_a(MOUTHOPENAMOUNT, (Object)Float.valueOf(0.0f));
        }

        public float getPrevLSA() {
            return ((Float)this.func_184212_Q().func_187225_a(PREVLSA)).floatValue();
        }

        public void setPrevLSA(float f) {
            this.func_184212_Q().func_187227_b(PREVLSA, (Object)Float.valueOf(f));
        }

        public float getLSA() {
            return ((Float)this.func_184212_Q().func_187225_a(LSA)).floatValue();
        }

        public void setLSA(float f) {
            this.func_184212_Q().func_187227_b(LSA, (Object)Float.valueOf(f));
        }

        public float getLS() {
            return ((Float)this.func_184212_Q().func_187225_a(LS)).floatValue();
        }

        public void setLS(float f) {
            this.func_184212_Q().func_187227_b(LS, (Object)Float.valueOf(f));
        }

        public float getMOA() {
            return ((Float)this.func_184212_Q().func_187225_a(MOUTHOPENAMOUNT)).floatValue();
        }

        public void setMOA(float f) {
            this.func_184212_Q().func_187227_b(MOUTHOPENAMOUNT, (Object)Float.valueOf(f));
        }

        private void setWaitPosition() {
            Vec3d vec = this.shootingEntity.func_70040_Z().func_186678_a(2.0).func_178787_e(this.shootingEntity.func_174824_e(1.0f));
            this.func_70012_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, this.shootingEntity.field_70759_as, this.shootingEntity.field_70125_A);
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            if (this.shootingEntity != null) {
                if (!this.isLaunched() && !this.func_184207_aI()) {
                    this.setWaitPosition();
                }
                if (this.ticksAlive <= this.wait) {
                    float f = this.ticksAlive;
                    ((Object)((Object)this)).getClass();
                    this.setEntityScale(this.fullScale * MathHelper.func_76131_a((float)(f / 30.0f), (float)0.2f, (float)1.0f));
                    if (this.field_70170_p instanceof WorldServer) {
                        ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.WATER_WAKE, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v, 10, (double)(this.field_70130_N / 2.0f), (double)(this.field_70131_O / 2.0f), (double)(this.field_70130_N / 2.0f), 0.0, new int[0]);
                    }
                } else {
                    if (this.target != null) {
                        Vec3d vec = this.target.func_174824_e(1.0f).func_178788_d(this.func_174791_d());
                        this.func_70186_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, this.func_70090_H() ? 0.85f : 0.8f, 0.0f);
                    } else {
                        this.target = this.shootingEntity instanceof EntityLiving ? ((EntityLiving)this.shootingEntity).func_70638_az() : ProcedureUtils.objectEntityLookingAt((Entity)this.shootingEntity, (double)50.0, (Entity)this).field_72308_g;
                        Vec3d vec = this.target != null ? this.target.func_174824_e(1.0f).func_178788_d(this.func_174791_d()) : this.shootingEntity.func_70040_Z();
                        this.func_70186_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, this.func_70090_H() ? 0.9f : 0.85f, 0.0f);
                    }
                    if (this.ticksAlive <= this.wait + this.mouthOpenTime) {
                        float f = this.ticksAlive - this.wait;
                        ((Object)((Object)this)).getClass();
                        this.setMOA(f / 20.0f);
                    }
                }
            }
            this.updateLimbSwing();
            if (!(this.field_70170_p.field_72995_K || this.ticksInAir <= 120 && this.shootingEntity != null && this.shootingEntity.func_70089_S())) {
                this.func_70106_y();
            }
        }

        private void updateLimbSwing() {
            if (!this.field_70170_p.field_72995_K) {
                this.setPrevLSA(this.getLSA());
                double d5 = this.field_70165_t - this.field_70169_q;
                double d7 = this.field_70161_v - this.field_70166_s;
                double d9 = this.field_70163_u - this.field_70167_r;
                float f10 = MathHelper.func_76133_a((double)(d5 * d5 + d9 * d9 + d7 * d7)) * 4.0f;
                if (f10 > 1.0f) {
                    f10 = 1.0f;
                }
                this.setLSA(this.getLSA() + (f10 - this.getLSA()) * 0.4f);
                this.setLS(this.getLS() + this.getLSA());
            }
        }

        @Override
        public void renderParticles() {
            if (this.field_70170_p instanceof WorldServer) {
                ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.WATER_DROP, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v, 100, (double)(this.field_70130_N / 2.0f), (double)(this.field_70131_O / 2.0f), (double)(this.field_70130_N / 2.0f), 0.0, new int[0]);
            }
        }

        @Override
        protected void onImpact(RayTraceResult result) {
            if (result.field_72308_g != null && result.field_72308_g.equals((Object)this.shootingEntity)) {
                return;
            }
            if (result.field_72313_a == RayTraceResult.Type.BLOCK && this.fullScale >= 2.0f && this.ticksInAir <= 15) {
                return;
            }
            if (!this.field_70170_p.field_72995_K && (result.field_72313_a == RayTraceResult.Type.BLOCK || result.field_72308_g != null && result.field_72308_g.equals((Object)this.target))) {
                float size = this.getEntityScale();
                ProcedureAoeCommand.set(this, 0.0, size).exclude((Entity)this.shootingEntity).damageEntities(ItemJutsu.causeJutsuDamage(this, this.shootingEntity), size * (this.func_70090_H() ? 24.0f : 16.0f));
                this.field_70170_p.func_72885_a((Entity)this.shootingEntity, this.field_70165_t, this.field_70163_u, this.field_70161_v, size * 2.0f, false, ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this.shootingEntity));
                HashMap map = Maps.newHashMap();
                for (BlockPos pos : ProcedureUtils.getAllAirBlocks(this.field_70170_p, this.func_174813_aQ().func_191195_a(0.0, (double)(this.field_70131_O - 1.0f), 0.0))) {
                    map.put(pos, Blocks.field_150358_i.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(1)));
                }
                new EventSetBlocks(this.field_70170_p, map, 0L, 10, false, false);
                this.func_70106_y();
            }
        }

        @Override
        protected void checkOnGround() {
        }

        public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
            if (this.fullScale >= 2.0f && this.ticksInAir <= 10) {
                return player.func_184220_m((Entity)this);
            }
            return false;
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (this.fullScale >= 4.0f && ItemJutsu.isDamageSourceNinjutsu(source)) {
                this.setEntityScale(this.getEntityScale() + amount * 0.013333f);
                if (source.func_76364_f() != null && !(source.func_76364_f() instanceof EntityLivingBase)) {
                    source.func_76364_f().func_70106_y();
                }
                return false;
            }
            if (this.fullScale >= 1.0f) {
                this.health -= amount;
                if (this.health <= 0.0f) {
                    this.func_70106_y();
                }
                return true;
            }
            return super.func_70097_a(source, amount);
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                return power >= 1.0f ? this.createJutsu(entity, power) : false;
            }

            public boolean createJutsu(EntityLivingBase entity, float power) {
                if (!entity.func_70055_a(Material.field_151586_h)) {
                    entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:suikodannojutsu")), SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                entity.field_70170_p.func_72838_d((Entity)new EC(entity, power));
                return true;
            }
        }
    }
}

