/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.Particles;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntitySummonAnimal
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 364;
    public static final int ENTITYID_RANGED = 365;

    public EntitySummonAnimal(ElementsNarutomodMod instance) {
        super(instance, 726);
    }

    public static class NavigateGround
    extends PathNavigateGround {
        private Base navigatingEntity;

        public NavigateGround(Base entityLivingIn, World worldIn) {
            super((EntityLiving)entityLivingIn, worldIn);
            this.navigatingEntity = entityLivingIn;
        }

        protected PathFinder func_179679_a() {
            this.field_179695_a = new WalkNodeProcessor(){

                protected PathNodeType func_189553_b(IBlockAccess world, int x, int y, int z) {
                    PathNodeType nodetype = super.func_189553_b(world, x, y, z);
                    if (nodetype != PathNodeType.OPEN && navigatingEntity.couldBreakBlocks() && Base.canBreakList.contains(world.func_180495_p(new BlockPos(x, y, z)).func_185904_a())) {
                        return PathNodeType.OPEN;
                    }
                    return nodetype;
                }
            };
            return new PathFinder(this.field_179695_a);
        }
    }

    public static abstract class Base
    extends EntityCreature {
        protected static final List<Material> canBreakList = Lists.newArrayList((Object[])new Material[]{Material.field_151575_d, Material.field_151570_A, Material.field_151592_s, Material.field_151584_j, Material.field_151585_k, Material.field_151597_y, Material.field_151582_l, Material.field_151569_G});
        protected static final DataParameter<Float> SCALE = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187193_c);
        protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187192_b);
        protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187203_m);
        protected int ageTicks;
        protected int lifeSpan = 1200;
        protected float ogWidth;
        protected float ogHeight;

        public Base(World w) {
            super(w);
            this.func_110163_bv();
        }

        public Base(EntityLivingBase summonerIn) {
            this(summonerIn.field_70170_p);
            this.setSummoner(summonerIn);
            this.dontWander(true);
            this.func_110163_bv();
        }

        public void func_70088_a() {
            super.func_70088_a();
            this.func_184212_Q().func_187214_a(SCALE, (Object)Float.valueOf(1.0f));
            this.func_184212_Q().func_187214_a(AGE, (Object)0);
            this.func_184212_Q().func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
        }

        public void setScale(float f) {
            this.func_184212_Q().func_187227_b(SCALE, (Object)Float.valueOf(f));
            this.postScaleFixup();
        }

        public float getScale() {
            return ((Float)this.func_184212_Q().func_187225_a(SCALE)).floatValue();
        }

        private void setAge(int age) {
            this.func_184212_Q().func_187227_b(AGE, (Object)age);
            this.ageTicks = age;
        }

        public int getAge() {
            return this.field_70170_p.field_72995_K ? (Integer)this.func_184212_Q().func_187225_a(AGE) : this.ageTicks;
        }

        public void func_184206_a(DataParameter<?> key) {
            super.func_184206_a(key);
            if (SCALE.equals(key) && this.field_70170_p.field_72995_K) {
                float scale = this.getScale();
                this.func_70105_a(this.ogWidth * scale, this.ogHeight * scale);
            }
        }

        @Nullable
        public UUID getOwnerId() {
            return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
        }

        public void setOwnerId(@Nullable UUID p_184754_1_) {
            this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)p_184754_1_));
        }

        public boolean hasSummoner() {
            return this.getOwnerId() != null;
        }

        protected void setOGSize(float width, float height) {
            this.ogWidth = width;
            this.ogHeight = height;
            this.func_70105_a(width, height);
        }

        protected void func_110147_ax() {
            super.func_110147_ax();
            this.func_110140_aT().func_111150_b(ProcedureUtils.MAXHEALTH);
            this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        }

        public IAttributeInstance func_110148_a(IAttribute attribute) {
            return super.func_110148_a(attribute == SharedMonsterAttributes.field_111267_a ? ProcedureUtils.MAXHEALTH : attribute);
        }

        protected void postScaleFixup() {
            float f = this.getScale();
            float f1 = this.ogHeight * f;
            this.func_70105_a(this.ogWidth * f, f1);
            if (f1 > 2.0f) {
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)(f1 - 2.0f));
            }
            this.func_70606_j(this.func_110138_aP());
        }

        public void setSummoner(EntityLivingBase player) {
            this.setOwnerId(player.func_110124_au());
        }

        @Nullable
        public EntityLivingBase getSummoner() {
            UUID uuid = this.getOwnerId();
            if (uuid == null) {
                return null;
            }
            Entity entity = ProcedureUtils.getEntityFromUUID(this.field_70170_p, uuid);
            if (entity instanceof EntityLivingBase) {
                return (EntityLivingBase)entity;
            }
            return null;
        }

        public boolean isSummoner(Entity entityIn) {
            return entityIn.func_110124_au().equals(this.getOwnerId());
        }

        public boolean func_184191_r(Entity entityIn) {
            return this.isSummoner(entityIn) || super.func_184191_r(entityIn);
        }

        protected boolean func_70692_ba() {
            return false;
        }

        protected Item func_146068_u() {
            return null;
        }

        protected void func_70619_bc() {
            super.func_70619_bc();
            EntityLivingBase owner = this.getSummoner();
            if (owner != null) {
                EntityLivingBase target = owner.func_70643_av();
                if (target == null) {
                    target = owner.func_110144_aD();
                }
                if (target != null && !target.equals((Object)this)) {
                    this.func_70624_b(target);
                }
                if ((target = this.func_70638_az()) != null && !target.func_70089_S()) {
                    this.func_70624_b(null);
                }
            }
        }

        protected abstract void dontWander(boolean var1);

        public boolean func_184645_a(EntityPlayer entity, EnumHand hand) {
            if (!this.field_70170_p.field_72995_K && this.isSummoner((Entity)entity)) {
                return this.canSitOnShoulder() ? this.func_184220_m((Entity)entity) : entity.func_184220_m((Entity)this);
            }
            return super.func_184645_a(entity, hand);
        }

        public boolean canSitOnShoulder() {
            return false;
        }

        public boolean shouldDismountInWater(Entity rider) {
            return false;
        }

        @Nullable
        public Entity func_184179_bs() {
            return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
        }

        public boolean func_184220_m(Entity entityIn) {
            if (entityIn instanceof EntityPlayer && this.field_70170_p instanceof WorldServer) {
                if (entityIn.func_184188_bt().size() < 2 && this.func_184205_a(entityIn, true)) {
                    ((WorldServer)this.field_70170_p).func_73039_n().func_151247_a((Entity)this, (Packet)new SPacketSetPassengers(entityIn));
                    return true;
                }
                return false;
            }
            return super.func_184220_m(entityIn);
        }

        public void func_70107_b(double x, double y, double z) {
            if (this.func_184187_bx() instanceof EntityPlayer) {
                EntityLivingBase riding = (EntityLivingBase)this.func_184187_bx();
                Vec3d[] vec = new Vec3d[]{new Vec3d(0.4, riding.func_70042_X(), 0.0), new Vec3d(-0.4, riding.func_70042_X(), 0.0)};
                Vec3d vec1 = vec[riding.func_184188_bt().indexOf((Object)this)].func_178785_b(-riding.field_70761_aq * ((float)Math.PI / 180)).func_178787_e(riding.func_174791_d());
                x = vec1.field_72450_a;
                y = vec1.field_72448_b;
                z = vec1.field_72449_c;
            }
            super.func_70107_b(x, y, z);
        }

        public boolean couldBreakBlocks() {
            return false;
        }

        public void func_70091_d(MoverType type, double x, double y, double z) {
            if (this.couldBreakBlocks()) {
                for (BlockPos pos : ProcedureUtils.getNonAirBlocks(this.field_70170_p, this.func_174813_aQ().func_186662_g(0.5).func_72321_a(x, y, z), true)) {
                    if (!canBreakList.contains(this.field_70170_p.func_180495_p(pos).func_185904_a())) continue;
                    this.field_70170_p.func_175655_b(pos, this.field_70146_Z.nextFloat() < 0.3f);
                    x *= 0.98;
                    y *= 0.98;
                    z *= 0.98;
                }
            }
            super.func_70091_d(type, x, y, z);
        }

        public void func_191986_a(float ti, float tj, float tk) {
            if (this.func_184218_aH()) {
                Entity entity = this.func_184187_bx();
                float f = this.field_70759_as - this.field_70177_z;
                this.field_70177_z = entity.field_70177_z;
                this.field_70125_A = entity.field_70125_A;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = MathHelper.func_76142_g((float)(this.field_70177_z + f));
                this.field_70761_aq = entity.field_70177_z;
                super.func_191986_a(0.0f, 0.0f, 0.0f);
            } else {
                super.func_191986_a(ti, tj, tk);
            }
        }

        public Vec3d func_70040_Z() {
            return this.func_174806_f(this.field_70125_A, this.field_70759_as);
        }

        public boolean func_70652_k(Entity entityIn) {
            return ProcedureUtils.attackEntityAsMob((EntityLivingBase)this, entityIn);
        }

        public boolean func_70104_M() {
            return super.func_70104_M() && this.getScale() < 4.0f;
        }

        protected boolean func_184219_q(Entity passenger) {
            EntityLivingBase owner = this.getSummoner();
            return this.getScale() >= 4.0f && this.func_184188_bt().size() < 1 && owner != null && (passenger.equals((Object)owner) || passenger.func_184191_r((Entity)owner));
        }

        protected void func_82167_n(Entity entityIn) {
            this.func_70108_f(entityIn);
        }

        public void func_70108_f(Entity entity) {
            double d3;
            double d2;
            double d4;
            if (this.getScale() < 4.0f) {
                super.func_70108_f(entity);
            } else if (!this.func_184223_x(entity) && !entity.field_70145_X && !entity.func_184207_aI() && (d4 = MathHelper.func_76132_a((double)(d2 = entity.field_70165_t - this.field_70165_t), (double)(d3 = entity.field_70161_v - this.field_70161_v))) >= 0.01) {
                d4 = MathHelper.func_76133_a((double)d4);
                d2 /= d4;
                d3 /= d4;
                double d5 = d4 >= 1.0 ? 1.0 / d4 : 1.0;
                entity.field_70159_w = d2 *= d5 * 0.05;
                entity.field_70179_y = d3 *= d5 * 0.05;
                entity.field_70160_al = true;
            }
        }

        public boolean func_184652_a(EntityPlayer player) {
            return player == this.getSummoner() && !this.func_110167_bD();
        }

        public void func_70106_y() {
            super.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:poof")), 2.0f, 1.0f);
                Particles.spawnParticle(this.field_70170_p, Particles.Types.SMOKE, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v, 300, (double)this.field_70130_N * 0.5, (double)this.field_70131_O * 0.3, (double)this.field_70130_N * 0.5, 0.0, 0.0, 0.0, -788529153, 15 + (int)(this.getScale() * 5.0f) + this.field_70146_Z.nextInt(16));
            }
        }

        protected void func_70609_aI() {
            this.func_70106_y();
        }

        public void func_70636_d() {
            this.func_82168_bl();
            super.func_70636_d();
        }

        public void func_70071_h_() {
            super.func_70071_h_();
            int age = this.getAge();
            if (!this.field_70170_p.field_72995_K) {
                EntityLivingBase owner = this.getSummoner();
                if (owner != null && owner.func_110143_aJ() <= 0.0f) {
                    this.func_70609_aI();
                }
                if (this instanceof IMob && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                    this.func_70106_y();
                }
                if (age > this.lifeSpan) {
                    this.func_70609_aI();
                }
            }
            this.setAge(age + 1);
        }

        public void func_70037_a(NBTTagCompound compound) {
            super.func_70037_a(compound);
            this.setAge(compound.func_74762_e("ageTicks"));
            this.lifeSpan = compound.func_74762_e("lifeSpan");
            this.setScale(compound.func_74760_g("scale"));
            String s = compound.func_74779_i("OwnerUUID");
            if (!s.isEmpty()) {
                this.setOwnerId(UUID.fromString(s));
            }
        }

        public void func_70014_b(NBTTagCompound compound) {
            super.func_70014_b(compound);
            compound.func_74768_a("ageTicks", this.getAge());
            compound.func_74768_a("lifeSpan", this.lifeSpan);
            compound.func_74776_a("scale", this.getScale());
            compound.func_74778_a("OwnerUUID", this.getOwnerId() == null ? "" : this.getOwnerId().toString());
        }
    }
}

