/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.Particles;
import net.narutomod.PlayerTracker;
import net.narutomod.item.ItemChokuto;
import net.narutomod.item.ItemJutsu;
import net.narutomod.item.ItemSharingan;
import net.narutomod.item.ItemShuriken;
import net.narutomod.item.ItemTotsukaSword;
import net.narutomod.procedure.ProcedureSusanoo;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public abstract class EntitySusanooBase
extends EntityCreature
implements IRangedAttackMob {
    private static final DataParameter<Integer> OWNER_ID = EntityDataManager.func_187226_a(EntitySusanooBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> FLAME_COLOR = EntityDataManager.func_187226_a(EntitySusanooBase.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final double BXP_REQUIRED_L0 = 2000.0;
    public static final double BXP_REQUIRED_L1 = 5000.0;
    public static final double BXP_REQUIRED_L2 = 10000.0;
    public static final double BXP_REQUIRED_L3 = 20000.0;
    public static final double BXP_REQUIRED_L4 = 36000.0;
    protected double chakraUsage = 30.0;
    protected double chakraUsageModifier = 2.0;
    protected double playerXp;

    public EntitySusanooBase(World world) {
        super(world);
        this.field_70728_aV = 5;
        this.field_70178_ae = true;
        this.field_70138_W = 0.5f;
        this.func_94061_f(true);
        this.func_110163_bv();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    public EntitySusanooBase(EntityLivingBase player) {
        this(player.field_70170_p);
        ItemStack helmetstack;
        this.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, 0.0f);
        this.setOwnerPlayer(player);
        if (player instanceof EntityPlayer) {
            this.playerXp = PlayerTracker.getBattleXp((EntityPlayer)player);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)MathHelper.func_76133_a((double)this.playerXp));
        }
        if ((helmetstack = player.func_184582_a(EntityEquipmentSlot.HEAD)).func_77973_b() instanceof ItemSharingan.Base) {
            int color;
            if (ProcedureUtils.isOriginalOwner(player, helmetstack)) {
                this.chakraUsageModifier = 1.0;
            }
            if ((color = ((ItemSharingan.Base)helmetstack.func_77973_b()).func_82814_b(helmetstack)) != 0) {
                this.setFlameColor(color);
            }
        }
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(ProcedureUtils.getModifiedSpeed(player) * 0.3);
        this.func_70606_j(this.func_110138_aP());
        this.func_174805_g(false);
        player.func_184220_m((Entity)this);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_ID, (Object)-1);
        this.field_70180_af.func_187214_a(FLAME_COLOR, (Object)539760701);
    }

    @Nullable
    public EntityLivingBase getOwnerPlayer() {
        Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(OWNER_ID)).intValue());
        return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
    }

    protected void setOwnerPlayer(EntityLivingBase owner) {
        this.field_70180_af.func_187227_b(OWNER_ID, (Object)owner.func_145782_y());
    }

    protected void setFlameColor(int color) {
        this.field_70180_af.func_187227_b(FLAME_COLOR, (Object)color);
    }

    public int getFlameColor() {
        return (Integer)this.field_70180_af.func_187225_a(FLAME_COLOR);
    }

    public abstract boolean shouldShowSword();

    public abstract void setShowSword(boolean var1);

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEFINED;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected boolean func_146066_aG() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(ProcedureUtils.MAXHEALTH);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110140_aT().func_111150_b(EntityPlayer.REACH_DISTANCE);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.05);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111128_a(7.0);
    }

    public IAttributeInstance func_110148_a(IAttribute attribute) {
        return super.func_110148_a(attribute == SharedMonsterAttributes.field_111267_a ? ProcedureUtils.MAXHEALTH : attribute);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76364_f() instanceof EntityPlayer && source.func_76364_f().equals((Object)this.func_184179_bs())) {
            return false;
        }
        if (source.func_76364_f() instanceof EntityCreature && source.func_76364_f().equals((Object)this)) {
            return false;
        }
        if (source.func_76364_f() instanceof EntityArrow) {
            return false;
        }
        if (source.func_76364_f() instanceof EntityPotion) {
            return false;
        }
        if (source == DamageSource.field_76379_h) {
            return false;
        }
        if (source == DamageSource.field_76367_g) {
            return false;
        }
        if (source == DamageSource.field_76369_e) {
            return false;
        }
        if (source == DamageSource.field_76376_m) {
            return false;
        }
        if (source == DamageSource.field_82727_n) {
            return false;
        }
        if (source == ProcedureUtils.AMATERASU) {
            return false;
        }
        float f = this.func_110143_aJ();
        boolean flag = super.func_70097_a(source, amount);
        EntityLivingBase summoner = this.getOwnerPlayer();
        if (flag && summoner != null && !this.func_70089_S()) {
            summoner.func_70097_a(source, CombatRules.func_189427_a((float)amount, (float)this.func_70658_aO(), (float)0.0f) - f);
        }
        return flag;
    }

    public boolean func_70652_k(Entity entityIn) {
        Entity passenger = this.func_184179_bs();
        if (passenger instanceof EntityLivingBase) {
            boolean flag;
            float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            float f2 = 1.0f;
            if (passenger instanceof EntityPlayer) {
                f2 = ((EntityPlayer)passenger).func_184825_o(0.5f);
                ((EntityPlayer)passenger).func_184821_cY();
            }
            f *= f2;
            ItemStack stack = this.func_184582_a(EntityEquipmentSlot.MAINHAND);
            DamageSource ds = ItemJutsu.causeJutsuDamage((Entity)this, this.getOwnerPlayer());
            if (stack.func_77973_b() == ItemTotsukaSword.block && entityIn instanceof EntityLivingBase && Chakra.pathway((EntityLivingBase)entityIn).getAmount() < 5.0) {
                ds = ds.func_151518_m().func_76348_h();
                f *= 2.0f + this.field_70146_Z.nextFloat();
            }
            if ((flag = entityIn.func_70097_a(ds, f)) && entityIn instanceof EntityLivingBase) {
                if (!stack.func_190926_b()) {
                    stack.func_77973_b().func_77644_a(stack, (EntityLivingBase)entityIn, (EntityLivingBase)this);
                }
                if (f2 > 0.8f) {
                    ((EntityLivingBase)entityIn).func_70653_a((Entity)this, f2 * 2.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                    this.field_70159_w *= 0.6;
                    this.field_70179_y *= 0.6;
                }
            }
            return flag;
        }
        return super.func_70652_k(entityIn);
    }

    public boolean func_184645_a(EntityPlayer entity, EnumHand hand) {
        super.func_184645_a(entity, hand);
        if (!this.field_70170_p.field_72995_K && entity.equals((Object)this.getOwnerPlayer())) {
            entity.func_184220_m((Entity)this);
            return true;
        }
        return false;
    }

    public void func_191986_a(float ti, float tj, float tk) {
        if (this.func_184207_aI() && this.func_175446_cd()) {
            Entity entity = this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = entity.field_70177_z;
            this.field_70125_A = entity.field_70125_A;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70747_aH = this.func_70689_ay();
            this.field_70761_aq = entity.field_70177_z;
            this.field_70759_as = entity.field_70177_z;
            this.field_70138_W = this.field_70131_O / 3.0f;
            if (entity instanceof EntityLivingBase) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                float forward = ((EntityLivingBase)entity).field_191988_bg;
                float strafe = ((EntityLivingBase)entity).field_70702_br;
                super.func_191986_a(strafe, 0.0f, forward);
            }
        } else {
            this.field_70747_aH = 0.02f;
            super.func_191986_a(ti, tj, tk);
        }
    }

    public double func_70042_X() {
        return 0.35;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        return true;
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public void func_70108_f(Entity entityIn) {
        double d1;
        double d0;
        double d2;
        if (!this.func_184223_x(entityIn) && !entityIn.field_70145_X && !entityIn.func_184207_aI() && (d2 = MathHelper.func_76132_a((double)(d0 = entityIn.field_70165_t - this.field_70165_t), (double)(d1 = entityIn.field_70161_v - this.field_70161_v))) >= 0.01) {
            d2 = MathHelper.func_76133_a((double)d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= 0.05;
            d1 *= 0.05;
            entityIn.func_70024_g(d0 *= (double)(1.0f - this.field_70144_Y), 0.0, d1 *= (double)(1.0f - this.field_70144_Y));
        }
    }

    private void clampMotion(double d) {
        if (Math.abs(this.field_70159_w) > d) {
            double d2 = this.field_70159_w = this.field_70159_w > 0.0 ? d : -d;
        }
        if (Math.abs(this.field_70181_x) > d) {
            double d3 = this.field_70181_x = this.field_70181_x > 0.0 ? d : -d;
        }
        if (Math.abs(this.field_70179_y) > d) {
            this.field_70179_y = this.field_70179_y > 0.0 ? d : -d;
        }
    }

    protected void consumeChakra() {
        if (this.field_70173_aa % 20 == 0 && !Chakra.pathway(this.getOwnerPlayer()).consume(this.chakraUsage * this.chakraUsageModifier)) {
            this.func_70106_y();
        }
    }

    public void func_70636_d() {
        EntityLivingBase ownerPlayer = this.getOwnerPlayer();
        boolean flag = ownerPlayer instanceof EntityPlayer;
        if (!this.field_70170_p.field_72995_K && (ownerPlayer == null || !ownerPlayer.func_70089_S() || ownerPlayer instanceof EntityPlayerMP && ((EntityPlayerMP)ownerPlayer).func_193105_t() || !flag && !this.func_184207_aI())) {
            this.func_70106_y();
        }
        if (flag && !((EntityPlayer)ownerPlayer).func_184812_l_()) {
            if (this.func_184207_aI()) {
                ownerPlayer.func_70095_a(false);
            } else if (!this.field_70170_p.field_72995_K) {
                ProcedureSusanoo.execute((EntityPlayer)ownerPlayer);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.consumeChakra();
            }
        }
        this.func_82168_bl();
        super.func_70636_d();
        this.clampMotion(0.05);
        if (this.field_70173_aa % 30 == 0) {
            this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("block.fire.ambient")), 1.0f, this.field_70146_Z.nextFloat() * 0.7f + 0.3f);
        }
        for (int i = 0; i < (int)this.field_70131_O; ++i) {
            double d0 = this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N;
            double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O);
            double d2 = this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N;
            this.field_70170_p.func_190523_a(Particles.Types.FLAME.getID(), d0, d1, d2, 0.0, 0.05, 0.0, new int[]{this.getFlameColor(), (int)(this.field_70130_N * 15.0f)});
        }
    }

    protected void func_70609_aI() {
        this.func_184185_a(SoundEvents.field_187769_eM, 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.7f);
        this.func_70106_y();
    }

    public void func_184724_a(boolean swingingArms) {
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
    }

    public void attackEntityRanged(double x, double y, double z) {
    }

    public void createBullet(float size) {
    }

    public void killBullet() {
    }

    protected void showHeldWeapons() {
        EntityLivingBase owner = this.getOwnerPlayer();
        if (!this.field_70170_p.field_72995_K && owner != null) {
            boolean flag;
            boolean bl = flag = owner.func_184614_ca().func_77973_b() == ItemChokuto.block;
            if (this.shouldShowSword() != flag) {
                this.setShowSword(flag);
            }
            if (owner.func_184614_ca().func_77973_b() == ItemShuriken.block) {
                this.createBullet((float)this.getEntityData().func_74769_h("entityModelScale") * 0.5f);
            } else {
                this.killBullet();
            }
        }
    }

    public static class AIAttackRangedAndMoveTowardsTarget
    extends EntityAIBase {
        private final EntitySusanooBase entityHost;
        private final IRangedAttackMob rangedAttackEntityHost;
        private EntityLivingBase attackTarget;
        private int rangedAttackTime;
        private final double entityMoveSpeed;
        private final int maxRangedAttackTime;
        private final float minAttackRadius;

        public AIAttackRangedAndMoveTowardsTarget(IRangedAttackMob attacker, double movespeed, int maxAttackTime, float minAttackDistanceIn) {
            if (!(attacker instanceof EntitySusanooBase)) {
                throw new IllegalArgumentException("AIAttackRangedAndMoveTowardsTarget requires Mob implements EntitySusanooBase");
            }
            this.rangedAttackEntityHost = attacker;
            this.entityHost = (EntitySusanooBase)attacker;
            this.entityMoveSpeed = movespeed;
            this.maxRangedAttackTime = maxAttackTime;
            this.rangedAttackTime = maxAttackTime;
            this.minAttackRadius = minAttackDistanceIn;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.entityHost.func_70638_az();
            if (entitylivingbase == null) {
                return false;
            }
            if ((double)entitylivingbase.func_70032_d((Entity)this.entityHost) < ProcedureUtils.getReachDistance((EntityLivingBase)this.entityHost) + (double)this.minAttackRadius) {
                return false;
            }
            this.attackTarget = entitylivingbase;
            return true;
        }

        public boolean func_75253_b() {
            return this.func_75250_a() || !this.entityHost.func_70661_as().func_75500_f();
        }

        public void func_75251_c() {
            this.attackTarget = null;
        }

        public void func_75246_d() {
            double d0 = this.entityHost.func_70011_f(this.attackTarget.field_70165_t, this.attackTarget.func_174813_aQ().field_72338_b, this.attackTarget.field_70161_v);
            if (d0 >= ProcedureUtils.getReachDistance((EntityLivingBase)this.entityHost) + (double)this.minAttackRadius) {
                this.entityHost.func_70661_as().func_75497_a((Entity)this.attackTarget, this.entityMoveSpeed);
            } else {
                this.entityHost.func_70661_as().func_75499_g();
            }
            this.entityHost.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
            if (--this.rangedAttackTime <= 0) {
                this.rangedAttackEntityHost.func_82196_d(this.attackTarget, 1.0f);
                this.rangedAttackTime = this.maxRangedAttackTime;
            }
        }
    }
}

