/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.collect.Maps;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.Particles;
import net.narutomod.block.BlockMud;
import net.narutomod.event.EventSetBlocks;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntitySwampPit
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 191;
    public static final int ENTITYID_RANGED = 192;

    public EntitySwampPit(ElementsNarutomodMod instance) {
        super(instance, 452);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "swamp_pit"), 191).name("swamp_pit").tracker(64, 3, true).build());
    }

    public static class EC
    extends Entity {
        private BlockPos center;
        private int radius;
        private int offsetY;

        public EC(World world) {
            super(world);
            this.func_70105_a(0.01f, 0.01f);
        }

        public EC(EntityLivingBase summonerIn, BlockPos centerPos, int radiusIn) {
            this(summonerIn.field_70170_p);
            this.center = centerPos.func_177982_a(0, radiusIn, 0);
            this.radius = radiusIn;
            int y = 0;
            for (int j = 0; j > -radiusIn * 2 && this.center.func_177956_o() + j > 0; --j) {
                if (j != y) continue;
                for (int i = -radiusIn; i <= radiusIn; ++i) {
                    for (int k = -radiusIn; k <= radiusIn; ++k) {
                        if (y < j || !this.field_70170_p.func_175623_d(this.center.func_177982_a(i, j, k))) continue;
                        --y;
                    }
                }
            }
            this.offsetY = y;
            this.func_70107_b((double)centerPos.func_177958_n() + 0.5, centerPos.func_177956_o(), (double)centerPos.func_177952_p() + 0.5);
        }

        protected void func_70088_a() {
        }

        public void func_70071_h_() {
            if (this.center != null) {
                for (int i = 0; i < this.radius; ++i) {
                    Particles.spawnParticle(this.field_70170_p, Particles.Types.SMOKE, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 100, (double)this.radius / 2.0, 0.0, (double)this.radius / 2.0, 0.0, 0.0, 0.0, -2145644019, 25);
                }
                HashMap map = Maps.newHashMap();
                for (int i = -this.radius; i <= this.radius; ++i) {
                    for (int k = -this.radius; k <= this.radius; ++k) {
                        if (1 - this.field_70173_aa > this.offsetY) {
                            map.put(this.center.func_177982_a(i, 1 - this.field_70173_aa, k), Blocks.field_150350_a.func_176223_P());
                            continue;
                        }
                        map.put(this.center.func_177982_a(i, 1 - this.field_70173_aa, k), BlockMud.block.func_176223_P());
                    }
                }
                new EventSetBlocks(this.field_70170_p, map, 0L, 600, false, false);
            }
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa >= this.radius - this.offsetY) {
                this.func_70106_y();
            }
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                RayTraceResult rtr = ProcedureUtils.raytraceBlocks((Entity)entity, 50.0);
                if (rtr != null && rtr.field_72313_a != RayTraceResult.Type.MISS) {
                    entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:yominuma")), SoundCategory.PLAYERS, 1.0f, 1.0f);
                    entity.field_70170_p.func_72838_d((Entity)new EC(entity, rtr.func_178782_a(), (int)power));
                    return true;
                }
                return false;
            }
        }
    }
}

