/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodModVariables;
import net.narutomod.Particles;
import net.narutomod.SaveData;
import net.narutomod.entity.EntityBijuManager;
import net.narutomod.entity.EntityRendererRegister;
import net.narutomod.entity.EntityScalableProjectile;
import net.narutomod.entity.EntityTenTails;
import net.narutomod.event.EventSphericalExplosion;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureAoeCommand;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityTailedBeast
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 251;
    public static final int ENTITYID_RANGED = 252;

    public EntityTailedBeast(ElementsNarutomodMod instance) {
        super(instance, 579);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityTailBeastBall.class).id(new ResourceLocation("narutomod", "tailbeastball"), 252).name("tailbeastball").tracker(128, 1, true).build());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new PlayerHooks());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        new ClientOnly().register();
    }

    public class PlayerHooks {
        private void checkAndRemove(EntityPlayer entity) {
            if (EntityBijuManager.cloakLevel(entity) > 0) {
                EntityBijuManager.toggleBijuCloak(entity);
            }
            for (EntityBijuManager bm : EntityBijuManager.getBMList()) {
                Object biju = bm.getEntityInWorld(entity.field_70170_p);
                if (biju == null || !biju.func_70089_S() || !entity.equals((Object)((Base)biju).summoningPlayer) && !entity.equals((Object)bm.getJinchurikiPlayer())) continue;
                ((Base)biju).func_70106_y();
            }
        }

        @SubscribeEvent
        public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            for (EntityBijuManager bm : EntityBijuManager.getBMList()) {
                bm.verifyVesselEntity((Entity)event.player);
            }
        }

        @SubscribeEvent
        public void onPlayerChangeDimension(EntityTravelToDimensionEvent event) {
            if (event.getEntity() instanceof EntityPlayer) {
                this.checkAndRemove((EntityPlayer)event.getEntity());
            }
        }

        @SubscribeEvent
        public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
            this.checkAndRemove(event.player);
        }

        @SubscribeEvent
        public void onServerDisconnect(FMLNetworkEvent.ServerDisconnectionFromClientEvent event) {
            this.checkAndRemove((EntityPlayer)((NetHandlerPlayServer)event.getHandler()).field_147369_b);
        }

        @SubscribeEvent
        public void onClone(PlayerEvent.Clone event) {
            EntityBijuManager bm = EntityBijuManager.getBijuManagerFrom(event.getOriginal());
            if (bm != null) {
                bm.setVesselEntity((Entity)event.getEntityPlayer(), false);
            }
        }

        @SubscribeEvent
        public void onPlayerTick(TickEvent.PlayerTickEvent event) {
            long l;
            EntityBijuManager bm;
            if (event.phase == TickEvent.Phase.END && event.player instanceof EntityPlayerMP && event.player.field_70173_aa % 40 == 1 && (bm = EntityBijuManager.getBijuManagerFrom(event.player)) != null && (l = ((EntityPlayerMP)event.player).func_154331_x()) != bm.getJinchurikiLastActiveTime()) {
                bm.setJinchurikiLastActiveTime(l);
            }
        }
    }

    public static abstract class SaveBase
    extends WorldSavedData
    implements SaveData.ISaveData {
        public SaveBase(String name) {
            super(name);
        }

        protected abstract EntityBijuManager getBijuManager();

        protected abstract Base createEntity(World var1);

        @Override
        public void resetData() {
            EntityBijuManager bm = this.getBijuManager();
            if (bm.getCloakLevel() > 0) {
                bm.toggleBijuCloak();
            }
            bm.reset();
        }

        public void func_76184_a(NBTTagCompound compound) {
            WorldServer world;
            if (this.getBijuManager().getEntity() == null && compound.func_74767_n("spawned") && (world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(compound.func_74762_e("dimension"))) != null) {
                this.getBijuManager().onAddedToWorld(this.createEntity((World)world), false);
                this.getBijuManager().loadEntityFromNBT(compound.func_74775_l("entityNBT"));
            }
            if (compound.func_186855_b("JinchurikiUUID")) {
                UUID vesseluuid = compound.func_186857_a("JinchurikiUUID");
                this.getBijuManager().setVesselUuid(vesseluuid);
                this.getBijuManager().setVesselName(compound.func_74779_i("VesselName"));
                this.getBijuManager().setVesselTime(compound.func_74763_f("VesselSetTime"));
                this.getBijuManager().setJinchurikiLastActiveTime(compound.func_74763_f("JinchurikiLastActiveTime"), false);
                this.getBijuManager().setCloakXPs(compound.func_74759_k("JinchurikiCloakXp"));
                this.getBijuManager().setCloakCD(compound.func_74763_f("JinchurikiCloakCD"));
                Entity entity = FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(vesseluuid);
                if (entity != null) {
                    this.getBijuManager().setVesselEntity(entity, false);
                }
            }
            if (compound.func_74764_b("spawnPosX")) {
                this.getBijuManager().setSpawnPos(new BlockPos(compound.func_74769_h("spawnPosX"), compound.func_74769_h("spawnPosY"), compound.func_74769_h("spawnPosZ")), false);
            }
            this.getBijuManager().setTicksSinceDeath(compound.func_74762_e("ticksSinceDeath"), false);
            this.getBijuManager().setHasLived(compound.func_74767_n("hasLived"), false);
        }

        public NBTTagCompound func_189551_b(NBTTagCompound compound) {
            UUID vesseluuid;
            Object entity = this.getBijuManager().getEntity();
            compound.func_74757_a("spawned", entity != null);
            if (entity != null) {
                compound.func_74768_a("dimension", ((Entity)entity).field_71093_bK);
                compound.func_74782_a("entityNBT", (NBTBase)entity.func_189511_e(new NBTTagCompound()));
            }
            if ((vesseluuid = this.getBijuManager().getVesselUuid()) != null) {
                compound.func_186854_a("JinchurikiUUID", vesseluuid);
                compound.func_74778_a("VesselName", this.getBijuManager().getVesselName());
                compound.func_74772_a("VesselSetTime", this.getBijuManager().getVesselSetTime());
                compound.func_74772_a("JinchurikiLastActiveTime", this.getBijuManager().getJinchurikiLastActiveTime());
                compound.func_74783_a("JinchurikiCloakXp", this.getBijuManager().getCloakXPs());
                compound.func_74772_a("JinchurikiCloakCD", this.getBijuManager().getCloakCD());
            } else {
                compound.func_82580_o("JinchurikiUUIDMost");
                compound.func_82580_o("JinchurikiUUIDLeast");
                compound.func_82580_o("VesselName");
                compound.func_82580_o("VesselSetTime");
                compound.func_82580_o("JinchurikiLastActiveTime");
                compound.func_82580_o("JinchurikiCloakXp");
                compound.func_82580_o("JinchurikiCloakCD");
            }
            if (this.getBijuManager().hasSpawnPos()) {
                BlockPos spawnPos = this.getBijuManager().getSpawnPos();
                compound.func_74780_a("spawnPosX", (double)spawnPos.func_177958_n());
                compound.func_74780_a("spawnPosY", (double)spawnPos.func_177956_o());
                compound.func_74780_a("spawnPosZ", (double)spawnPos.func_177952_p());
            }
            compound.func_74768_a("ticksSinceDeath", this.getBijuManager().getTicksSinceDeath());
            compound.func_74757_a("hasLived", this.getBijuManager().getHasLived());
            return compound;
        }
    }

    public static class ClientOnly
    extends EntityRendererRegister {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void register() {
            RenderingRegistry.registerEntityRenderingHandler(EntityTailBeastBall.class, x$0 -> new RenderTailBeastBall(x$0));
        }

        @SideOnly(value=Side.CLIENT)
        public class ModelSquareBall
        extends ModelBase {
            private final ModelRenderer core;
            private final ModelRenderer shell;

            public ModelSquareBall() {
                this.field_78090_t = 32;
                this.field_78089_u = 32;
                this.core = new ModelRenderer((ModelBase)this);
                this.core.func_78793_a(0.0f, 0.0f, 0.0f);
                ModelRenderer cube = new ModelRenderer((ModelBase)this);
                cube.func_78793_a(0.0f, 0.0f, 0.0f);
                this.core.func_78792_a(cube);
                cube.field_78804_l.add(new ModelBox(cube, 0, 0, -2.0f, -2.0f, -2.0f, 4, 4, 4, 0.0f, false));
                cube = new ModelRenderer((ModelBase)this);
                cube.func_78793_a(0.0f, 0.0f, 0.0f);
                this.core.func_78792_a(cube);
                this.setRotationAngle(cube, 0.0f, 0.0f, 0.7854f);
                cube.field_78804_l.add(new ModelBox(cube, 0, 0, -2.0f, -2.0f, -2.0f, 4, 4, 4, 0.0f, false));
                cube = new ModelRenderer((ModelBase)this);
                cube.func_78793_a(0.0f, 0.0f, 0.0f);
                this.core.func_78792_a(cube);
                this.setRotationAngle(cube, 0.0f, -0.7854f, 0.0f);
                cube.field_78804_l.add(new ModelBox(cube, 0, 0, -2.0f, -2.0f, -2.0f, 4, 4, 4, 0.0f, false));
                cube = new ModelRenderer((ModelBase)this);
                cube.func_78793_a(0.0f, 0.0f, 0.0f);
                this.core.func_78792_a(cube);
                this.setRotationAngle(cube, -0.7854f, 0.0f, 0.0f);
                cube.field_78804_l.add(new ModelBox(cube, 0, 0, -2.0f, -2.0f, -2.0f, 4, 4, 4, 0.0f, false));
                this.shell = new ModelRenderer((ModelBase)this);
                this.shell.func_78793_a(0.0f, 0.0f, 0.0f);
                cube = new ModelRenderer((ModelBase)this);
                cube.func_78793_a(0.0f, 0.0f, 0.0f);
                this.shell.func_78792_a(cube);
                cube.field_78804_l.add(new ModelBox(cube, 0, 0, -2.0f, -2.0f, -2.0f, 4, 4, 4, 0.1f, false));
                cube = new ModelRenderer((ModelBase)this);
                cube.func_78793_a(0.0f, 0.0f, 0.0f);
                this.shell.func_78792_a(cube);
                this.setRotationAngle(cube, 0.0f, 0.0f, 0.7854f);
                cube.field_78804_l.add(new ModelBox(cube, 0, 0, -2.0f, -2.0f, -2.0f, 4, 4, 4, 0.1f, false));
                cube = new ModelRenderer((ModelBase)this);
                cube.func_78793_a(0.0f, 0.0f, 0.0f);
                this.shell.func_78792_a(cube);
                this.setRotationAngle(cube, 0.0f, -0.7854f, 0.0f);
                cube.field_78804_l.add(new ModelBox(cube, 0, 0, -2.0f, -2.0f, -2.0f, 4, 4, 4, 0.1f, false));
                cube = new ModelRenderer((ModelBase)this);
                cube.func_78793_a(0.0f, 0.0f, 0.0f);
                this.shell.func_78792_a(cube);
                this.setRotationAngle(cube, -0.7854f, 0.0f, 0.0f);
                cube.field_78804_l.add(new ModelBox(cube, 0, 0, -2.0f, -2.0f, -2.0f, 4, 4, 4, 0.1f, false));
            }

            public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
                GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                this.core.func_78785_a(f5);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.15f);
                this.shell.func_78785_a(f5);
            }

            public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
                modelRenderer.field_78795_f = x;
                modelRenderer.field_78796_g = y;
                modelRenderer.field_78808_h = z;
            }
        }

        @SideOnly(value=Side.CLIENT)
        public class RenderTailBeastBall
        extends Render<EntityTailBeastBall> {
            private final ResourceLocation BIJUDAMA_TEXTURE;
            protected final ModelBase mainModel;

            public RenderTailBeastBall(RenderManager renderManagerIn) {
                super(renderManagerIn);
                this.BIJUDAMA_TEXTURE = new ResourceLocation("narutomod:textures/longcube_white.png");
                this.mainModel = new ModelSquareBall();
            }

            public void doRender(EntityTailBeastBall entity, double x, double y, double z, float entityYaw, float partialTicks) {
                this.func_180548_c(entity);
                GlStateManager.func_179094_E();
                float scale = entity.getEntityScale();
                GlStateManager.func_179137_b((double)x, (double)(y + (double)(0.125f * scale)), (double)z);
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                GlStateManager.func_179114_b((float)((float)entity.field_70173_aa * 30.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179141_d();
                GlStateManager.func_179147_l();
                GlStateManager.func_179140_f();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                for (int i = 0; i < 6; ++i) {
                    GlStateManager.func_179114_b((float)(entity.getRNG().nextFloat() * 30.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)(entity.getRNG().nextFloat() * 30.0f), (float)1.0f, (float)1.0f, (float)0.0f);
                    this.mainModel.func_78088_a((Entity)entity, 0.0f, 0.0f, partialTicks + (float)entity.field_70173_aa, 0.0f, 0.0f, 0.0625f);
                }
                GlStateManager.func_179145_e();
                GlStateManager.func_179118_c();
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }

            protected ResourceLocation getEntityTexture(EntityTailBeastBall entity) {
                return this.BIJUDAMA_TEXTURE;
            }
        }

        @SideOnly(value=Side.CLIENT)
        public static abstract class Renderer<T extends Base>
        extends RenderLiving<T> {
            public Renderer(RenderManager renderManagerIn, ModelBase model, float shadowsize) {
                super(renderManagerIn, model, shadowsize);
                this.func_177094_a(new LayerEntityDeath(this));
            }

            public void doRender(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
                if (entity.func_184207_aI() && ((Base)entity).func_82171_bF() && ((Base)entity).func_184179_bs() instanceof EntityLivingBase) {
                    this.copyLimbSwing(entity, (EntityLivingBase)((Base)entity).func_184179_bs());
                }
                this.setModelVisibilities(entity);
                this.field_76989_e = ((Base)entity).getModelScale() * 0.5f;
                super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
            }

            protected void renderModel(T entity, float f0, float f1, float f2, float f3, float f4, float f5) {
                boolean flag;
                float f = ((Base)entity).getTransparency();
                boolean bl = flag = f > 0.0f && f < 1.0f;
                if (flag) {
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)f);
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                }
                super.func_77036_a(entity, f0, f1, f2, f3, f4, f5);
                if (flag) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179084_k();
                }
            }

            protected void copyLimbSwing(T entity, EntityLivingBase rider) {
                ((Base)entity).field_70733_aJ = rider.field_70733_aJ;
                ((Base)entity).field_110158_av = rider.field_110158_av;
                ((Base)entity).field_70732_aI = rider.field_70732_aI;
                ((Base)entity).field_82175_bq = rider.field_82175_bq;
                ((Base)entity).field_184622_au = rider.field_184622_au;
            }

            protected void setModelVisibilities(T entity) {
                if (this.func_177087_b() instanceof ModelBiped) {
                    ModelBiped model = (ModelBiped)this.func_177087_b();
                    model.func_178719_a(true);
                    if (Minecraft.func_71410_x().func_175606_aa().equals((Object)((Base)entity).func_184179_bs()) && this.field_76990_c.field_78733_k.field_74320_O == 0) {
                        model.field_78116_c.field_78806_j = false;
                        model.field_178720_f.field_78806_j = false;
                    }
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        public static class LayerEntityDeath
        implements LayerRenderer<Base> {
            private final ResourceLocation textureRed = new ResourceLocation("narutomod:textures/fuuin_beam_red.png");
            private final ResourceLocation texture10t = new ResourceLocation("narutomod:textures/fuuin_beam_10tails.png");
            private final RenderLiving renderer;

            public LayerEntityDeath(RenderLiving rendererIn) {
                this.renderer = rendererIn;
            }

            public void doRenderLayer(Base entity, float _1, float _2, float partialTicks, float _3, float _4, float _5, float _6) {
                Entity vessel = entity.getTargetVessel();
                if (entity.deathTicks > 1 && vessel != null) {
                    float f = ((float)entity.deathTicks + partialTicks) * 0.01f;
                    float offset = entity.getFuuinBeamHeight();
                    double d0 = vessel.field_70142_S + (vessel.field_70165_t - vessel.field_70142_S) * (double)partialTicks;
                    double d1 = vessel.field_70137_T + (vessel.field_70163_u - vessel.field_70137_T) * (double)partialTicks + (double)vessel.func_70047_e();
                    double d2 = vessel.field_70136_U + (vessel.field_70161_v - vessel.field_70136_U) * (double)partialTicks;
                    double dx = d0 - entity.field_70165_t;
                    double dy = d1 - (entity.field_70163_u + (double)offset);
                    double dz = d2 - entity.field_70161_v;
                    double dxz = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
                    double max_l = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
                    float rot_y = (float)(-Math.atan2(dx, dz)) * 180.0f / (float)Math.PI;
                    float rot_x = (float)(-Math.atan2(dy, dxz)) * 180.0f / (float)Math.PI;
                    rot_y = MathHelper.func_76142_g((float)(rot_y - entity.field_70761_aq));
                    this.renderer.func_110776_a(entity instanceof EntityTenTails.EntityCustom ? this.texture10t : this.textureRed);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)0.0f, (float)(-offset + (vessel instanceof EntityPlayer ? 1.501f : 0.0f)), (float)0.0f);
                    GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)rot_y, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179114_b((float)(rot_x - 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                    Tessellator tessellator = Tessellator.func_178181_a();
                    BufferBuilder bufferbuilder = tessellator.func_178180_c();
                    RenderHelper.func_74518_a();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179129_p();
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    GlStateManager.func_179103_j((int)7425);
                    float f5 = 0.0f - f;
                    float f6 = (float)max_l / 32.0f - f;
                    bufferbuilder.func_181668_a(5, DefaultVertexFormats.field_181709_i);
                    for (int j = 0; j <= 8; ++j) {
                        float f7 = MathHelper.func_76126_a((float)((float)(j % 8) * ((float)Math.PI * 2) / 8.0f));
                        float f8 = MathHelper.func_76134_b((float)((float)(j % 8) * ((float)Math.PI * 2) / 8.0f));
                        float f9 = (float)(j % 8) / 8.0f;
                        bufferbuilder.func_181662_b((double)(f7 * 1.5f), (double)(f8 * 1.5f), 0.0).func_187315_a((double)f9, (double)f5).func_181669_b(0, 0, 0, 128).func_181675_d();
                        bufferbuilder.func_181662_b((double)(f7 * 0.3f), (double)(f8 * 0.3f), (double)((float)max_l)).func_187315_a((double)f9, (double)f6).func_181669_b(255, 255, 255, 192).func_181675_d();
                    }
                    tessellator.func_78381_a();
                    GlStateManager.func_179089_o();
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179103_j((int)7424);
                    RenderHelper.func_74519_b();
                    GlStateManager.func_179121_F();
                }
            }

            public boolean func_177142_b() {
                return false;
            }
        }
    }

    public static class FlySwimHelper
    extends EntityMoveHelper {
        private Base baseEntity;

        public FlySwimHelper(Base entityIn) {
            super((EntityLiving)entityIn);
            this.baseEntity = entityIn;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                double d0 = this.field_75646_b - this.field_75648_a.field_70165_t;
                double d1 = this.field_75647_c - this.field_75648_a.field_70163_u;
                double d2 = this.field_75644_d - this.field_75648_a.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                if (d3 < 1.6E-7) {
                    ProcedureUtils.multiplyVelocity((Entity)this.field_75648_a, 0.0);
                } else {
                    double movementSpeed = this.field_75648_a.func_189652_ae() && this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_193334_e) != null ? this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111126_e() : this.field_75648_a.func_110148_a(EntityLivingBase.SWIM_SPEED).func_111126_e();
                    float f = (float)(this.field_75645_e * movementSpeed);
                    float f1 = -((float)MathHelper.func_181159_b((double)d0, (double)d2)) * 57.295776f;
                    this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, f1, 60.0f);
                    f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2))) * 57.29577951308232));
                    this.field_75648_a.field_70125_A = this.func_75639_a(this.field_75648_a.field_70125_A, f1, 30.0f);
                    if (this.field_75648_a.field_70132_H) {
                        if (this.baseEntity.collisionData.hitOnSide(EnumFacing.UP)) {
                            d1 = 0.0;
                            if (this.baseEntity.collisionData.hitOnAxis(EnumFacing.Axis.X)) {
                                d0 = 0.0;
                                d2 = d3;
                            }
                            if (this.baseEntity.collisionData.hitOnAxis(EnumFacing.Axis.Z)) {
                                d2 = 0.0;
                                d0 = d3;
                            }
                        } else {
                            d1 = 12.0;
                        }
                    }
                    d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                    this.field_75648_a.field_70159_w = d0 / d3 * (double)f;
                    this.field_75648_a.field_70181_x = d1 / d3 * (double)f;
                    this.field_75648_a.field_70179_y = d2 / d3 * (double)f;
                }
            } else {
                ProcedureUtils.multiplyVelocity((Entity)this.field_75648_a, 0.6);
            }
        }
    }

    public static class MoveHelper
    extends EntityMoveHelper {
        private Base baseEntity;

        public MoveHelper(Base entity) {
            super((EntityLiving)entity);
            this.baseEntity = entity;
        }

        public void func_75641_c() {
            if (this.func_75640_a()) {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                double d0 = this.field_75646_b - this.field_75648_a.field_70165_t;
                double d2 = this.field_75647_c - this.field_75648_a.field_70163_u;
                double d1 = this.field_75644_d - this.field_75648_a.field_70161_v;
                double d3 = d0 * d0 + d2 * d2 + d1 * d1;
                if (d3 < 2.5E-7) {
                    this.field_75648_a.func_191989_p(0.0f);
                    return;
                }
                if (this.field_75648_a.field_70123_F) {
                    double d5 = this.field_75648_a.field_70163_u;
                    for (EnumFacing face : EnumFacing.field_176754_o) {
                        for (BlockPos pos : this.baseEntity.collisionData.hitsOnSide(face)) {
                            double d6 = this.getHighestSolidTop(this.field_75648_a.field_70170_p, pos);
                            if (!(d6 > d5)) continue;
                            d5 = d6;
                        }
                    }
                    if (d5 - this.field_75648_a.field_70163_u > 2.0 * (double)this.field_75648_a.field_70131_O || this.baseEntity.collisionData.hitOnSide(EnumFacing.UP)) {
                        if (this.baseEntity.collisionData.hitOnAxis(EnumFacing.Axis.X)) {
                            d0 = 0.0;
                        }
                        if (this.baseEntity.collisionData.hitOnAxis(EnumFacing.Axis.Z)) {
                            d1 = 0.0;
                        }
                    } else {
                        this.field_75648_a.field_70181_x = this.field_75648_a.field_70122_E ? 0.8 + (d5 - this.field_75648_a.field_70163_u) * 0.1 : (this.field_75648_a.field_70181_x += 0.1);
                    }
                }
                float f = (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.29577951308232) - 90.0f;
                this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, f, 90.0f);
                f = (float)(-(MathHelper.func_181159_b((double)d2, (double)MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1))) * 57.29577951308232));
                this.field_75648_a.field_70125_A = this.func_75639_a(this.field_75648_a.field_70125_A, f, 60.0f);
                this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
            } else {
                super.func_75641_c();
            }
        }

        private double getHighestSolidTop(World world, BlockPos pos) {
            while (pos.func_177956_o() < world.func_72800_K() && world.func_180495_p(pos.func_177984_a()).func_185890_d((IBlockAccess)world, pos) != null) {
                pos = pos.func_177984_a();
            }
            return world.func_180495_p((BlockPos)pos).func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72337_e + (double)pos.func_177956_o();
        }
    }

    public static class NavigateGround
    extends PathNavigateGround {
        protected Base baseEntity;
        private BlockPos targetPos;

        public NavigateGround(Base entityLivingIn, World worldIn) {
            super((EntityLiving)entityLivingIn, worldIn);
            this.baseEntity = entityLivingIn;
        }

        protected PathFinder func_179679_a() {
            return null;
        }

        public float func_111269_d() {
            return (float)this.field_75515_a.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
        }

        protected boolean func_75485_k() {
            return true;
        }

        protected Vec3d func_75502_i() {
            return this.field_75515_a.func_174791_d();
        }

        public Path func_179680_a(BlockPos pos) {
            if (this.field_75513_b.func_180495_p(pos).func_185904_a() == Material.field_151579_a) {
                BlockPos blockpos = pos.func_177977_b();
                while (blockpos.func_177956_o() > 0 && this.field_75513_b.func_180495_p(blockpos).func_185904_a() == Material.field_151579_a) {
                    blockpos = blockpos.func_177977_b();
                }
                if (blockpos.func_177956_o() > 0) {
                    return this.getPathTo(blockpos.func_177984_a());
                }
                while (blockpos.func_177956_o() < this.field_75513_b.func_72800_K() && this.field_75513_b.func_180495_p(blockpos).func_185904_a() == Material.field_151579_a) {
                    blockpos = blockpos.func_177984_a();
                }
                pos = blockpos;
            }
            if (!this.field_75513_b.func_180495_p(pos).func_185904_a().func_76220_a()) {
                return this.getPathTo(pos);
            }
            BlockPos blockpos1 = pos.func_177984_a();
            while (blockpos1.func_177956_o() < this.field_75513_b.func_72800_K() && this.field_75513_b.func_180495_p(blockpos1).func_185904_a().func_76220_a()) {
                blockpos1 = blockpos1.func_177984_a();
            }
            return this.getPathTo(blockpos1);
        }

        private double distanceTo(double x, double y, double z) {
            return MathHelper.func_76133_a((double)this.func_75502_i().func_186679_c(x, y, z));
        }

        protected Path getPathTo(BlockPos pos) {
            if (!this.func_75485_k() || this.distanceTo(0.5 + (double)pos.func_177958_n(), this.field_75515_a.field_70163_u, 0.5 + (double)pos.func_177952_p()) > (double)this.func_111269_d()) {
                return null;
            }
            if (this.field_75514_c != null && !this.field_75514_c.func_75879_b() && pos.equals((Object)this.targetPos)) {
                return this.field_75514_c;
            }
            this.targetPos = pos;
            BlockPos blockpos = new BlockPos((Entity)this.field_75515_a);
            PathPoint[] pathpoints = new PathPoint[]{new PathPoint(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p()), new PathPoint(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())};
            return new Path(pathpoints);
        }

        public void func_75501_e() {
            ++this.field_75510_g;
            if (!this.func_75500_f()) {
                this.func_179677_a(this.func_75502_i());
                if (!this.func_75500_f()) {
                    Vec3d vec3d2 = this.field_75514_c.func_75878_a((Entity)this.field_75515_a);
                    if (this.distanceTo(vec3d2.field_72450_a, vec3d2.field_72448_b, vec3d2.field_72449_c) < 0.5 * ((double)this.field_75515_a.field_70130_N + 1.0)) {
                        this.field_75514_c.func_75875_a();
                    } else {
                        this.field_75515_a.func_70605_aq().func_75642_a(vec3d2.field_72450_a, vec3d2.field_72448_b, vec3d2.field_72449_c, this.field_75511_d);
                    }
                }
            }
        }

        protected void func_75487_m() {
        }

        public void func_179688_b(boolean canBreakDoors) {
        }

        public void func_179691_c(boolean enterDoors) {
        }

        public boolean func_179686_g() {
            return false;
        }

        public void func_179693_d(boolean canSwim) {
        }

        public boolean func_179684_h() {
            return false;
        }
    }

    public static class AILeapAtTarget
    extends EntityAIBase {
        private EntityLiving leaper;
        private EntityLivingBase leapTarget;
        private float leapStrength;
        private double leapRange;

        public AILeapAtTarget(EntityLiving leapingEntity, double range, float strength) {
            this.leaper = leapingEntity;
            this.leapRange = range;
            this.leapStrength = strength;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            this.leapTarget = this.leaper.func_70638_az();
            if (this.leapTarget != null) {
                double d0 = this.leaper.func_70068_e((Entity)this.leapTarget);
                double d1 = this.leaper.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
                return (d0 > 64.0 || d0 > d1 * d1) && d0 <= this.leapRange * this.leapRange && this.leaper.field_70122_E && this.leaper.func_70681_au().nextInt(5) == 0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return !this.leaper.field_70122_E;
        }

        public void func_75249_e() {
            double d0 = this.leapTarget.field_70165_t - this.leaper.field_70165_t;
            double d1 = this.leapTarget.field_70161_v - this.leaper.field_70161_v;
            float f = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
            if ((double)f >= 1.0E-4) {
                this.leaper.field_70159_w += d0 / (double)f * (double)this.leapStrength * 0.4 + this.leaper.field_70159_w * 0.2;
                this.leaper.field_70179_y += d1 / (double)f * (double)this.leapStrength * 0.4 + this.leaper.field_70179_y * 0.2;
            }
            this.leaper.field_70181_x = this.leapStrength;
            this.leaper.field_70177_z = (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.29577951308232) - 90.0f;
        }
    }

    public static class EntityTailBeastBall
    extends EntityScalableProjectile.Base {
        private final int buildupTime = 100;
        private float maxScale;
        private float maxDamage;
        private boolean shooterAIDisabled;

        public EntityTailBeastBall(World worldIn) {
            super(worldIn);
            this.setOGSize(0.25f, 0.25f);
            this.setEntityScale(0.01f);
            this.setWaterSlowdown(0.98f);
        }

        public EntityTailBeastBall(EntityLivingBase shooter, float maxscale, float maxdamage) {
            super(shooter);
            this.setOGSize(0.25f, 0.25f);
            if (shooter instanceof EntityLiving) {
                this.shooterAIDisabled = ((EntityLiving)shooter).func_175446_cd();
                ((EntityLiving)shooter).func_94061_f(true);
            }
            this.setBuildupPosition();
            this.setEntityScale(0.01f);
            this.setWaterSlowdown(0.98f);
            this.maxScale = maxscale;
            this.maxDamage = maxdamage;
        }

        private void setBuildupPosition() {
            Vec3d vec3d = this.shootingEntity instanceof Base ? ((Base)this.shootingEntity).getPositionMouth() : Vec3d.func_189986_a((float)this.shootingEntity.field_70125_A, (float)this.shootingEntity.field_70759_as).func_186678_a((double)this.shootingEntity.field_70130_N * 1.5).func_178787_e(this.shootingEntity.func_174824_e(1.0f));
            this.func_70107_b(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            if (this.shootingEntity != null && !this.field_70128_L) {
                if (this.field_70173_aa <= this.buildupTime) {
                    if (this.field_70173_aa == 1) {
                        this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:bijudama")), 10.0f, 1.0f);
                    }
                    this.setBuildupPosition();
                    float f = this.maxScale * (float)this.field_70173_aa;
                    ((Object)((Object)this)).getClass();
                    this.setEntityScale(f / 100.0f);
                    if (this.field_70173_aa <= this.buildupTime - 40) {
                        Particles.spawnParticle(this.field_70170_p, Particles.Types.HOMING_ORB, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v, 2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, MathHelper.func_76123_f((float)(this.maxScale * 0.35f)), (int)(this.maxScale * 2.2f));
                    }
                } else if (this.shootingEntity instanceof EntityLiving && !this.shooterAIDisabled) {
                    EntityLiving living = (EntityLiving)this.shootingEntity;
                    if (living.func_175446_cd()) {
                        living.func_94061_f(false);
                    }
                    if (!this.isLaunched()) {
                        if (living.func_70638_az() != null) {
                            this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:nagiharai")), 10.0f, 1.0f);
                            this.func_70186_c(living.func_70638_az().field_70165_t - this.field_70165_t, living.func_70638_az().field_70163_u - this.field_70163_u - (double)(this.field_70131_O / 2.0f), living.func_70638_az().field_70161_v - this.field_70161_v, 1.05f, 0.0f);
                        } else {
                            this.func_70106_y();
                        }
                    }
                } else if (!this.isLaunched()) {
                    this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:nagiharai")), 10.0f, 1.0f);
                    Vec3d vec = this.shootingEntity.func_70040_Z();
                    this.func_70186_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 1.05f, 0.0f);
                    if (this.shootingEntity instanceof Base) {
                        ((Base)this.shootingEntity).func_184724_a(false);
                    }
                }
            }
        }

        @Override
        protected void onImpact(RayTraceResult result) {
            if (result.field_72308_g != null && result.field_72308_g.equals((Object)this.shootingEntity)) {
                return;
            }
            if (!this.field_70170_p.field_72995_K) {
                EntityLivingBase excludePlayer;
                Object object = this.shootingEntity instanceof Base ? (((Base)this.shootingEntity).getBijuManager().getJinchurikiPlayer() != null ? ((Base)this.shootingEntity).getBijuManager().getJinchurikiPlayer() : ((Base)this.shootingEntity).getSummoningPlayer()) : (excludePlayer = this.shootingEntity);
                if (excludePlayer != null) {
                    excludePlayer.getEntityData().func_74780_a(NarutomodModVariables.InvulnerableTime, 40.0);
                }
                float radius = MathHelper.func_76129_c((float)this.getEntityScale()) * 6.0f;
                new EventSphericalExplosion(this.field_70170_p, (Entity)this.shootingEntity, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, (int)radius, 0L, 0.33f);
                ProcedureAoeCommand.set(this, 0.0, (double)radius * 1.2).exclude((Entity)excludePlayer).damageEntitiesCentered(ItemJutsu.causeJutsuDamage(this, this.shootingEntity), this.maxDamage);
                this.func_70106_y();
            }
        }

        @Override
        protected void checkOnGround() {
        }

        @Override
        public void renderParticles() {
        }

        public static boolean spawn(EntityLivingBase summonerIn, float maxscale, float maxdamage) {
            double chakraUsage = 100.0 * (double)maxscale;
            EntityLivingBase user = null;
            if (summonerIn instanceof Base) {
                user = ((Base)summonerIn).getBijuManager().getJinchurikiPlayer();
            }
            if (user == null) {
                user = summonerIn;
            }
            if (user instanceof Base && ((Base)user).consumeHealthAsChakra((float)chakraUsage * 0.2f) || user != null && Chakra.pathway(user).consume(chakraUsage)) {
                return summonerIn.field_70170_p.func_72838_d((Entity)new EntityTailBeastBall(summonerIn, maxscale, maxdamage));
            }
            return false;
        }

        public static void create(EntityLivingBase entity, boolean is_pressed) {
            if (!CDTracker.cdMap.containsKey(entity)) {
                CDTracker.cdMap.put(entity, new CDTracker());
            }
            CDTracker cd = (CDTracker)CDTracker.cdMap.get(entity);
            if (entity.field_70173_aa >= cd.cooldown) {
                if (is_pressed) {
                    if (cd.power < 14.0f) {
                        cd.power = cd.power + (entity instanceof EntityPlayer ? (float)EntityBijuManager.getCloakXp((EntityPlayer)entity) * 0.1f / 4800.0f : 0.01f);
                    }
                    if (entity instanceof EntityPlayer && !entity.field_70170_p.field_72995_K) {
                        ((EntityPlayer)entity).func_146105_b((ITextComponent)new TextComponentString(String.format("%.1f", Float.valueOf(cd.power))), true);
                    }
                } else {
                    if (EntityTailBeastBall.spawn(entity, cd.power, cd.power * 70.0f)) {
                        cd.cooldown = entity.field_70173_aa + 100;
                    }
                    cd.power = 0.0f;
                }
            } else if (entity instanceof EntityPlayer && !entity.field_70170_p.field_72995_K) {
                ((EntityPlayer)entity).func_146105_b((ITextComponent)new TextComponentTranslation("chattext.cooldown.formatted", new Object[]{(cd.cooldown - entity.field_70173_aa) / 20}), true);
            }
        }

        protected static class CDTracker {
            private static final Map<EntityLivingBase, CDTracker> cdMap = Maps.newHashMap();
            int cooldown;
            float power;

            CDTracker() {
                this(0, 0.0f);
            }

            CDTracker(int cd, float p) {
                this.cooldown = cd;
                this.power = p;
            }

            private static void clean() {
                Iterator<Map.Entry<EntityLivingBase, CDTracker>> iter = cdMap.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<EntityLivingBase, CDTracker> entry = iter.next();
                    if (entry.getKey().func_70089_S() && entry.getKey().isAddedToWorld()) continue;
                    iter.remove();
                }
            }
        }
    }

    public static abstract class Base
    extends EntityMob
    implements IRangedAttackMob,
    EntityBijuManager.ITailBeast {
        protected static final List<Material> canBreakList = Lists.newArrayList((Object[])new Material[]{Material.field_151575_d, Material.field_151570_A, Material.field_151592_s, Material.field_151584_j, Material.field_151585_k, Material.field_151597_y, Material.field_151582_l, Material.field_151569_G});
        private static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187192_b);
        private static final DataParameter<Integer> VESSEL = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187192_b);
        private static final DataParameter<Boolean> SHOOT = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187198_h);
        private static final DataParameter<Boolean> CANSTEER = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187198_h);
        private static final DataParameter<Boolean> FACEDOWN = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187198_h);
        private static final DataParameter<Float> TRANSPARENCY = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187193_c);
        private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS);
        public static final int BIJUDAMA_CD = 200;
        protected final double TARGET_RANGE = 108.0;
        private int deathTicks;
        private int deathTotalTicks;
        private EntityPlayer summoningPlayer;
        private int tailBeastBallTime = 200;
        private int angerLevel;
        private int lifeSpan = 0x7FFFFFFE;
        private boolean motionHalted;
        protected boolean canPassengerDismount = true;
        protected boolean spawnedBySpawner;
        protected final ProcedureUtils.CollisionHelper collisionData = new ProcedureUtils.CollisionHelper((Entity)this);

        public Base(World world) {
            super(world);
            this.field_70178_ae = true;
            this.deathTicks = 0;
            this.func_94061_f(false);
            this.func_110163_bv();
            this.func_70606_j(this.func_110138_aP());
            this.deathTotalTicks = 200;
            this.setMeleeAttackTasks();
        }

        public Base(EntityPlayer player) {
            this(player.field_70170_p);
            if (player.equals((Object)this.getBijuManager().getJinchurikiPlayer())) {
                this.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
                player.func_184220_m((Entity)this);
            } else {
                Vec3d vec = player.func_174824_e(1.0f).func_178787_e(player.func_70040_Z().func_186678_a(20.0));
                this.func_70012_b(vec.field_72450_a, player.field_70163_u + 10.0, vec.field_72449_c, player.field_70177_z - 180.0f, 0.0f);
                this.setSummoningPlayer(player);
            }
        }

        protected PathNavigate func_175447_b(World worldIn) {
            NavigateGround navi = new NavigateGround(this, worldIn);
            this.field_70765_h = new MoveHelper(this);
            return navi;
        }

        protected void func_70088_a() {
            super.func_70088_a();
            this.func_184212_Q().func_187214_a(AGE, (Object)0);
            this.func_184212_Q().func_187214_a(VESSEL, (Object)-1);
            this.func_184212_Q().func_187214_a(SHOOT, (Object)false);
            this.func_184212_Q().func_187214_a(CANSTEER, (Object)false);
            this.func_184212_Q().func_187214_a(FACEDOWN, (Object)false);
            this.func_184212_Q().func_187214_a(TRANSPARENCY, (Object)Float.valueOf(1.0f));
        }

        public int getAge() {
            return (Integer)this.func_184212_Q().func_187225_a(AGE);
        }

        protected void setAge(int age) {
            this.func_184212_Q().func_187227_b(AGE, (Object)age);
        }

        public void setLifeSpan(int lifespan) {
            this.lifeSpan = lifespan;
        }

        protected boolean isFaceDown() {
            return (Boolean)this.func_184212_Q().func_187225_a(FACEDOWN);
        }

        public void setFaceDown(boolean down) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_184212_Q().func_187227_b(FACEDOWN, (Object)down);
            }
            this.motionHalted = down;
        }

        public abstract float getModelScale();

        @Nullable
        protected Entity getTargetVessel() {
            return this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(VESSEL)).intValue());
        }

        private void setTargetVessel(@Nullable Entity player) {
            this.func_184212_Q().func_187227_b(VESSEL, (Object)(player != null ? player.func_145782_y() : -1));
        }

        public float getTransparency() {
            return ((Float)this.func_184212_Q().func_187225_a(TRANSPARENCY)).floatValue();
        }

        protected void setTransparency(float transparency) {
            this.func_184212_Q().func_187227_b(TRANSPARENCY, (Object)Float.valueOf(transparency));
        }

        public void func_184206_a(DataParameter<?> key) {
            super.func_184206_a(key);
            if (FACEDOWN.equals(key) && this.field_70170_p.field_72995_K) {
                this.setFaceDown(this.isFaceDown());
            }
        }

        public void setAngerLevel(int i) {
            this.angerLevel = MathHelper.func_76125_a((int)i, (int)0, (int)2);
        }

        public abstract EntityBijuManager getBijuManager();

        public void setSummoningPlayer(EntityPlayer player) {
            this.summoningPlayer = player;
        }

        public EntityPlayer getSummoningPlayer() {
            return this.summoningPlayer;
        }

        protected void func_110147_ax() {
            super.func_110147_ax();
            this.func_110140_aT().func_111150_b(ProcedureUtils.MAXHEALTH);
            this.func_110140_aT().func_111150_b(EntityPlayer.REACH_DISTANCE);
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(108.0);
            this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(200.0);
        }

        public IAttributeInstance func_110148_a(IAttribute attribute) {
            return super.func_110148_a(attribute == SharedMonsterAttributes.field_111267_a ? ProcedureUtils.MAXHEALTH : attribute);
        }

        protected void setMeleeAttackTasks() {
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AILeapAtTarget((EntityLiving)this, 24.0, 2.0f){

                @Override
                public boolean func_75250_a() {
                    return !this.isMotionHalted() && super.func_75250_a();
                }
            });
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.2, true){

                public boolean func_75250_a() {
                    return !this.isMotionHalted() && super.func_75250_a();
                }

                protected double func_179512_a(EntityLivingBase attackTarget) {
                    return ProcedureUtils.getReachDistanceSq((EntityLivingBase)this.field_75441_b) * 0.36;
                }
            });
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]){

                protected double func_111175_f() {
                    return 108.0;
                }
            });
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true, false){

                public boolean func_75250_a() {
                    return super.func_75250_a() && !this.func_184191_r((Entity)this.field_75309_a) && angerLevel > 0;
                }

                protected double func_111175_f() {
                    return 108.0;
                }
            });
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, true, false){

                public boolean func_75250_a() {
                    return super.func_75250_a() && angerLevel > 1;
                }

                protected double func_111175_f() {
                    return 54.0;
                }
            });
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackRanged(this, 1.2, 200, 172.0f){

                public boolean func_75250_a() {
                    return super.func_75250_a() && !this.isMotionHalted() && this.canShootBijudama() && (double)this.func_70032_d((Entity)this.func_70638_az()) > 32.0 && !this.func_70055_a(Material.field_151586_h);
                }

                public void func_75251_c() {
                    super.func_75251_c();
                    this.func_184724_a(false);
                }
            });
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0){

                public boolean func_75250_a() {
                    return !this.isMotionHalted() && super.func_75250_a();
                }

                @Nullable
                protected Vec3d func_190864_f() {
                    return RandomPositionGenerator.func_75463_a((EntityCreature)this.field_75457_a, (int)56, (int)21);
                }
            });
        }

        protected void func_70619_bc() {
            super.func_70619_bc();
            if (this.func_70638_az() != null && !this.func_70638_az().func_70089_S()) {
                this.func_70624_b(null);
            }
        }

        protected void haltMotion(boolean halt) {
            this.motionHalted = halt;
        }

        protected boolean isMotionHalted() {
            return this.motionHalted;
        }

        protected boolean func_70692_ba() {
            return false;
        }

        protected Item func_146068_u() {
            return null;
        }

        public boolean func_184191_r(Entity entityIn) {
            return entityIn.equals((Object)this.getBijuManager().getJinchurikiPlayer()) || entityIn.equals((Object)this.summoningPlayer);
        }

        protected float func_70599_aP() {
            return 50.0f;
        }

        public boolean func_70104_M() {
            return false;
        }

        protected void func_82167_n(Entity entityIn) {
            this.func_70108_f(entityIn);
        }

        public void func_70108_f(Entity entity) {
            double d3;
            double d2;
            double d4;
            if (!this.func_184223_x(entity) && !entity.field_70145_X && !entity.func_184207_aI() && (d4 = MathHelper.func_76132_a((double)(d2 = entity.field_70165_t - this.field_70165_t), (double)(d3 = entity.field_70161_v - this.field_70161_v))) >= 0.01) {
                d4 = MathHelper.func_76133_a((double)d4);
                d2 /= d4;
                d3 /= d4;
                double d5 = d4 >= 1.0 ? 1.0 / d4 : 1.0;
                entity.field_70159_w = d2 *= d5 * 0.05;
                entity.field_70179_y = d3 *= d5 * 0.05;
                entity.field_70160_al = true;
            }
        }

        public Vec3d getPositionMouth() {
            return Vec3d.func_189986_a((float)this.field_70125_A, (float)this.field_70759_as).func_186678_a((double)this.field_70130_N * 1.5).func_178787_e(this.func_174824_e(1.0f));
        }

        public float getFuuinBeamHeight() {
            return 0.5833f * this.field_70131_O;
        }

        public boolean func_184645_a(EntityPlayer entity, EnumHand hand) {
            super.func_184645_a(entity, hand);
            if (!this.field_70170_p.field_72995_K && (entity.equals((Object)this.getBijuManager().getJinchurikiPlayer()) || entity.equals((Object)this.summoningPlayer))) {
                entity.func_184220_m((Entity)this);
                return true;
            }
            return false;
        }

        public double func_70042_X() {
            return (double)this.field_70131_O + 0.35 - (this.func_184179_bs().equals((Object)this.getBijuManager().getJinchurikiPlayer()) ? 3.0 : 0.0);
        }

        public boolean shouldRiderSit() {
            return false;
        }

        private void setCanSteer(boolean b) {
            this.func_184212_Q().func_187227_b(CANSTEER, (Object)b);
        }

        public boolean func_82171_bF() {
            return (Boolean)this.func_184212_Q().func_187225_a(CANSTEER);
        }

        protected boolean func_184228_n(Entity entityIn) {
            return entityIn.equals((Object)this.getBijuManager().getJinchurikiPlayer()) || entityIn.equals((Object)this.summoningPlayer) || entityIn instanceof EntityPlayer && ((EntityPlayer)entityIn).func_184812_l_();
        }

        protected boolean func_184219_q(Entity passenger) {
            return super.func_184219_q(passenger) && this.func_184228_n(passenger);
        }

        protected void func_184200_o(Entity passenger) {
            super.func_184200_o(passenger);
            if (!this.field_70170_p.field_72995_K) {
                if (passenger.equals((Object)this.getBijuManager().getJinchurikiPlayer())) {
                    this.func_94061_f(true);
                    this.setCanSteer(true);
                    this.canPassengerDismount = false;
                } else {
                    this.setCanSteer(false);
                }
            }
        }

        public Entity func_184179_bs() {
            return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
        }

        public boolean shouldDismountInWater(Entity rider) {
            return false;
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            Vec3d vec3d;
            if (this.func_110143_aJ() <= 0.0f) {
                return false;
            }
            if (source.func_76346_g() instanceof EntityPlayer && source.func_76346_g().equals((Object)this.func_184179_bs())) {
                return false;
            }
            if (source.func_76364_f() instanceof EntityPotion) {
                return false;
            }
            if (source == DamageSource.field_76379_h) {
                return false;
            }
            if (source == DamageSource.field_76367_g) {
                return false;
            }
            if (source == DamageSource.field_76369_e) {
                return false;
            }
            if (source == DamageSource.field_180137_b) {
                return false;
            }
            if (this.equals(source.func_76346_g())) {
                return false;
            }
            if (!source.func_76363_c() && source.func_76346_g() != null && (vec3d = source.func_188404_v()) != null) {
                Vec3d vec3d1 = this.func_70676_i(1.0f);
                Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v)).func_72432_b();
                vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
                if (vec3d2.func_72430_b(vec3d1) < 0.0) {
                    amount *= this.field_70146_Z.nextFloat();
                }
            }
            float hp = this.func_110143_aJ();
            if (source.func_76346_g() instanceof EntityLivingBase) {
                float maxhp = this.func_110138_aP();
                this.setAngerLevel(hp < 0.5f * maxhp ? 2 : (hp < maxhp - 500.0f ? 1 : 0));
            }
            boolean flag = super.func_70097_a(source, amount);
            EntityPlayer jin = this.getBijuManager().getJinchurikiPlayer();
            if (flag && jin != null && !this.func_70089_S()) {
                jin.func_70097_a(source, CombatRules.func_189427_a((float)amount, (float)this.func_70658_aO(), (float)0.0f) - hp);
            }
            return flag;
        }

        public boolean func_70652_k(Entity entityIn) {
            if (super.func_70652_k(entityIn)) {
                this.field_70170_p.func_72876_a((Entity)this, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, 10.0f, ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this));
                ProcedureAoeCommand.set(entityIn, 0.0, 5.0).exclude((Entity)this).exclude((Entity)this.getSummoningPlayer()).exclude((Entity)this.getBijuManager().getJinchurikiPlayer()).exclude(this.func_184179_bs()).damageEntities((Entity)this, (float)ProcedureUtils.getModifiedAttackDamage((EntityLivingBase)this) * (this.field_70146_Z.nextFloat() * 0.5f + 0.5f));
                return true;
            }
            return false;
        }

        public boolean couldBreakBlocks() {
            return this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
        }

        public void func_70091_d(MoverType type, double x, double y, double z) {
            this.collisionData.collideWithAABBs(this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ().func_72321_a(x, y, z)), x, y, z);
            if (this.couldBreakBlocks()) {
                for (BlockPos pos : this.collisionData.getHitBlocks()) {
                    if (!canBreakList.contains(this.field_70170_p.func_180495_p(pos).func_185904_a())) continue;
                    this.field_70170_p.func_175655_b(pos, this.field_70146_Z.nextFloat() < 0.3f);
                    x *= 0.96;
                    y *= 0.96;
                    z *= 0.96;
                }
            }
            super.func_70091_d(type, x, y, z);
        }

        public void func_191986_a(float ti, float tj, float tk) {
            if (this.func_184207_aI() && this.func_82171_bF()) {
                Entity entity = this.func_184179_bs();
                this.field_70126_B = this.field_70177_z = entity.field_70177_z;
                this.field_70125_A = entity.field_70125_A;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70747_aH = this.func_70689_ay() * 0.15f;
                this.field_70761_aq = entity.field_70177_z;
                this.field_70759_as = entity.field_70177_z;
                this.field_70138_W = this.field_70131_O / 3.0f;
                if (entity instanceof EntityLivingBase) {
                    this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                    float forward = ((EntityLivingBase)entity).field_191988_bg;
                    float strafe = ((EntityLivingBase)entity).field_70702_br;
                    super.func_191986_a(strafe, 0.0f, forward);
                }
            } else {
                this.field_70747_aH = 0.02f;
                super.func_191986_a(ti, tj, tk);
            }
        }

        @Override
        public void fuuinIntoVessel(Entity vessel, int fuuinTime) {
            if (!(this.getBijuManager().isSealed() || !(this.func_110143_aJ() < this.func_110138_aP() * 0.1f) || vessel instanceof EntityPlayer && EntityBijuManager.isJinchuriki((EntityPlayer)vessel))) {
                if (!vessel.equals((Object)this.getTargetVessel())) {
                    this.deathTicks = 0;
                }
                this.setTargetVessel(vessel);
                this.func_70606_j(0.0f);
                this.deathTotalTicks = fuuinTime;
            }
            if (this.angerLevel == 0) {
                this.setAngerLevel(1);
            }
        }

        @Override
        public boolean isFuuinInProgress() {
            return this.getTargetVessel() != null && this.deathTicks > 0;
        }

        @Override
        public void cancelFuuin() {
            this.func_70606_j(this.func_110138_aP() * 0.05f);
            this.setTargetVessel(null);
            this.deathTicks = 0;
            this.deathTotalTicks = 200;
        }

        @Override
        public void incFuuinProgress(int i) {
            if (this.getTargetVessel() != null) {
                this.deathTicks += i;
            }
        }

        @Override
        public float getFuuinProgress() {
            return this.isFuuinInProgress() ? (float)this.deathTicks / (float)this.deathTotalTicks : 0.0f;
        }

        protected void func_70609_aI() {
            ++this.deathTicks;
            if (!this.field_70170_p.field_72995_K) {
                Entity jinchuriki = this.getTargetVessel();
                if (jinchuriki != null && this.getBijuManager().isSealed() && this.deathTicks == 1) {
                    jinchuriki = null;
                    this.setTargetVessel(null);
                    this.deathTotalTicks = 200;
                }
                if (jinchuriki != null && this.field_70173_aa % 50 == 1) {
                    this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:KamuiSFX")), 3.0f, 1.0f);
                }
                for (int i = 0; i < (int)((float)this.deathTicks / (float)this.deathTotalTicks * 100.0f); ++i) {
                    Particles.spawnParticle(this.field_70170_p, Particles.Types.SMOKE, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O * 0.5, this.field_70161_v, 1, (double)this.field_70130_N * 0.5, (double)this.field_70131_O * 0.5, (double)this.field_70130_N * 0.5, 0.0, 0.5, 0.0, 96.0, 0x10B00000, 100);
                }
                if (this.deathTicks > this.deathTotalTicks) {
                    if (jinchuriki != null) {
                        this.getBijuManager().setVesselEntity(jinchuriki);
                        ProcedureUtils.sendChatAll(I18n.func_74837_a((String)"chattext.tentails.sealedintoplayer", (Object[])new Object[]{this.func_70005_c_(), jinchuriki.func_70005_c_()}));
                    }
                    this.func_70106_y();
                }
            }
        }

        public void func_70106_y() {
            super.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                if (this.getBijuManager().getCloakLevel() == 3) {
                    this.getBijuManager().toggleBijuCloak();
                }
                this.getBijuManager().onRemovedFromWorld(this);
            }
        }

        private void clampMotion(double d) {
            if (Math.abs(this.field_70159_w) > d) {
                double d2 = this.field_70159_w = this.field_70159_w > 0.0 ? d : -d;
            }
            if (Math.abs(this.field_70181_x) > d) {
                double d3 = this.field_70181_x = this.field_70181_x > 0.0 ? d : -d;
            }
            if (Math.abs(this.field_70179_y) > d) {
                this.field_70179_y = this.field_70179_y > 0.0 ? d : -d;
            }
        }

        public void func_70030_z() {
            int age = this.getAge() + 1;
            this.setAge(age);
            EntityPlayer jinchuriki = this.getBijuManager().getJinchurikiPlayer();
            if (this.func_184207_aI() && !this.canPassengerDismount) {
                this.func_184179_bs().func_70095_a(false);
            }
            super.func_70030_z();
            if (this.deathTicks > 0) {
                return;
            }
            if (!this.field_70170_p.field_72995_K) {
                float maxhp;
                float hp;
                if (jinchuriki instanceof EntityPlayerMP && ((EntityPlayerMP)jinchuriki).func_193105_t() || age > this.lifeSpan) {
                    this.func_70106_y();
                }
                if ((hp = this.func_110143_aJ()) >= (maxhp = this.func_110138_aP()) * 0.1f && this.isFaceDown()) {
                    this.setFaceDown(false);
                }
                if (hp <= 150.0f && !this.isFaceDown()) {
                    this.setFaceDown(true);
                }
                if (this.func_175446_cd() && jinchuriki != null && jinchuriki.func_110143_aJ() <= 0.0f) {
                    this.func_94061_f(false);
                }
                if (this.field_70173_aa % 100 == 0 && hp > 0.0f && hp < maxhp) {
                    this.func_70606_j(hp + 100.0f * Math.max(hp / maxhp, 0.1f));
                }
                if (this.angerLevel > 0 && this.field_70173_aa - this.func_142015_aE() > 6000) {
                    this.setAngerLevel(0);
                }
            }
            if (this.func_184207_aI()) {
                this.clampMotion(0.05);
            }
            if (this.tailBeastBallTime > 0) {
                --this.tailBeastBallTime;
            }
        }

        protected boolean isShooting() {
            return (Boolean)this.func_184212_Q().func_187225_a(SHOOT);
        }

        public void func_184724_a(boolean swingingArms) {
            this.func_184212_Q().func_187227_b(SHOOT, (Object)swingingArms);
        }

        public void func_82196_d(EntityLivingBase target, float flval) {
            if (this.func_175446_cd() && this.tailBeastBallTime > 0) {
                if (target instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)target;
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("chattext.cooldown.formatted", new Object[]{this.tailBeastBallTime / 20}), true);
                }
                return;
            }
            if (EntityTailBeastBall.spawn((EntityLivingBase)this, 14.0f, 1000.0f)) {
                this.func_184724_a(true);
                this.tailBeastBallTime = 200;
            }
        }

        protected boolean consumeHealthAsChakra(float amount) {
            float f = this.func_110143_aJ();
            if (this.canShootBijudama() && f > amount) {
                this.func_70606_j(f - amount);
                return true;
            }
            return false;
        }

        protected boolean canShootBijudama() {
            return this.func_110143_aJ() >= this.func_110138_aP() * 0.4f;
        }

        public boolean func_184222_aU() {
            return false;
        }

        public void func_184178_b(EntityPlayerMP player) {
            super.func_184178_b(player);
            if (this.getBijuManager().getJinchurikiPlayer() == null) {
                this.bossInfo.func_186760_a(player);
            }
        }

        public void func_184203_c(EntityPlayerMP player) {
            super.func_184203_c(player);
            this.bossInfo.func_186761_b(player);
        }

        public void func_70071_h_() {
            super.func_70071_h_();
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }

        public void func_70037_a(NBTTagCompound compound) {
            super.func_70037_a(compound);
            this.setAge(compound.func_74762_e("age"));
        }

        public void func_70014_b(NBTTagCompound compound) {
            super.func_70014_b(compound);
            compound.func_74768_a("age", this.getAge());
        }

        public void onAddedToWorld() {
            super.onAddedToWorld();
            if (!this.field_70170_p.field_72995_K) {
                this.getBijuManager().onAddedToWorld(this);
            }
        }

        @Nullable
        public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
            this.spawnedBySpawner = true;
            return livingdata;
        }
    }
}

