/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodModVariables;
import net.narutomod.Particles;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureAirPunch;
import net.narutomod.procedure.ProcedureSync;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityTenseiBakuSilver
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 340;
    public static final int ENTITYID_RANGED = 341;

    public EntityTenseiBakuSilver(ElementsNarutomodMod instance) {
        super(instance, 696);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "tensei_baku_silver"), 340).name("tensei_baku_silver").tracker(64, 3, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EC.class, renderManager -> new RenderCustom(renderManager));
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderCustom
    extends Render<EC> {
        private final ResourceLocation TEXTURE;
        private final ResourceLocation TEXTURE2;

        public RenderCustom(RenderManager renderManager) {
            super(renderManager);
            this.TEXTURE = new ResourceLocation("narutomod:textures/ring_green.png");
            this.TEXTURE2 = new ResourceLocation("narutomod:textures/white_orb.png");
            this.field_76989_e = 0.1f;
        }

        public void doRender(EC entity, double x, double y, double z, float entityYaw, float partialTicks) {
            this.func_180548_c(entity);
            float ageInTicks = (float)entity.field_70173_aa + partialTicks;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)(y + 0.5), (double)z);
            GlStateManager.func_179091_B();
            float alpha = ageInTicks / 20.0f;
            if (alpha > 1.0f) {
                alpha = Math.max(1.0f - (alpha - 1.0f) * 0.5f, 0.0f);
            }
            GlStateManager.func_179129_p();
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)3.0f, (float)3.0f, (float)3.0f);
            GlStateManager.func_179114_b((float)(-entity.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(9.0f * ageInTicks), (float)0.0f, (float)0.0f, (float)1.0f);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181712_l);
            bufferbuilder.func_181662_b(-0.5, -0.5, 0.0).func_187315_a(0.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            bufferbuilder.func_181662_b(0.5, -0.5, 0.0).func_187315_a(1.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            bufferbuilder.func_181662_b(0.5, 0.5, 0.0).func_187315_a(1.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            bufferbuilder.func_181662_b(-0.5, 0.5, 0.0).func_187315_a(0.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            this.func_110776_a(this.TEXTURE2);
            alpha = MathHelper.func_76129_c((float)(1.0f - Math.min(ageInTicks / 20.0f, 1.0f)));
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.func_179114_b((float)(180.0f - this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)(this.field_76990_c.field_78733_k.field_74320_O == 2 ? -1 : 1) * -this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(9.0f * ageInTicks), (float)0.0f, (float)0.0f, (float)1.0f);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181712_l);
            bufferbuilder.func_181662_b(-0.5, -0.5, 0.0).func_187315_a(0.0, 1.0).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            bufferbuilder.func_181662_b(0.5, -0.5, 0.0).func_187315_a(1.0, 1.0).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            bufferbuilder.func_181662_b(0.5, 0.5, 0.0).func_187315_a(1.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            bufferbuilder.func_181662_b(-0.5, 0.5, 0.0).func_187315_a(0.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, alpha).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179118_c();
            GlStateManager.func_179089_o();
            GlStateManager.func_179101_C();
            GlStateManager.func_179121_F();
        }

        protected ResourceLocation getEntityTexture(EC entity) {
            return this.TEXTURE;
        }
    }

    public static class EC
    extends Entity {
        private static final DataParameter<Integer> USERID = EntityDataManager.func_187226_a(EC.class, (DataSerializer)DataSerializers.field_187192_b);
        private final AirPunch airPunch = new AirPunch();
        private float power;
        private final int growTime = 20;
        private int duration;

        public EC(World w) {
            super(w);
            this.func_70105_a(2.0f, 2.0f);
            this.field_70178_ae = true;
        }

        public EC(EntityLivingBase userIn, float powerIn) {
            this(userIn.field_70170_p);
            this.setUser(userIn);
            this.power = powerIn;
            this.duration = (int)powerIn * 4 + this.growTime;
            this.setIdlePosition();
        }

        protected void func_70088_a() {
            this.func_184212_Q().func_187214_a(USERID, (Object)-1);
        }

        private void setUser(EntityLivingBase user) {
            this.func_184212_Q().func_187227_b(USERID, (Object)user.func_145782_y());
        }

        protected EntityLivingBase getUser() {
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(USERID)).intValue());
            return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
        }

        private void setIdlePosition() {
            EntityLivingBase user = this.getUser();
            if (user != null) {
                Vec3d vec = user.func_70040_Z();
                vec = user.func_174791_d().func_72441_c(vec.field_72450_a, 0.6, vec.field_72449_c);
                this.func_70012_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, user.field_70177_z, 0.0f);
            }
        }

        public void func_70071_h_() {
            EntityLivingBase user = this.getUser();
            if (user != null) {
                this.setIdlePosition();
                if (this.field_70173_aa == 1) {
                    ProcedureSync.EntityNBTTag.setAndSync((Entity)user, NarutomodModVariables.forceBowPose, true);
                    this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:tenseiblastcharge")), 2.0f, 1.0f);
                } else if (this.field_70173_aa >= this.growTime) {
                    if (this.field_70173_aa % 40 == this.growTime) {
                        Vec3d vec = user.func_70040_Z().func_186678_a((double)(this.power * 0.5f)).func_178787_e(this.func_174791_d());
                        this.field_70170_p.func_184148_a(null, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:wind")), SoundCategory.NEUTRAL, 4.0f, 1.0f);
                    }
                    this.airPunch.execute(user, this.power, (double)this.power * 0.1);
                }
            }
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa > this.duration) {
                this.func_70106_y();
            }
        }

        public void func_70106_y() {
            EntityLivingBase user;
            super.func_70106_y();
            if (!this.field_70170_p.field_72995_K && (user = this.getUser()) != null) {
                ProcedureSync.EntityNBTTag.removeAndSync((Entity)user, NarutomodModVariables.forceBowPose);
            }
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                entity.field_70170_p.func_72838_d((Entity)new EC(entity, power));
                return true;
            }
        }

        public class AirPunch
        extends ProcedureAirPunch {
            private boolean griefing = true;

            public AirPunch() {
                this.blockHardnessLimit = 1.0f;
                this.particlesDuring = null;
            }

            @Override
            public void execute(EntityLivingBase player, double range, double radius) {
                this.griefing = EC.this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
                super.execute(player, range, radius);
            }

            @Override
            protected void preExecuteParticles(EntityLivingBase player) {
                Vec3d vec0 = player.func_70040_Z();
                Vec3d vec = vec0.func_186678_a(2.0).func_72441_c(player.field_70165_t, player.field_70163_u + 1.5, player.field_70161_v);
                for (int i = 1; i <= 50; ++i) {
                    Vec3d vec1 = vec0.func_186678_a((player.func_70681_au().nextDouble() * 0.8 + 0.2) * this.getRange(0) * 0.125);
                    Particles.spawnParticle(player.field_70170_p, Particles.Types.SMOKE, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 1, 0.0, 0.0, 0.0, vec1.field_72450_a + (player.func_70681_au().nextDouble() - 0.5) * this.getFarRadius(0) * 0.15, vec1.field_72448_b + (player.func_70681_au().nextDouble() - 0.5) * this.getFarRadius(0) * 0.15, vec1.field_72449_c + (player.func_70681_au().nextDouble() - 0.5) * this.getFarRadius(0) * 0.15, -2134851392, 80 + player.func_70681_au().nextInt(20), (int)(16.0 / (player.func_70681_au().nextDouble() * 0.8 + 0.2)));
                }
            }

            @Override
            protected void attackEntityFrom(EntityLivingBase player, Entity target) {
                ProcedureUtils.pushEntity((Entity)player, target, this.getRange(0), target instanceof EntityFallingBlock ? 1.0f : 2.0f);
            }

            @Override
            protected EntityItem processAffectedBlock(EntityLivingBase player, BlockPos pos, EnumFacing facing) {
                if (this.griefing && player.func_70681_au().nextInt(10) == 0) {
                    EntityFallingBlock falling = new EntityFallingBlock(player.field_70170_p, 0.5 + (double)pos.func_177958_n(), pos.func_177956_o(), 0.5 + (double)pos.func_177952_p(), player.field_70170_p.func_180495_p(pos)){
                        {
                            this.field_145813_c = false;
                        }

                        public boolean func_70104_M() {
                            return !this.field_70128_L;
                        }

                        public void func_70071_h_() {
                            super.func_70071_h_();
                            if (this.field_145812_b == 5 || ProcedureUtils.getVelocity((Entity)this) > 0.1) {
                                this.func_189654_d(false);
                            }
                        }
                    };
                    falling.func_189654_d(true);
                    player.field_70170_p.func_72838_d((Entity)falling);
                }
                return null;
            }

            @Override
            protected float getBreakChance(BlockPos pos, EntityLivingBase player, double range) {
                return 0.0f;
            }
        }
    }
}

