/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodModVariables;
import net.narutomod.block.BlockAmaterasuBlock;
import net.narutomod.block.BlockWaterStill;
import net.narutomod.event.EventSetBlocks;
import net.narutomod.item.ItemJutsu;
import net.narutomod.item.ItemSuiton;
import net.narutomod.procedure.ProcedureSync;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityWaterPrison
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 156;
    public static final int ENTITYID_RANGED = 157;
    private static final Map<EntityLivingBase, EntityLivingBase> trappedMap = Maps.newHashMap();

    public EntityWaterPrison(ElementsNarutomodMod instance) {
        super(instance, 412);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "water_prison"), 156).name("water_prison").tracker(64, 3, true).build());
    }

    public static boolean isEntityTrapped(EntityLivingBase entity) {
        return trappedMap.containsValue(entity);
    }

    public static boolean isEntityTrappedBy(EntityLivingBase trapper, EntityLivingBase target) {
        EntityLivingBase entity1 = trappedMap.get(trapper);
        return entity1 != null ? entity1.equals((Object)target) : false;
    }

    public static boolean isEntityTrapping(EntityLivingBase trapper) {
        return trappedMap.containsKey(trapper);
    }

    public static class EC
    extends Entity {
        private EntityLivingBase user;
        private EntityLivingBase target;
        private AxisAlignedBB realBB;
        private int totalWaterBlocks;
        private int duration;
        private final double chakraBurn;

        public EC(World world) {
            super(world);
            this.chakraBurn = ItemSuiton.WATERPRISON.chakraUsage * 0.1;
            this.func_70105_a(0.01f, 0.01f);
        }

        public EC(EntityLivingBase userIn, EntityLivingBase targetIn, int durationIn) {
            this(userIn.field_70170_p);
            this.user = userIn;
            this.target = targetIn;
            this.duration = durationIn;
            if (!this.field_70170_p.func_175623_d(new BlockPos((Entity)targetIn).func_177977_b())) {
                targetIn.func_70634_a(targetIn.field_70165_t, targetIn.field_70163_u + 0.5, targetIn.field_70161_v);
            }
            this.func_70107_b(targetIn.field_70165_t, targetIn.field_70163_u, targetIn.field_70161_v);
            int minX = (int)Math.floor(targetIn.func_174813_aQ().field_72340_a - 0.5);
            int maxX = (int)Math.ceil(targetIn.func_174813_aQ().field_72336_d + 0.5);
            int minZ = (int)Math.floor(targetIn.func_174813_aQ().field_72339_c - 0.5);
            int maxZ = (int)Math.ceil(targetIn.func_174813_aQ().field_72334_f + 0.5);
            int minY = (int)Math.floor(targetIn.func_174813_aQ().field_72338_b - 0.5);
            int maxY = (int)Math.ceil(targetIn.func_174813_aQ().field_72337_e + 0.5);
            this.realBB = new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            for (BlockPos pos : BlockPos.func_191531_b((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ)) {
                IBlockState blockstate = this.field_70170_p.func_180495_p(pos);
                if (blockstate.func_185904_a() != Material.field_151579_a && (blockstate.func_185904_a() != Material.field_151581_o || blockstate.func_177230_c() == BlockAmaterasuBlock.block) && !(blockstate.func_177230_c() instanceof BlockBush)) continue;
                this.field_70170_p.func_180501_a(pos, BlockWaterStill.block.func_176223_P(), 3);
                ++this.totalWaterBlocks;
            }
            trappedMap.put(userIn, targetIn);
        }

        protected void func_70088_a() {
        }

        public void func_70106_y() {
            super.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                this.func_184185_a(this.func_184181_aa(), 1.0f, 1.0f);
                for (BlockPos pos : BlockPos.func_191531_b((int)((int)this.realBB.field_72340_a), (int)((int)this.realBB.field_72338_b), (int)((int)this.realBB.field_72339_c), (int)((int)this.realBB.field_72336_d), (int)((int)this.realBB.field_72337_e), (int)((int)this.realBB.field_72334_f))) {
                    if (this.field_70170_p.func_180495_p(pos).func_185904_a() != Material.field_151586_h) continue;
                    this.field_70170_p.func_175698_g(pos);
                }
                HashMap map = Maps.newHashMap();
                for (BlockPos pos : ProcedureUtils.getAllAirBlocks(this.field_70170_p, this.realBB.func_191195_a(0.0, this.realBB.field_72337_e - this.realBB.field_72338_b - 1.0, 0.0))) {
                    map.put(pos, Blocks.field_150358_i.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(1)));
                }
                new EventSetBlocks(this.field_70170_p, map, 0L, 10, false, false);
                trappedMap.remove(this.user);
            }
        }

        private boolean enoughWaterRemaining() {
            int remaining = 0;
            for (BlockPos pos : BlockPos.func_191531_b((int)((int)this.realBB.field_72340_a), (int)((int)this.realBB.field_72338_b), (int)((int)this.realBB.field_72339_c), (int)((int)this.realBB.field_72336_d), (int)((int)this.realBB.field_72337_e), (int)((int)this.realBB.field_72334_f))) {
                if (this.field_70170_p.func_180495_p(pos).func_177230_c() != BlockWaterStill.block) continue;
                ++remaining;
            }
            return remaining >= this.totalWaterBlocks * 2 / 3;
        }

        public void func_70071_h_() {
            if (this.user != null && this.user.func_70089_S() && ItemJutsu.canTarget((Entity)this.target) && (double)this.user.func_70032_d((Entity)this.target) <= 4.0 && ProcedureUtils.isEntityInFOV(this.user, (Entity)this.target) && this.enoughWaterRemaining() && this.field_70173_aa <= this.duration) {
                this.target.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                for (EntityLivingBase entity : this.field_70170_p.func_72872_a(EntityLivingBase.class, this.realBB)) {
                    if (entity.equals((Object)this.target)) continue;
                    Vec3d vec = entity.func_174791_d().func_178788_d(this.func_174791_d()).func_72432_b().func_186678_a(0.2);
                    ProcedureUtils.setVelocity((Entity)entity, entity.field_70159_w + vec.field_72450_a, entity.field_70181_x, entity.field_70179_y + vec.field_72449_c);
                }
                if (this.field_70173_aa % 20 == 0) {
                    Chakra.pathway(this.user).consume(this.chakraBurn);
                }
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
            if (this.user != null) {
                if (this.field_70128_L) {
                    ProcedureSync.EntityNBTTag.removeAndSync((Entity)this.user, NarutomodModVariables.forceBowPose);
                } else if (!this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
                    ProcedureSync.EntityNBTTag.setAndSync((Entity)this.user, NarutomodModVariables.forceBowPose, true);
                }
            }
        }

        protected void func_70037_a(NBTTagCompound compound) {
            this.field_70173_aa = compound.func_74762_e("ticksExisted");
            this.duration = compound.func_74762_e("duration");
            this.totalWaterBlocks = compound.func_74762_e("totalWaterBlocks");
            this.realBB = new AxisAlignedBB(compound.func_74769_h("minX"), compound.func_74769_h("minY"), compound.func_74769_h("minZ"), compound.func_74769_h("maxX"), compound.func_74769_h("maxY"), compound.func_74769_h("maxZ"));
        }

        protected void func_70014_b(NBTTagCompound compound) {
            compound.func_74768_a("ticksExisted", this.field_70173_aa);
            compound.func_74768_a("duration", this.duration);
            compound.func_74768_a("totalWaterBlocks", this.totalWaterBlocks);
            compound.func_74780_a("minX", this.realBB.field_72340_a);
            compound.func_74780_a("minY", this.realBB.field_72338_b);
            compound.func_74780_a("minZ", this.realBB.field_72339_c);
            compound.func_74780_a("maxX", this.realBB.field_72336_d);
            compound.func_74780_a("maxY", this.realBB.field_72337_e);
            compound.func_74780_a("maxZ", this.realBB.field_72334_f);
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                return this.createJutsu(entity) != null;
            }

            public Entity createJutsu(EntityLivingBase entity, EntityLivingBase target) {
                return this.createJutsu(entity, target, 3600);
            }

            public Entity createJutsu(EntityLivingBase entity, EntityLivingBase target, int duration) {
                if ((double)entity.func_70032_d((Entity)target) <= 4.0 && target.field_70130_N <= 2.0f && target.field_70131_O <= 3.0f) {
                    entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:suironojutsu")), SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    EC entitytospawn = new EC(entity, target, duration);
                    entity.field_70170_p.func_72838_d((Entity)entitytospawn);
                    return entitytospawn;
                }
                return null;
            }

            public Entity createJutsu(EntityLivingBase entity) {
                Entity target;
                Object object = entity instanceof EntityPlayer ? ProcedureUtils.objectEntityLookingAt((Entity)entity, (double)4.0).field_72308_g : (target = entity instanceof EntityLiving ? ((EntityLiving)entity).func_70638_az() : null);
                if (target instanceof EntityLivingBase) {
                    return this.createJutsu(entity, (EntityLivingBase)target);
                }
                return null;
            }
        }
    }
}

