/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.block.BlockWaterStill;
import net.narutomod.entity.EntitySuitonShark;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityWaterShockwave
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 197;
    public static final int ENTITYID_RANGED = 198;

    public EntityWaterShockwave(ElementsNarutomodMod instance) {
        super(instance, 456);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "water_shockwave"), 197).name("water_shockwave").tracker(64, 3, true).build());
    }

    public static class EC
    extends Entity {
        private EntityLivingBase user;
        private int radius;
        private boolean buildUpPhase;
        private final List<BlockPos> domeBlocks = Lists.newArrayList();
        private boolean shouldDie;
        private int deathTicks;
        private static final AttributeModifier SWIM_SPEED_MODIFIER = new AttributeModifier("watershockwave.swimspeed", 1.2, 0);

        public EC(World world) {
            super(world);
            this.func_70105_a(0.01f, 0.01f);
        }

        public EC(EntityLivingBase userIn, float power) {
            this(userIn.field_70170_p);
            this.user = userIn;
            this.radius = (int)power;
            this.func_70107_b(userIn.field_70165_t, userIn.field_70163_u, userIn.field_70161_v);
            this.buildUpPhase = true;
        }

        protected void func_70088_a() {
        }

        public void onDeathUpdate() {
            if (this.user != null) {
                this.user.func_110148_a(EntityLivingBase.SWIM_SPEED).func_111124_b(SWIM_SPEED_MODIFIER);
            }
            if (this.deathTicks == 0) {
                for (BlockPos pos : this.domeBlocks) {
                    this.field_70170_p.func_180501_a(pos, this.field_70146_Z.nextInt(3) == 0 ? Blocks.field_150358_i.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(1)) : Blocks.field_150350_a.func_176223_P(), 3);
                }
            } else if (this.deathTicks % 5 == 0) {
                for (BlockPos pos : this.domeBlocks) {
                    this.field_70170_p.func_175698_g(pos);
                }
            } else if (this.deathTicks > 30) {
                this.func_70106_y();
                this.domeBlocks.clear();
            }
            ++this.deathTicks;
        }

        public void func_70071_h_() {
            if (this.shouldDie) {
                this.onDeathUpdate();
                return;
            }
            if (this.user != null && this.user.func_70089_S()) {
                IAttributeInstance attrInstance;
                Object list;
                if (this.buildUpPhase) {
                    this.user.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    list = this.getAirBlocksInRadius();
                    if (!list.isEmpty()) {
                        for (int i = 0; i < this.radius * this.radius && i < list.size(); ++i) {
                            BlockPos pos = list.get(i);
                            this.field_70170_p.func_180501_a(pos, BlockWaterStill.block.func_176223_P(), 3);
                            this.domeBlocks.add(pos);
                        }
                    } else {
                        this.buildUpPhase = false;
                    }
                } else {
                    this.func_70107_b(this.user.field_70165_t, this.user.field_70163_u, this.user.field_70161_v);
                    list = this.getAirBlocksInRadius();
                    if (list.size() > this.domeBlocks.size() / 2) {
                        this.shouldDie = true;
                        return;
                    }
                    for (int i = 0; i < list.size() && i < 512; ++i) {
                        BlockPos pos = (BlockPos)list.get(i);
                        this.field_70170_p.func_180501_a(pos, BlockWaterStill.block.func_176223_P(), 3);
                        if (this.domeContains(pos)) continue;
                        this.domeBlocks.add(pos);
                    }
                    Iterator<BlockPos> iter = this.domeBlocks.iterator();
                    double d = (double)this.radius + 0.5;
                    d *= d;
                    int i = 0;
                    while (iter.hasNext() && i < 512) {
                        BlockPos pos = iter.next();
                        if (!(pos.func_177957_d(this.field_70165_t, this.field_70163_u, this.field_70161_v) > d)) continue;
                        this.field_70170_p.func_175698_g(pos);
                        iter.remove();
                        ++i;
                    }
                }
                for (Entity entity : this.field_70170_p.func_72839_b((Entity)this.user, this.func_174813_aQ().func_186662_g((double)this.radius))) {
                    if (entity instanceof EntitySuitonShark.EC || !BlockWaterStill.isInsideBlock(entity, false)) continue;
                    ProcedureUtils.multiplyVelocity(entity, 0.8);
                }
                this.user.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 2, 0));
                this.user.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 210, 0));
                if (!this.buildUpPhase && !(attrInstance = this.user.func_110148_a(EntityLivingBase.SWIM_SPEED)).func_180374_a(SWIM_SPEED_MODIFIER)) {
                    attrInstance.func_111121_a(SWIM_SPEED_MODIFIER);
                }
            } else if (!this.field_70170_p.field_72995_K) {
                this.shouldDie = true;
            }
        }

        private List<BlockPos> getAirBlocksInRadius() {
            List<BlockPos> list = ProcedureUtils.getAllAirBlocks(this.field_70170_p, this.func_174813_aQ().func_186662_g((double)this.radius));
            list.sort(new ProcedureUtils.BlockposSorter(new BlockPos((Entity)this)));
            Iterator<BlockPos> iter = list.iterator();
            double d = (double)this.radius + 0.5;
            d *= d;
            while (iter.hasNext()) {
                BlockPos pos = iter.next();
                if (!(pos.func_177957_d(this.field_70165_t, this.field_70163_u, this.field_70161_v) > d)) continue;
                iter.remove();
            }
            return list;
        }

        private boolean domeContains(BlockPos pos) {
            for (BlockPos pos1 : this.domeBlocks) {
                if (!pos1.equals((Object)pos)) continue;
                return true;
            }
            return false;
        }

        public void setShouldDie() {
            this.shouldDie = true;
        }

        protected void func_70037_a(NBTTagCompound compound) {
            if (compound.func_186855_b("userUUID") && this.field_70170_p instanceof WorldServer) {
                this.user = (EntityLivingBase)((WorldServer)this.field_70170_p).func_175733_a(compound.func_186857_a("userUUID"));
            }
            this.buildUpPhase = compound.func_74767_n("buildUpPhase");
            this.radius = compound.func_74762_e("radius");
            if (compound.func_150297_b("domeBlocks", 9)) {
                NBTTagList nbttaglist = compound.func_150295_c("domeBlocks", 10);
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                    this.domeBlocks.add(new BlockPos(nbttagcompound.func_74762_e("blockPosX"), nbttagcompound.func_74762_e("blockPosY"), nbttagcompound.func_74762_e("blockPosZ")));
                }
            }
        }

        protected void func_70014_b(NBTTagCompound compound) {
            if (this.user != null) {
                compound.func_186854_a("userUUID", this.user.func_110124_au());
            }
            compound.func_74757_a("buildUpPhase", this.buildUpPhase);
            compound.func_74768_a("radius", this.radius);
            NBTTagList nbttaglist = new NBTTagList();
            for (BlockPos pos : this.domeBlocks) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74768_a("blockPosX", pos.func_177958_n());
                nbttagcompound.func_74768_a("blockPosY", pos.func_177956_o());
                nbttagcompound.func_74768_a("blockPosZ", pos.func_177952_p());
                nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            }
            if (!nbttaglist.func_82582_d()) {
                compound.func_74782_a("domeBlocks", (NBTBase)nbttaglist);
            }
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            private static final String ID_KEY = "WaterShockwaveEntityIdKey";

            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                Entity entity1 = entity.field_70170_p.func_73045_a(entity.getEntityData().func_74762_e(ID_KEY));
                if (entity1 instanceof EC) {
                    ((EC)entity1).shouldDie = true;
                    return false;
                }
                entity1 = this.createJutsu(entity, power);
                entity.getEntityData().func_74768_a(ID_KEY, entity1.func_145782_y());
                return true;
            }

            public EC createJutsu(EntityLivingBase entity, float power) {
                entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:daibakusuishoha")), SoundCategory.PLAYERS, 2.0f, 1.0f);
                EC entity1 = new EC(entity, power);
                entity.field_70170_p.func_72838_d((Entity)entity1);
                return entity1;
            }
        }
    }
}

