/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.item.ItemJutsu;
import net.narutomod.item.ItemMokuton;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityWoodArm
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 321;
    public static final int ENTITYID_RANGED = 322;

    public EntityWoodArm(ElementsNarutomodMod instance) {
        super(instance, 673);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "wood_arm"), 321).name("wood_arm").tracker(64, 3, true).build());
    }

    public static class EC
    extends ItemMokuton.WoodSegment {
        private int lifespan = 200;
        private EC prevSegment;
        private Entity target;
        private double targetDistance;
        private double targetYOffset;
        private float targetYawOffset;
        private int reachedCount;

        public EC(World world) {
            super(world);
        }

        public EC(EntityLivingBase user, Entity targetIn) {
            this(user.field_70170_p);
            this.setParent((Entity)user);
            this.setOffset(-0.4, 1.2, 0.0, 0.0f, 90.0f);
            this.setPositionAndRotationFromParent(1.0f);
            this.lifespan = 200;
            this.prevSegment = this;
            this.target = targetIn;
        }

        public EC(EC segment, float yawOffset, float pitchOffset) {
            super(segment, yawOffset, pitchOffset);
            this.target = segment.target;
        }

        private void setLifespan(int ticks) {
            this.lifespan = ticks;
        }

        @Override
        public void func_70071_h_() {
            Entity parent;
            super.func_70071_h_();
            if (this.field_70173_aa == 1 && this.field_70146_Z.nextFloat() < 0.5f) {
                this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:woodgrow")), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.6f);
            }
            if ((parent = this.getParent()) != null && parent.func_70089_S() && this.field_70173_aa < this.lifespan) {
                if (!this.field_70170_p.field_72995_K && this.getIndex() == 0 && this.field_70173_aa > 1 && this.field_70173_aa <= 50) {
                    ProcedureUtils.Vec2f vec2f = new ProcedureUtils.Vec2f((this.field_70146_Z.nextFloat() - 0.5f) * 30.0f, (this.field_70146_Z.nextFloat() - 0.5f) * 30.0f);
                    if (this.hasLivingTarget() && this.prevSegment.getIndex() > 10) {
                        Vec3d vec = this.target.func_174791_d().func_72441_c(0.0, (double)(this.target.field_70131_O / 2.0f), 0.0);
                        double d = this.prevSegment.func_70011_f(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                        float f1 = 1.0f / (this.target.field_70130_N + (float)MathHelper.func_151237_a((double)d, (double)1.0, (double)4.4));
                        vec2f = ProcedureUtils.getYawPitchFromVec(vec.func_178788_d(this.prevSegment.func_174791_d())).add(-this.prevSegment.field_70177_z, 90.0f - this.prevSegment.field_70125_A).scale(f1);
                        if (d < (double)((this.target.field_70130_N + this.field_70130_N) * 0.6f)) {
                            ++this.reachedCount;
                        }
                        if (this.targetDistance == 0.0 && this.reachedCount >= MathHelper.func_76123_f((float)(this.target.field_70130_N * 4.0f / this.field_70130_N))) {
                            vec = this.target.func_174791_d().func_178788_d(parent.func_174791_d());
                            this.targetDistance = vec.func_72433_c();
                            this.targetYOffset = vec.field_72448_b;
                            this.targetYawOffset = MathHelper.func_76142_g((float)(ProcedureUtils.getYawFromVec(vec.field_72450_a, vec.field_72449_c) - parent.field_70177_z));
                        }
                    }
                    this.prevSegment = new EC(this.prevSegment, vec2f.x, vec2f.y);
                    this.prevSegment.setLifespan(this.lifespan - this.field_70173_aa * 2);
                    this.field_70170_p.func_72838_d((Entity)this.prevSegment);
                }
                if (this.field_70173_aa == 1 && this.targetTargetable() && this.func_174813_aQ().func_72326_a(this.target.func_174813_aQ())) {
                    this.target.getEntityData().func_74757_a("TempData_disableKnockback", true);
                    this.target.func_70097_a(ItemJutsu.causeJutsuDamage(this, parent instanceof EntityLivingBase ? (EntityLivingBase)parent : null), 4.0f);
                }
                if (this.targetDistance != 0.0 && this.targetTargetable() && this.field_70173_aa < this.lifespan * 4 / 5) {
                    Vec3d vec = new Vec3d(0.0, 0.0, this.targetDistance).func_178785_b(-(parent.field_70177_z + this.targetYawOffset) * ((float)Math.PI / 180)).func_72441_c(parent.field_70165_t, this.targetYOffset + parent.field_70163_u, parent.field_70161_v);
                    this.target.func_70634_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                }
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }

        private boolean hasLivingTarget() {
            return this.target != null && this.target.func_70089_S();
        }

        private boolean targetTargetable() {
            return ItemJutsu.canTarget(this.target);
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                RayTraceResult res = ProcedureUtils.objectEntityLookingAt((Entity)entity, 30.0);
                if (res != null && res.field_72308_g != null) {
                    entity.field_70170_p.func_72838_d((Entity)new EC(entity, res.field_72308_g));
                    return true;
                }
                return false;
            }
        }
    }
}

