/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.entity.EntityShieldBase;
import net.narutomod.item.ItemJutsu;
import net.narutomod.item.ItemMokuton;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityWoodGolem
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 276;
    public static final int ENTITYID_RANGED = 277;
    private static final float MODELSCALE = 8.0f;

    public EntityWoodGolem(ElementsNarutomodMod instance) {
        super(instance, 595);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "wood_golem"), 276).name("wood_golem").tracker(96, 3, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EC.class, renderManager -> new RenderCustom(renderManager));
    }

    @SideOnly(value=Side.CLIENT)
    public class ModelWoodGolem
    extends ModelBiped {
        private final ModelRenderer HatLayer_r1;
        private final ModelRenderer bone9;
        private final ModelRenderer bone45;
        private final ModelRenderer HatLayer_r2;
        private final ModelRenderer bone47;
        private final ModelRenderer HatLayer_r3;
        private final ModelRenderer bone48;
        private final ModelRenderer HatLayer_r4;
        private final ModelRenderer bone46;
        private final ModelRenderer HatLayer_r5;
        private final ModelRenderer bone44;
        private final ModelRenderer HatLayer_r6;
        private final ModelRenderer bone43;
        private final ModelRenderer HatLayer_r7;
        private final ModelRenderer rightUpperArm;
        private final ModelRenderer rightForeArm;
        private final ModelRenderer leftUpperArm;
        private final ModelRenderer leftForeArm;
        private final ModelRenderer rightThigh;
        private final ModelRenderer rightCalf;
        private final ModelRenderer leftThigh;
        private final ModelRenderer leftCalf;
        private final ModelRenderer dragon;
        private final ModelRenderer bone10;
        private final ModelRenderer bone11;
        private final ModelRenderer bone12;
        private final ModelRenderer bone13;
        private final ModelRenderer bone14;
        private final ModelRenderer bone15;
        private final ModelRenderer bone16;
        private final ModelRenderer bone17;
        private final ModelRenderer bone18;
        private final ModelRenderer bone19;
        private final ModelRenderer bone20;
        private final ModelRenderer bone21;
        private final ModelRenderer bone22;
        private final ModelRenderer bone23;
        private final ModelRenderer bone24;
        private final ModelRenderer bone25;
        private final ModelRenderer bone26;
        private final ModelRenderer bone27;
        private final ModelRenderer bone28;
        private final ModelRenderer bone29;
        private final ModelRenderer bone30;
        private final ModelRenderer bone31;
        private final ModelRenderer bone32;
        private final ModelRenderer bone33;
        private final ModelRenderer bone34;
        private final ModelRenderer bone35;
        private final ModelRenderer bone36;
        private final ModelRenderer bone37;
        private final ModelRenderer bone38;
        private final ModelRenderer dragonHead;
        private final ModelRenderer bone39;
        private final ModelRenderer bone50;
        private final ModelRenderer bone49;
        private final ModelRenderer bone51;
        private final ModelRenderer bone40;
        private final ModelRenderer dragonEyes;
        private final ModelRenderer bone41;
        private final ModelRenderer bone42;

        public ModelWoodGolem() {
            this.field_78090_t = 64;
            this.field_78089_u = 64;
            this.field_78116_c = new ModelRenderer((ModelBase)this);
            this.field_78116_c.func_78793_a(0.0f, 0.0f, 0.0f);
            this.field_78116_c.field_78804_l.add(new ModelBox(this.field_78116_c, 0, 16, -4.0f, -8.5f, -4.0f, 8, 8, 8, 0.0f, false));
            this.HatLayer_r1 = new ModelRenderer((ModelBase)this);
            this.HatLayer_r1.func_78793_a(0.0f, -5.0119f, 5.1599f);
            this.field_78116_c.func_78792_a(this.HatLayer_r1);
            this.setRotationAngle(this.HatLayer_r1, 1.0036f, 3.1416f, 0.0f);
            this.HatLayer_r1.field_78804_l.add(new ModelBox(this.HatLayer_r1, 46, 32, -4.0f, -1.25f, -1.625f, 8, 5, 0, 0.0f, false));
            this.bone9 = new ModelRenderer((ModelBase)this);
            this.bone9.func_78793_a(0.0f, -8.5f, -4.0f);
            this.field_78116_c.func_78792_a(this.bone9);
            this.setRotationAngle(this.bone9, -0.5236f, 0.0f, 0.0f);
            this.bone9.field_78804_l.add(new ModelBox(this.bone9, 46, 32, -4.0f, -5.0f, 0.0f, 8, 5, 0, 0.0f, false));
            this.bone45 = new ModelRenderer((ModelBase)this);
            this.bone45.func_78793_a(-3.7f, -10.7815f, -3.0149f);
            this.field_78116_c.func_78792_a(this.bone45);
            this.setRotationAngle(this.bone45, -1.0036f, 0.7854f, -1.1781f);
            this.HatLayer_r2 = new ModelRenderer((ModelBase)this);
            this.HatLayer_r2.func_78793_a(-1.4091f, 0.2641f, -0.1594f);
            this.bone45.func_78792_a(this.HatLayer_r2);
            this.setRotationAngle(this.HatLayer_r2, 0.1309f, -0.5236f, 0.0f);
            this.HatLayer_r2.field_78804_l.add(new ModelBox(this.HatLayer_r2, 59, 44, -0.725f, -1.775f, -0.625f, 2, 5, 0, 0.0f, false));
            this.bone47 = new ModelRenderer((ModelBase)this);
            this.bone47.func_78793_a(-3.7f, -10.7815f, -3.0149f);
            this.field_78116_c.func_78792_a(this.bone47);
            this.setRotationAngle(this.bone47, -1.0036f, 0.7854f, -1.1781f);
            this.HatLayer_r3 = new ModelRenderer((ModelBase)this);
            this.HatLayer_r3.func_78793_a(-9.8033f, 0.1704f, 2.2299f);
            this.bone47.func_78792_a(this.HatLayer_r3);
            this.setRotationAngle(this.HatLayer_r3, 0.2618f, 1.1345f, 0.0f);
            this.HatLayer_r3.field_78804_l.add(new ModelBox(this.HatLayer_r3, 59, 44, -0.9f, -1.45f, -0.8f, 2, 5, 0, 0.0f, false));
            this.bone48 = new ModelRenderer((ModelBase)this);
            this.bone48.func_78793_a(3.7f, -10.7815f, -3.0149f);
            this.field_78116_c.func_78792_a(this.bone48);
            this.setRotationAngle(this.bone48, -1.0036f, -0.7854f, 1.1781f);
            this.HatLayer_r4 = new ModelRenderer((ModelBase)this);
            this.HatLayer_r4.func_78793_a(9.8033f, 0.1704f, 2.2299f);
            this.bone48.func_78792_a(this.HatLayer_r4);
            this.setRotationAngle(this.HatLayer_r4, 0.2618f, -1.1345f, 0.0f);
            this.HatLayer_r4.field_78804_l.add(new ModelBox(this.HatLayer_r4, 59, 44, -1.25f, -1.45f, -1.175f, 2, 5, 0, 0.0f, true));
            this.bone46 = new ModelRenderer((ModelBase)this);
            this.bone46.func_78793_a(3.7f, -10.7815f, -3.0149f);
            this.field_78116_c.func_78792_a(this.bone46);
            this.setRotationAngle(this.bone46, -1.0036f, -0.7854f, 1.1781f);
            this.HatLayer_r5 = new ModelRenderer((ModelBase)this);
            this.HatLayer_r5.func_78793_a(1.4091f, 0.2641f, -0.1594f);
            this.bone46.func_78792_a(this.HatLayer_r5);
            this.setRotationAngle(this.HatLayer_r5, 0.1309f, 0.5236f, 0.0f);
            this.HatLayer_r5.field_78804_l.add(new ModelBox(this.HatLayer_r5, 59, 44, -1.275f, -1.775f, -0.625f, 2, 5, 0, 0.0f, true));
            this.bone44 = new ModelRenderer((ModelBase)this);
            this.bone44.func_78793_a(-4.6479f, -9.2565f, 0.5796f);
            this.field_78116_c.func_78792_a(this.bone44);
            this.setRotationAngle(this.bone44, 0.7418f, 1.309f, 0.0f);
            this.HatLayer_r6 = new ModelRenderer((ModelBase)this);
            this.HatLayer_r6.func_78793_a(0.0f, 0.0f, 0.0f);
            this.bone44.func_78792_a(this.HatLayer_r6);
            this.setRotationAngle(this.HatLayer_r6, -0.3054f, -0.3491f, -0.7854f);
            this.HatLayer_r6.field_78804_l.add(new ModelBox(this.HatLayer_r6, 13, 0, -6.425f, -1.225f, -0.8f, 9, 5, 0, 0.0f, true));
            this.bone43 = new ModelRenderer((ModelBase)this);
            this.bone43.func_78793_a(4.6479f, -9.2565f, 0.5796f);
            this.field_78116_c.func_78792_a(this.bone43);
            this.setRotationAngle(this.bone43, 0.7418f, -1.309f, 0.0f);
            this.HatLayer_r7 = new ModelRenderer((ModelBase)this);
            this.HatLayer_r7.func_78793_a(0.0f, 0.0f, 0.0f);
            this.bone43.func_78792_a(this.HatLayer_r7);
            this.setRotationAngle(this.HatLayer_r7, -0.3054f, 0.3491f, 0.7854f);
            this.HatLayer_r7.field_78804_l.add(new ModelBox(this.HatLayer_r7, 13, 0, -2.575f, -1.225f, -0.8f, 9, 5, 0, 0.0f, false));
            this.field_178720_f = new ModelRenderer((ModelBase)this);
            this.field_178720_f.func_78793_a(0.0f, 0.0f, 0.0f);
            this.field_178720_f.field_78804_l.add(new ModelBox(this.field_178720_f, 42, 46, -4.025f, -6.925f, -4.005f, 8, 2, 0, 0.0f, false));
            this.field_78115_e = new ModelRenderer((ModelBase)this);
            this.field_78115_e.func_78793_a(0.0f, 0.0f, 0.0f);
            this.field_78115_e.field_78804_l.add(new ModelBox(this.field_78115_e, 0, 32, -4.0f, -0.5f, -2.0f, 8, 12, 4, 0.6f, false));
            this.field_78115_e.field_78804_l.add(new ModelBox(this.field_78115_e, 6, 6, -4.0f, 4.25f, -3.425f, 8, 7, 2, 0.0f, false));
            this.field_178723_h = new ModelRenderer((ModelBase)this);
            this.field_178723_h.func_78793_a(-5.0f, 2.0f, 0.0f);
            this.rightUpperArm = new ModelRenderer((ModelBase)this);
            this.rightUpperArm.func_78793_a(-1.0f, 0.0f, 0.0f);
            this.field_178723_h.func_78792_a(this.rightUpperArm);
            this.setRotationAngle(this.rightUpperArm, -1.0472f, -0.5236f, 0.2618f);
            this.rightUpperArm.field_78804_l.add(new ModelBox(this.rightUpperArm, 32, 0, -3.1121f, -2.483f, -1.9353f, 4, 8, 4, 0.0f, false));
            this.rightForeArm = new ModelRenderer((ModelBase)this);
            this.rightForeArm.func_78793_a(-1.0f, 5.0f, 0.0f);
            this.rightUpperArm.func_78792_a(this.rightForeArm);
            this.setRotationAngle(this.rightForeArm, -0.5236f, 0.0f, -0.5236f);
            this.rightForeArm.field_78804_l.add(new ModelBox(this.rightForeArm, 28, 12, -2.1121f, -0.4506f, -2.1854f, 4, 8, 4, 0.0f, false));
            this.field_178724_i = new ModelRenderer((ModelBase)this);
            this.field_178724_i.func_78793_a(5.0f, 2.0f, 0.0f);
            this.leftUpperArm = new ModelRenderer((ModelBase)this);
            this.leftUpperArm.func_78793_a(1.0f, 0.0f, 0.0f);
            this.field_178724_i.func_78792_a(this.leftUpperArm);
            this.setRotationAngle(this.leftUpperArm, -1.0472f, 0.5236f, -0.2618f);
            this.leftUpperArm.field_78804_l.add(new ModelBox(this.leftUpperArm, 32, 0, -0.8879f, -2.483f, -1.9353f, 4, 8, 4, 0.0f, true));
            this.leftForeArm = new ModelRenderer((ModelBase)this);
            this.leftForeArm.func_78793_a(1.0f, 5.0f, 0.0f);
            this.leftUpperArm.func_78792_a(this.leftForeArm);
            this.setRotationAngle(this.leftForeArm, -0.5236f, 0.0f, 0.5236f);
            this.leftForeArm.field_78804_l.add(new ModelBox(this.leftForeArm, 28, 12, -1.8879f, -0.4506f, -2.1854f, 4, 8, 4, 0.0f, true));
            this.field_178721_j = new ModelRenderer((ModelBase)this);
            this.field_178721_j.func_78793_a(-1.9f, 12.0f, 0.0f);
            this.rightThigh = new ModelRenderer((ModelBase)this);
            this.rightThigh.func_78793_a(-0.1f, -1.0f, 0.0f);
            this.field_178721_j.func_78792_a(this.rightThigh);
            this.setRotationAngle(this.rightThigh, -2.0944f, 0.2618f, -1.4835f);
            this.rightThigh.field_78804_l.add(new ModelBox(this.rightThigh, 20, 44, -1.9f, 0.5076f, -2.0868f, 4, 6, 4, 0.4f, false));
            this.rightCalf = new ModelRenderer((ModelBase)this);
            this.rightCalf.func_78793_a(0.0f, 7.0f, -2.2f);
            this.rightThigh.func_78792_a(this.rightCalf);
            this.setRotationAngle(this.rightCalf, 1.309f, 0.0f, 0.0f);
            this.rightCalf.field_78804_l.add(new ModelBox(this.rightCalf, 44, 8, -1.9f, -0.4981f, 0.0436f, 4, 7, 4, 0.2f, false));
            this.field_178722_k = new ModelRenderer((ModelBase)this);
            this.field_178722_k.func_78793_a(1.9f, 12.0f, 0.0f);
            this.leftThigh = new ModelRenderer((ModelBase)this);
            this.leftThigh.func_78793_a(0.1f, -1.0f, 0.0f);
            this.field_178722_k.func_78792_a(this.leftThigh);
            this.setRotationAngle(this.leftThigh, -2.0944f, -0.2618f, 1.4835f);
            this.leftThigh.field_78804_l.add(new ModelBox(this.leftThigh, 20, 44, -2.1f, 0.5076f, -2.0868f, 4, 6, 4, 0.4f, true));
            this.leftCalf = new ModelRenderer((ModelBase)this);
            this.leftCalf.func_78793_a(0.0f, 7.0f, -2.2f);
            this.leftThigh.func_78792_a(this.leftCalf);
            this.setRotationAngle(this.leftCalf, 1.309f, 0.0f, 0.0f);
            this.leftCalf.field_78804_l.add(new ModelBox(this.leftCalf, 44, 8, -2.1f, -0.4981f, 0.0436f, 4, 7, 4, 0.2f, true));
            this.dragon = new ModelRenderer((ModelBase)this);
            this.dragon.func_78793_a(0.0f, 0.0f, 0.0f);
            this.dragon.field_78804_l.add(new ModelBox(this.dragon, 44, 19, -4.0f, 15.5f, 3.0f, 4, 4, 4, 0.0f, false));
            this.dragon.field_78804_l.add(new ModelBox(this.dragon, 44, 19, -4.0f, 17.875f, 3.0f, 4, 4, 4, -0.5f, false));
            this.dragon.field_78804_l.add(new ModelBox(this.dragon, 44, 19, -4.0f, 19.875f, 3.0f, 4, 4, 4, -1.0f, false));
            this.dragon.field_78804_l.add(new ModelBox(this.dragon, 44, 19, -4.05f, 21.3f, 3.0f, 4, 4, 4, -1.2f, false));
            this.bone10 = new ModelRenderer((ModelBase)this);
            this.bone10.func_78793_a(-2.0f, 15.0f, 5.0f);
            this.dragon.func_78792_a(this.bone10);
            this.setRotationAngle(this.bone10, 0.2618f, 0.0f, -0.2618f);
            this.bone10.field_78804_l.add(new ModelBox(this.bone10, 44, 19, -1.8706f, -1.4665f, -1.875f, 4, 4, 4, 0.0f, false));
            this.bone11 = new ModelRenderer((ModelBase)this);
            this.bone11.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone10.func_78792_a(this.bone11);
            this.setRotationAngle(this.bone11, 0.2618f, 0.0f, -0.2618f);
            this.bone11.field_78804_l.add(new ModelBox(this.bone11, 44, 19, -1.7543f, -1.3706f, -1.7713f, 4, 4, 4, 0.0f, false));
            this.bone12 = new ModelRenderer((ModelBase)this);
            this.bone12.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone11.func_78792_a(this.bone12);
            this.setRotationAngle(this.bone12, 0.2618f, 0.0f, -0.2618f);
            this.bone12.field_78804_l.add(new ModelBox(this.bone12, 44, 19, -1.6667f, -1.2251f, -1.7029f, 4, 4, 4, 0.0f, false));
            this.bone13 = new ModelRenderer((ModelBase)this);
            this.bone13.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone12.func_78792_a(this.bone13);
            this.setRotationAngle(this.bone13, 0.2182f, 0.0f, 0.0f);
            this.bone13.field_78804_l.add(new ModelBox(this.bone13, 44, 19, -1.6667f, -1.1555f, -1.6612f, 4, 4, 4, 0.0f, false));
            this.bone14 = new ModelRenderer((ModelBase)this);
            this.bone14.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone13.func_78792_a(this.bone14);
            this.setRotationAngle(this.bone14, 0.2618f, 0.0f, 0.2618f);
            this.bone14.field_78804_l.add(new ModelBox(this.bone14, 44, 19, -1.7183f, -1.1407f, -1.6116f, 4, 4, 4, 0.0f, false));
            this.bone15 = new ModelRenderer((ModelBase)this);
            this.bone15.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone14.func_78792_a(this.bone15);
            this.setRotationAngle(this.bone15, 0.0f, 0.0f, 0.3491f);
            this.bone15.field_78804_l.add(new ModelBox(this.bone15, 44, 19, -1.7834f, -1.2285f, -1.6116f, 4, 4, 4, 0.0f, false));
            this.bone16 = new ModelRenderer((ModelBase)this);
            this.bone16.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone15.func_78792_a(this.bone16);
            this.setRotationAngle(this.bone16, 0.0f, 0.0f, 0.3491f);
            this.bone16.field_78804_l.add(new ModelBox(this.bone16, 44, 19, -1.8747f, -1.2888f, -1.6116f, 4, 4, 4, 0.0f, false));
            this.bone17 = new ModelRenderer((ModelBase)this);
            this.bone17.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone16.func_78792_a(this.bone17);
            this.setRotationAngle(this.bone17, 0.0f, 0.0f, 0.3491f);
            this.bone17.field_78804_l.add(new ModelBox(this.bone17, 44, 19, -1.981f, -1.3143f, -1.6116f, 4, 4, 4, 0.0f, false));
            this.bone18 = new ModelRenderer((ModelBase)this);
            this.bone18.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone17.func_78792_a(this.bone18);
            this.setRotationAngle(this.bone18, 0.2618f, 0.0f, 0.3491f);
            this.bone18.field_78804_l.add(new ModelBox(this.bone18, 44, 19, -2.0896f, -1.191f, -1.5467f, 4, 4, 4, 0.0f, false));
            this.bone19 = new ModelRenderer((ModelBase)this);
            this.bone19.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone18.func_78792_a(this.bone19);
            this.setRotationAngle(this.bone19, 0.0f, 0.0f, 0.2618f);
            this.bone19.field_78804_l.add(new ModelBox(this.bone19, 44, 19, -2.136f, -1.1613f, -1.5467f, 4, 4, 4, 0.0f, false));
            this.bone20 = new ModelRenderer((ModelBase)this);
            this.bone20.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone19.func_78792_a(this.bone20);
            this.bone20.field_78804_l.add(new ModelBox(this.bone20, 44, 19, -2.136f, -1.1613f, -1.5467f, 4, 4, 4, 0.0f, false));
            this.bone21 = new ModelRenderer((ModelBase)this);
            this.bone21.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone20.func_78792_a(this.bone21);
            this.bone21.field_78804_l.add(new ModelBox(this.bone21, 44, 19, -2.136f, -1.1613f, -1.5467f, 4, 4, 4, 0.0f, false));
            this.bone22 = new ModelRenderer((ModelBase)this);
            this.bone22.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone21.func_78792_a(this.bone22);
            this.setRotationAngle(this.bone22, -0.2618f, 0.0f, 0.2618f);
            this.bone22.field_78804_l.add(new ModelBox(this.bone22, 44, 19, -2.1731f, -1.2338f, -1.5934f, 4, 4, 4, 0.0f, false));
            this.bone23 = new ModelRenderer((ModelBase)this);
            this.bone23.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone22.func_78792_a(this.bone23);
            this.setRotationAngle(this.bone23, -0.2618f, 0.0f, 0.2618f);
            this.bone23.field_78804_l.add(new ModelBox(this.bone23, 44, 19, -2.2278f, -1.2801f, -1.6541f, 4, 4, 4, 0.0f, false));
            this.bone24 = new ModelRenderer((ModelBase)this);
            this.bone24.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone23.func_78792_a(this.bone24);
            this.setRotationAngle(this.bone24, -0.2618f, 0.0f, 0.2618f);
            this.bone24.field_78804_l.add(new ModelBox(this.bone24, 44, 19, -2.2925f, -1.2939f, -1.7206f, 4, 4, 4, 0.0f, false));
            this.bone25 = new ModelRenderer((ModelBase)this);
            this.bone25.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone24.func_78792_a(this.bone25);
            this.setRotationAngle(this.bone25, -0.2618f, 0.0f, 0.0f);
            this.bone25.field_78804_l.add(new ModelBox(this.bone25, 44, 19, -2.2925f, -1.3562f, -1.8062f, 4, 4, 4, 0.0f, false));
            this.bone26 = new ModelRenderer((ModelBase)this);
            this.bone26.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone25.func_78792_a(this.bone26);
            this.setRotationAngle(this.bone26, 0.0f, 0.0f, 0.2618f);
            this.bone26.field_78804_l.add(new ModelBox(this.bone26, 44, 19, -2.3747f, -1.2684f, -1.8062f, 4, 4, 4, 0.0f, false));
            this.bone27 = new ModelRenderer((ModelBase)this);
            this.bone27.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone26.func_78792_a(this.bone27);
            this.setRotationAngle(this.bone27, 0.0f, 0.0f, 0.2618f);
            this.bone27.field_78804_l.add(new ModelBox(this.bone27, 44, 19, -2.4314f, -1.1623f, -1.8062f, 4, 4, 4, 0.0f, false));
            this.bone28 = new ModelRenderer((ModelBase)this);
            this.bone28.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone27.func_78792_a(this.bone28);
            this.setRotationAngle(this.bone28, 0.0f, 0.0f, 0.2618f);
            this.bone28.field_78804_l.add(new ModelBox(this.bone28, 44, 19, -2.4587f, -1.0451f, -1.8062f, 4, 4, 4, 0.0f, false));
            this.bone29 = new ModelRenderer((ModelBase)this);
            this.bone29.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone28.func_78792_a(this.bone29);
            this.setRotationAngle(this.bone29, -0.2618f, 0.0f, -0.0873f);
            this.bone29.field_78804_l.add(new ModelBox(this.bone29, 44, 19, -2.453f, -1.1321f, -1.8348f, 4, 4, 4, 0.0f, false));
            this.bone30 = new ModelRenderer((ModelBase)this);
            this.bone30.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone29.func_78792_a(this.bone30);
            this.setRotationAngle(this.bone30, -0.2618f, 0.0f, 0.1745f);
            this.bone30.field_78804_l.add(new ModelBox(this.bone30, 44, 19, -2.4691f, -1.0925f, -1.8537f, 4, 4, 4, 0.0f, false));
            this.bone31 = new ModelRenderer((ModelBase)this);
            this.bone31.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone30.func_78792_a(this.bone31);
            this.setRotationAngle(this.bone31, -0.2618f, 0.0f, 0.1745f);
            this.bone31.field_78804_l.add(new ModelBox(this.bone31, 44, 19, -2.478f, -1.0471f, -1.8612f, 4, 4, 4, 0.0f, false));
            this.bone32 = new ModelRenderer((ModelBase)this);
            this.bone32.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone31.func_78792_a(this.bone32);
            this.setRotationAngle(this.bone32, -0.2618f, 0.0f, 0.1745f);
            this.bone32.field_78804_l.add(new ModelBox(this.bone32, 44, 19, -2.479f, -1.0006f, -1.8565f, 4, 4, 4, 0.0f, false));
            this.bone33 = new ModelRenderer((ModelBase)this);
            this.bone33.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone32.func_78792_a(this.bone33);
            this.setRotationAngle(this.bone33, -0.2618f, -0.1745f, 0.1745f);
            this.bone33.field_78804_l.add(new ModelBox(this.bone33, 44, 19, -2.4718f, -0.9573f, -1.84f, 4, 4, 4, 0.0f, false));
            this.bone34 = new ModelRenderer((ModelBase)this);
            this.bone34.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone33.func_78792_a(this.bone34);
            this.setRotationAngle(this.bone34, -0.2618f, 0.0f, 0.0f);
            this.bone34.field_78804_l.add(new ModelBox(this.bone34, 44, 19, -2.4718f, -1.0002f, -1.8344f, 4, 4, 4, 0.0f, false));
            this.bone35 = new ModelRenderer((ModelBase)this);
            this.bone35.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone34.func_78792_a(this.bone35);
            this.setRotationAngle(this.bone35, -0.2618f, 0.0f, 0.0f);
            this.bone35.field_78804_l.add(new ModelBox(this.bone35, 44, 19, -2.4718f, -1.0431f, -1.8401f, 4, 4, 4, 0.0f, false));
            this.bone36 = new ModelRenderer((ModelBase)this);
            this.bone36.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone35.func_78792_a(this.bone36);
            this.setRotationAngle(this.bone36, 0.0f, 0.0f, 0.2618f);
            this.bone36.field_78804_l.add(new ModelBox(this.bone36, 44, 19, -2.4668f, -0.9195f, -1.8401f, 4, 4, 4, 0.0f, false));
            this.bone37 = new ModelRenderer((ModelBase)this);
            this.bone37.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone36.func_78792_a(this.bone37);
            this.setRotationAngle(this.bone37, -0.2618f, 0.0f, 0.2618f);
            this.bone37.field_78804_l.add(new ModelBox(this.bone37, 44, 19, -2.4301f, -0.8496f, -1.7941f, 4, 4, 4, 0.0f, false));
            this.bone38 = new ModelRenderer((ModelBase)this);
            this.bone38.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone37.func_78792_a(this.bone38);
            this.setRotationAngle(this.bone38, -0.2618f, 0.0f, 0.2618f);
            this.bone38.field_78804_l.add(new ModelBox(this.bone38, 44, 19, -2.3765f, -0.8054f, -1.7347f, 4, 4, 4, 0.0f, false));
            this.dragonHead = new ModelRenderer((ModelBase)this);
            this.dragonHead.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone38.func_78792_a(this.dragonHead);
            this.setRotationAngle(this.dragonHead, -0.2618f, 0.0f, 0.2618f);
            this.dragonHead.field_78804_l.add(new ModelBox(this.dragonHead, 48, 0, -2.3133f, -0.793f, -1.6699f, 4, 4, 4, -0.2f, false));
            this.bone39 = new ModelRenderer((ModelBase)this);
            this.bone39.func_78793_a(-1.6789f, 0.6243f, -0.55f);
            this.dragonHead.func_78792_a(this.bone39);
            this.setRotationAngle(this.bone39, 0.3491f, 0.0f, -2.0944f);
            this.bone39.field_78804_l.add(new ModelBox(this.bone39, 0, 0, -0.5f, -2.0f, -0.5f, 1, 2, 1, 0.0f, false));
            this.bone50 = new ModelRenderer((ModelBase)this);
            this.bone50.func_78793_a(-1.6789f, 0.5243f, 1.25f);
            this.dragonHead.func_78792_a(this.bone50);
            this.setRotationAngle(this.bone50, -0.3491f, 0.0f, -2.0944f);
            this.bone50.field_78804_l.add(new ModelBox(this.bone50, 0, 0, -0.5f, -2.0f, -0.5f, 1, 2, 1, 0.0f, false));
            this.bone49 = new ModelRenderer((ModelBase)this);
            this.bone49.func_78793_a(-1.3605f, 1.6264f, -0.1965f);
            this.dragonHead.func_78792_a(this.bone49);
            this.setRotationAngle(this.bone49, 0.1745f, 0.0f, -2.3562f);
            this.bone49.field_78804_l.add(new ModelBox(this.bone49, 0, 4, -0.5f, -3.0f, -0.5f, 1, 3, 1, 0.0f, false));
            this.bone51 = new ModelRenderer((ModelBase)this);
            this.bone51.func_78793_a(-1.3605f, 1.6264f, 0.9035f);
            this.dragonHead.func_78792_a(this.bone51);
            this.setRotationAngle(this.bone51, -0.1745f, 0.0f, -2.3562f);
            this.bone51.field_78804_l.add(new ModelBox(this.bone51, 0, 4, -0.5f, -3.0f, -0.5f, 1, 3, 1, 0.0f, false));
            this.bone40 = new ModelRenderer((ModelBase)this);
            this.bone40.func_78793_a(0.0f, -2.0f, 0.0f);
            this.dragonHead.func_78792_a(this.bone40);
            this.bone40.field_78804_l.add(new ModelBox(this.bone40, 0, 48, -2.3133f, -0.793f, -1.6699f, 4, 4, 4, -0.4f, false));
            this.dragonEyes = new ModelRenderer((ModelBase)this);
            this.dragonEyes.func_78793_a(2.0f, -1.0f, -8.0f);
            this.bone40.func_78792_a(this.dragonEyes);
            this.dragonEyes.field_78804_l.add(new ModelBox(this.dragonEyes, 42, 51, -4.3133f, 0.207f, 6.25f, 4, 4, 1, -0.4f, false));
            this.dragonEyes.field_78804_l.add(new ModelBox(this.dragonEyes, 42, 57, -4.3133f, 0.207f, 9.4f, 4, 4, 1, -0.4f, true));
            this.bone41 = new ModelRenderer((ModelBase)this);
            this.bone41.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone40.func_78792_a(this.bone41);
            this.bone41.field_78804_l.add(new ModelBox(this.bone41, 0, 56, -2.3133f, -0.793f, -1.6699f, 4, 4, 4, -0.6f, false));
            this.bone42 = new ModelRenderer((ModelBase)this);
            this.bone42.func_78793_a(0.0f, -2.0f, 0.0f);
            this.bone41.func_78792_a(this.bone42);
            this.bone42.field_78804_l.add(new ModelBox(this.bone42, 16, 56, -2.3133f, -0.793f, -1.6699f, 4, 4, 4, -0.8f, false));
            this.bone42.field_78804_l.add(new ModelBox(this.bone42, 0, 9, 0.8098f, 0.0018f, -0.2068f, 1, 1, 1, 0.0f, false));
        }

        public void func_78088_a(Entity entity, float f, float f1, float ageInTicks, float f3, float f4, float f5) {
            float f6 = 12.0f;
            GlStateManager.func_179109_b((float)0.0f, (float)(1.5f - f6 * ((EC)entity).getGrowth(ageInTicks)), (float)0.0f);
            GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
            super.func_78088_a(entity, f, f1, ageInTicks, f3, f4, f5);
            GlStateManager.func_179140_f();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            this.field_178720_f.func_78785_a(f5);
            GlStateManager.func_179145_e();
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public void func_178719_a(boolean visible) {
            super.func_178719_a(visible);
            this.dragon.field_78806_j = visible;
        }

        public void func_78087_a(float limbSwing, float f1, float f2, float f3, float f4, float f5, Entity entityIn) {
            super.func_78087_a(limbSwing * 2.0f / entityIn.field_70131_O, f1, f2, f3, f4, f5, entityIn);
            this.poseSitting(entityIn.func_184218_aH());
        }

        private void poseSitting(boolean isSitting) {
            if (isSitting) {
                this.setRotationAngle(this.field_178723_h, 0.0f, 0.0f, 0.0f);
                this.setRotationAngle(this.rightUpperArm, -1.0472f, -0.5236f, 0.2618f);
                this.setRotationAngle(this.rightForeArm, -0.5236f, 0.0f, -0.5236f);
                this.setRotationAngle(this.field_178724_i, 0.0f, 0.0f, 0.0f);
                this.setRotationAngle(this.leftUpperArm, -1.0472f, 0.5236f, -0.2618f);
                this.setRotationAngle(this.leftForeArm, -0.5236f, 0.0f, 0.5236f);
                this.setRotationAngle(this.rightThigh, -2.0944f, 0.2618f, -1.4835f);
                this.setRotationAngle(this.rightCalf, 1.309f, 0.0f, 0.0f);
                this.setRotationAngle(this.leftThigh, -2.0944f, -0.2618f, 1.4835f);
                this.setRotationAngle(this.leftCalf, 1.309f, 0.0f, 0.0f);
            } else {
                this.setRotationAngle(this.rightUpperArm, 0.0f, -0.5236f, 0.2618f);
                this.setRotationAngle(this.rightForeArm, -0.5236f, 0.0f, 0.0f);
                this.setRotationAngle(this.leftUpperArm, 0.0f, 0.5236f, -0.2618f);
                this.setRotationAngle(this.leftForeArm, -0.5236f, 0.0f, 0.0f);
                this.setRotationAngle(this.rightThigh, -0.1745f, 0.3491f, 0.0f);
                this.setRotationAngle(this.rightCalf, 0.2618f, 0.0f, 0.0f);
                this.setRotationAngle(this.leftThigh, -0.1745f, -0.3491f, 0.0f);
                this.setRotationAngle(this.leftCalf, 0.2618f, 0.0f, 0.0f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderCustom
    extends RenderLivingBase<EC> {
        private final ResourceLocation TEXTURE;

        public RenderCustom(RenderManager renderManagerIn) {
            super(renderManagerIn, (ModelBase)new ModelWoodGolem(), 4.0f);
            this.TEXTURE = new ResourceLocation("narutomod:textures/woodgolem.png");
        }

        public boolean shouldRender(EC livingEntity, ICamera camera, double camX, double camY, double camZ) {
            return true;
        }

        public void doRender(EC entity, double x, double y, double z, float entityYaw, float partialTicks) {
            if (entity.func_184207_aI() && entity.func_184179_bs() instanceof EntityLivingBase) {
                this.copyLimbSwing(entity, (EntityLivingBase)entity.func_184179_bs());
            }
            this.setModelVisibilities(entity);
            super.func_76986_a((EntityLivingBase)entity, x, y, z, entityYaw, partialTicks);
        }

        protected void copyLimbSwing(EC entity, EntityLivingBase rider) {
            entity.field_70733_aJ = rider.field_70733_aJ;
            entity.field_110158_av = rider.field_110158_av;
            entity.field_70732_aI = rider.field_70732_aI;
            entity.field_82175_bq = rider.field_82175_bq;
            entity.field_184622_au = rider.field_184622_au;
        }

        protected void setModelVisibilities(EC entity) {
            if (this.func_177087_b() instanceof ModelWoodGolem) {
                ModelWoodGolem model = (ModelWoodGolem)this.func_177087_b();
                model.func_178719_a(true);
                if (entity.func_184218_aH()) {
                    ((ModelWoodGolem)model).dragon.field_78806_j = false;
                }
                if (Minecraft.func_71410_x().func_175606_aa().equals((Object)entity.func_184179_bs()) && this.field_76990_c.field_78733_k.field_74320_O == 0) {
                    model.field_78116_c.field_78806_j = false;
                    model.field_178720_f.field_78806_j = false;
                    ((ModelWoodGolem)model).dragon.field_78806_j = false;
                }
            }
        }

        protected ResourceLocation getEntityTexture(EC entity) {
            return this.TEXTURE;
        }
    }

    public static class EC
    extends EntityShieldBase {
        protected final int growTime = 30;
        private List<BlockPos> particleArea;
        private double chakraBurn;

        public EC(World world) {
            super(world);
            this.func_70105_a(4.8f, 16.0f);
            this.setOwnerCanSteer(true, 1.0f);
            this.field_70138_W = this.field_70131_O / 3.0f;
        }

        public EC(EntityLivingBase summonerIn, double chakraUsagePerSec) {
            super(summonerIn);
            this.func_70105_a(4.8f, 16.0f);
            this.func_70107_b(summonerIn.field_70165_t, summonerIn.field_70163_u, summonerIn.field_70161_v);
            this.setOwnerCanSteer(true, 1.0f);
            this.field_70138_W = this.field_70131_O / 3.0f;
            Chakra.Pathway cp = Chakra.pathway(summonerIn);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Chakra.getLevel(summonerIn) * 50.0);
            this.func_70606_j(this.func_110138_aP());
            this.chakraBurn = chakraUsagePerSec;
        }

        @Override
        protected void func_110147_ax() {
            super.func_110147_ax();
            this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
            this.func_110140_aT().func_111150_b(EntityPlayer.REACH_DISTANCE);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(200.0);
            this.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111128_a(18.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        }

        @Override
        public double func_70042_X() {
            return (double)(this.field_70131_O * this.getGrowth(this.field_70173_aa)) + 0.35;
        }

        public double func_70033_W() {
            return -5.0;
        }

        public boolean func_70652_k(Entity entityIn) {
            super.func_70652_k(entityIn);
            return ProcedureUtils.attackEntityAsMob(this, entityIn);
        }

        private float getGrowth(float ageInTicks) {
            ((Object)((Object)this)).getClass();
            return Math.min(ageInTicks / 30.0f, 1.0f);
        }

        @Override
        public void func_70636_d() {
            this.dieOnNoPassengers = !this.func_184218_aH();
            super.func_70636_d();
        }

        public void func_70071_h_() {
            EntityLivingBase summoner;
            super.func_70071_h_();
            if (this.field_70173_aa <= this.growTime) {
                if (this.particleArea == null) {
                    this.particleArea = ProcedureUtils.getNonAirBlocks(this.field_70170_p, this.func_174813_aQ().func_72317_d(0.0, -0.5 * (double)this.field_70131_O, 0.0));
                }
                if (this.particleArea != null) {
                    for (BlockPos pos : this.particleArea) {
                        IBlockState state = this.field_70170_p.func_180495_p(pos);
                        if (!state.func_185917_h() || !this.field_70170_p.func_175623_d(pos.func_177984_a())) continue;
                        for (int i = 0; i < 10; ++i) {
                            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, 0.5 + (double)pos.func_177958_n(), 1.0 + (double)pos.func_177956_o(), 0.5 + (double)pos.func_177952_p(), this.field_70146_Z.nextGaussian() * 0.15, this.field_70146_Z.nextGaussian() * 0.15, this.field_70146_Z.nextGaussian() * 0.15, new int[]{Block.func_149682_b((Block)state.func_177230_c())});
                        }
                    }
                }
            }
            if (this.chakraBurn > 0.0 && this.field_70173_aa % 20 == 19 && (summoner = this.getSummoner()) != null && !Chakra.pathway(summoner).consume(this.chakraBurn)) {
                this.func_70106_y();
            }
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                if (!entity.func_184218_aH() || !(entity.func_184187_bx() instanceof EC)) {
                    entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:mokujin_no_jutsu")), SoundCategory.PLAYERS, 1.0f, 1.0f);
                    entity.field_70170_p.func_72838_d((Entity)new EC(entity, ItemMokuton.GOLEM.chakraUsage * 0.05 * (double)((ItemMokuton.ItemCustom)stack.func_77973_b()).getCurrentJutsuXpModifier(stack, entity)));
                    return true;
                }
                return false;
            }
        }
    }
}

