/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.event;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.narutomod.event.EnumEventType;
import net.narutomod.event.SpecialEvent;

public class EventDelayedSpawn
extends SpecialEvent {
    private Entity entityToSpawn;
    private double dx;
    private double dy;
    private double dz;

    public EventDelayedSpawn() {
    }

    public EventDelayedSpawn(World worldIn, Entity entityIn, double x, double y, double z, long timeToExecute) {
        super(EnumEventType.DELAYED_SPAWN, worldIn, entityIn, 0, 0, 0, timeToExecute);
        if (!worldIn.field_72995_K) {
            this.entityToSpawn = entityIn;
            this.dx = entityIn.field_70165_t + x;
            this.dy = entityIn.field_70163_u + y;
            this.dz = entityIn.field_70161_v + z;
        }
    }

    @Override
    protected void onUpdate() {
        if (this.shouldExecute()) {
            super.onUpdate();
            if (this.entityToSpawn != null) {
                this.entityToSpawn.func_70107_b(this.dx, this.dy, this.dz);
                this.world.func_72838_d(this.entityToSpawn);
            }
            this.clear();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74778_a("EntityClass", this.entityToSpawn.getClass().getName());
        this.entityToSpawn.func_189511_e(compound);
        compound.func_74780_a("SpawnPosX", this.dx);
        compound.func_74780_a("SpawnPosY", this.dy);
        compound.func_74780_a("SpawnPosZ", this.dz);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.entityToSpawn = this.newEntityFromClassName(compound.func_74779_i("EntityClass"));
        if (this.entityToSpawn != null) {
            this.entityToSpawn.func_70020_e(compound);
            this.dx = compound.func_74769_h("SpawnPosX");
            this.dy = compound.func_74769_h("SpawnPosY");
            this.dz = compound.func_74769_h("SpawnPosZ");
        }
    }

    @Override
    public String toString() {
        return super.toString() + " {entityToSpawn:" + this.entityToSpawn.getClass().getName() + " at:(" + this.dx + ", " + this.dy + ", " + this.dz + ")}";
    }
}

