/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.event;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.Template;
import net.narutomod.event.EnumEventType;
import net.narutomod.event.SpecialEvent;

public class EventSetBlocks
extends SpecialEvent {
    private List<Template.BlockInfo> blocksList = Lists.newArrayList();
    private int lifespan;
    private int addIndex;
    private int removeIndex;

    public EventSetBlocks() {
    }

    public EventSetBlocks(World worldIn, Map<BlockPos, IBlockState> map, long startTime, int life) {
        this(worldIn, map, startTime, life, true, true);
    }

    public EventSetBlocks(World worldIn, Map<BlockPos, IBlockState> map, long startTime, int life, boolean particlesIn, boolean sounds) {
        super(EnumEventType.SET_BLOCKS, worldIn, null, 0, 0, 0, startTime, particlesIn, sounds);
        if (!worldIn.field_72995_K) {
            for (Map.Entry<BlockPos, IBlockState> entry : map.entrySet()) {
                this.blocksList.add(new Template.BlockInfo(entry.getKey(), entry.getValue(), new NBTTagCompound()));
            }
            this.lifespan = life;
            this.addIndex = 0;
            this.removeIndex = 0;
        }
    }

    public EventSetBlocks(World worldIn, List<Template.BlockInfo> list, long startTime, int life, boolean particlesIn, boolean sounds) {
        super(EnumEventType.SET_BLOCKS, worldIn, null, 0, 0, 0, startTime, particlesIn, sounds);
        if (!worldIn.field_72995_K) {
            this.blocksList = Lists.newArrayList(list);
            this.lifespan = life;
            this.addIndex = 0;
            this.removeIndex = 0;
        }
    }

    @Override
    protected void onUpdate() {
        boolean flag2;
        if (!this.shouldExecute()) {
            return;
        }
        super.onUpdate();
        boolean flag = this.lifespan > 0 && this.world.func_82737_E() > this.startTime + (long)this.lifespan;
        boolean bl = flag2 = this.addIndex < this.blocksList.size();
        if (flag2 || flag) {
            Template.BlockInfo blockinfo;
            int i;
            if (flag2) {
                this.onAddTick(this.tick);
            }
            if (flag) {
                this.onRemoveTick(this.tick);
            }
            int j = 0;
            for (i = this.addIndex; i < this.blocksList.size() && j < 64; ++j, ++i) {
                blockinfo = this.blocksList.get(i);
                BlockPos pos = blockinfo.field_186242_a;
                IBlockState state = blockinfo.field_186243_b;
                if (state.func_177230_c() != Blocks.field_150350_a || !this.world.func_175623_d(pos)) {
                    if (this.sound && j == 0 && this.tick % 5 == 1) {
                        SoundType soundtype = state.func_177230_c().func_185467_w();
                        this.world.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b());
                        j += 7;
                    }
                    if (this.particles) {
                        ((WorldServer)this.world).func_175739_a(EnumParticleTypes.BLOCK_DUST, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 2, 0.0, 0.0, 0.0, 0.15, new int[]{Block.func_149682_b((Block)state.func_177230_c())});
                        j += 3;
                    }
                    this.onSetBlock(pos);
                    this.world.func_180501_a(pos, state, 2);
                }
                ++this.addIndex;
            }
            if (j >= 64) {
                return;
            }
            if (flag) {
                j = 0;
                for (i = this.removeIndex; i < this.blocksList.size() && j < 64; ++j, ++i) {
                    blockinfo = this.blocksList.get(i);
                    IBlockState state = this.world.func_180495_p(blockinfo.field_186242_a);
                    if (state.func_177230_c() == blockinfo.field_186243_b.func_177230_c() || state.func_185904_a() == blockinfo.field_186243_b.func_185904_a() && state.func_185904_a().func_76224_d()) {
                        this.onRemoveBlock(blockinfo.field_186242_a);
                    }
                    ++this.removeIndex;
                }
                if (j >= 64) {
                    return;
                }
            }
        }
        if (this.lifespan == 0 || flag) {
            this.clear();
        }
    }

    public void onAddTick(int tick) {
    }

    public void onRemoveTick(int tick) {
    }

    public void onSetBlock(BlockPos pos) {
        Template.BlockInfo blockinfo = this.blocksList.get(this.addIndex);
        if (blockinfo.field_186244_c != null) {
            blockinfo.field_186244_c.func_74768_a("ogstate", Block.func_176210_f((IBlockState)this.world.func_180495_p(pos)));
        }
    }

    public void onRemoveBlock(BlockPos pos) {
        Template.BlockInfo blockinfo = this.blocksList.get(this.removeIndex);
        if (blockinfo.field_186244_c != null && blockinfo.field_186244_c.func_74764_b("ogstate")) {
            IBlockState ogstate = Block.func_176220_d((int)blockinfo.field_186244_c.func_74762_e("ogstate"));
            this.world.func_180501_a(pos, ogstate, 2);
        } else {
            this.world.func_175698_g(pos);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74768_a("lifespan", this.lifespan);
        compound.func_74768_a("addIndex", this.addIndex);
        compound.func_74768_a("removeIndex", this.removeIndex);
        NBTTagList taglist = new NBTTagList();
        if (!this.blocksList.isEmpty()) {
            for (Template.BlockInfo blockinfo : this.blocksList) {
                NBTTagCompound newcompound = new NBTTagCompound();
                newcompound.func_74768_a("x", blockinfo.field_186242_a.func_177958_n());
                newcompound.func_74768_a("y", blockinfo.field_186242_a.func_177956_o());
                newcompound.func_74768_a("z", blockinfo.field_186242_a.func_177952_p());
                newcompound.func_74768_a("blockstate", Block.func_176210_f((IBlockState)blockinfo.field_186243_b));
                if (blockinfo.field_186244_c != null) {
                    newcompound.func_74782_a("extraNBT", (NBTBase)blockinfo.field_186244_c);
                }
                taglist.func_74742_a((NBTBase)newcompound);
            }
        }
        if (!taglist.func_82582_d()) {
            compound.func_74782_a("blocksList", (NBTBase)taglist);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.lifespan = compound.func_74762_e("lifespan");
        this.addIndex = compound.func_74762_e("addIndex");
        this.removeIndex = compound.func_74762_e("removeIndex");
        if (compound.func_150297_b("blocksList", 9)) {
            NBTTagList taglist = compound.func_150295_c("blocksList", 10);
            for (int i = 0; i < taglist.func_74745_c(); ++i) {
                NBTTagCompound tagcompound = taglist.func_150305_b(i);
                BlockPos pos = new BlockPos(tagcompound.func_74762_e("x"), tagcompound.func_74762_e("y"), tagcompound.func_74762_e("z"));
                IBlockState state = Block.func_176220_d((int)tagcompound.func_74762_e("blockstate"));
                NBTTagCompound extraNBT = (NBTTagCompound)tagcompound.func_74781_a("extraNBT");
                this.blocksList.add(new Template.BlockInfo(pos, state, extraNBT != null ? extraNBT : new NBTTagCompound()));
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + " + {lifespan:" + this.lifespan + ",addIndex:" + this.addIndex + ",removeIndex:" + this.removeIndex + ",blocksCount:" + this.blocksList.size() + "}";
    }
}

