/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.event;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.narutomod.Particles;
import net.narutomod.event.EnumEventType;
import net.narutomod.event.SpecialEvent;

public class EventVanillaExplosion
extends SpecialEvent {
    private boolean causesFire;
    private boolean damagesTerrain;
    private float size;
    private List<BlockPos> affectedBlockPositions;
    private int blockIndex;
    private int fireIndex;

    public EventVanillaExplosion() {
    }

    public EventVanillaExplosion(World worldIn, Entity entityIn, int x, int y, int z, float strengthIn, long startTime, boolean flames) {
        super(EnumEventType.VANILLA_EXPLOSION, worldIn, entityIn, x, y, z, startTime, true, true);
        if (!worldIn.field_72995_K) {
            this.size = strengthIn;
            this.causesFire = flames;
            this.damagesTerrain = ForgeEventFactory.getMobGriefingEvent((World)worldIn, (Entity)entityIn);
            this.affectedBlockPositions = Lists.newArrayList();
        }
    }

    @Override
    protected void onUpdate() {
        if (!this.shouldExecute()) {
            return;
        }
        super.onUpdate();
        Entity target = this.getEntity();
        if (target != null && this.blockIndex == 0) {
            this.x0 = MathHelper.func_76128_c((double)target.field_70165_t);
            this.y0 = MathHelper.func_76128_c((double)target.field_70163_u);
            this.z0 = MathHelper.func_76128_c((double)target.field_70161_v);
        }
        this.world.func_72885_a(null, (double)this.x0, (double)this.y0, (double)this.z0, this.size, this.causesFire, this.damagesTerrain);
        this.clear();
    }

    protected void damageEntity(Entity entityIn, float amount) {
        entityIn.func_70097_a(DamageSource.func_188405_b((EntityLivingBase)null), amount);
    }

    private void doExplosionA() {
        HashSet set = Sets.newHashSet();
        int i = 16;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.x0;
                    double d6 = this.y0;
                    double d8 = this.z0;
                    float f1 = 0.3f;
                    for (float f = this.size * (0.7f + this.world.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = new BlockPos(d4, d6, d8);
                        IBlockState iblockstate = this.world.func_180495_p(blockpos);
                        if (iblockstate.func_185904_a() != Material.field_151579_a) {
                            float f2 = iblockstate.func_177230_c().getExplosionResistance(this.world, blockpos, null, null);
                            f -= (f2 + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.affectedBlockPositions.addAll(set);
        float f3 = this.size * 2.0f;
        int k1 = MathHelper.func_76128_c((double)((double)this.x0 - (double)f3 - 1.0));
        int l1 = MathHelper.func_76128_c((double)((double)this.x0 + (double)f3 + 1.0));
        int i2 = MathHelper.func_76128_c((double)((double)this.y0 - (double)f3 - 1.0));
        int i1 = MathHelper.func_76128_c((double)((double)this.y0 + (double)f3 + 1.0));
        int j2 = MathHelper.func_76128_c((double)((double)this.z0 - (double)f3 - 1.0));
        int j1 = MathHelper.func_76128_c((double)((double)this.z0 + (double)f3 + 1.0));
        List list = this.world.func_72839_b(null, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        Vec3d vec3d = new Vec3d((double)this.x0, (double)this.y0, (double)this.z0);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            Entity entity = (Entity)list.get(k2);
            if (entity.func_180427_aV() || !((d12 = entity.func_70011_f((double)this.x0, (double)this.y0, (double)this.z0) / (double)f3) <= 1.0) || (d13 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - (double)this.x0) * d5 + (d7 = entity.field_70163_u + (double)entity.func_70047_e() - (double)this.y0) * d7 + (d9 = entity.field_70161_v - (double)this.z0) * d9))) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = this.world.func_72842_a(vec3d, entity.func_174813_aQ());
            double d10 = (1.0 - d12) * d14;
            this.damageEntity(entity, (int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f3 + 1.0));
            double d11 = d10;
            if (entity instanceof EntityLivingBase) {
                d11 = EnchantmentProtection.func_92092_a((EntityLivingBase)((EntityLivingBase)entity), (double)d10);
            }
            entity.field_70159_w += d5 * d11;
            entity.field_70181_x += d7 * d11;
            entity.field_70179_y += d9 * d11;
            entity.field_70133_I = true;
        }
    }

    public void doExplosionB() {
        int i;
        int j;
        if (this.sound) {
            this.world.func_184148_a(null, (double)this.x0, (double)this.y0, (double)this.z0, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
        if (this.particles) {
            if (this.size >= 2.0f && this.damagesTerrain) {
                Particles.spawnParticle(this.world, Particles.Types.SMOKE, (double)this.x0, (double)this.y0, (double)this.z0, 1, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, -251658241, 30);
            } else {
                Particles.spawnParticle(this.world, Particles.Types.SMOKE, (double)this.x0, (double)this.y0, (double)this.z0, 1, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, -251658241, 15);
            }
        }
        boolean done = false;
        if (this.damagesTerrain) {
            j = 0;
            for (i = this.blockIndex; i < this.affectedBlockPositions.size() && j < 512; ++i) {
                BlockPos blockpos = this.affectedBlockPositions.get(i);
                IBlockState iblockstate = this.world.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                if (this.particles) {
                    double d0 = (float)blockpos.func_177958_n() + this.world.field_73012_v.nextFloat();
                    double d1 = (float)blockpos.func_177956_o() + this.world.field_73012_v.nextFloat();
                    double d2 = (float)blockpos.func_177952_p() + this.world.field_73012_v.nextFloat();
                    double d3 = d0 - (double)this.x0;
                    double d4 = d1 - (double)this.y0;
                    double d5 = d2 - (double)this.z0;
                    double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                    d3 /= d6;
                    d4 /= d6;
                    d5 /= d6;
                    double d7 = 0.5 / (d6 / (double)this.size + 0.1);
                    Particles.spawnParticle(this.world, Particles.Types.SMOKE, (d0 + (double)this.x0) / 2.0, (d1 + (double)this.y0) / 2.0, (d2 + (double)this.z0) / 2.0, 1, 0.0, 0.0, 0.0, d3 *= (d7 *= (double)(this.world.field_73012_v.nextFloat() * this.world.field_73012_v.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7, -251658241);
                    Particles.spawnParticle(this.world, Particles.Types.SMOKE, d0, d1, d2, 1, 0.0, 0.0, 0.0, d3, d4, d5, -268435456);
                }
                if (iblockstate.func_185904_a() == Material.field_151579_a) continue;
                if (block.func_149659_a(null)) {
                    block.func_180653_a(this.world, blockpos, this.world.func_180495_p(blockpos), 1.0f / this.size, 0);
                }
                this.world.func_175698_g(blockpos);
                ++j;
            }
            this.blockIndex = i;
            if (i >= this.affectedBlockPositions.size()) {
                done = true;
            }
        }
        if (done) {
            if (this.causesFire) {
                j = 0;
                for (i = this.fireIndex; i < this.affectedBlockPositions.size() && j < 128; ++i) {
                    BlockPos pos = this.affectedBlockPositions.get(i);
                    if (this.world.func_180495_p(pos).func_185904_a() != Material.field_151579_a || !this.world.func_180495_p(pos.func_177977_b()).func_185913_b()) continue;
                    if (rand.nextInt(3) != 0) continue;
                    this.world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
                    ++j;
                }
                this.fireIndex = i;
                if (i >= this.affectedBlockPositions.size()) {
                    this.clear();
                }
            } else {
                this.clear();
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74776_a("strength", this.size);
        compound.func_74757_a("flaming", this.causesFire);
        compound.func_74757_a("damagesTerrain", this.damagesTerrain);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.size = compound.func_74760_g("strength");
        this.causesFire = compound.func_74767_n("flaming");
        this.damagesTerrain = compound.func_74767_n("damagesTerrain");
    }
}

