/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.gui;

import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodMod;
import net.narutomod.PlayerTracker;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@ElementsNarutomodMod.ModElement.Tag
public class GuiNinjaScroll
extends ElementsNarutomodMod.ModElement {
    private static Map<Integer, GuiContainerMod> guiMap = Maps.newHashMap();

    public GuiNinjaScroll(ElementsNarutomodMod instance) {
        super(instance, 445);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        this.elements.addNetworkMessage(GUIButtonPressedMessage.Handler.class, GUIButtonPressedMessage.class, Side.SERVER);
    }

    public static ItemStack enableJutsu(EntityPlayer player, ItemJutsu.Base item, ItemJutsu.JutsuEnum jutsu, boolean enable) {
        ItemStack stack = ProcedureUtils.getMatchingItemStack(player, item);
        if (stack == null && PlayerTracker.isNinja(player) && enable) {
            stack = new ItemStack((Item)item, 1);
            ((ItemJutsu.Base)stack.func_77973_b()).setOwner(stack, (EntityLivingBase)player);
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack);
        }
        if (stack != null) {
            ((ItemJutsu.Base)stack.func_77973_b()).enableJutsu(stack, jutsu, enable);
        }
        return stack;
    }

    public static class GUIButtonPressedMessage
    implements IMessage {
        int guiWindow;
        int buttonID;

        public GUIButtonPressedMessage() {
        }

        public GUIButtonPressedMessage(int win, int button) {
            this.guiWindow = win;
            this.buttonID = button;
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.guiWindow);
            buf.writeInt(this.buttonID);
        }

        public void fromBytes(ByteBuf buf) {
            this.guiWindow = buf.readInt();
            this.buttonID = buf.readInt();
        }

        public static class Handler
        implements IMessageHandler<GUIButtonPressedMessage, IMessage> {
            public IMessage onMessage(GUIButtonPressedMessage message, MessageContext context) {
                EntityPlayerMP entity = context.getServerHandler().field_147369_b;
                entity.func_71121_q().func_152344_a(() -> {
                    if (guiMap.containsKey(message.guiWindow)) {
                        ((GuiContainerMod)guiMap.get(message.guiWindow)).handleButtonAction((EntityPlayer)entity, message.buttonID);
                    }
                });
                return null;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static abstract class GuiWindow
    extends GuiContainer {
        private final int id;
        protected World world;
        protected int x;
        protected int y;
        protected int z;
        protected EntityPlayer entity;

        public GuiWindow(GuiContainerMod container) {
            super((Container)container);
            this.world = container.world;
            this.x = container.x;
            this.y = container.y;
            this.z = container.z;
            this.entity = container.entity;
            this.field_146999_f = 176;
            this.field_147000_g = 166;
            this.id = container.id;
        }

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            this.func_146276_q_();
            super.func_73863_a(mouseX, mouseY, partialTicks);
            this.func_191948_b(mouseX, mouseY);
        }

        protected void func_146976_a(float par1, int par2, int par3) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_73735_i = 0.0f;
            this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation("narutomod:textures/scoll_screen.png"));
            Gui.func_146110_a((int)(this.field_147003_i - 70), (int)(this.field_147009_r - 70), (float)0.0f, (float)0.0f, (int)320, (int)320, (float)320.0f, (float)320.0f);
        }

        public void func_73876_c() {
            super.func_73876_c();
        }

        protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }

        protected void func_73869_a(char typedChar, int keyCode) throws IOException {
            super.func_73869_a(typedChar, keyCode);
        }

        public void func_146281_b() {
            super.func_146281_b();
            Keyboard.enableRepeatEvents((boolean)false);
        }

        public void func_73866_w_() {
            super.func_73866_w_();
            this.field_147003_i = (this.field_146294_l - 176) / 2;
            this.field_147009_r = (this.field_146295_m - 166) / 2;
            Keyboard.enableRepeatEvents((boolean)true);
            this.field_146292_n.clear();
            this.field_146292_n.add(new GuiButton(0, this.field_147003_i - 56, this.field_147009_r + 127, 39, 20, "Learn"));
        }

        protected void func_146284_a(GuiButton button) {
            NarutomodMod.PACKET_HANDLER.sendToServer((IMessage)new GUIButtonPressedMessage(this.id, button.field_146127_k));
            ((GuiContainerMod)guiMap.get(this.id)).handleButtonAction(this.entity, button.field_146127_k);
        }

        public boolean func_73868_f() {
            return false;
        }
    }

    public static abstract class GuiContainerMod
    extends Container
    implements Supplier<Map<Integer, Slot>> {
        private IInventory internal;
        private World world;
        private EntityPlayer entity;
        protected int x;
        protected int y;
        protected int z;
        private final int id;
        private Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();

        public GuiContainerMod(World world, int x, int y, int z, EntityPlayer player, int guiID) {
            this.world = world;
            this.entity = player;
            this.x = x;
            this.y = y;
            this.z = z;
            this.internal = new InventoryBasic("", true, 0);
            this.id = guiID;
            guiMap.put(guiID, this);
        }

        @Override
        public Map<Integer, Slot> get() {
            return this.customSlots;
        }

        public boolean func_75145_c(EntityPlayer player) {
            return this.internal.func_70300_a(player);
        }

        public void func_75134_a(EntityPlayer playerIn) {
            super.func_75134_a(playerIn);
            if (this.internal instanceof InventoryBasic && playerIn instanceof EntityPlayerMP) {
                this.func_193327_a(playerIn, playerIn.field_70170_p, this.internal);
            }
        }

        protected void handleButtonAction(EntityPlayer player, int buttonID) {
            if (player instanceof EntityPlayerMP) {
                if (player.func_184614_ca().func_77958_k() == 1) {
                    player.func_184614_ca().func_190918_g(1);
                } else if (player.func_184592_cb().func_77958_k() == 1) {
                    player.func_184592_cb().func_190918_g(1);
                }
                if (!ProcedureUtils.advancementAchieved((EntityPlayerMP)player, "narutomod:learned_1st_jutsu")) {
                    ProcedureUtils.grantAdvancement((EntityPlayerMP)player, "narutomod:learned_1st_jutsu", true);
                }
            }
        }
    }
}

