/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.gui.overlay;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodMod;
import net.narutomod.PlayerTracker;

@ElementsNarutomodMod.ModElement.Tag
public class OverlayChakraDisplay
extends ElementsNarutomodMod.ModElement {
    private static OverlayChakraDisplay instance;
    private int warningTime;
    private boolean showSageBar;

    public OverlayChakraDisplay(ElementsNarutomodMod instanceIn) {
        super(instanceIn, 397);
        instance = this;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        this.elements.addNetworkMessage(WarningMessage.Handler.class, WarningMessage.class, Side.CLIENT);
        this.elements.addNetworkMessage(ShowFlamesMessage.Handler.class, ShowFlamesMessage.class, Side.CLIENT);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new GUIRenderEventClass());
    }

    public static void notEnoughChakraWarning(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            NarutomodMod.PACKET_HANDLER.sendTo((IMessage)new WarningMessage(60), (EntityPlayerMP)player);
        } else {
            OverlayChakraDisplay.instance.warningTime = 60;
        }
    }

    public static class GUIRenderEventClass {
        @SubscribeEvent(priority=EventPriority.NORMAL)
        @SideOnly(value=Side.CLIENT)
        public void eventHandler(RenderGameOverlayEvent event) {
            if (!event.isCancelable() && event.getType() == RenderGameOverlayEvent.ElementType.HELMET) {
                int sWidth = event.getResolution().func_78326_a();
                int sHeight = event.getResolution().func_78328_b();
                Minecraft mc = Minecraft.func_71410_x();
                EntityPlayerSP entity = mc.field_71439_g;
                World world = entity.field_70170_p;
                if (PlayerTracker.isNinja((EntityPlayer)entity) && Chakra.isInitialized((EntityPlayer)entity)) {
                    int color = instance.warningTime % 20 < 10 ? -16711681 : -65536;
                    Chakra.PathwayPlayer p = Chakra.pathway((EntityPlayer)entity);
                    double d = p.getAmount() / p.getMax();
                    double d1 = d - Math.floor(d);
                    d1 = d != 0.0 && d1 == 0.0 ? 1.0 : d1;
                    int bartop = sHeight - (4 * ((int)Math.ceil(d) - 1) + 9);
                    int left = sWidth / 2 - 206;
                    int w = 80;
                    if (instance.showSageBar) {
                        mc.field_71446_o.func_110577_a(new ResourceLocation("narutomod:textures/flames_green.png"));
                        int w1 = w + 10;
                        int h1 = sHeight - bartop + 20;
                        int v = entity.field_70173_aa % 8 / 2;
                        GuiIngame.func_146110_a((int)(left - 5), (int)(bartop - 20), (float)0.0f, (float)((float)v * (float)h1), (int)w1, (int)h1, (float)w1, (float)(h1 * 4));
                    }
                    GuiIngame.func_73734_a((int)(left - 1), (int)(bartop - 1), (int)(left + w + 1), (int)(sHeight - 5), (int)-14671840);
                    for (int i = bartop; i <= sHeight - 9; i += 4) {
                        GuiIngame.func_73734_a((int)left, (int)i, (int)(left + (int)((i == bartop ? d1 : 1.0) * (double)w)), (int)(i + 3), (int)(i == sHeight - 9 ? color : -256));
                    }
                    String chakraText = String.format("%d/%d", (int)p.getAmount(), (int)p.getMax());
                    int chakraTextLen = mc.field_71466_p.func_78256_a(chakraText);
                    mc.field_71466_p.func_175063_a(chakraText, (float)(left + 40 - chakraTextLen / 2), (float)(bartop - 10), color);
                }
                if (instance.warningTime > 0) {
                    --instance.warningTime;
                }
            }
        }
    }

    public static class ShowFlamesMessage
    implements IMessage {
        boolean show;

        public ShowFlamesMessage() {
        }

        public ShowFlamesMessage(boolean b) {
            this.show = b;
        }

        public static void send(EntityPlayerMP player, boolean b) {
            NarutomodMod.PACKET_HANDLER.sendTo((IMessage)new ShowFlamesMessage(b), player);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeBoolean(this.show);
        }

        public void fromBytes(ByteBuf buf) {
            this.show = buf.readBoolean();
        }

        public static class Handler
        implements IMessageHandler<ShowFlamesMessage, IMessage> {
            @SideOnly(value=Side.CLIENT)
            public IMessage onMessage(ShowFlamesMessage message, MessageContext context) {
                Minecraft.func_71410_x().func_152344_a(() -> instance.showSageBar = message.show);
                return null;
            }
        }
    }

    public static class WarningMessage
    implements IMessage {
        int ticks;

        public WarningMessage() {
        }

        public WarningMessage(int t) {
            this.ticks = t;
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.ticks);
        }

        public void fromBytes(ByteBuf buf) {
            this.ticks = buf.readInt();
        }

        public static class Handler
        implements IMessageHandler<WarningMessage, IMessage> {
            @SideOnly(value=Side.CLIENT)
            public IMessage onMessage(WarningMessage message, MessageContext context) {
                Minecraft.func_71410_x().func_152344_a(() -> instance.warningTime = message.ticks);
                return null;
            }
        }
    }
}

