/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.creativetab.TabModTab;
import net.narutomod.entity.EntityC1;
import net.narutomod.entity.EntityC2;
import net.narutomod.entity.EntityC3;
import net.narutomod.entity.EntityClone;
import net.narutomod.entity.EntityExplosiveClone;
import net.narutomod.item.ItemDoton;
import net.narutomod.item.ItemJutsu;
import net.narutomod.item.ItemRaiton;
import net.narutomod.potion.PotionChakraEnhancedStrength;
import net.narutomod.procedure.ProcedureOnLeftClickEmpty;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class ItemBakuton
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:bakuton")
    public static final Item block = null;
    public static final int ENTITYID = 230;
    public static final ItemJutsu.JutsuEnum JIRAIKEN = new ItemJutsu.JutsuEnum(0, "tooltip.bakuton.jiraiken", 'S', 150, 30.0, new Jiraiken());
    public static final ItemJutsu.JutsuEnum CLAY = new ItemJutsu.JutsuEnum(1, "c_1", 'S', 200, 75.0, new ExplosiveClay.Jutsu());
    public static final ItemJutsu.JutsuEnum CLONE = new ItemJutsu.JutsuEnum(2, "explosive_clone", 'S', 200, 150.0, new EntityExplosiveClone.EC.Jutsu());

    public ItemBakuton(ElementsNarutomodMod instance) {
        super(instance, 543);
    }

    @Override
    public void initElements() {
        this.elements.items.add(() -> new RangedItem(JIRAIKEN, CLAY, CLONE));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)block, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:bakuton", "inventory"));
    }

    @Override
    public void init(FMLInitializationEvent event) {
        ProcedureOnLeftClickEmpty.addQualifiedItem(block, EnumHand.MAIN_HAND);
    }

    public static ItemJutsu.JutsuEnum getCurrentJutsu(ItemStack stack) {
        return ((RangedItem)block).getCurrentJutsu(stack);
    }

    public static abstract class ExplosiveClay
    extends EntityCreature {
        private EntityLivingBase owner;
        private int lifeSpan = 600;

        public ExplosiveClay(World world) {
            super(world);
            this.field_70178_ae = true;
            this.field_70765_h = new EntityClone.AIFlyControl((EntityLiving)this);
        }

        public ExplosiveClay(EntityLivingBase ownerIn) {
            this(ownerIn.field_70170_p);
            this.owner = ownerIn;
        }

        protected PathNavigate func_175447_b(World worldIn) {
            PathNavigateFlying pathnavigateflying = new PathNavigateFlying((EntityLiving)this, worldIn);
            pathnavigateflying.func_192879_a(false);
            pathnavigateflying.func_192877_c(true);
            pathnavigateflying.func_192878_b(true);
            return pathnavigateflying;
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIChargeAttack());
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AICopyOwnerTarget(this));
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        }

        protected boolean func_70692_ba() {
            return false;
        }

        protected Item func_146068_u() {
            return null;
        }

        public EntityLivingBase getOwner() {
            return this.owner;
        }

        public int getRemainingLife() {
            return this.lifeSpan - this.field_70173_aa;
        }

        public void setRemainingLife(int ticks) {
            this.lifeSpan = this.field_70173_aa + ticks;
        }

        protected void func_110147_ax() {
            super.func_110147_ax();
            this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
        }

        protected SoundEvent func_184615_bR() {
            return null;
        }

        protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
            return null;
        }

        protected void func_180429_a(BlockPos pos, Block blockIn) {
        }

        public boolean func_184191_r(Entity entityIn) {
            return super.func_184191_r(entityIn) || entityIn.equals((Object)this.owner);
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source.func_94541_c() || source == DamageSource.field_76379_h) {
                return false;
            }
            return super.func_70097_a(source, amount);
        }

        public void func_70071_h_() {
            this.field_70143_R = 0.0f;
            super.func_70071_h_();
            this.func_189654_d(true);
            if (this.field_70173_aa > this.lifeSpan && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }

        class AICopyOwnerTarget
        extends EntityAITarget {
            public AICopyOwnerTarget(EntityCreature creature) {
                super(creature, false);
            }

            public boolean func_75250_a() {
                this.field_188509_g = ExplosiveClay.this.owner instanceof EntityLiving ? ((EntityLiving)ExplosiveClay.this.owner).func_70638_az() : (ExplosiveClay.this.owner != null ? (ExplosiveClay.this.owner.func_70643_av() != null ? ExplosiveClay.this.owner.func_70643_av() : ExplosiveClay.this.owner.func_110144_aD()) : null);
                return this.field_188509_g != null && this.func_75296_a(this.field_188509_g, false);
            }

            public void func_75249_e() {
                ExplosiveClay.this.func_70624_b(this.field_188509_g);
                super.func_75249_e();
            }
        }

        class AIChargeAttack
        extends EntityAIBase {
            public AIChargeAttack() {
                this.func_75248_a(1);
            }

            public boolean func_75250_a() {
                EntityLivingBase target = ExplosiveClay.this.func_70638_az();
                if (target != null && !ExplosiveClay.this.func_70605_aq().func_75640_a() && ExplosiveClay.this.field_70146_Z.nextInt(5) == 0) {
                    return ExplosiveClay.this.func_70068_e((Entity)target) > 4.0;
                }
                return false;
            }

            public boolean func_75253_b() {
                return ExplosiveClay.this.func_70638_az() != null && ExplosiveClay.this.func_70638_az().func_70089_S();
            }

            public void func_75249_e() {
                EntityLivingBase entitylivingbase = ExplosiveClay.this.func_70638_az();
                Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
                ExplosiveClay.this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 2.0);
            }

            public void func_75246_d() {
                EntityLivingBase entitylivingbase = ExplosiveClay.this.func_70638_az();
                if (ExplosiveClay.this.func_174813_aQ().func_72326_a(entitylivingbase.func_174813_aQ())) {
                    ExplosiveClay.this.func_70652_k((Entity)entitylivingbase);
                } else {
                    Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
                    ExplosiveClay.this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 2.0);
                }
            }
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float powerIn) {
                Object ec;
                Vec3d vec = entity.func_70040_Z();
                vec = entity.func_174791_d().func_72441_c(vec.field_72450_a, 1.0, vec.field_72449_c);
                if (powerIn < 2.0f) {
                    ec = new EntityC1.EC(entity);
                } else if (powerIn < 3.0f) {
                    ec = new EntityC2.EC(entity);
                } else if (powerIn < 4.0f) {
                    ec = new EntityC3.EC(entity);
                } else {
                    return false;
                }
                ec.func_70012_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, entity.field_70177_z, 0.0f);
                ec.func_70034_d(entity.field_70177_z);
                entity.field_70170_p.func_72838_d((Entity)ec);
                return true;
            }
        }
    }

    public static class Jiraiken
    implements ItemJutsu.IJutsuCallback {
        @Override
        public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float powerIn) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            boolean flag = !entity.func_70644_a(PotionChakraEnhancedStrength.potion);
            stack.func_77978_p().func_74757_a("isJiraikenActivated", flag);
            stack.func_77978_p().func_74776_a("JiraikenPower", powerIn);
            return flag;
        }

        @Override
        public boolean isActivated(ItemStack stack) {
            return stack.func_77942_o() ? stack.func_77978_p().func_74767_n("isJiraikenActivated") : false;
        }

        @Override
        public float getPower(ItemStack stack) {
            return stack.func_77942_o() ? stack.func_77978_p().func_74760_g("JiraikenPower") : 0.0f;
        }
    }

    public static class RangedItem
    extends ItemJutsu.Base {
        public RangedItem(ItemJutsu.JutsuEnum ... list) {
            super(ItemJutsu.JutsuEnum.Type.BAKUTON, list);
            this.func_77655_b("bakuton");
            this.setRegistryName("bakuton");
            this.func_77637_a(TabModTab.tab);
            this.defaultCooldownMap[ItemBakuton.JIRAIKEN.index] = 0L;
            this.defaultCooldownMap[ItemBakuton.CLAY.index] = 0L;
            this.defaultCooldownMap[ItemBakuton.CLONE.index] = 0L;
        }

        @Override
        protected float getPower(ItemStack stack, EntityLivingBase entity, int timeLeft) {
            ItemJutsu.JutsuEnum jutsu = this.getCurrentJutsu(stack);
            if (jutsu == JIRAIKEN) {
                return this.getPower(stack, entity, timeLeft, 0.2f, 200.0f);
            }
            if (jutsu == CLAY) {
                return (float)Math.floor(this.getPower(stack, entity, timeLeft, 1.0f, 150.0f));
            }
            return 1.0f;
        }

        @Override
        protected float getMaxPower(ItemStack stack, EntityLivingBase entity) {
            float f = super.getMaxPower(stack, entity);
            ItemJutsu.JutsuEnum jutsu = this.getCurrentJutsu(stack);
            if (jutsu == CLAY) {
                return Math.min(3.1f, f);
            }
            if (jutsu == JIRAIKEN) {
                return Math.min(10.0f, f);
            }
            return f;
        }

        @Override
        public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
            if (player instanceof EntityPlayer && !player.field_70170_p.field_72995_K && this.getCurrentJutsu(stack) == CLAY) {
                ((EntityPlayer)player).func_146105_b((ITextComponent)new TextComponentString("C-" + (int)this.getPower(stack, player, count)), true);
            } else {
                super.onUsingTick(stack, player, count);
            }
        }

        @Override
        public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entity, EnumHand hand) {
            if (entity.func_184812_l_() || ProcedureUtils.hasItemInInventory(entity, ItemDoton.block) && ProcedureUtils.hasItemInInventory(entity, ItemRaiton.block)) {
                return super.func_77659_a(world, entity, hand);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)entity.func_184586_b(hand));
        }

        @Override
        public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
            super.func_77663_a(itemstack, world, entity, par4, par5);
            if (entity.field_70173_aa % 10 == 2 && entity instanceof EntityLivingBase && ItemBakuton.JIRAIKEN.jutsu.isActivated(itemstack)) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(PotionChakraEnhancedStrength.potion, 12, (int)(((Jiraiken)ItemBakuton.JIRAIKEN.jutsu).getPower(itemstack) * 19.0f), false, false));
            }
        }

        public boolean onLeftClickEntity(ItemStack itemstack, EntityPlayer attacker, Entity target) {
            if (attacker.equals((Object)target)) {
                target = ProcedureUtils.objectEntityLookingAt((Entity)attacker, (double)50.0).field_72308_g;
            }
            if (target instanceof EntityLivingBase) {
                attacker.func_70604_c((EntityLivingBase)target);
            }
            return super.onLeftClickEntity(itemstack, attacker, target);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
            super.func_77624_a(itemstack, world, list, flag);
            list.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.bakuton.musthave") + TextFormatting.RESET);
        }
    }
}

