/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.MapItemRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketMaps;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodMod;
import net.narutomod.creativetab.TabModTab;
import net.narutomod.entity.EntityBijuManager;

@ElementsNarutomodMod.ModElement.Tag
public class ItemBijuMap
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:biju_map")
    public static final Item block = null;

    public ItemBijuMap(ElementsNarutomodMod instance) {
        super(instance, 836);
    }

    @Override
    public void initElements() {
        this.elements.items.add(() -> ((Item)new TBMapItem().func_77655_b("biju_map").setRegistryName("biju_map")).func_77637_a(TabModTab.tab));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)block, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:biju_map", "inventory"));
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        this.elements.addNetworkMessage(TBMapItem.CPacketTBMap.ClientHandler.class, TBMapItem.CPacketTBMap.class, Side.CLIENT);
    }

    public static class TBMapItem
    extends ItemMap {
        public static final String MAP_ID = "biju_map";

        public int getItemStackLimit(ItemStack stack) {
            return 1;
        }

        public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
            NBTTagCompound nbt;
            super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
            if (!(entityIn instanceof EntityPlayer) || worldIn.field_72995_K) {
                return;
            }
            EntityPlayer player = (EntityPlayer)entityIn;
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if ((nbt = stack.func_77978_p()).func_74767_n("hasInitialized")) {
                return;
            }
            EntityBijuManager bm = EntityBijuManager.getClosestBiju(player);
            if (bm != null) {
                BlockPos target = bm.getPosition();
                this.setupNewMap(stack, worldIn, target.func_177958_n(), target.func_177952_p(), true, true);
                TBMapItem.func_190905_a((World)worldIn, (ItemStack)stack);
                TBMapData data = ((TBMapItem)stack.func_77973_b()).getMapData(stack, worldIn);
                data.addTBDeco(target, (byte)(bm.getTails() - 1));
                nbt.func_74757_a("hasInitialized", true);
            } else if (isSelected && worldIn.func_82737_E() % 20L == 0L) {
                String name;
                player.func_146105_b((ITextComponent)new TextComponentTranslation("overlay.no_biju_available", new Object[0]), true);
                if (!nbt.func_74767_n("hasReset") && worldIn.func_72943_a(TBMapData.class, name = String.format("%s_%s", MAP_ID, stack.func_77960_j())) != null) {
                    worldIn.func_72823_a(name, (WorldSavedData)new TBMapData(name));
                    nbt.func_74757_a("hasReset", true);
                }
            }
        }

        private TBMapData setupNewMap(ItemStack stack, World world, double worldX, double worldZ, boolean trackingPosition, boolean unlimitedTracking) {
            String name = String.format("%s_%s", MAP_ID, stack.func_77960_j());
            TBMapData data = new TBMapData(name);
            world.func_72823_a(name, (WorldSavedData)data);
            data.func_176054_a(worldX, worldZ, data.field_76197_d);
            data.field_76200_c = DimensionType.OVERWORLD.func_186068_a();
            data.field_186210_e = trackingPosition;
            data.field_191096_f = unlimitedTracking;
            data.func_76185_a();
            return data;
        }

        @Nullable
        @SideOnly(value=Side.CLIENT)
        public static TBMapData loadMapData(int mapId, World worldIn) {
            String name = String.format("%s_%s", MAP_ID, mapId);
            return (TBMapData)worldIn.func_72943_a(TBMapData.class, name);
        }

        @Nullable
        public TBMapData getMapData(ItemStack stack, World worldIn) {
            String name = String.format("%s_%s", MAP_ID, stack.func_77960_j());
            TBMapData data = (TBMapData)worldIn.func_72943_a(TBMapData.class, name);
            if (data == null && !worldIn.field_72995_K) {
                data = this.setupNewMap(stack, worldIn, 0.0, 0.0, true, true);
            }
            return data;
        }

        @Nullable
        public Packet<?> func_150911_c(ItemStack stack, World worldIn, EntityPlayer player) {
            Packet packet = super.func_150911_c(stack, worldIn, player);
            TBMapData data = this.getMapData(stack, worldIn);
            if (packet instanceof SPacketMaps) {
                return NarutomodMod.PACKET_HANDLER.getPacketFrom((IMessage)new CPacketTBMap(stack.func_77952_i(), data, (SPacketMaps)packet));
            }
            return packet;
        }

        public static class CPacketTBMap
        implements IMessage {
            private int mapID;
            private byte[] decoData;
            private SPacketMaps inner;

            public CPacketTBMap() {
            }

            public CPacketTBMap(int mapID, TBMapData data, SPacketMaps inner) {
                this.mapID = mapID;
                this.decoData = data.serializeTBDecos();
                this.inner = inner;
            }

            public void fromBytes(ByteBuf buf) {
                PacketBuffer tmp = new PacketBuffer(buf);
                this.mapID = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
                this.decoData = tmp.func_179251_a();
                this.inner = new SPacketMaps();
                try {
                    this.inner.func_148837_a(tmp);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            public void toBytes(ByteBuf buf) {
                PacketBuffer tmp = new PacketBuffer(buf);
                ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.mapID, (int)5);
                tmp.func_179250_a(this.decoData);
                try {
                    this.inner.func_148840_b(tmp);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            public static class ClientHandler
            implements IMessageHandler<CPacketTBMap, IMessage> {
                @SideOnly(value=Side.CLIENT)
                public IMessage onMessage(CPacketTBMap message, MessageContext ctx) {
                    Minecraft.func_71410_x().func_152344_a(() -> {
                        MapItemRenderer mapItemRenderer = Minecraft.func_71410_x().field_71460_t.func_147701_i();
                        TBMapData data = TBMapItem.loadMapData(message.mapID, (World)Minecraft.func_71410_x().field_71441_e);
                        if (data == null) {
                            MapData existingData;
                            String name = String.format("%s_%s", TBMapItem.MAP_ID, message.mapID);
                            data = new TBMapData(name);
                            if (mapItemRenderer.func_191205_a(name) != null && (existingData = mapItemRenderer.func_191207_a(mapItemRenderer.func_191205_a(name))) instanceof TBMapData) {
                                data = (TBMapData)existingData;
                            }
                            Minecraft.func_71410_x().field_71441_e.func_72823_a(name, (WorldSavedData)data);
                        }
                        message.inner.func_179734_a((MapData)data);
                        data.deserializeTBDecos(message.decoData);
                        Map saveVanilla = data.field_76203_h;
                        data.field_76203_h = Maps.newLinkedHashMap();
                        for (TBMapData.TBMapDecoration deco : data.tbDecorations) {
                            data.field_76203_h.put(((Object)((Object)deco)).toString(), deco);
                        }
                        data.field_76203_h.putAll(saveVanilla);
                        mapItemRenderer.func_148246_a((MapData)data);
                    });
                    return null;
                }
            }
        }
    }

    public static class TBMapData
    extends MapData {
        private final Set<TBMapDecoration> tbDecorations = Sets.newHashSet();

        public TBMapData(String name) {
            super(name);
        }

        public void addTBDeco(BlockPos target, int index) {
            int i = 1 << this.field_76197_d;
            float f = (float)((double)target.func_177958_n() - (double)this.field_76201_a) / (float)i;
            float f1 = (float)((double)target.func_177952_p() - (double)this.field_76199_b) / (float)i;
            byte xIn = (byte)((double)(f * 2.0f) + 0.5);
            byte yIn = (byte)((double)(f1 * 2.0f) + 0.5);
            double rotationIn = 180.0;
            if (f >= -63.0f && f1 >= -63.0f && f <= 63.0f && f1 <= 63.0f) {
                this.tbDecorations.add(new TBMapDecoration(index, xIn, yIn, (byte)((rotationIn += rotationIn < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0)));
            }
        }

        public void func_76184_a(NBTTagCompound nbt) {
            super.func_76184_a(nbt);
            byte[] storage = nbt.func_74770_j("tb_decorations");
            if (storage.length > 0) {
                this.deserializeTBDecos(storage);
            }
        }

        public NBTTagCompound func_189551_b(NBTTagCompound compound) {
            compound = super.func_189551_b(compound);
            if (this.tbDecorations.size() > 0) {
                compound.func_74773_a("tb_decorations", this.serializeTBDecos());
            }
            return compound;
        }

        public void deserializeTBDecos(byte[] storage) {
            this.tbDecorations.clear();
            for (int i = 0; i < storage.length / 4; ++i) {
                byte index = storage[i * 4];
                byte mapX = storage[i * 4 + 1];
                byte mapZ = storage[i * 4 + 2];
                byte mapRotation = storage[i * 4 + 3];
                this.tbDecorations.add(new TBMapDecoration(index, mapX, mapZ, mapRotation));
            }
        }

        public byte[] serializeTBDecos() {
            byte[] storage = new byte[this.tbDecorations.size() * 4];
            int i = 0;
            for (TBMapDecoration deco : this.tbDecorations) {
                storage[i * 4] = (byte)deco.index;
                storage[i * 4 + 1] = deco.func_176112_b();
                storage[i * 4 + 2] = deco.func_176113_c();
                storage[i * 4 + 3] = deco.func_176111_d();
                ++i;
            }
            return storage;
        }

        public static class TBMapDecoration
        extends MapDecoration {
            private static final ResourceLocation MAP_ICONS = new ResourceLocation("narutomod", "textures/map_icons.png");
            private final int index;

            public TBMapDecoration(int index, byte xIn, byte yIn, byte rotationIn) {
                super(MapDecoration.Type.TARGET_X, xIn, yIn, rotationIn);
                this.index = index;
            }

            @SideOnly(value=Side.CLIENT)
            public boolean render(int idx) {
                Minecraft mc = Minecraft.func_71410_x();
                mc.field_71446_o.func_110577_a(MAP_ICONS);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)this.func_176112_b() / 2.0f + 64.0f), (float)((float)this.func_176113_c() / 2.0f + 64.0f), (float)-0.02f);
                GlStateManager.func_179114_b((float)((float)(this.func_176111_d() * 360) / 16.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179152_a((float)7.5f, (float)7.5f, (float)7.5f);
                GlStateManager.func_179132_a((boolean)false);
                float width = 32.0f;
                float height = 32.0f;
                float x = (float)this.index * width;
                float y = (float)(this.index / 4) * height;
                float max = 128.0f;
                float f0 = x / max;
                float f1 = y / max;
                float f2 = (width + x) / max;
                float f3 = (height + y) / max;
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buffer = tessellator.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                buffer.func_181662_b(-1.0, 1.0, 0.0).func_187315_a((double)f2, (double)f1).func_181675_d();
                buffer.func_181662_b(1.0, 1.0, 0.0).func_187315_a((double)f0, (double)f1).func_181675_d();
                buffer.func_181662_b(1.0, -1.0, 0.0).func_187315_a((double)f0, (double)f3).func_181675_d();
                buffer.func_181662_b(-1.0, -1.0, 0.0).func_187315_a((double)f2, (double)f3).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179121_F();
                return true;
            }

            public boolean equals(Object obj) {
                if (super.equals(obj) && obj instanceof TBMapDecoration) {
                    TBMapDecoration other = (TBMapDecoration)((Object)obj);
                    return this.index == other.index;
                }
                return false;
            }

            public int hashCode() {
                return super.hashCode() * 31 + this.index;
            }
        }
    }
}

