/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.creativetab.TabModTab;
import net.narutomod.entity.EntityLightningArc;
import net.narutomod.item.ItemJutsu;
import net.narutomod.item.ItemOnBody;
import net.narutomod.item.ItemRaiton;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class ItemCleaver
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:cleaver")
    public static final Item block = null;
    public static final int ENTITYID = 33;

    public ItemCleaver(ElementsNarutomodMod instance) {
        super(instance, 780);
    }

    @Override
    public void initElements() {
        this.elements.items.add(() -> new ItemCustom());
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityCustom.class).id(new ResourceLocation("narutomod", "entity_cleaver"), 33).name("entity_cleaver").tracker(64, 1, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)block, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:cleaver", "inventory"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityCustom.class, renderManager -> new RenderCustom(renderManager));
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderCustom
    extends Render<EntityCustom> {
        public RenderCustom(RenderManager renderManagerIn) {
            super(renderManagerIn);
        }

        private Vec3d transform3rdPerson(Vec3d startvec, Vec3d angles, EntityLivingBase entity, EnumHandSide side) {
            return ProcedureUtils.rotateRoll(startvec, (float)(-angles.field_72449_c)).func_178785_b((float)(-angles.field_72448_b)).func_178789_a((float)(-angles.field_72450_a)).func_72441_c((double)(0.0625f * (float)(side == EnumHandSide.RIGHT ? -5 : 5)), (double)(1.5f - (entity.func_70093_af() ? 0.3f : 0.0f)), (double)-0.05f).func_178785_b(-entity.field_70761_aq * ((float)Math.PI / 180)).func_72441_c(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        }

        public void doRender(EntityCustom entity, double x, double y, double z, float f, float partialTicks) {
            EntityLivingBase user = entity.getOwner();
            if (user != null) {
                RenderLivingBase renderer = (RenderLivingBase)this.field_76990_c.func_78713_a((Entity)user);
                ModelRenderer rightarmModel = ((ModelBiped)renderer.func_177087_b()).field_178723_h;
                Vec3d rightarmAngles = new Vec3d((double)rightarmModel.field_78795_f, (double)rightarmModel.field_78796_g, (double)rightarmModel.field_78808_h);
                ModelRenderer leftarmModel = ((ModelBiped)renderer.func_177087_b()).field_178724_i;
                Vec3d leftarmAngles = new Vec3d((double)leftarmModel.field_78795_f, (double)leftarmModel.field_78796_g, (double)leftarmModel.field_78808_h);
                EnumHandSide mainhandside = user.func_184591_cq();
                Vec3d mainarmAngles = mainhandside == EnumHandSide.RIGHT ? rightarmAngles : leftarmAngles;
                Vec3d offarmAngles = mainhandside == EnumHandSide.RIGHT ? leftarmAngles : rightarmAngles;
                boolean flag1 = entity.isHoldingWeapon(EnumHand.MAIN_HAND);
                if (flag1 && entity.getRNG().nextFloat() < 0.01f) {
                    Vec3d vec0 = this.transform3rdPerson(new Vec3d(0.0, -1.0, 0.2), mainarmAngles, user, mainhandside);
                    Vec3d vec1 = this.transform3rdPerson(new Vec3d(0.0, -1.0, 2.0), mainarmAngles, user, mainhandside).func_178788_d(vec0).func_186678_a(0.2);
                    vec0 = vec0.func_178787_e(vec1);
                    EntityLightningArc.spawnAsParticle(entity.field_70170_p, vec0.field_72450_a, vec0.field_72448_b, vec0.field_72449_c, 0.01, vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c, new int[0]);
                }
            }
        }

        protected ResourceLocation getEntityTexture(EntityCustom entity) {
            return null;
        }
    }

    public static class EntityCustom
    extends Entity {
        private static final DataParameter<Integer> OWNER_ID = EntityDataManager.func_187226_a(EntityCustom.class, (DataSerializer)DataSerializers.field_187192_b);
        protected EntityLivingBase summoner;

        public EntityCustom(World a) {
            super(a);
        }

        protected EntityCustom(EntityLivingBase summonerIn) {
            this(summonerIn.field_70170_p);
            this.setOwner(summonerIn);
            this.setPositionToSummoner();
        }

        protected void func_70088_a() {
            this.func_184212_Q().func_187214_a(OWNER_ID, (Object)0);
        }

        public EntityLivingBase getOwner() {
            if (!this.field_70170_p.field_72995_K) {
                return this.summoner;
            }
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(OWNER_ID)).intValue());
            return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
        }

        protected void setOwner(EntityLivingBase entity) {
            this.func_184212_Q().func_187227_b(OWNER_ID, (Object)entity.func_145782_y());
            this.summoner = entity;
        }

        public boolean isHoldingWeapon(EnumHand hand) {
            return this.getOwner() != null && this.getOwner().func_184586_b(hand).func_77973_b() == block;
        }

        public void func_70071_h_() {
            if (this.summoner != null) {
                this.setPositionToSummoner();
            }
            if (!(this.field_70170_p.field_72995_K || this.getOwner() != null && this.isHoldingWeapon(EnumHand.MAIN_HAND))) {
                this.func_70106_y();
            } else if (this.field_70146_Z.nextFloat() < 0.01f) {
                this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:electricity")), 0.1f, this.field_70146_Z.nextFloat() * 0.5f + 0.4f);
            }
        }

        protected void setPositionToSummoner() {
            EntityLivingBase entity = this.summoner;
            this.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        }

        public Random getRNG() {
            return this.field_70146_Z;
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }
    }

    public static class ItemCustom
    extends ItemSword
    implements ItemOnBody.Interface {
        public ItemCustom() {
            super(EnumHelper.addToolMaterial((String)"CLEAVER", (int)1, (int)1000, (float)8.0f, (float)11.0f, (int)0));
            this.func_77655_b("cleaver");
            this.setRegistryName("cleaver");
            this.func_77637_a(TabModTab.tab);
        }

        public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot slot) {
            HashMultimap multimap = HashMultimap.create();
            if (slot == EntityEquipmentSlot.MAINHAND) {
                multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.func_150931_i(), 0));
                multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -3.0, 0));
            }
            return multimap;
        }

        public Set<String> getToolClasses(ItemStack stack) {
            HashMap<String, Integer> ret = new HashMap<String, Integer>();
            ret.put("sword", 1);
            return ret.keySet();
        }

        public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
            return repair.func_77973_b() == new ItemStack(Items.field_151042_j, 1).func_77973_b();
        }

        public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
            super.func_77624_a(itemstack, world, list, flag);
            list.add(I18n.func_74838_a((String)"tooltip.cleaver.descr"));
        }

        public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
            if (this.canUseRaiton(attacker)) {
                if (field_77697_d.nextInt(3) == 0) {
                    EntityLightningArc.onStruck((Entity)target, ItemJutsu.causeJutsuDamage((Entity)attacker, attacker), 2.0f);
                }
            }
            return super.func_77644_a(stack, target, attacker);
        }

        private boolean canUseRaiton(EntityLivingBase entity) {
            if (entity instanceof EntityPlayer) {
                ItemStack stack = ProcedureUtils.getMatchingItemStack((EntityPlayer)entity, ItemRaiton.block);
                return stack != null && (((EntityPlayer)entity).func_184812_l_() || ((ItemJutsu.Base)stack.func_77973_b()).canUseAnyJutsu(stack));
            }
            return false;
        }

        public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
            super.func_77663_a(itemstack, world, entity, par4, par5);
            if (!world.field_72995_K && entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_184614_ca().equals(itemstack)) {
                boolean flag = this.canUseRaiton((EntityLivingBase)entity);
                EntityCustom entity1 = this.getEntity(itemstack, world);
                if (entity1 == null && flag) {
                    entity1 = new EntityCustom((EntityLivingBase)entity);
                    world.func_72838_d((Entity)entity1);
                    this.setEntity(itemstack, entity1);
                } else if (entity1 != null && !flag) {
                    entity1.func_70106_y();
                    this.setEntity(itemstack, null);
                }
            }
        }

        private void setEntity(ItemStack itemstack, @Nullable EntityCustom entity) {
            if (!itemstack.func_77942_o()) {
                itemstack.func_77982_d(new NBTTagCompound());
            }
            if (entity == null) {
                itemstack.func_77978_p().func_82580_o("BladeEntityId");
            } else {
                itemstack.func_77978_p().func_74768_a("BladeEntityId", entity.func_145782_y());
            }
        }

        @Nullable
        public EntityCustom getEntity(ItemStack itemstack, World world) {
            if (itemstack.func_77942_o()) {
                Entity entity = world.func_73045_a(itemstack.func_77978_p().func_74762_e("BladeEntityId"));
                return entity instanceof EntityCustom && entity.func_70089_S() ? (EntityCustom)entity : null;
            }
            return null;
        }

        public boolean isShield(ItemStack stack, EntityLivingBase entity) {
            return stack.func_77973_b() == block;
        }

        public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entity, EnumHand hand) {
            entity.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)entity.func_184586_b(hand));
        }

        public EnumAction func_77661_b(ItemStack itemstack) {
            return EnumAction.BLOCK;
        }

        public int func_77626_a(ItemStack itemstack) {
            return 72000;
        }
    }
}

