/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.Particles;
import net.narutomod.PlayerTracker;
import net.narutomod.creativetab.TabModTab;
import net.narutomod.entity.EntityChakraFlow;
import net.narutomod.entity.EntityFutonGreatBreakthrough;
import net.narutomod.entity.EntityFutonVacuum;
import net.narutomod.entity.EntityRasenshuriken;
import net.narutomod.item.ItemJutsu;
import net.narutomod.item.ItemNinjutsu;
import net.narutomod.item.ItemRaiton;
import net.narutomod.potion.PotionReach;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class ItemFuton
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:futon")
    public static final Item block = null;
    public static final int ENTITYID = 132;
    public static final int ENTITY2ID = 10132;
    private static final Random rand = new Random();
    public static final ItemJutsu.JutsuEnum CHAKRAFLOW = new ItemJutsu.JutsuEnum(0, "futonchakraflow", 'D', 20.0, (ItemJutsu.IJutsuCallback)new ChakraFlow.Jutsu());
    public static final ItemJutsu.JutsuEnum RASENSHURIKEN = new ItemJutsu.JutsuEnum(1, "rasenshuriken", 'S', 1000.0, (ItemJutsu.IJutsuCallback)new EntityRasenshuriken.EC.Jutsu());
    public static final ItemJutsu.JutsuEnum VACUUMS = new ItemJutsu.JutsuEnum(2, "futon_vacuum", 'B', 20.0, (ItemJutsu.IJutsuCallback)new EntityFutonVacuum.EC.Jutsu());
    public static final ItemJutsu.JutsuEnum BIGBLOW = new ItemJutsu.JutsuEnum(3, "futon_great_breakthrough", 'C', 20.0, (ItemJutsu.IJutsuCallback)new EntityFutonGreatBreakthrough.EC.Jutsu());

    public ItemFuton(ElementsNarutomodMod instance) {
        super(instance, 376);
    }

    @Override
    public void initElements() {
        this.elements.items.add(() -> new RangedItem(CHAKRAFLOW, RASENSHURIKEN, VACUUMS, BIGBLOW));
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(ChakraFlow.class).id(new ResourceLocation("narutomod", "futonchakraflow"), 132).name("futonchakraflow").tracker(64, 1, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)block, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:futon", "inventory"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(ChakraFlow.class, renderManager -> new RenderChakraFlow(renderManager));
    }

    public static boolean isJutsuEnabled(@Nullable ItemStack stack, ItemJutsu.JutsuEnum jutsu) {
        return stack != null && stack.func_77973_b() == block && ((RangedItem)stack.func_77973_b()).isJutsuEnabled(stack, jutsu);
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderChakraFlow
    extends EntityChakraFlow.RenderCustom<ChakraFlow> {
        public RenderChakraFlow(RenderManager renderManagerIn) {
            super(renderManagerIn);
        }

        @Override
        protected void spawnParticles(ChakraFlow entity, Vec3d startvec, Vec3d endvec) {
            Vec3d vec = endvec.func_178788_d(startvec).func_186678_a(0.2);
            Particles.spawnParticle(entity.field_70170_p, Particles.Types.SMOKE, startvec.field_72450_a, startvec.field_72448_b, startvec.field_72449_c, 10, 0.05, 0.05, 0.05, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 141218303, 10, 5, 240);
        }
    }

    public static class ChakraFlow
    extends EntityChakraFlow.Base {
        private int strengthModifier = 2;

        public ChakraFlow(World world) {
            super(world);
        }

        public ChakraFlow(EntityLivingBase user, ItemStack itemstack) {
            super(user);
            float f;
            if (itemstack.func_77973_b() == block && (f = ((RangedItem)itemstack.func_77973_b()).getCurrentJutsuXpModifier(itemstack, user)) > 0.0f) {
                f = 1.0f / f;
                if (user instanceof EntityPlayer) {
                    f = (float)((double)f * (PlayerTracker.getNinjaLevel((EntityPlayer)user) / 30.0));
                }
                this.strengthModifier = (int)f;
            }
        }

        @Override
        protected void addEffects() {
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 10 == 0) {
                EntityLivingBase user = this.getUser();
                user.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 12, this.strengthModifier + this.ogStrength, false, false));
                user.func_70690_d(new PotionEffect(PotionReach.potion, 12, 0, false, false));
            }
        }

        @Override
        public void func_70071_h_() {
            EntityLivingBase user;
            super.func_70071_h_();
            if (!this.field_70170_p.field_72995_K && (user = this.getUser()) != null && this.isUserHoldingWeapon() && this.field_70173_aa % 10 == 1 && !Chakra.pathway(user).consume(ItemFuton.CHAKRAFLOW.chakraUsage * 0.1)) {
                this.func_70106_y();
            }
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            private static final String ID_KEY = "FutonChakraFlowEntityIdKey";

            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                Entity entity1 = entity.field_70170_p.func_73045_a(stack.func_77978_p().func_74762_e(ID_KEY));
                if (entity1 instanceof ChakraFlow) {
                    entity1.func_70106_y();
                    stack.func_77978_p().func_82580_o(ID_KEY);
                    if (entity instanceof EntityPlayer && !entity.field_70170_p.field_72995_K) {
                        ((EntityPlayer)entity).func_146105_b((ITextComponent)new TextComponentString("Off"), true);
                    }
                    return false;
                }
                if (ItemRaiton.CHAKRAMODE.jutsu.isActivated(entity)) {
                    ItemRaiton.CHAKRAMODE.jutsu.deactivate(entity);
                }
                if (ItemRaiton.CHIDORI.jutsu.isActivated(entity)) {
                    ItemRaiton.CHIDORI.jutsu.deactivate(entity);
                }
                entity1 = new ChakraFlow(entity, stack);
                entity.field_70170_p.func_72838_d(entity1);
                stack.func_77978_p().func_74768_a(ID_KEY, entity1.func_145782_y());
                if (entity instanceof EntityPlayer && !entity.field_70170_p.field_72995_K) {
                    ((EntityPlayer)entity).func_146105_b((ITextComponent)new TextComponentString("On"), true);
                }
                return true;
            }

            @Override
            public boolean isActivated(EntityLivingBase entity) {
                return this.getData(entity) != null;
            }

            @Override
            public void deactivate(EntityLivingBase entity) {
                ItemJutsu.IJutsuCallback.JutsuData jd = this.getData(entity);
                if (jd != null) {
                    jd.entity.func_70106_y();
                    jd.stack.func_77978_p().func_82580_o(ID_KEY);
                }
            }

            @Override
            @Nullable
            public ItemJutsu.IJutsuCallback.JutsuData getData(EntityLivingBase entity) {
                ItemStack stack;
                if (entity instanceof EntityPlayer && (stack = ProcedureUtils.getMatchingItemStack((EntityPlayer)entity, block)) != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b(ID_KEY)) {
                    Entity entity1 = entity.field_70170_p.func_73045_a(stack.func_77978_p().func_74762_e(ID_KEY));
                    return entity1 instanceof ChakraFlow ? new ItemJutsu.IJutsuCallback.JutsuData(entity1, stack) : null;
                }
                return null;
            }
        }
    }

    public static class RangedItem
    extends ItemJutsu.Base {
        public RangedItem(ItemJutsu.JutsuEnum ... list) {
            super(ItemJutsu.JutsuEnum.Type.FUTON, list);
            this.func_77655_b("futon");
            this.setRegistryName("futon");
            this.func_77637_a(TabModTab.tab);
        }

        @Override
        protected float getMaxPower(ItemStack stack, EntityLivingBase entity) {
            ItemJutsu.JutsuEnum jutsu = this.getCurrentJutsu(stack);
            float f = super.getMaxPower(stack, entity);
            if (jutsu == RASENSHURIKEN) {
                return Math.min(f, 2.0f);
            }
            if (jutsu == VACUUMS) {
                return Math.min(f, 50.0f);
            }
            if (jutsu == BIGBLOW) {
                return Math.min(f, 64.0f);
            }
            return f;
        }

        @Override
        protected float getPower(ItemStack stack, EntityLivingBase entity, int timeLeft) {
            ItemJutsu.JutsuEnum jutsu = this.getCurrentJutsu(stack);
            if (jutsu == RASENSHURIKEN) {
                return this.getPower(stack, entity, timeLeft, 0.0f, 300.0f);
            }
            if (jutsu == VACUUMS) {
                return this.getPower(stack, entity, timeLeft, 0.0f, 20.0f);
            }
            if (jutsu == BIGBLOW) {
                return this.getPower(stack, entity, timeLeft, 5.0f, 20.0f);
            }
            return 1.0f;
        }

        @Override
        public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
            super.func_77663_a(itemstack, world, entity, par4, par5);
            if (!world.field_72995_K && entity instanceof EntityPlayer && entity.field_70173_aa % 10 == 3) {
                boolean rasenganEnabled;
                ItemStack stack1 = ProcedureUtils.getMatchingItemStack((EntityPlayer)entity, ItemNinjutsu.block);
                boolean rasenshurikenEnabled = this.isJutsuEnabled(itemstack, RASENSHURIKEN);
                boolean bl = stack1 != null ? ((ItemNinjutsu.RangedItem)stack1.func_77973_b()).canUseJutsu(stack1, ItemNinjutsu.RASENGAN, (EntityLivingBase)((EntityPlayer)entity)) && ((ItemNinjutsu.RangedItem)stack1.func_77973_b()).getXpRatio(stack1, ItemNinjutsu.RASENGAN) >= 1.0f : (rasenganEnabled = false);
                if (rasenshurikenEnabled && !rasenganEnabled) {
                    this.enableJutsu(itemstack, RASENSHURIKEN, false);
                } else if (!rasenshurikenEnabled && rasenganEnabled) {
                    this.enableJutsu(itemstack, RASENSHURIKEN, true);
                    ((EntityPlayer)entity).func_146105_b((ITextComponent)new TextComponentTranslation("chattext.jutsu.enabled", new Object[]{RASENSHURIKEN.getName()}), false);
                }
            }
        }
    }
}

