/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.Particles;
import net.narutomod.creativetab.TabModTab;
import net.narutomod.entity.EntityCellularActivation;
import net.narutomod.entity.EntityPoisonMist;
import net.narutomod.item.ItemJutsu;
import net.narutomod.potion.PotionChakraEnhancedStrength;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class ItemIryoJutsu
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:iryo_jutsu")
    public static final Item block = null;
    public static final int ENTITYID = 210;
    public static final ItemJutsu.JutsuEnum HEALING = new ItemJutsu.JutsuEnum(0, "healingjutsu", 'A', 0.25, (ItemJutsu.IJutsuCallback)new HealingJutsu());
    public static final ItemJutsu.JutsuEnum POISONMIST = new ItemJutsu.JutsuEnum(1, "poison_mist", 'B', 20.0, (ItemJutsu.IJutsuCallback)new EntityPoisonMist.EC.Jutsu());
    public static final ItemJutsu.JutsuEnum MEDMODE = new ItemJutsu.JutsuEnum(2, "cellular_activation", 'A', 20.0, (ItemJutsu.IJutsuCallback)new EntityCellularActivation.EC.Jutsu());
    public static final ItemJutsu.JutsuEnum POWERMODE = new ItemJutsu.JutsuEnum(3, "enhanced_strength", 'A', 30.0, (ItemJutsu.IJutsuCallback)new ChakraEnhancedStrength());

    public ItemIryoJutsu(ElementsNarutomodMod instance) {
        super(instance, 523);
    }

    @Override
    public void initElements() {
        this.elements.items.add(() -> new RangedItem(HEALING, POISONMIST, MEDMODE, POWERMODE));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)block, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:iryo_jutsu", "inventory"));
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new HealingJutsu.PlayerHook());
    }

    public static class ChakraEnhancedStrength
    implements ItemJutsu.IJutsuCallback {
        @Override
        public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            boolean flag = !entity.func_70644_a(PotionChakraEnhancedStrength.potion);
            stack.func_77978_p().func_74757_a("isChakraEnhancedStrengthActive", flag);
            return flag;
        }

        @Override
        public boolean isActivated(ItemStack stack) {
            return stack.func_77942_o() ? stack.func_77978_p().func_74767_n("isChakraEnhancedStrengthActive") : false;
        }
    }

    public static class HealingJutsu
    implements ItemJutsu.IJutsuCallback {
        @Override
        public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
            EntityLivingBase target = null;
            RayTraceResult res = ProcedureUtils.objectEntityLookingAt((Entity)entity, 3.0);
            if (res != null) {
                if (res.field_72308_g instanceof EntityLivingBase) {
                    target = (EntityLivingBase)res.field_72308_g;
                } else if ((int)res.field_72307_f.field_72450_a == (int)entity.field_70165_t && (int)res.field_72307_f.field_72448_b == (int)entity.field_70163_u && (int)res.field_72307_f.field_72449_c == (int)entity.field_70161_v) {
                    target = entity;
                }
            }
            if (target != null) {
                this.createJutsu(entity, target, power);
                return true;
            }
            return false;
        }

        public void createJutsu(EntityLivingBase entity, EntityLivingBase target, float power) {
            if (entity.field_70173_aa % 3 == 0) {
                entity.field_70170_p.func_184148_a(null, target.field_70165_t, target.field_70163_u, target.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:windecho")), SoundCategory.NEUTRAL, 0.5f, MathHelper.func_76126_a((float)((float)entity.field_70173_aa * 0.1f)) * 0.8f + 1.5f);
            }
            Particles.spawnParticle(entity.field_70170_p, Particles.Types.SMOKE, target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v, 10, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0xFFF6 | 32 + target.func_70681_au().nextInt(32) << 24, 10 + target.func_70681_au().nextInt(25), 0, 240, -1, 0);
            target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 80, 6, false, false));
            target.func_70691_i(power * 0.02f);
        }

        public static class PlayerHook {
            @SubscribeEvent
            public void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
                EntityPlayer player = event.getEntityPlayer();
                ItemStack stack = player.func_184614_ca();
                if (stack.func_77973_b() == block && ((RangedItem)block).getCurrentJutsu(stack) == HEALING) {
                    event.setCanceled(true);
                    event.setCancellationResult(EnumActionResult.PASS);
                }
            }
        }
    }

    public static class RangedItem
    extends ItemJutsu.Base {
        public RangedItem(ItemJutsu.JutsuEnum ... list) {
            super(ItemJutsu.JutsuEnum.Type.IRYO, list);
            this.func_77655_b("iryo_jutsu");
            this.setRegistryName("iryo_jutsu");
            this.func_77637_a(TabModTab.tab);
        }

        @Override
        protected float getPower(ItemStack stack, EntityLivingBase entity, int timeLeft) {
            if (this.getCurrentJutsu(stack) == POISONMIST) {
                return this.getPower(stack, entity, timeLeft, 5.0f, 15.0f);
            }
            return 1.0f;
        }

        @Override
        protected float getMaxPower(ItemStack stack, EntityLivingBase entity) {
            ItemJutsu.JutsuEnum jutsu = this.getCurrentJutsu(stack);
            float f = super.getMaxPower(stack, entity);
            if (jutsu == POISONMIST) {
                return Math.min(f, 35.0f);
            }
            return f;
        }

        @Override
        public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
            float power;
            if (!world.field_72995_K && this.executeJutsu(stack, entity, power = this.getPower(stack, entity, timeLeft)) && (this.getCurrentJutsu(stack) != HEALING || timeLeft < this.getMaxUseDuration() - 200)) {
                this.addCurrentJutsuXp(stack, 1);
            }
        }

        private float xpModifier(EntityLivingBase player, ItemStack stack) {
            return (float)Chakra.getLevel(player) * (player instanceof EntityPlayer && ((EntityPlayer)player).func_184812_l_() ? 1.0f : (float)this.getCurrentJutsuXp(stack) / (float)this.getCurrentJutsuRequiredXp(stack));
        }

        @Override
        public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
            if (this.getCurrentJutsu(stack) == HEALING) {
                if (!player.field_70170_p.field_72995_K) {
                    this.executeJutsu(stack, player, this.xpModifier(player, stack) / 15.0f);
                }
                return;
            }
            super.onUsingTick(stack, player, count);
        }

        @Override
        public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
            super.func_77663_a(itemstack, world, entity, par4, par5);
            if (!world.field_72995_K && entity instanceof EntityPlayer && ItemIryoJutsu.POWERMODE.jutsu.isActivated(itemstack) && entity.field_70173_aa % 10 == 2) {
                ((EntityPlayer)entity).func_70690_d(new PotionEffect(PotionChakraEnhancedStrength.potion, 12, (int)Chakra.getLevel((EntityLivingBase)((EntityPlayer)entity)) / 2, true, false));
            }
        }
    }
}

