/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.Particles;
import net.narutomod.PlayerTracker;
import net.narutomod.creativetab.TabModTab;
import net.narutomod.entity.EntityBeamBase;
import net.narutomod.entity.EntityScalableProjectile;
import net.narutomod.item.ItemDoton;
import net.narutomod.item.ItemFuton;
import net.narutomod.item.ItemJutsu;
import net.narutomod.item.ItemKaton;
import net.narutomod.procedure.ProcedureAirPunch;
import net.narutomod.procedure.ProcedureAoeCommand;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class ItemJinton
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:jinton")
    public static final Item block = null;
    public static final int ENTITYID = 124;
    public static final int ENTITY2ID = 10124;
    private static final int MIN_PLAYER_XP = 70;
    public static final ItemJutsu.JutsuEnum BEAM = new ItemJutsu.JutsuEnum(0, "jintonbeam", 'S', 700, 500.0, new EntityBeam.Jutsu());
    public static final ItemJutsu.JutsuEnum CUBE = new ItemJutsu.JutsuEnum(1, "jintoncube", 'S', 700, 600.0, new EntityCube.Jutsu());

    public ItemJinton(ElementsNarutomodMod instance) {
        super(instance, 367);
    }

    @Override
    public void initElements() {
        this.elements.items.add(() -> new RangedItem(BEAM, CUBE));
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityBeam.class).id(new ResourceLocation("narutomod", "jintonbeam"), 124).name("jintonbeam").tracker(64, 1, true).build());
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityCube.class).id(new ResourceLocation("narutomod", "jintoncube"), 10124).name("jintoncube").tracker(64, 1, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)block, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:jinton", "inventory"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityBeam.class, renderManager -> new RenderBeam(renderManager));
        RenderingRegistry.registerEntityRenderingHandler(EntityCube.class, renderManager -> new RenderCube(renderManager));
    }

    private static void attackEntityWithJutsu(Entity projectile, EntityLivingBase attacker, Entity target, float amount) {
        if (target instanceof EntityLivingBase) {
            target.field_70172_ad = 10;
            target.func_70097_a(ItemJutsu.causeJutsuDamage(projectile, attacker).func_76348_h().func_151518_m(), amount);
        } else {
            target.func_174812_G();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class ModelCube
    extends ModelBase {
        private final ModelRenderer bone;
        private final ModelRenderer bone2;

        public ModelCube() {
            this.field_78090_t = 32;
            this.field_78089_u = 32;
            this.bone = new ModelRenderer((ModelBase)this);
            this.bone.func_78793_a(0.0f, 0.0f, 0.0f);
            this.bone.field_78804_l.add(new ModelBox(this.bone, 0, 0, -0.5f, -4.5f, -0.5f, 1, 1, 1, 0.0f, false));
            this.bone2 = new ModelRenderer((ModelBase)this);
            this.bone2.func_78793_a(0.0f, 0.0f, 0.0f);
            this.bone2.field_78804_l.add(new ModelBox(this.bone2, 0, 0, -1.0f, -5.0f, -1.0f, 2, 2, 2, 0.0f, false));
            this.bone2.field_78804_l.add(new ModelBox(this.bone2, 0, 0, -1.5f, -5.5f, -1.5f, 3, 3, 3, 0.0f, false));
            this.bone2.field_78804_l.add(new ModelBox(this.bone2, 0, 0, -2.0f, -6.0f, -2.0f, 4, 4, 4, 0.0f, false));
            this.bone2.field_78804_l.add(new ModelBox(this.bone2, 0, 16, -4.0f, -8.0f, -4.0f, 8, 8, 8, 0.0f, false));
        }

        public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.bone.func_78785_a(f5);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
            this.bone2.func_78785_a(f5);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class ModelLongCube
    extends EntityBeamBase.Model {
        private final ModelRenderer bone;
        private final ModelRenderer bone2;
        protected float scale = 1.0f;

        public ModelLongCube(float length) {
            this.field_78090_t = 32;
            this.field_78089_u = 32;
            int len = (int)(16.0f * length);
            this.bone = new ModelRenderer((ModelBase)this);
            this.bone.func_78793_a(0.0f, 0.0f, 0.0f);
            this.bone.field_78804_l.add(new ModelBox(this.bone, 0, 0, -0.5f, -16.0f, -0.5f, 1, len, 1, 0.0f, false));
            this.bone2 = new ModelRenderer((ModelBase)this);
            this.bone2.func_78793_a(0.0f, 0.0f, 0.0f);
            this.bone2.field_78804_l.add(new ModelBox(this.bone2, 0, 0, -1.0f, -16.0f, -1.0f, 2, len, 2, 0.0f, false));
            this.bone2.field_78804_l.add(new ModelBox(this.bone2, 0, 0, -1.5f, -16.0f, -1.5f, 3, len, 3, 0.0f, false));
            this.bone2.field_78804_l.add(new ModelBox(this.bone2, 0, 0, -2.0f, -16.0f, -2.0f, 4, len, 4, 0.0f, false));
            this.bone2.field_78804_l.add(new ModelBox(this.bone2, 0, 0, -4.0f, -16.0f, -4.0f, 8, len, 8, 0.0f, false));
        }

        @Override
        public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)((this.scale - 1.0f) * 1.5f + 1.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)this.scale);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.bone.func_78785_a(f5);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
            this.bone2.func_78785_a(f5);
            GlStateManager.func_179121_F();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderCube
    extends Render<EntityCube> {
        private final ResourceLocation TEXTURE;
        private final ModelCube model;

        public RenderCube(RenderManager renderManager) {
            super(renderManager);
            this.TEXTURE = new ResourceLocation("narutomod:textures/longcube_white.png");
            this.model = new ModelCube();
            this.field_76989_e = 0.1f;
        }

        public void doRender(EntityCube entity, double x, double y, double z, float yaw, float pt) {
            this.func_180548_c(entity);
            GlStateManager.func_179094_E();
            float scale = entity.getEntityScale();
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
            GlStateManager.func_179114_b((float)(-entity.field_70126_B - (entity.field_70177_z - entity.field_70126_B) * pt), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * pt - 180.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179129_p();
            GlStateManager.func_179140_f();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
            this.model.func_78088_a(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179145_e();
            GlStateManager.func_179089_o();
            GlStateManager.func_179118_c();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }

        protected ResourceLocation getEntityTexture(EntityCube entity) {
            return this.TEXTURE;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderBeam
    extends EntityBeamBase.Renderer<EntityBeam> {
        private final ResourceLocation texture;

        public RenderBeam(RenderManager renderManager) {
            super(renderManager);
            this.texture = new ResourceLocation("narutomod:textures/longcube_white.png");
        }

        @Override
        public EntityBeamBase.Model getMainModel(EntityBeam entity) {
            int i = entity.ticksAlive - 60;
            if (i > 0) {
                float length = MathHelper.func_76131_a((float)(entity.getBeamLength() * (float)i / 10.0f), (float)1.0f, (float)entity.getBeamLength());
                float scale = entity.getScale() * 2.0f * length / entity.getBeamLength();
                ModelLongCube model = new ModelLongCube(length / scale);
                model.scale = scale;
                return model;
            }
            return new ModelLongCube(1.0f);
        }

        @Override
        protected ResourceLocation getEntityTexture(EntityBeam entity) {
            return this.texture;
        }
    }

    public static class EntityCube
    extends EntityScalableProjectile.Base {
        private final int wait = 60;
        private final int growTime = 30;
        private final int idleTime = 40;
        private final int shrinkTime = 10;
        private float fullScale = 1.0f;

        public EntityCube(World a) {
            super(a);
            this.setOGSize(0.5f, 0.5f);
            this.field_70178_ae = true;
        }

        public EntityCube(EntityLivingBase shooter, float scale) {
            super(shooter);
            this.setOGSize(0.5f, 0.5f);
            this.fullScale = scale;
            this.setWaitPosition(shooter);
            this.field_70178_ae = true;
        }

        private void setWaitPosition(EntityLivingBase shooter) {
            Vec3d vec3d = shooter.func_70040_Z().func_186678_a(0.5);
            this.func_70107_b(shooter.field_70165_t + vec3d.field_72450_a, shooter.field_70163_u + (double)shooter.func_70047_e() - 0.6 + vec3d.field_72448_b, shooter.field_70161_v + vec3d.field_72449_c);
            this.setEntityScale(0.5f);
        }

        public void shoot(RayTraceResult result) {
            double d0 = result.field_72308_g != null ? result.field_72308_g.field_70165_t : result.field_72307_f.field_72450_a;
            double d1 = result.field_72308_g != null ? result.field_72308_g.field_70163_u + (double)(result.field_72308_g.field_70131_O / 2.0f) : result.field_72307_f.field_72448_b;
            double d2 = result.field_72308_g != null ? result.field_72308_g.field_70161_v : result.field_72307_f.field_72449_c;
            this.func_70107_b(d0, d1, d2);
            ProcedureAoeCommand.set(this.field_70170_p, d0, d1, d2, 0.0, this.fullScale / 4.0f).effect(MobEffects.field_76421_d, 5, 5);
        }

        private void destroyBlocksAndEntitiesInAABB(AxisAlignedBB bb) {
            if (ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this.shootingEntity)) {
                int j2 = MathHelper.func_76128_c((double)bb.field_72340_a);
                int k2 = MathHelper.func_76143_f((double)bb.field_72336_d);
                int l2 = MathHelper.func_76128_c((double)bb.field_72338_b);
                int i3 = MathHelper.func_76143_f((double)bb.field_72337_e);
                int j3 = MathHelper.func_76128_c((double)bb.field_72339_c);
                int k3 = MathHelper.func_76143_f((double)bb.field_72334_f);
                BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
                for (int l3 = j2; l3 < k2; ++l3) {
                    for (int i4 = l2; i4 < i3; ++i4) {
                        for (int j4 = j3; j4 < k3; ++j4) {
                            if (this.field_70170_p.func_175623_d((BlockPos)pos.func_181079_c(l3, i4, j4))) continue;
                            this.field_70170_p.func_175698_g((BlockPos)pos);
                        }
                    }
                }
                pos.func_185344_t();
            }
            for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, bb)) {
                double d = ProcedureUtils.BB.getVolume(bb.func_191500_a(entity.func_174813_aQ())) / ProcedureUtils.BB.getVolume(entity.func_174813_aQ()) * 0.5;
                ItemJinton.attackEntityWithJutsu(this, this.shootingEntity, entity, entity instanceof EntityLivingBase ? ((EntityLivingBase)entity).func_110138_aP() * (float)d : Float.MAX_VALUE);
            }
        }

        @Override
        public void setEntityScale(float scale) {
            double d = (this.field_70131_O * scale / this.getEntityScale() - this.field_70131_O) / 2.0f;
            super.setEntityScale(scale);
            this.func_70107_b(this.field_70165_t, this.field_70163_u - d, this.field_70161_v);
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            int idle = this.wait + this.growTime + this.idleTime;
            if (this.shootingEntity != null) {
                if (this.ticksAlive < this.wait) {
                    this.setWaitPosition(this.shootingEntity);
                } else if (this.ticksAlive == this.wait) {
                    this.shoot(ProcedureUtils.objectEntityLookingAt((Entity)this.shootingEntity, 50.0, true));
                } else {
                    ProcedureAoeCommand.set(this, 0.0, this.field_70130_N / 2.0f).motion(0.0, 0.0, 0.0);
                    if (this.ticksAlive < this.wait + this.growTime) {
                        float f = (this.fullScale - 1.0f) * (float)(this.ticksAlive - this.wait);
                        ((Object)((Object)this)).getClass();
                        this.setEntityScale(1.0f + f / 30.0f);
                    } else {
                        Particles.spawnParticle(this.field_70170_p, Particles.Types.FALLING_DUST, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v, (int)(this.fullScale * 6.0f), (double)(this.field_70130_N * 0.2f), (double)(this.field_70131_O * 0.2f), (double)(this.field_70130_N * 0.2f), 0.0, 0.1, 0.0, -1063214944, 15, 0);
                        if (this.ticksAlive > idle) {
                            this.destroyBlocksAndEntitiesInAABB(this.func_174813_aQ());
                            float f = this.ticksAlive - idle;
                            ((Object)((Object)this)).getClass();
                            this.setEntityScale(this.fullScale * (1.0f - f / 10.0f));
                        }
                    }
                }
            }
            if (this.ticksAlive > idle + this.shrinkTime || this.shootingEntity != null && !this.shootingEntity.func_70089_S()) {
                this.func_70106_y();
            }
        }

        @Override
        protected void onImpact(RayTraceResult result) {
        }

        @Override
        protected void checkOnGround() {
        }

        @Override
        public void renderParticles() {
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                power = power * 2.0f + 2.0f;
                entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:genkaihakurinojutsu")), SoundCategory.PLAYERS, 1.0f, 1.0f);
                entity.field_70170_p.func_72838_d((Entity)new EntityCube(entity, power));
                return true;
            }
        }
    }

    public static class EntityBeam
    extends EntityBeamBase.Base {
        private static final DataParameter<Float> SCALE = EntityDataManager.func_187226_a(EntityBeam.class, (DataSerializer)DataSerializers.field_187193_c);
        private final AirPunch beam = new AirPunch();
        private final int wait = 60;

        public EntityBeam(World a) {
            super(a);
            this.field_70178_ae = true;
        }

        public EntityBeam(EntityLivingBase shooter, float scale) {
            super(shooter);
            this.setScale(scale);
            this.field_70178_ae = true;
        }

        @Override
        protected void func_70088_a() {
            super.func_70088_a();
            this.func_184212_Q().func_187214_a(SCALE, (Object)Float.valueOf(1.0f));
        }

        public float getScale() {
            return ((Float)this.func_184212_Q().func_187225_a(SCALE)).floatValue();
        }

        protected void setScale(float scale) {
            this.func_184212_Q().func_187227_b(SCALE, (Object)Float.valueOf(scale));
        }

        @Override
        protected void updatePosition() {
            if (this.shootingEntity != null) {
                this.func_70107_b(this.shootingEntity.field_70165_t, this.shootingEntity.field_70163_u + (double)this.shootingEntity.func_70047_e() - 0.2, this.shootingEntity.field_70161_v);
            }
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            if (this.shootingEntity != null) {
                Vec3d vec3d;
                if (this.ticksAlive < this.wait) {
                    vec3d = this.shootingEntity.func_70040_Z();
                    this.shoot(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
                }
                if (this.ticksAlive >= this.wait) {
                    vec3d = this.shootingEntity.func_70040_Z().func_186678_a(30.0);
                    this.shoot(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
                }
                if (this.ticksAlive >= this.wait + 2) {
                    this.beam.execute2((EntityLivingBase)this.shootingEntity, this.getBeamLength(), (double)this.getScale() / 2.0);
                }
            }
            if (this.ticksAlive > this.wait + 60) {
                this.field_70170_p.func_72900_e((Entity)this);
            }
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                if (entity instanceof EntityPlayer) {
                    power = Math.min(power / 2.0f + 0.5f, 10.0f);
                    entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:genkaihakurinojutsu")), SoundCategory.PLAYERS, 1.0f, 1.0f);
                    Vec3d vec3d = entity.func_70040_Z();
                    EntityBeam entitybeam = new EntityBeam(entity, power);
                    entitybeam.shoot(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
                    entity.field_70170_p.func_72838_d((Entity)entitybeam);
                    return true;
                }
                return false;
            }
        }

        public class AirPunch
        extends ProcedureAirPunch {
            public AirPunch() {
                this.blockDropChance = -1.0f;
                this.blockHardnessLimit = 100.0f;
                this.particlesPre = null;
                this.particlesDuring = EnumParticleTypes.SMOKE_LARGE;
            }

            @Override
            protected void attackEntityFrom(EntityLivingBase player, Entity target) {
                double d = this.getFarRadius(0) / target.func_174813_aQ().func_72320_b();
                float f = target instanceof EntityLivingBase ? ((EntityLivingBase)target).func_110138_aP() * (float)d : Float.MAX_VALUE;
                ItemJinton.attackEntityWithJutsu(EntityBeam.this, player, target, f);
            }

            @Override
            protected float getBreakChance(BlockPos pos, EntityLivingBase player, double range) {
                return 1.0f;
            }
        }
    }

    public static class RangedItem
    extends ItemJutsu.Base {
        public RangedItem(ItemJutsu.JutsuEnum ... list) {
            super(ItemJutsu.JutsuEnum.Type.JINTON, list);
            this.func_77655_b("jinton");
            this.setRegistryName("jinton");
            this.func_77637_a(TabModTab.tab);
            this.defaultCooldownMap[ItemJinton.BEAM.index] = 0L;
            this.defaultCooldownMap[ItemJinton.CUBE.index] = 0L;
        }

        private float getMaxUsablePower(EntityLivingBase entity, ItemStack stack) {
            float max = entity instanceof EntityPlayer ? (float)(PlayerTracker.getNinjaLevel((EntityPlayer)entity) - 70.0 + 5.0) / 5.0f : 6.0f;
            return MathHelper.func_76131_a((float)max, (float)0.0f, (float)(this.getCurrentJutsu(stack) == BEAM ? 10.0f : 50.0f));
        }

        private float getUsePercent(int timeLeft) {
            return Math.min((float)(this.getMaxUseDuration() - timeLeft) / 400.0f, 1.0f);
        }

        @Override
        protected float getPower(ItemStack stack, EntityLivingBase entity, int timeLeft) {
            return Math.min(this.getUsePercent(timeLeft) * this.getMaxUsablePower(entity, stack), this.getMaxPower(stack, entity));
        }

        @Override
        public void func_77615_a(ItemStack itemstack, World world, EntityLivingBase entity, int timeLeft) {
            float power;
            if (!world.field_72995_K && (power = this.getPower(itemstack, entity, timeLeft)) >= 1.0f && this.executeJutsu(itemstack, entity, power) && entity instanceof EntityPlayer && !((EntityPlayer)entity).func_184812_l_()) {
                ((EntityPlayer)entity).func_184811_cZ().func_185145_a(itemstack.func_77973_b(), (int)((double)(this.getUsePercent(timeLeft) * 12000.0f) * ProcedureUtils.getCooldownModifier((EntityPlayer)entity)));
            }
        }

        @Override
        public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entity, EnumHand hand) {
            if (entity.func_184812_l_() || ProcedureUtils.hasItemInInventory(entity, ItemKaton.block) && ProcedureUtils.hasItemInInventory(entity, ItemFuton.block) && ProcedureUtils.hasItemInInventory(entity, ItemDoton.block)) {
                return super.func_77659_a(world, entity, hand);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)entity.func_184586_b(hand));
        }

        @Override
        public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
            super.func_77624_a(itemstack, world, list, flag);
            list.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.jinton.musthave") + TextFormatting.RESET);
        }
    }
}

