/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import com.google.common.collect.Multimap;
import java.util.Iterator;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.vecmath.Vector4d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.creativetab.TabModTab;
import net.narutomod.entity.EntityHiraishin;
import net.narutomod.entity.EntityRendererRegister;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class ItemKunaiHiraishin
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:kunai_hiraishin")
    public static final Item block = null;
    public static final int ENTITYID = 402;

    public ItemKunaiHiraishin(ElementsNarutomodMod instance) {
        super(instance, 790);
    }

    @Override
    public void initElements() {
        this.elements.items.add(() -> new RangedItem());
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityCustom.class).id(new ResourceLocation("narutomod", "entitybulletkunai_hiraishin"), 402).name("entitybulletkunai_hiraishin").tracker(64, 1, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)block, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:kunai_hiraishin", "inventory"));
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)Renderer.instance);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        new Renderer().register();
    }

    public static class Renderer
    extends EntityRendererRegister {
        private static Renderer instance;

        public Renderer() {
            instance = this;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void register() {
            RenderingRegistry.registerEntityRenderingHandler(EntityCustom.class, renderManager -> new RenderCustom(renderManager));
        }

        @SubscribeEvent
        public void onTossItem(ItemTossEvent event) {
            ItemStack stack = event.getEntityItem().func_92059_d();
            if (stack.func_77973_b() == block) {
                event.setCanceled(true);
                this.playerDropKunai(event.getPlayer(), stack);
            }
        }

        private void playerDropKunai(EntityPlayer player, ItemStack stack) {
            if (!player.field_70170_p.field_72995_K) {
                EntityCustom entityarrow = new EntityCustom(player, stack);
                Vec3d vec = player.func_70040_Z();
                entityarrow.func_70186_c(vec.field_72450_a, 0.0, vec.field_72449_c, 0.4f, 0.0f);
                entityarrow.func_70239_b(7.0);
                entityarrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
                player.field_70170_p.func_72838_d((Entity)entityarrow);
                UUID ownerUuid = RangedItem.getOwnerUuid(stack);
                if (ownerUuid != null && !ownerUuid.equals(player.func_110124_au())) {
                    EntityHiraishin.updateServerMarkerMap(ownerUuid, player.func_110124_au(), null);
                }
            }
        }

        @SubscribeEvent
        public void onPlayerDrops(PlayerDropsEvent event) {
            Iterator iter = event.getDrops().iterator();
            while (iter.hasNext()) {
                EntityItem itemEntity = (EntityItem)iter.next();
                if (itemEntity.func_92059_d().func_77973_b() != block) continue;
                this.playerDropKunai(event.getEntityPlayer(), itemEntity.func_92059_d());
                iter.remove();
            }
        }

        @SideOnly(value=Side.CLIENT)
        public class RenderCustom
        extends Render<EntityCustom> {
            protected final Item item;
            private final RenderItem itemRenderer;

            public RenderCustom(RenderManager renderManagerIn) {
                super(renderManagerIn);
                this.item = block;
                this.itemRenderer = Minecraft.func_71410_x().func_175599_af();
            }

            public void doRender(EntityCustom entity, double x, double y, double z, float entityYaw, float partialTicks) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
                GlStateManager.func_179091_B();
                GlStateManager.func_179114_b((float)(entityYaw - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks), (float)0.0f, (float)0.0f, (float)1.0f);
                this.func_110776_a(TextureMap.field_110575_b);
                if (this.field_188301_f) {
                    GlStateManager.func_179142_g();
                    GlStateManager.func_187431_e((int)this.func_188298_c((Entity)entity));
                }
                this.itemRenderer.func_181564_a(this.getStackToRender(), ItemCameraTransforms.TransformType.GROUND);
                if (this.field_188301_f) {
                    GlStateManager.func_187417_n();
                    GlStateManager.func_179119_h();
                }
                GlStateManager.func_179101_C();
                GlStateManager.func_179121_F();
                super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
            }

            public ItemStack getStackToRender() {
                return new ItemStack(this.item);
            }

            protected ResourceLocation getEntityTexture(EntityCustom entity) {
                return TextureMap.field_110575_b;
            }
        }
    }

    public static class EntityCustom
    extends EntityArrow {
        private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(EntityCustom.class, (DataSerializer)DataSerializers.field_187196_f);
        private boolean noUpdate;
        private int pickupDelay = 60;
        private int lastCollideTime;

        public EntityCustom(World a) {
            super(a);
        }

        public EntityCustom(EntityPlayer shooter, ItemStack stack) {
            super(shooter.field_70170_p, (EntityLivingBase)shooter);
            this.setItem(stack.func_77946_l());
        }

        public void func_70088_a() {
            super.func_70088_a();
            this.func_184212_Q().func_187214_a(ITEM, (Object)ItemStack.field_190927_a);
        }

        public ItemStack getItem() {
            return (ItemStack)this.func_184212_Q().func_187225_a(ITEM);
        }

        public void setItem(ItemStack stack) {
            this.func_184212_Q().func_187227_b(ITEM, (Object)stack);
            this.func_184212_Q().func_187217_b(ITEM);
        }

        @Nullable
        public UUID getOwnerId() {
            ItemStack stack = this.getItem();
            return stack.func_77973_b() == block ? RangedItem.getOwnerUuid(stack) : null;
        }

        @Nullable
        public EntityPlayerMP getOwner() {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : ProcedureUtils.getPlayerMatchingUuid(uuid);
        }

        protected ItemStack func_184550_j() {
            return this.getItem().func_77946_l();
        }

        public void func_70106_y() {
            UUID uuid;
            super.func_70106_y();
            if (!this.field_70170_p.field_72995_K && (uuid = this.getOwnerId()) != null) {
                EntityHiraishin.updateServerMarkerMap(uuid, this.func_110124_au(), null);
            }
        }

        public void func_70071_h_() {
            super.func_70071_h_();
            if (this.field_70254_i && this.getOwnerId() != null && (Integer)ReflectionHelper.getPrivateValue(EntityArrow.class, (Object)((Object)this), (int)12) > 1198) {
                ReflectionHelper.setPrivateValue(EntityArrow.class, (Object)((Object)this), (Object)1, (int)12);
            }
            if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                EntityPlayerMP owner = this.getOwner();
                if (owner == null) {
                    this.noUpdate = false;
                } else if (!this.noUpdate) {
                    Vec3d vec = this.func_174791_d();
                    Vector4d vec4d = new Vector4d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, (double)this.field_71093_bK);
                    EntityHiraishin.updateServerMarkerMap(owner.func_110124_au(), this.func_110124_au(), vec4d);
                    if (this.field_70254_i) {
                        this.noUpdate = true;
                    }
                }
            }
        }

        public void func_70100_b_(EntityPlayer entityIn) {
            if (!this.field_70170_p.field_72995_K && this.field_70254_i && this.field_70249_b <= 0) {
                if (this.field_184552_b - this.lastCollideTime > 20) {
                    this.pickupDelay = 60;
                }
                if (this.pickupDelay <= 0) {
                    super.func_70100_b_(entityIn);
                }
                if (this.pickupDelay > 0) {
                    --this.pickupDelay;
                }
                this.lastCollideTime = this.field_184552_b;
            }
        }

        protected void func_184549_a(RayTraceResult result) {
            if (result.field_72308_g == null || !this.field_70170_p.field_72995_K) {
                super.func_184549_a(result);
            }
        }

        protected void func_184548_a(EntityLivingBase living) {
            super.func_184548_a(living);
            living.func_85034_r(living.func_85035_bI() - 1);
            if (living instanceof EntityPlayer) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)((EntityPlayer)living), (ItemStack)this.getItem());
            } else {
                RayTraceResult rtr;
                EntityPlayerMP owner = this.getOwner();
                if (owner != null && (rtr = living.func_174813_aQ().func_72327_a(this.func_174791_d(), living.func_174791_d().func_72441_c(0.0, 0.5 * (double)living.field_70131_O, 0.0))) != null) {
                    rtr.field_72308_g = living;
                    rtr.field_72313_a = RayTraceResult.Type.ENTITY;
                    this.field_70170_p.func_72838_d((Entity)new EntityHiraishin.EC((EntityLivingBase)owner, rtr));
                }
            }
        }

        public void func_70037_a(NBTTagCompound compound) {
            super.func_70037_a(compound);
            if (compound.func_74764_b("Item")) {
                this.setItem(new ItemStack(compound.func_74775_l("Item")));
            }
        }

        public void func_70014_b(NBTTagCompound compound) {
            super.func_70014_b(compound);
            if (!this.getItem().func_190926_b()) {
                compound.func_74782_a("Item", (NBTBase)this.getItem().func_77955_b(new NBTTagCompound()));
            }
        }
    }

    public static class RangedItem
    extends Item {
        public RangedItem() {
            this.func_77656_e(100);
            this.func_77664_n();
            this.func_77655_b("kunai_hiraishin");
            this.setRegistryName("kunai_hiraishin");
            this.field_77777_bU = 1;
            this.func_77637_a(TabModTab.tab);
        }

        public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot slot) {
            Multimap multimap = super.func_111205_h(slot);
            if (slot == EntityEquipmentSlot.MAINHAND) {
                multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Ranged item modifier", 6.0, 0));
                multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Ranged item modifier", -2.4, 0));
            }
            return multimap;
        }

        public void func_77615_a(ItemStack itemstack, World world, EntityLivingBase entityLivingBase, int timeLeft) {
            if (!world.field_72995_K && entityLivingBase instanceof EntityPlayerMP) {
                EntityPlayerMP entity = (EntityPlayerMP)entityLivingBase;
                float power = 1.0f;
                itemstack.func_77972_a(1, (EntityLivingBase)entity);
                EntityCustom entityarrow = new EntityCustom((EntityPlayer)entity, itemstack);
                entityarrow.func_70186_c(entity.func_70040_Z().field_72450_a, entity.func_70040_Z().field_72448_b, entity.func_70040_Z().field_72449_c, power * 2.0f, 0.0f);
                entityarrow.func_174810_b(true);
                entityarrow.func_70243_d(false);
                entityarrow.func_70239_b(7.0);
                entityarrow.func_70240_a(0);
                world.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.0f) + power / 2.0f);
                if (entity.func_184812_l_()) {
                    entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                } else {
                    entityarrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
                    itemstack.func_190918_g(1);
                }
                world.func_72838_d((Entity)entityarrow);
            }
        }

        public static void setOwner(ItemStack stack, EntityLivingBase owner) {
            if (stack.func_77973_b() == block && !owner.field_70170_p.field_72995_K) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_186854_a("owner", owner.func_110124_au());
                stack.func_151001_c(stack.func_82833_r() + " (" + owner.func_70005_c_() + ")");
            }
        }

        @Nullable
        public static UUID getOwnerUuid(ItemStack stack) {
            return stack.func_77942_o() ? stack.func_77978_p().func_186857_a("owner") : null;
        }

        public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
            UUID ownerUuid;
            super.func_77663_a(stack, world, entity, par4, par5);
            if (entity instanceof EntityPlayerMP && ((EntityPlayerMP)entity).func_184812_l_() && (!stack.func_77942_o() || !stack.func_77978_p().func_186855_b("owner"))) {
                RangedItem.setOwner(stack, (EntityLivingBase)((EntityPlayerMP)entity));
            }
            if ((ownerUuid = RangedItem.getOwnerUuid(stack)) != null) {
                UUID lastMarkerUuid;
                UUID uUID = lastMarkerUuid = stack.func_77978_p().func_186855_b("lastMarkerUuid") ? stack.func_77978_p().func_186857_a("lastMarkerUuid") : null;
                if (!ownerUuid.equals(entity.func_110124_au())) {
                    if (lastMarkerUuid != null && !lastMarkerUuid.equals(entity.func_110124_au())) {
                        EntityHiraishin.updateServerMarkerMap(ownerUuid, lastMarkerUuid, null);
                    }
                    EntityHiraishin.updateServerMarkerMap(ownerUuid, entity.func_110124_au(), new Vector4d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (double)entity.field_71093_bK));
                    stack.func_77978_p().func_186854_a("lastMarkerUuid", entity.func_110124_au());
                } else if (lastMarkerUuid != null) {
                    EntityHiraishin.updateServerMarkerMap(ownerUuid, lastMarkerUuid, null);
                    stack.func_77978_p().func_82580_o("lastMarkerUuid");
                }
            }
        }

        public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entity, EnumHand hand) {
            entity.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)entity.func_184586_b(hand));
        }

        public EnumAction func_77661_b(ItemStack itemstack) {
            return EnumAction.BOW;
        }

        public int func_77626_a(ItemStack itemstack) {
            return 72000;
        }
    }
}

