/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.creativetab.TabModTab;
import net.narutomod.entity.EntityWoodArm;
import net.narutomod.entity.EntityWoodBurial;
import net.narutomod.entity.EntityWoodGolem;
import net.narutomod.entity.EntityWoodPrison;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureSync;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class ItemMokuton
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:mokuton")
    public static final Item block = null;
    public static final ItemJutsu.JutsuEnum WOODBURIAL = new ItemJutsu.JutsuEnum(0, "wood_burial", 'S', 100.0, (ItemJutsu.IJutsuCallback)new EntityWoodBurial.EC.Jutsu());
    public static final ItemJutsu.JutsuEnum WOODPRISON = new ItemJutsu.JutsuEnum(1, "wood_prison", 'S', 50.0, (ItemJutsu.IJutsuCallback)new EntityWoodPrison.EC.Jutsu());
    public static final ItemJutsu.JutsuEnum WOODHOUSE = new ItemJutsu.JutsuEnum(2, "tooltip.mokuton.rightclick2", 'S', 100.0, (ItemJutsu.IJutsuCallback)new JutsuHouse());
    public static final ItemJutsu.JutsuEnum GOLEM = new ItemJutsu.JutsuEnum(3, "wood_golem", 'S', 800, 1000.0, new EntityWoodGolem.EC.Jutsu());
    public static final ItemJutsu.JutsuEnum ARMATTACK = new ItemJutsu.JutsuEnum(4, "wood_arm", 'S', 400, 50.0, new EntityWoodArm.EC.Jutsu());

    public ItemMokuton(ElementsNarutomodMod instance) {
        super(instance, 245);
    }

    @Override
    public void initElements() {
        this.elements.items.add(() -> new ItemCustom(WOODBURIAL, WOODPRISON, WOODHOUSE, GOLEM, ARMATTACK));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)block, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:mokuton", "inventory"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(WoodSegment.class, renderManager -> new RenderSegment(renderManager));
    }

    @SideOnly(value=Side.CLIENT)
    public class ModelWoodSegment
    extends ModelBase {
        private final ModelRenderer[] segment = new ModelRenderer[1];

        public ModelWoodSegment() {
            this.field_78090_t = 16;
            this.field_78089_u = 16;
            for (int i = 0; i < this.segment.length; ++i) {
                this.segment[i] = new ModelRenderer((ModelBase)this);
                this.segment[i].func_78793_a(0.0f, i == 0 ? 0.0f : -3.0f, 0.0f);
                this.segment[i].field_78804_l.add(new ModelBox(this.segment[i], 0, 0, -2.0f, -3.0f, -2.0f, 4, 4, 4, 0.0f, false));
                ModelRenderer bone5 = new ModelRenderer((ModelBase)this);
                bone5.func_78793_a(0.0f, 1.0f, 0.0f);
                this.segment[i].func_78792_a(bone5);
                ModelRenderer bone = new ModelRenderer((ModelBase)this);
                bone.func_78793_a(0.0f, -4.0f, -2.0f);
                bone5.func_78792_a(bone);
                this.setRotationAngle(bone, 0.5236f, 3.1416f, 0.0f);
                bone.field_78804_l.add(new ModelBox(bone, 0, 0, -2.0f, -4.0f, 0.0f, 4, 4, 0, 0.0f, false));
                ModelRenderer bone2 = new ModelRenderer((ModelBase)this);
                bone2.func_78793_a(0.0f, -4.0f, 2.0f);
                bone5.func_78792_a(bone2);
                this.setRotationAngle(bone2, 0.5236f, 0.0f, 0.0f);
                bone2.field_78804_l.add(new ModelBox(bone2, 0, 0, -2.0f, -4.0f, 0.0f, 4, 4, 0, 0.0f, false));
                ModelRenderer bone3 = new ModelRenderer((ModelBase)this);
                bone3.func_78793_a(-2.0f, -4.0f, 0.0f);
                bone5.func_78792_a(bone3);
                this.setRotationAngle(bone3, 0.0f, -1.5708f, 0.5236f);
                bone3.field_78804_l.add(new ModelBox(bone3, 0, 0, -2.0f, -4.0f, 0.0f, 4, 4, 0, 0.0f, false));
                ModelRenderer bone4 = new ModelRenderer((ModelBase)this);
                bone4.func_78793_a(2.0f, -4.0f, 0.0f);
                bone5.func_78792_a(bone4);
                this.setRotationAngle(bone4, 0.0f, 1.5708f, -0.5236f);
                bone4.field_78804_l.add(new ModelBox(bone4, 0, 0, -2.0f, -4.0f, 0.0f, 4, 4, 0, 0.0f, true));
                if (i <= 0) continue;
                this.segment[i - 1].func_78792_a(this.segment[i]);
            }
        }

        public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
            this.segment[0].func_78785_a(f5);
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderSegment
    extends Render<WoodSegment> {
        private final ResourceLocation texture;
        protected final ModelWoodSegment model;

        public RenderSegment(RenderManager renderManagerIn) {
            super(renderManagerIn);
            this.texture = new ResourceLocation("narutomod:textures/woodblock.png");
            this.model = new ModelWoodSegment();
            this.field_76989_e = 0.4f;
        }

        public void doRender(WoodSegment entity, double x, double y, double z, float entityYaw, float pt) {
            if (entity.getParent() != null) {
                entity.setPositionAndRotationFromParent(pt);
                x = entity.field_70165_t - this.field_76990_c.field_78730_l;
                y = entity.field_70163_u - this.field_76990_c.field_78731_m;
                z = entity.field_70161_v - this.field_76990_c.field_78728_n;
                this.func_180548_c(entity);
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)x, (double)y, (double)z);
                GlStateManager.func_179114_b((float)(-entity.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(entity.field_70125_A - 180.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(5.0f * (float)entity.getIndex()), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
                this.model.func_78088_a(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                GlStateManager.func_179121_F();
            }
        }

        protected ResourceLocation getEntityTexture(WoodSegment entity) {
            return this.texture;
        }
    }

    public static abstract class WoodSegment
    extends Entity {
        private static final DataParameter<Integer> PARENT_ID = EntityDataManager.func_187226_a(WoodSegment.class, (DataSerializer)DataSerializers.field_187192_b);
        private static final DataParameter<Float> OFFSET_X = EntityDataManager.func_187226_a(WoodSegment.class, (DataSerializer)DataSerializers.field_187193_c);
        private static final DataParameter<Float> OFFSET_Y = EntityDataManager.func_187226_a(WoodSegment.class, (DataSerializer)DataSerializers.field_187193_c);
        private static final DataParameter<Float> OFFSET_Z = EntityDataManager.func_187226_a(WoodSegment.class, (DataSerializer)DataSerializers.field_187193_c);
        private static final DataParameter<Float> OFFSET_YAW = EntityDataManager.func_187226_a(WoodSegment.class, (DataSerializer)DataSerializers.field_187193_c);
        private static final DataParameter<Float> OFFSET_PITCH = EntityDataManager.func_187226_a(WoodSegment.class, (DataSerializer)DataSerializers.field_187193_c);
        private static final DataParameter<Integer> SEG_IDX = EntityDataManager.func_187226_a(WoodSegment.class, (DataSerializer)DataSerializers.field_187192_b);
        private double lastX;
        private double lastY;
        private double lastZ;

        public WoodSegment(World worldIn) {
            super(worldIn);
            this.func_70105_a(0.5f, 0.5f);
        }

        public WoodSegment(WoodSegment segment, float yawOffset, float pitchOffset) {
            this(segment, 0.0, 0.75 * (double)segment.field_70131_O, 0.0, yawOffset, pitchOffset);
        }

        public WoodSegment(WoodSegment segment, double offsetX, double offsetY, double offsetZ, float yawOffset, float pitchOffset) {
            this(segment.field_70170_p);
            ProcedureUtils.Vec2f vec2f = segment.getOffsetRotation();
            Vec3d vec = new Vec3d(offsetX, offsetY, offsetZ).func_178789_a(-vec2f.y * ((float)Math.PI / 180)).func_178785_b(-vec2f.x * ((float)Math.PI / 180)).func_178787_e(segment.getOffsetPosition());
            this.setOffset(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, vec2f.x + yawOffset, vec2f.y + pitchOffset);
            this.setParent(segment.getParent());
            this.setPositionAndRotationFromParent(1.0f);
            this.setIndex(segment.getIndex() + 1);
        }

        protected void func_70088_a() {
            this.func_184212_Q().func_187214_a(PARENT_ID, (Object)-1);
            this.func_184212_Q().func_187214_a(OFFSET_X, (Object)Float.valueOf(0.0f));
            this.func_184212_Q().func_187214_a(OFFSET_Y, (Object)Float.valueOf(0.0f));
            this.func_184212_Q().func_187214_a(OFFSET_Z, (Object)Float.valueOf(0.0f));
            this.func_184212_Q().func_187214_a(OFFSET_YAW, (Object)Float.valueOf(0.0f));
            this.func_184212_Q().func_187214_a(OFFSET_PITCH, (Object)Float.valueOf(0.0f));
            this.func_184212_Q().func_187214_a(SEG_IDX, (Object)0);
        }

        protected void setParent(Entity entity) {
            this.func_184212_Q().func_187227_b(PARENT_ID, (Object)entity.func_145782_y());
        }

        @Nullable
        protected Entity getParent() {
            return this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(PARENT_ID)).intValue());
        }

        protected void setOffset(double x, double y, double z, float yaw, float pitch) {
            this.func_184212_Q().func_187227_b(OFFSET_X, (Object)Float.valueOf((float)x));
            this.func_184212_Q().func_187227_b(OFFSET_Y, (Object)Float.valueOf((float)y));
            this.func_184212_Q().func_187227_b(OFFSET_Z, (Object)Float.valueOf((float)z));
            this.func_184212_Q().func_187227_b(OFFSET_YAW, (Object)Float.valueOf(yaw));
            this.func_184212_Q().func_187227_b(OFFSET_PITCH, (Object)Float.valueOf(pitch));
        }

        protected Vec3d getOffsetPosition() {
            return new Vec3d((double)((Float)this.field_70180_af.func_187225_a(OFFSET_X)).floatValue(), (double)((Float)this.field_70180_af.func_187225_a(OFFSET_Y)).floatValue(), (double)((Float)this.field_70180_af.func_187225_a(OFFSET_Z)).floatValue());
        }

        protected ProcedureUtils.Vec2f getOffsetRotation() {
            return new ProcedureUtils.Vec2f(((Float)this.field_70180_af.func_187225_a(OFFSET_YAW)).floatValue(), ((Float)this.field_70180_af.func_187225_a(OFFSET_PITCH)).floatValue());
        }

        protected void setIndex(int i) {
            this.func_184212_Q().func_187227_b(SEG_IDX, (Object)i);
        }

        @Nullable
        protected int getIndex() {
            return (Integer)this.func_184212_Q().func_187225_a(SEG_IDX);
        }

        protected void setPositionAndRotationFromParent(float partialTicks) {
            Entity parent = this.getParent();
            if (parent != null) {
                float yaw = parent.field_70126_B + MathHelper.func_76142_g((float)(parent.field_70177_z - parent.field_70126_B)) * partialTicks;
                double x = parent.field_70142_S + (parent.field_70165_t - parent.field_70142_S) * (double)partialTicks;
                double y = parent.field_70137_T + (parent.field_70163_u - parent.field_70137_T) * (double)partialTicks;
                double z = parent.field_70136_U + (parent.field_70161_v - parent.field_70136_U) * (double)partialTicks;
                Vec3d vec = this.getOffsetPosition().func_178785_b(-yaw * ((float)Math.PI / 180)).func_72441_c(x, y, z);
                ProcedureUtils.Vec2f vec2f = this.getOffsetRotation();
                this.field_70177_z = yaw + vec2f.x;
                this.field_70125_A = vec2f.y;
                this.func_70107_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                if (this.field_70170_p.field_72995_K && (this.field_70169_q != this.field_70165_t || this.field_70167_r != this.field_70163_u || this.field_70166_s != this.field_70161_v || this.field_70126_B != this.field_70177_z || this.field_70127_C != this.field_70125_A)) {
                    ProcedureSync.EntityPositionAndRotation.sendToServer(this);
                    this.field_70169_q = this.field_70165_t;
                    this.field_70167_r = this.field_70163_u;
                    this.field_70166_s = this.field_70161_v;
                    this.field_70126_B = this.field_70177_z;
                    this.field_70127_C = this.field_70125_A;
                }
            }
        }

        public void func_70071_h_() {
            BlockPos blockpos = new BlockPos((Entity)this);
            IBlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
            if (blockstate.func_185913_b() && (this.field_70173_aa == 1 || this.field_70165_t != this.lastX || this.field_70161_v != this.lastZ)) {
                for (int i = 0; i < 6; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, this.field_70146_Z.nextDouble() + (double)blockpos.func_177958_n(), this.field_70146_Z.nextDouble() + (double)blockpos.func_177956_o(), this.field_70146_Z.nextDouble() + (double)blockpos.func_177952_p(), 0.15, 0.15, 0.15, new int[]{Block.func_149682_b((Block)blockstate.func_177230_c())});
                }
            }
            this.lastX = this.field_70165_t;
            this.lastY = this.field_70163_u;
            this.lastZ = this.field_70161_v;
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }
    }

    public static class JutsuHouse
    implements ItemJutsu.IJutsuCallback {
        @Override
        public boolean createJutsu(ItemStack itemstack, EntityLivingBase entity, float power) {
            World world = entity.field_70170_p;
            if (!ForgeEventFactory.getMobGriefingEvent((World)world, (Entity)entity)) {
                return false;
            }
            RayTraceResult rtr = ProcedureUtils.objectEntityLookingAt((Entity)entity, 30.0, false);
            if (rtr.field_72313_a == RayTraceResult.Type.BLOCK && rtr.field_178784_b == EnumFacing.UP && ItemCustom.canSpawnStructureHere(world, rtr.func_178782_a()) && !world.field_72995_K) {
                Template template = ((WorldServer)world).func_184163_y().func_186237_a(world.func_73046_m(), new ResourceLocation("narutomod", "wood_house_2"));
                if (template != null) {
                    Rotation rotation;
                    BlockPos spos;
                    BlockPos spawnTo;
                    world.func_184133_a(null, rtr.func_178782_a(), (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:woodspawn")), SoundCategory.BLOCKS, 2.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
                    float yaw = MathHelper.func_76142_g((float)entity.field_70177_z);
                    if (yaw >= 135.0f || yaw < -135.0f) {
                        spos = spawnTo = rtr.func_178782_a().func_177982_a(-8, 1, -16);
                        rotation = Rotation.NONE;
                    } else if (yaw >= -45.0f && yaw < 45.0f) {
                        spawnTo = rtr.func_178782_a().func_177982_a(8, 1, 16);
                        spos = spawnTo.func_177982_a(-template.func_186259_a().func_177958_n(), 0, -template.func_186259_a().func_177952_p());
                        rotation = Rotation.CLOCKWISE_180;
                    } else if (yaw >= 45.0f && yaw < 135.0f) {
                        spawnTo = rtr.func_178782_a().func_177982_a(-16, 1, 8);
                        spos = spawnTo.func_177982_a(0, 0, -template.func_186259_a().func_177958_n());
                        rotation = Rotation.COUNTERCLOCKWISE_90;
                    } else {
                        spawnTo = rtr.func_178782_a().func_177982_a(16, 1, -8);
                        spos = spawnTo.func_177982_a(-template.func_186259_a().func_177952_p(), 0, 0);
                        rotation = Rotation.CLOCKWISE_90;
                    }
                    IBlockState iblockstate = world.func_180495_p(spawnTo);
                    world.func_184138_a(spawnTo, iblockstate, iblockstate, 3);
                    PlacementSettings placementsetting = new PlacementSettings().func_186220_a(rotation).func_186214_a(Mirror.NONE).func_186218_a(null).func_186225_a(null).func_186226_b(false).func_186222_a(false);
                    for (BlockPos pos : BlockPos.func_177975_b((BlockPos)spos, (BlockPos)spos.func_177971_a((Vec3i)template.func_186257_a(rotation)))) {
                        ((WorldServer)world).func_175739_a(EnumParticleTypes.BLOCK_DUST, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 6, 0.0, 0.0, 0.0, 0.2, new int[]{Block.func_149682_b((Block)Blocks.field_180407_aO)});
                    }
                    template.func_186260_a(world, spawnTo, placementsetting);
                }
                return true;
            }
            return false;
        }
    }

    public static class ItemCustom
    extends ItemJutsu.Base {
        public ItemCustom(ItemJutsu.JutsuEnum ... list) {
            super(ItemJutsu.JutsuEnum.Type.MOKUTON, list);
            this.func_77655_b("mokuton");
            this.setRegistryName("mokuton");
            this.func_77637_a(TabModTab.tab);
            this.defaultCooldownMap[ItemMokuton.WOODBURIAL.index] = 0L;
            this.defaultCooldownMap[ItemMokuton.WOODPRISON.index] = 0L;
            this.defaultCooldownMap[ItemMokuton.WOODHOUSE.index] = 0L;
            this.defaultCooldownMap[ItemMokuton.GOLEM.index] = 0L;
            this.defaultCooldownMap[ItemMokuton.ARMATTACK.index] = 0L;
        }

        @Override
        protected float getPower(ItemStack stack, EntityLivingBase entity, int timeLeft) {
            if (this.getCurrentJutsu(stack) == WOODPRISON) {
                return this.getPower(stack, entity, timeLeft, 1.0f, 50.0f);
            }
            return 1.0f;
        }

        @Override
        protected float getMaxPower(ItemStack stack, EntityLivingBase entity) {
            float ret = super.getMaxPower(stack, entity);
            ItemJutsu.JutsuEnum jutsu = this.getCurrentJutsu(stack);
            return jutsu == WOODPRISON ? Math.min(ret, 40.0f) : ret;
        }

        private static boolean canSpawnStructureHere(World world, BlockPos pos) {
            return world.func_180495_p(pos).func_185904_a() == Material.field_151578_c || world.func_180495_p(pos).func_185904_a() == Material.field_151595_p || world.func_180495_p(pos).func_185904_a() == Material.field_151577_b || world.func_180495_p(pos).func_185904_a() == Material.field_151576_e;
        }

        @Override
        public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
            super.func_77663_a(itemstack, world, entity, par4, par5);
            if (entity instanceof EntityPlayer && !world.field_72995_K && entity.field_70173_aa % 20 == 6) {
                ((EntityPlayer)entity).func_71024_bL().func_75122_a(20, 0.02f);
            }
        }
    }
}

