/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.Particles;
import net.narutomod.creativetab.TabModTab;
import net.narutomod.entity.EntityRendererRegister;
import net.narutomod.entity.EntityScalableProjectile;
import net.narutomod.event.EventSphericalExplosion;
import net.narutomod.item.ItemFuton;
import net.narutomod.item.ItemJutsu;
import net.narutomod.item.ItemKaton;
import net.narutomod.procedure.ProcedureAoeCommand;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class ItemShakuton
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:shakuton")
    public static final Item block = null;
    public static final int ENTITYID = 269;
    public static final ItemJutsu.JutsuEnum ORB = new ItemJutsu.JutsuEnum(0, "scorchorb", 'S', 150, 100.0, new EntityScorchBall.Jutsu());
    public static final ItemJutsu.JutsuEnum SHOOT = new ItemJutsu.JutsuEnum(1, "tooltip.shakuton.scorchkill", 'S', 200, 50.0, new SetOrbTarget());
    public static final ItemJutsu.JutsuEnum BLAST = new ItemJutsu.JutsuEnum(2, "tooltip.shakuton.scorchblast", 'S', 250, 50.0, new SuperSteamBlast());

    public ItemShakuton(ElementsNarutomodMod instance) {
        super(instance, 589);
    }

    @Override
    public void initElements() {
        this.elements.items.add(() -> new RangedItem(ORB, SHOOT, BLAST));
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityScorchBall.class).id(new ResourceLocation("narutomod", "scorchorb"), 269).name("scorchorb").tracker(64, 1, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)block, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:shakuton", "inventory"));
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        new Renderer().register();
    }

    public static class Renderer
    extends EntityRendererRegister {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void register() {
            RenderingRegistry.registerEntityRenderingHandler(EntityScorchBall.class, renderManager -> new RenderCustom(renderManager));
        }

        @SideOnly(value=Side.CLIENT)
        public class RenderCustom
        extends Render<EntityScorchBall> {
            private final ResourceLocation texture;

            public RenderCustom(RenderManager renderManager) {
                super(renderManager);
                this.texture = new ResourceLocation("narutomod:textures/fireball2.png");
                this.field_76989_e = 0.1f;
            }

            public void doRender(EntityScorchBall entity, double x, double y, double z, float entityYaw, float partialTicks) {
                GlStateManager.func_179094_E();
                this.func_180548_c(entity);
                float scale = entity.getEntityScale();
                GlStateManager.func_179137_b((double)x, (double)(y + 0.5 * (double)scale), (double)z);
                GlStateManager.func_179091_B();
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                GlStateManager.func_179114_b((float)(180.0f - this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)(this.field_76990_c.field_78733_k.field_74320_O == 2 ? -1 : 1) * -this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(9.0f * (partialTicks + (float)entity.field_70173_aa)), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179140_f();
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181710_j);
                bufferbuilder.func_181662_b(-0.5, -0.5, 0.0).func_187315_a(0.0, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b(0.5, -0.5, 0.0).func_187315_a(1.0, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b(0.5, 0.5, 0.0).func_187315_a(1.0, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_181662_b(-0.5, 0.5, 0.0).func_187315_a(0.0, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179145_e();
                GlStateManager.func_179101_C();
                GlStateManager.func_179121_F();
            }

            protected ResourceLocation getEntityTexture(EntityScorchBall entity) {
                return this.texture;
            }
        }
    }

    public static class SuperSteamBlast
    implements ItemJutsu.IJutsuCallback {
        @Override
        public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
            int j = ((RangedItem)block).getTotalBalls(stack);
            for (int i = 0; i < j; ++i) {
                EntityScorchBall entity1 = ((RangedItem)block).get1stBallAndPutLast(entity.field_70170_p, stack);
                if (entity1 == null) continue;
                entity1.setMaxScale(i == 0 ? 0.5f * (float)j : 0.0f);
            }
            ((RangedItem)block).clearBalls(stack);
            return j > 0;
        }
    }

    public static class EntityScorchBall
    extends EntityScalableProjectile.Base {
        private double idleHeight;
        private Entity target;
        private final float inititalScale = 0.5f;
        private float maxScale = 0.5f;
        private int targetTime = -1;

        public EntityScorchBall(World a) {
            super(a);
            this.setOGSize(1.0f, 1.0f);
        }

        public EntityScorchBall(EntityLivingBase shooter) {
            super(shooter);
            this.setOGSize(1.0f, 1.0f);
            this.setEntityScale(this.inititalScale);
            this.func_70107_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.field_70131_O, shooter.field_70161_v);
            this.idleHeight = shooter.func_70047_e();
        }

        private Vec3d getIdlePosition() {
            if (this.shootingEntity != null) {
                Vec3d vec = Vec3d.func_189986_a((float)0.0f, (float)(this.field_70173_aa * 9)).func_72441_c(0.0, this.idleHeight, 0.0);
                return this.shootingEntity.func_174791_d().func_178787_e(vec);
            }
            return this.func_174791_d();
        }

        public void setNextPosition(Vec3d vec) {
            if (this.func_70011_f(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c) > 0.5 && this.targetTime >= 0) {
                this.setVelocity(vec.func_178788_d(this.func_174791_d()).func_72432_b().func_186678_a(0.6));
            } else {
                this.setVelocity(vec.func_178788_d(this.func_174791_d()));
                if (vec.equals((Object)this.getIdlePosition()) && this.targetTime >= 0) {
                    this.setTarget(null);
                }
            }
        }

        protected void setTarget(@Nullable Entity targetIn) {
            this.target = targetIn;
            this.targetTime = targetIn != null ? 100 : -1;
        }

        protected void setMaxScale(float scale) {
            this.maxScale = scale;
        }

        private void moveGrowAndShoot() {
            if (this.shootingEntity != null) {
                Vec3d vec = this.shootingEntity.func_174791_d().func_72441_c(0.0, (double)(this.shootingEntity.field_70131_O + 1.5f), 0.0);
                if (this.func_70011_f(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c) > 0.2) {
                    this.setVelocity(vec.func_178788_d(this.func_174791_d()).func_72432_b().func_186678_a(0.1));
                } else if (this.maxScale > 0.0f) {
                    this.setVelocity(Vec3d.field_186680_a);
                    float scale = this.getEntityScale();
                    if (scale < this.maxScale) {
                        this.setEntityScale(scale * 1.03f);
                    } else {
                        Vec3d vec2 = this.shootingEntity.func_70040_Z();
                        this.func_70186_c(vec2.field_72450_a, vec2.field_72448_b, vec2.field_72449_c, 0.95f, 0.0f);
                    }
                } else {
                    this.func_70106_y();
                }
            }
        }

        private void setVelocity(Vec3d vec) {
            this.field_70159_w = vec.field_72450_a;
            this.field_70181_x = vec.field_72448_b;
            this.field_70179_y = vec.field_72449_c;
            this.field_70160_al = true;
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            if (!this.isLaunched()) {
                if (this.maxScale != this.getEntityScale()) {
                    this.moveGrowAndShoot();
                } else if (this.target != null && this.targetTime > 0) {
                    if (this.target.func_70089_S()) {
                        this.setNextPosition(this.target.func_174824_e(1.0f));
                        --this.targetTime;
                    } else {
                        this.targetTime = 0;
                    }
                } else {
                    this.setNextPosition(this.getIdlePosition());
                }
                if (!this.field_70170_p.field_72995_K) {
                    for (EntityLivingBase entity : this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ())) {
                        if (entity.equals((Object)this.shootingEntity) || entity.equals((Object)this)) continue;
                        entity.field_70172_ad = 10;
                        entity.getEntityData().func_74757_a("TempData_disableKnockback", true);
                        entity.func_70097_a(ItemJutsu.causeJutsuDamage(this, this.shootingEntity), 1.5f);
                        this.scorchEffects(entity.field_70165_t, entity.field_70163_u + (double)(entity.field_70131_O / 2.0f), entity.field_70161_v, entity.field_70130_N / 2.0f, entity.field_70131_O / 2.0f);
                    }
                }
            }
            if (!this.field_70170_p.field_72995_K && (this.shootingEntity == null || this.shootingEntity.func_184614_ca().func_77973_b() != block && this.shootingEntity.func_184592_cb().func_77973_b() != block)) {
                this.func_70106_y();
            }
        }

        @Override
        protected void checkOnGround() {
            super.checkOnGround();
            if (this.field_70122_E) {
                this.field_70122_E = false;
                this.scorchEffects(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.4, 0.4);
                this.targetTime = 0;
            }
            if (this.func_70090_H()) {
                this.func_70106_y();
            }
        }

        @Override
        protected void onImpact(RayTraceResult result) {
            if (!this.field_70170_p.field_72995_K) {
                if (result.field_72308_g != null && result.field_72308_g.equals((Object)this.shootingEntity) || result.field_72313_a == RayTraceResult.Type.BLOCK && this.ticksInAir <= 15) {
                    return;
                }
                boolean flag = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this.shootingEntity);
                new EventSphericalExplosion(this.field_70170_p, (Entity)this.shootingEntity, (int)this.field_70165_t, (int)this.field_70163_u + 5, (int)this.field_70161_v, (int)this.maxScale, 0L, 0.3333f);
                ProcedureAoeCommand.set(this, 0.0, this.maxScale).damageEntitiesCentered(ItemJutsu.causeJutsuDamage(this, this.shootingEntity), this.maxScale * 60.0f);
                this.scorchEffects(this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.5 * (double)this.maxScale, 1.0);
                this.func_70106_y();
            }
        }

        @Override
        public void renderParticles() {
            if (this.field_70170_p.field_72995_K) {
                Particles.spawnParticle(this.field_70170_p, Particles.Types.SMOKE, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v, (int)(this.field_70130_N * 25.0f), (double)(this.field_70130_N / 2.0f), 0.0, (double)(this.field_70130_N / 2.0f), 0.0, 0.0, 0.0, 1090473603, 10, 0, 240);
            }
        }

        private void scorchEffects(double x, double y, double z, double dx, double dy) {
            this.func_184185_a(SoundEvents.field_187646_bt, 1.0f, this.field_70146_Z.nextFloat() * 0.6f + 0.7f);
            Particles.spawnParticle(this.field_70170_p, Particles.Types.SMOKE, x, y, z, (int)(dx * dy * 100.0), dx, dy, dx, 0.0, 0.0, 0.0, 0x40FFFFFF, 15);
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                if (((RangedItem)block).getTotalBalls(stack) < 20) {
                    EntityScorchBall entity1 = new EntityScorchBall(entity);
                    entity.field_70170_p.func_72838_d((Entity)entity1);
                    ((RangedItem)block).saveSpawnedBall(stack, entity1);
                    return true;
                }
                return false;
            }
        }
    }

    public static class SetOrbTarget
    implements ItemJutsu.IJutsuCallback {
        @Override
        public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
            RayTraceResult res;
            EntityScorchBall entity1 = ((RangedItem)block).get1stBallAndPutLast(entity.field_70170_p, stack);
            if (entity1 != null && entity1.func_70089_S() && (res = ProcedureUtils.objectEntityLookingAt((Entity)entity, 30.0, 1.5, EntityScorchBall.class)) != null && res.field_72308_g != null) {
                entity1.setTarget(res.field_72308_g);
                return true;
            }
            return false;
        }
    }

    public static class RangedItem
    extends ItemJutsu.Base {
        protected static final String spawnedBalls = "SpawnedBallsId";

        public RangedItem(ItemJutsu.JutsuEnum ... list) {
            super(ItemJutsu.JutsuEnum.Type.SHAKUTON, list);
            this.func_77655_b("shakuton");
            this.setRegistryName("shakuton");
            this.func_77637_a(TabModTab.tab);
            this.defaultCooldownMap[ItemShakuton.ORB.index] = 0L;
            this.defaultCooldownMap[ItemShakuton.SHOOT.index] = 0L;
            this.defaultCooldownMap[ItemShakuton.BLAST.index] = 0L;
        }

        @Override
        protected float getPower(ItemStack stack, EntityLivingBase entity, int timeLeft) {
            return 1.0f;
        }

        protected void saveSpawnedBall(ItemStack stack, Entity entity) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            int[] oldarray = stack.func_77978_p().func_74759_k(spawnedBalls);
            int[] newarray = new int[oldarray.length + 1];
            System.arraycopy(oldarray, 0, newarray, 0, oldarray.length);
            newarray[oldarray.length] = entity.func_145782_y();
            stack.func_77978_p().func_74783_a(spawnedBalls, newarray);
        }

        @Nullable
        protected EntityScorchBall get1stBallAndPutLast(World world, ItemStack stack) {
            Entity entity;
            int[] balls;
            if (stack.func_77942_o() && (balls = stack.func_77978_p().func_74759_k(spawnedBalls)).length > 0 && (entity = world.func_73045_a(balls[0])) instanceof EntityScorchBall) {
                if (balls.length > 1) {
                    System.arraycopy(balls, 1, balls, 0, balls.length - 1);
                    balls[balls.length - 1] = entity.func_145782_y();
                }
                if (entity.func_70089_S()) {
                    return (EntityScorchBall)entity;
                }
            }
            return null;
        }

        protected int getTotalBalls(ItemStack stack) {
            return stack.func_77942_o() ? stack.func_77978_p().func_74759_k(spawnedBalls).length : 0;
        }

        protected void clearBalls(ItemStack stack) {
            stack.func_77978_p().func_82580_o(spawnedBalls);
        }

        @Override
        public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
            EntityLivingBase livingEntity;
            super.func_77663_a(itemstack, world, entity, par4, par5);
            if (entity instanceof EntityLivingBase && !(livingEntity = (EntityLivingBase)entity).func_184614_ca().equals(itemstack) && !livingEntity.func_184592_cb().equals(itemstack)) {
                this.clearBalls(itemstack);
            }
        }

        @Override
        public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entity, EnumHand hand) {
            if (entity.func_184812_l_() || ProcedureUtils.hasItemInInventory(entity, ItemFuton.block) && ProcedureUtils.hasItemInInventory(entity, ItemKaton.block)) {
                return super.func_77659_a(world, entity, hand);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)entity.func_184586_b(hand));
        }

        @Override
        public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
            super.func_77624_a(itemstack, world, list, flag);
            list.add(TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.shakuton.musthave") + TextFormatting.RESET);
        }
    }
}

