/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.creativetab.TabModTab;
import net.narutomod.item.ItemDojutsu;
import net.narutomod.item.ItemJutsu;
import net.narutomod.item.ItemMangekyoSharinganEternal;
import net.narutomod.procedure.ProcedureOnLivingUpdate;
import net.narutomod.procedure.ProcedureSharinganHelmetTickEvent;
import net.narutomod.procedure.ProcedureSync;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class ItemSharingan
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:sharinganhelmet")
    public static final Item helmet = null;

    public ItemSharingan(ElementsNarutomodMod instance) {
        super(instance, 56);
    }

    public static boolean hasAny(EntityPlayer player) {
        return ProcedureUtils.hasAnyItemOfSubtype(player, Base.class);
    }

    public static boolean wearingAny(EntityLivingBase entity) {
        return entity.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() instanceof Base;
    }

    public static boolean isBlinded(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_74767_n("sharingan_blinded") : false;
    }

    public static boolean isBlinded(EntityPlayer entity) {
        if (entity.func_184812_l_()) {
            return false;
        }
        int i = 0;
        List<ItemStack> list = ProcedureUtils.getAllItemsOfSubType(entity, ItemDojutsu.Base.class);
        for (ItemStack stack : list) {
            if (!ItemSharingan.isBlinded(stack)) continue;
            ++i;
        }
        return !list.isEmpty() && i == list.size();
    }

    @Override
    public void initElements() {
        ItemArmor.ArmorMaterial enuma = EnumHelper.addArmorMaterial((String)"SHARINGAN", (String)"narutomod:sharingan_", (int)1024, (int[])new int[]{2, 5, 6, 10}, (int)0, null, (float)0.0f);
        this.elements.items.add(() -> ((Item)new Base(enuma){

            public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
                return "narutomod:textures/sharinganhelmet.png";
            }
        }.func_77655_b("sharinganhelmet").setRegistryName("sharinganhelmet")).func_77637_a(TabModTab.tab));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)helmet, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:sharinganhelmet", "inventory"));
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new PlayerHook());
    }

    public class PlayerHook {
        @SubscribeEvent
        public void onAttacked(LivingAttackEvent event) {
            EntityLivingBase entity = event.getEntityLiving();
            Entity attacker = event.getSource().func_76346_g();
            if (ItemSharingan.wearingAny(entity) && ItemJutsu.canTarget((Entity)entity) && !entity.func_184218_aH() && attacker instanceof EntityLivingBase && !attacker.field_70170_p.field_72995_K) {
                if (entity.func_70681_au().nextFloat() < 0.5f) {
                    List<BlockPos> list = ProcedureUtils.getAllAirBlocks(entity.field_70170_p, entity.func_174813_aQ().func_186662_g(2.5));
                    for (int i = 0; i < list.size(); ++i) {
                        BlockPos pos = list.get(entity.func_70681_au().nextInt(list.size()));
                        Material material = entity.field_70170_p.func_180495_p(pos.func_177977_b()).func_185904_a();
                        if (!material.func_76220_a()) {
                            if (material != Material.field_151586_h) continue;
                        }
                        if (!(attacker.func_174831_c(pos) > 6.25) || !ProcedureUtils.isSpaceOpenToStandOn(entity, pos)) continue;
                        event.setCanceled(true);
                        entity.func_70634_a(0.5 + (double)pos.func_177958_n(), (double)pos.func_177956_o(), 0.5 + (double)pos.func_177952_p());
                        break;
                    }
                }
                if (entity instanceof EntityPlayer) {
                    this.lockOnTarget(entity, (EntityLivingBase)attacker, 300);
                }
            }
        }

        @SubscribeEvent
        public void onPlayerTick(TickEvent.PlayerTickEvent event) {
            EntityPlayer entity = event.player;
            if (event.phase == TickEvent.Phase.END && this.hasTargetLockOnEntity((EntityLivingBase)entity)) {
                int remaining = this.targetLockTicksRemaining((EntityLivingBase)entity);
                EntityLivingBase target = this.getLockedTarget((EntityLivingBase)entity);
                if (!(entity.field_70170_p.field_72995_K || remaining > 0 && target != null && target.func_70089_S() && !(target.func_70068_e((Entity)entity) > 1024.0))) {
                    this.unlockOnTarget((EntityLivingBase)entity);
                } else if (target != null) {
                    if (entity.field_70170_p.field_72995_K) {
                        ProcedureOnLivingUpdate.setGlowingFor((Entity)target, 3);
                    }
                    if (entity.getEntityData().func_74767_n("shouldTargetLockOnEntity")) {
                        Vec3d vec2 = target.func_174824_e(1.0f).func_178788_d(entity.func_174824_e(1.0f));
                        entity.field_70177_z = ProcedureUtils.getYawFromVec(vec2);
                        entity.field_70125_A = ProcedureUtils.getPitchFromVec(vec2);
                    }
                    this.lockOnTarget((EntityLivingBase)entity, target, remaining - 1);
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onMouseEvent(MouseEvent event) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (FMLClientHandler.instance().isGUIOpen(GuiChat.class) || player == null) {
                return;
            }
            if (event.getButton() == 1 && this.hasTargetLockOnEntity((EntityLivingBase)player)) {
                boolean flag = !event.isButtonstate();
                player.getEntityData().func_74757_a("shouldTargetLockOnEntity", !flag);
                ProcedureSync.EntityNBTTag.sendToServer((Entity)player, "shouldTargetLockOnEntity", !flag);
            }
        }

        @SubscribeEvent
        public void onEntitySpawn(EntityJoinWorldEvent event) {
            if (event.getEntity() instanceof EntityPlayerMP) {
                this.unlockOnTarget((EntityLivingBase)event.getEntity());
            }
        }

        private void lockOnTarget(EntityLivingBase entity, EntityLivingBase target, int ticks) {
            if (!entity.field_70170_p.field_72995_K) {
                entity.getEntityData().func_74768_a("targetLockOnEntityId", target.func_145782_y());
                entity.getEntityData().func_74768_a("targetLockOnEntityTicksRemaining", ticks);
                if (entity instanceof EntityPlayerMP) {
                    ProcedureSync.EntityNBTTag.sendToSelf((EntityPlayerMP)entity, "targetLockOnEntityId", target.func_145782_y());
                }
            }
        }

        private void unlockOnTarget(EntityLivingBase entity) {
            if (!entity.field_70170_p.field_72995_K) {
                entity.getEntityData().func_82580_o("targetLockOnEntityId");
                entity.getEntityData().func_82580_o("targetLockOnEntityTicksRemaining");
                entity.getEntityData().func_82580_o("shouldTargetLockOnEntity");
                if (entity instanceof EntityPlayerMP) {
                    ProcedureSync.EntityNBTTag.sendToSelf((EntityPlayerMP)entity, "targetLockOnEntityId");
                    ProcedureSync.EntityNBTTag.sendToSelf((EntityPlayerMP)entity, "shouldTargetLockOnEntity");
                }
            }
        }

        private boolean hasTargetLockOnEntity(EntityLivingBase entity) {
            return entity.getEntityData().func_74764_b("targetLockOnEntityId");
        }

        @Nullable
        private EntityLivingBase getLockedTarget(EntityLivingBase entity) {
            Entity target = entity.field_70170_p.func_73045_a(entity.getEntityData().func_74762_e("targetLockOnEntityId"));
            return target instanceof EntityLivingBase ? (EntityLivingBase)target : null;
        }

        private int targetLockTicksRemaining(EntityLivingBase entity) {
            return entity.getEntityData().func_74762_e("targetLockOnEntityTicksRemaining");
        }
    }

    public static class Base
    extends ItemDojutsu.Base {
        private boolean canDamage;

        public Base(ItemArmor.ArmorMaterial material) {
            super(material);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public ModelBiped getArmorModel(EntityLivingBase living, ItemStack stack, EntityEquipmentSlot slot, ModelBiped defaultModel) {
            ItemDojutsu.ClientModel.ModelHelmetSnug armorModel = (ItemDojutsu.ClientModel.ModelHelmetSnug)super.getArmorModel(living, stack, slot, defaultModel);
            armorModel.highlightHide = ItemSharingan.isBlinded(stack);
            return armorModel;
        }

        @Override
        public void onArmorTick(World world, EntityPlayer entity, ItemStack itemstack) {
            super.onArmorTick(world, entity, itemstack);
            int x = (int)entity.field_70165_t;
            int y = (int)entity.field_70163_u;
            int z = (int)entity.field_70161_v;
            HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
            $_dependencies.put("entity", entity);
            $_dependencies.put("x", x);
            $_dependencies.put("y", y);
            $_dependencies.put("z", z);
            $_dependencies.put("itemstack", itemstack);
            $_dependencies.put("world", world);
            ProcedureSharinganHelmetTickEvent.executeProcedure($_dependencies);
            if (!(world.field_72995_K || entity.field_70173_aa % 6 != 1 || itemstack.func_77973_b() == ItemMangekyoSharinganEternal.helmet && this.isOwner(itemstack, (EntityLivingBase)entity) || !entity.getEntityData().func_74767_n("amaterasu_active") && !entity.getEntityData().func_74767_n("susanoo_activated") && !entity.getEntityData().func_74767_n("kamui_teleport"))) {
                ((Base)itemstack.func_77973_b()).canDamage = true;
                itemstack.func_77972_a(this.isOwner(itemstack, (EntityLivingBase)entity) ? 3 : 9, (EntityLivingBase)entity);
                ((Base)itemstack.func_77973_b()).canDamage = false;
            }
        }

        public void setDamage(ItemStack stack, int damage) {
            if (this.canDamage) {
                super.setDamage(stack, damage);
            }
        }

        public void forceDamage(ItemStack stack, int damage) {
            super.setDamage(stack, damage);
        }

        public int getDamage(ItemStack stack) {
            int itemDamage = this.getMetadata(stack);
            if (itemDamage > this.func_77612_l()) {
                itemDamage = this.func_77612_l();
            }
            return itemDamage;
        }

        @Override
        public void setOwner(ItemStack stack, EntityLivingBase entityIn) {
            super.setOwner(stack, entityIn);
            this.func_82813_b(stack, 1 + entityIn.func_70681_au().nextInt(0xFFFFFF) | 0x20000000);
        }

        @Override
        public void copyOwner(ItemStack toStack, ItemStack fromStack) {
            super.copyOwner(toStack, fromStack);
            if (toStack.func_77973_b() instanceof Base && fromStack.func_77973_b() instanceof Base) {
                this.func_82813_b(toStack, ((Base)fromStack.func_77973_b()).func_82814_b(fromStack));
            }
        }

        public void func_82813_b(ItemStack stack, int color) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74768_a("color", color);
        }

        public int func_82814_b(ItemStack stack) {
            return stack.func_77942_o() ? stack.func_77978_p().func_74762_e("color") : 0;
        }

        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, tooltip, flagIn);
            tooltip.add(TextFormatting.DARK_GRAY + I18n.func_74838_a((String)"tooltip.sharingan.descr") + TextFormatting.WHITE);
        }
    }
}

