/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.creativetab.TabModTab;
import net.narutomod.entity.EntityFingerBone;
import net.narutomod.entity.EntitySpike;
import net.narutomod.item.ItemBoneArmor;
import net.narutomod.item.ItemBoneDrill;
import net.narutomod.item.ItemBoneSword;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class ItemShikotsumyaku
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:shikotsumyaku")
    public static final Item block = null;
    public static final int ENTITYID = 318;
    public static final ItemJutsu.JutsuEnum LARCH = new ItemJutsu.JutsuEnum(0, "tooltip.shikotsumyaku.dancelarch", 'S', 150, 100.0, new LarchDance());
    public static final ItemJutsu.JutsuEnum WILLOW = new ItemJutsu.JutsuEnum(1, "tooltip.shikotsumyaku.dancewillow", 'S', 150, 100.0, new WillowDance());
    public static final ItemJutsu.JutsuEnum CAMELLIA = new ItemJutsu.JutsuEnum(2, "tooltip.shikotsumyaku.dancecamellia", 'S', 150, 100.0, new CamelliaDance());
    public static final ItemJutsu.JutsuEnum BULLETS = new ItemJutsu.JutsuEnum(3, "finger_bone", 'S', 150, 5.0, new EntityFingerBone.EC.Jutsu());
    public static final ItemJutsu.JutsuEnum CFLOWER = new ItemJutsu.JutsuEnum(4, "tooltip.shikotsumyaku.danceclementisflower", 'S', 400, 500.0, new ClementisFlower());
    public static final ItemJutsu.JutsuEnum BRACKEN = new ItemJutsu.JutsuEnum(5, "entitybrackendance", 'S', 400, 20.0, new EntityBrackenDance.Jutsu());

    public ItemShikotsumyaku(ElementsNarutomodMod instance) {
        super(instance, 659);
    }

    @Override
    public void initElements() {
        this.elements.items.add(() -> new RangedItem(LARCH, WILLOW, CAMELLIA, BULLETS, CFLOWER, BRACKEN));
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityBrackenDance.class).id(new ResourceLocation("narutomod", "entitybrackendance"), 318).name("entitybrackendance").tracker(64, 1, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)block, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:shikotsumyaku", "inventory"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityBrackenDance.class, renderManager -> new EntitySpike.Renderer<EntityBrackenDance>(renderManager){

            @Override
            protected ResourceLocation getEntityTexture(EntityBrackenDance entity) {
                return new ResourceLocation("narutomod:textures/spike_bone.png");
            }
        });
    }

    public static class EntityBrackenDance
    extends EntitySpike.Base {
        private final int growTime = 8;
        private final float maxScale = 2.0f;
        private final float damage = 20.0f;

        public EntityBrackenDance(World worldIn) {
            super(worldIn);
            this.setColor(-1);
        }

        public EntityBrackenDance(EntityLivingBase userIn, float damageIn) {
            super(userIn, -1);
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            if (this.ticksAlive <= this.growTime) {
                float f = this.maxScale * (float)this.ticksAlive;
                ((Object)((Object)this)).getClass();
                this.setEntityScale(MathHelper.func_76131_a((float)(f / 8.0f), (float)0.0f, (float)this.maxScale));
                for (EntityLivingBase entity : this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(1.0, 0.0, 1.0))) {
                    if (entity.equals((Object)this.shootingEntity)) continue;
                    entity.field_70172_ad = 10;
                    DamageSource damageSource = ItemJutsu.causeJutsuDamage(this, this.shootingEntity);
                    float f2 = this.ticksAlive - 1;
                    ((Object)((Object)this)).getClass();
                    entity.func_70097_a(damageSource, this.damage * (1.0f - f2 / 8.0f));
                }
            }
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                Vec3d vec3d2;
                World world = entity.field_70170_p;
                Vec3d vec3d = entity.func_174824_e(1.0f);
                RayTraceResult res = world.func_147447_a(vec3d, vec3d2 = vec3d.func_178787_e(entity.func_70040_Z().func_186678_a(30.0)), false, true, true);
                if (res != null && res.field_72313_a == RayTraceResult.Type.BLOCK && res.field_178784_b == EnumFacing.UP) {
                    float f = MathHelper.func_76129_c((float)(power * 9.0f / 5.0f));
                    for (int i = 0; i < Math.round(power); ++i) {
                        EntityBrackenDance entity1 = new EntityBrackenDance(entity, power);
                        Vec3d vec = res.field_72307_f.func_72441_c((entity.func_70681_au().nextDouble() - 0.5) * (double)f, 0.0, (entity.func_70681_au().nextDouble() - 0.5) * (double)f);
                        while (!world.func_180495_p(new BlockPos(vec)).func_185896_q()) {
                            vec = vec.func_178786_a(0.0, 1.0, 0.0);
                        }
                        while (world.func_180495_p(new BlockPos(vec).func_177984_a()).func_185896_q()) {
                            vec = vec.func_72441_c(0.0, 1.0, 0.0);
                        }
                        entity1.func_70012_b(vec.field_72450_a, vec.field_72448_b + 0.5, vec.field_72449_c, entity.func_70681_au().nextFloat() * 360.0f, (entity.func_70681_au().nextFloat() - 0.5f) * 60.0f);
                        world.func_72838_d((Entity)entity1);
                        world.func_184148_a(null, entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:bonecrack")), SoundCategory.NEUTRAL, 5.0f, entity.func_70681_au().nextFloat() * 0.4f + 0.4f);
                    }
                    return true;
                }
                return false;
            }
        }
    }

    public static class ClementisFlower
    implements ItemJutsu.IJutsuCallback {
        @Override
        public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
            if (entity instanceof EntityPlayer) {
                if (!ProcedureUtils.hasItemInInventory((EntityPlayer)entity, ItemBoneDrill.block)) {
                    entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:bonecrack")), SoundCategory.PLAYERS, 1.0f, 1.0f);
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)((EntityPlayer)entity), (ItemStack)new ItemStack(ItemBoneDrill.block));
                    ItemJutsu.setCurrentJutsuCooldown(stack, (EntityLivingBase)((EntityPlayer)entity), 1200L);
                    return true;
                }
            } else if (entity.func_184614_ca().func_77973_b() != ItemBoneDrill.block) {
                entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:bonecrack")), SoundCategory.PLAYERS, 1.0f, 1.0f);
                entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ItemBoneDrill.block));
                return true;
            }
            return false;
        }
    }

    public static class CamelliaDance
    implements ItemJutsu.IJutsuCallback {
        @Override
        public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
            if (entity.func_184614_ca().func_77973_b() != ItemBoneSword.block) {
                entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:bonecrack")), SoundCategory.PLAYERS, 1.0f, 1.0f);
                ItemStack itemstack = new ItemStack(ItemBoneSword.block);
                if (entity instanceof EntityPlayer) {
                    ProcedureUtils.swapItemToSlot((EntityPlayer)entity, EntityEquipmentSlot.MAINHAND, itemstack);
                } else {
                    entity.func_184201_a(EntityEquipmentSlot.MAINHAND, itemstack);
                }
                return true;
            }
            return false;
        }
    }

    public static class WillowDance
    implements ItemJutsu.IJutsuCallback {
        @Override
        public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
            entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:bonecrack")), SoundCategory.PLAYERS, 1.0f, 1.0f);
            ItemStack cheststack = entity.func_184582_a(EntityEquipmentSlot.CHEST);
            if (!ItemBoneArmor.isWillowActive(cheststack)) {
                if (cheststack.func_77973_b() != ItemBoneArmor.body) {
                    cheststack = new ItemStack(ItemBoneArmor.body);
                    ItemBoneArmor.setWillowActive(cheststack, true);
                    if (entity instanceof EntityPlayer) {
                        ProcedureUtils.swapItemToSlot((EntityPlayer)entity, EntityEquipmentSlot.CHEST, cheststack);
                    } else {
                        entity.func_184201_a(EntityEquipmentSlot.CHEST, cheststack);
                    }
                } else {
                    ItemBoneArmor.setWillowActive(cheststack, true);
                }
                return true;
            }
            ItemBoneArmor.setWillowActive(cheststack, false);
            return false;
        }
    }

    public static class LarchDance
    implements ItemJutsu.IJutsuCallback {
        @Override
        public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
            entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:bonecrack")), SoundCategory.PLAYERS, 1.0f, 1.0f);
            ItemStack cheststack = entity.func_184582_a(EntityEquipmentSlot.CHEST);
            if (!ItemBoneArmor.isLarchActive(cheststack)) {
                if (cheststack.func_77973_b() != ItemBoneArmor.body) {
                    cheststack = new ItemStack(ItemBoneArmor.body);
                    ItemBoneArmor.setLarchActive(cheststack, true);
                    if (entity instanceof EntityPlayer) {
                        ProcedureUtils.swapItemToSlot((EntityPlayer)entity, EntityEquipmentSlot.CHEST, cheststack);
                    } else {
                        entity.func_184201_a(EntityEquipmentSlot.CHEST, cheststack);
                    }
                } else {
                    ItemBoneArmor.setLarchActive(cheststack, true);
                }
                return true;
            }
            ItemBoneArmor.setLarchActive(cheststack, false);
            return false;
        }
    }

    public static class RangedItem
    extends ItemJutsu.Base {
        public RangedItem(ItemJutsu.JutsuEnum ... list) {
            super(ItemJutsu.JutsuEnum.Type.SHIKOTSUMYAKU, list);
            this.func_77655_b("shikotsumyaku");
            this.setRegistryName("shikotsumyaku");
            this.func_77637_a(TabModTab.tab);
            for (int i = 0; i < list.length; ++i) {
                this.defaultCooldownMap[i] = 0L;
            }
        }

        @Override
        protected float getPower(ItemStack stack, EntityLivingBase entity, int timeLeft) {
            if (this.getCurrentJutsu(stack) == BRACKEN) {
                return this.getPower(stack, entity, timeLeft, 0.5f, 10.0f);
            }
            return 1.0f;
        }
    }
}

