/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.item;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.Particles;
import net.narutomod.creativetab.TabModTab;
import net.narutomod.entity.EntityBeamBase;
import net.narutomod.entity.EntityRendererRegister;
import net.narutomod.entity.EntitySuitonShark;
import net.narutomod.entity.EntityWaterDragon;
import net.narutomod.entity.EntityWaterPrison;
import net.narutomod.entity.EntityWaterShockwave;
import net.narutomod.event.EventSetBlocks;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureAirPunch;
import net.narutomod.procedure.ProcedureRenderView;
import net.narutomod.procedure.ProcedureSync;

@ElementsNarutomodMod.ModElement.Tag
public class ItemSuiton
extends ElementsNarutomodMod.ModElement {
    @GameRegistry.ObjectHolder(value="narutomod:suiton")
    public static final Item block = null;
    public static final int ENTITYID = 125;
    public static final int ENTITY2ID = 10125;
    public static final int ENTITY3ID = 11125;
    public static final ItemJutsu.JutsuEnum HIDINGINMIST = new ItemJutsu.JutsuEnum(0, "suitonmist", 'D', 100.0, (ItemJutsu.IJutsuCallback)new EntityMist.Jutsu());
    public static final ItemJutsu.JutsuEnum WATERBULLET = new ItemJutsu.JutsuEnum(1, "suitonstream", 'C', 10.0, (ItemJutsu.IJutsuCallback)new EntityStream.Jutsu());
    public static final ItemJutsu.JutsuEnum WATERDRAGON = new ItemJutsu.JutsuEnum(2, "water_dragon", 'B', 50.0, (ItemJutsu.IJutsuCallback)new EntityWaterDragon.EC.Jutsu());
    public static final ItemJutsu.JutsuEnum WATERPRISON = new ItemJutsu.JutsuEnum(3, "water_prison", 'C', 200.0, (ItemJutsu.IJutsuCallback)new EntityWaterPrison.EC.Jutsu());
    public static final ItemJutsu.JutsuEnum WATERSHARK = new ItemJutsu.JutsuEnum(4, "suiton_shark", 'B', 75.0, (ItemJutsu.IJutsuCallback)new EntitySuitonShark.EC.Jutsu());
    public static final ItemJutsu.JutsuEnum WATERSHOCK = new ItemJutsu.JutsuEnum(5, "water_shockwave", 'B', 30.0, (ItemJutsu.IJutsuCallback)new EntityWaterShockwave.EC.Jutsu());

    public ItemSuiton(ElementsNarutomodMod instance) {
        super(instance, 368);
    }

    @Override
    public void initElements() {
        this.elements.items.add(() -> new RangedItem(HIDINGINMIST, WATERBULLET, WATERDRAGON, WATERPRISON, WATERSHARK, WATERSHOCK));
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityStream.class).id(new ResourceLocation("narutomod", "suitonstream"), 125).name("suitonstream").tracker(64, 1, true).build());
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityMist.class).id(new ResourceLocation("narutomod", "suitonmist"), 10125).name("suitonmist").tracker(64, 1, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)block, (int)0, (ModelResourceLocation)new ModelResourceLocation("narutomod:suiton", "inventory"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        new Renderer().register();
    }

    public static class Renderer
    extends EntityRendererRegister {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void register() {
            RenderingRegistry.registerEntityRenderingHandler(EntityStream.class, renderManager -> new RenderStream(renderManager));
        }

        @SideOnly(value=Side.CLIENT)
        public class ModelLongCube
        extends EntityBeamBase.Model {
            private final ModelRenderer bone;
            protected float scale = 1.0f;

            public ModelLongCube(float length) {
                this.field_78090_t = 32;
                this.field_78089_u = 1024;
                this.bone = new ModelRenderer((ModelBase)this);
                this.bone.func_78793_a(0.0f, 0.0f, 0.0f);
                this.bone.field_78804_l.add(new ModelBox(this.bone, 0, 0, -4.0f, -16.0f, -4.0f, 8, (int)(16.0f * length), 8, 0.0f, false));
            }

            @Override
            public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)((this.scale - 1.0f) * 1.5f + 1.0f), (float)0.0f);
                GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)this.scale);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.bone.func_78785_a(f5);
                GlStateManager.func_179121_F();
            }
        }

        @SideOnly(value=Side.CLIENT)
        public class RenderStream
        extends EntityBeamBase.Renderer<EntityStream> {
            private final ResourceLocation TEXTURE;

            public RenderStream(RenderManager renderManager) {
                super(renderManager);
                this.TEXTURE = new ResourceLocation("minecraft:textures/blocks/water_flow.png");
            }

            @Override
            public EntityBeamBase.Model getMainModel(EntityStream entity) {
                float f = entity.ticksAlive >= 100 - 10 ? Math.max((float)(100 - entity.ticksAlive) / 10.0f, 0.0f) : Math.min((float)entity.ticksAlive / 10.0f, 1.0f);
                return new ModelLongCube(entity.getBeamLength() * f);
            }

            @Override
            protected ResourceLocation getEntityTexture(EntityStream entity) {
                return this.TEXTURE;
            }
        }
    }

    public static class EntityStream
    extends EntityBeamBase.Base {
        private final AirPunch stream = new AirPunch();
        private final int maxLife = 100;
        private final float damageModifier = 0.5f;
        private float power;

        public EntityStream(World a) {
            super(a);
        }

        public EntityStream(EntityLivingBase shooter, float scale) {
            super(shooter);
            this.power = scale;
        }

        public void shoot() {
            if (this.shootingEntity != null) {
                Vec3d vec3d = this.shootingEntity.func_70040_Z();
                Vec3d vec3d1 = vec3d.func_72441_c(this.shootingEntity.field_70165_t, this.shootingEntity.field_70163_u + (double)this.shootingEntity.func_70047_e() - 0.2, this.shootingEntity.field_70161_v);
                this.func_70080_a(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, this.shootingEntity.field_70177_z, this.shootingEntity.field_70125_A);
                vec3d1 = vec3d.func_186678_a((double)this.power);
                this.shoot(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c);
            }
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            if (this.shootingEntity != null) {
                if (this.ticksAlive == 1) {
                    this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:waterblast")), 0.5f, this.power / 30.0f);
                }
                this.shoot();
                this.stream.execute2((EntityLivingBase)this.shootingEntity, this.power, 0.5);
            }
            if (this.ticksAlive > this.maxLife) {
                this.func_70106_y();
            }
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                if (power >= 5.0f) {
                    EntityStream entityarrow = new EntityStream(entity, power);
                    entityarrow.shoot();
                    entity.field_70170_p.func_72838_d((Entity)entityarrow);
                    return true;
                }
                return false;
            }
        }

        public class AirPunch
        extends ProcedureAirPunch {
            public AirPunch() {
                this.blockDropChance = 0.4f;
                this.blockHardnessLimit = 5.0f;
                this.particlesPre = EnumParticleTypes.WATER_DROP;
                this.particlesDuring = EnumParticleTypes.WATER_WAKE;
            }

            @Override
            protected void preExecuteParticles(EntityLivingBase player) {
                double range = this.getRange(0);
                Particles.Renderer particles = new Particles.Renderer(player.field_70170_p);
                int j = (int)(range * 5.0);
                for (int i = 1; i < j; ++i) {
                    Vec3d vec = EntityStream.this.func_174791_d().func_72441_c((this.rand.nextDouble() - 0.5) * 0.25, this.rand.nextDouble() * 0.25, (this.rand.nextDouble() - 0.5) * 0.25);
                    Vec3d vec3d = player.func_70040_Z().func_186678_a(range * (this.rand.nextDouble() * 0.5 + 0.5) * 0.4);
                    particles.spawnParticles(Particles.Types.WATER_SPLASH, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 1, 0.0, 0.0, 0.0, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 10 + this.rand.nextInt(15));
                }
                particles.send();
            }

            @Override
            protected void attackEntityFrom(EntityLivingBase player, Entity target) {
                target.func_70097_a(ItemJutsu.causeJutsuDamage(EntityStream.this, player), EntityStream.this.power * 0.5f);
            }

            @Override
            protected EntityItem processAffectedBlock(EntityLivingBase player, BlockPos pos, EnumFacing facing) {
                EntityItem ret = super.processAffectedBlock(player, pos, facing);
                if (ret != null && player.field_70170_p.func_175623_d(pos.func_177984_a())) {
                    new EventSetBlocks(player.field_70170_p, (Map<BlockPos, IBlockState>)ImmutableMap.of((Object)pos.func_177984_a(), (Object)Blocks.field_150358_i.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(1))), 0L, 10, false, false);
                }
                return ret;
            }

            @Override
            protected float getBreakChance(BlockPos pos, EntityLivingBase player, double range) {
                return 1.0f - (float)(Math.sqrt(player.func_174831_c(pos)) / range);
            }
        }
    }

    public static class EntityMist
    extends Entity {
        private static final UUID FOLLOW_MODIFIER = UUID.fromString("7c3e5536-e32d-4ef7-8cf2-e5ef57f9d48f");
        private final float density = 1.0f;
        private final int buildTime = 200;
        private final int DISSIPATE = 120;
        private int idleTime;
        private int dissipateTime;
        private double radius;
        private EntityLivingBase user;

        public EntityMist(World world) {
            super(world);
            this.func_70105_a(0.0f, 0.0f);
        }

        public EntityMist(World world, double x, double y, double z, double r) {
            this(world);
            this.func_70107_b(x, y, z);
            this.radius = r;
            this.idleTime = this.buildTime + (world.func_72953_d(new AxisAlignedBB(x - 20.0, y - 10.0, z - 20.0, x + 20.0, y + 10.0, z + 20.0)) ? 800 : 400);
            this.dissipateTime = this.idleTime + this.DISSIPATE;
        }

        public EntityMist(EntityLivingBase userIn) {
            this(userIn.field_70170_p, userIn.field_70165_t, userIn.field_70163_u, userIn.field_70161_v, userIn instanceof EntityPlayer ? Math.min(1.5 * (double)((EntityPlayer)userIn).field_71068_ca, 60.0) : 32.0);
            this.user = userIn;
        }

        protected void func_70088_a() {
        }

        public void func_70106_y() {
            super.func_70106_y();
            ProcedureRenderView.setFogDensity(this, 255.0, false, 0.0f);
            for (EntityLivingBase entity : this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g(255.0))) {
                if (!(entity instanceof EntityLiving)) continue;
                entity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_188479_b(FOLLOW_MODIFIER);
            }
        }

        public void func_70071_h_() {
            if (!this.field_70170_p.field_72995_K) {
                for (EntityLivingBase entity : this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g(this.radius + 100.0))) {
                    if (entity.equals((Object)this.user) && !(this.user instanceof EntityPlayer)) continue;
                    double d0 = 1.0;
                    double d1 = (double)this.func_70032_d((Entity)entity) - this.radius;
                    if (this.field_70173_aa <= this.buildTime) {
                        d0 = (double)this.field_70173_aa / (double)this.buildTime;
                    } else if (this.field_70173_aa > this.idleTime && this.field_70173_aa < this.dissipateTime) {
                        d0 = (double)(this.dissipateTime - this.field_70173_aa) / (double)(this.dissipateTime - this.idleTime);
                    }
                    if (entity instanceof EntityPlayer) {
                        ((Object)((Object)this)).getClass();
                        d0 = d0 * 1.0 / Math.max(d1, 1.0);
                        ProcedureRenderView.setFogDensity((Entity)entity, (float)d0, 20);
                    } else if (entity instanceof EntityLiving) {
                        IAttributeInstance aInstance = entity.func_110148_a(SharedMonsterAttributes.field_111265_b);
                        aInstance.func_188479_b(FOLLOW_MODIFIER);
                        double d2 = aInstance.func_111126_e() - 2.0;
                        d0 = d0 * d2 - MathHelper.func_151237_a((double)d1, (double)0.0, (double)d2);
                        aInstance.func_111121_a(new AttributeModifier(FOLLOW_MODIFIER, "suiton.followModifier", -d0, 0));
                    }
                    if (entity.equals((Object)this.user) || !(this.user instanceof EntityPlayerMP)) continue;
                    ProcedureSync.SetGlowing.send((EntityPlayerMP)this.user, (Entity)entity, 5);
                }
                if (this.field_70173_aa >= this.dissipateTime) {
                    this.func_70106_y();
                }
            }
        }

        protected void func_70037_a(NBTTagCompound compound) {
            this.field_70173_aa = compound.func_74762_e("age");
            this.radius = compound.func_74769_h("radius");
            this.idleTime = compound.func_74762_e("idleTime");
            this.dissipateTime = compound.func_74762_e("dissipateTime");
        }

        protected void func_70014_b(NBTTagCompound compound) {
            compound.func_74768_a("age", this.field_70173_aa);
            compound.func_74780_a("radius", this.radius);
            compound.func_74768_a("idleTime", this.idleTime);
            compound.func_74768_a("dissipateTime", this.dissipateTime);
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:kirigakurenojutsu")), SoundCategory.PLAYERS, 5.0f, 1.0f);
                entity.field_70170_p.func_72838_d((Entity)new EntityMist(entity));
                return true;
            }
        }
    }

    public static class RangedItem
    extends ItemJutsu.Base {
        public RangedItem(ItemJutsu.JutsuEnum ... list) {
            super(ItemJutsu.JutsuEnum.Type.SUITON, list);
            this.setRegistryName("suiton");
            this.func_77655_b("suiton");
            this.func_77637_a(TabModTab.tab);
        }

        @Override
        protected float getPower(ItemStack stack, EntityLivingBase entity, int timeLeft) {
            ItemJutsu.JutsuEnum jutsu = this.getCurrentJutsu(stack);
            if (jutsu == WATERSHARK || jutsu == WATERDRAGON) {
                return this.getPower(stack, entity, timeLeft, 0.9f, 150.0f);
            }
            if (jutsu == WATERSHOCK) {
                return this.getPower(stack, entity, timeLeft, 5.0f, 50.0f);
            }
            if (jutsu == WATERBULLET) {
                return this.getPower(stack, entity, timeLeft, 5.0f, 20.0f);
            }
            return 1.0f;
        }

        @Override
        protected float getMaxPower(ItemStack stack, EntityLivingBase entity) {
            float ret = super.getMaxPower(stack, entity);
            ItemJutsu.JutsuEnum jutsu = this.getCurrentJutsu(stack);
            return jutsu == WATERSHOCK ? Math.min(ret, 25.0f) : (jutsu == WATERBULLET ? Math.min(ret, 30.0f) : (jutsu == WATERSHARK ? Math.min(ret, 5.0f) : (jutsu == WATERDRAGON ? Math.min(ret, 5.0f) : ret)));
        }
    }
}

