/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.procedure;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodMod;
import net.narutomod.NarutomodModVariables;
import net.narutomod.procedure.ProcedureDeathAnimations;
import net.narutomod.procedure.ProcedureSync;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class ProcedureOnLivingUpdate
extends ElementsNarutomodMod.ModElement {
    public ProcedureOnLivingUpdate(ElementsNarutomodMod instance) {
        super(instance, 105);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        this.elements.addNetworkMessage(CustomDataMessage.Handler.class, CustomDataMessage.class, Side.CLIENT);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static boolean isNoClip(Entity player) {
        return player.getEntityData().func_74771_c(NarutomodModVariables.noClipFlag) != 0;
    }

    public static boolean noClipAllowClicks(Entity player) {
        return (player.getEntityData().func_74771_c(NarutomodModVariables.noClipFlag) & 2) != 0;
    }

    public static void setNoClip(Entity player, boolean noClip) {
        ProcedureOnLivingUpdate.setNoClip(player, noClip, false);
    }

    public static void setNoClip(Entity player, boolean noClip, boolean allowMouseClicks) {
        if (player instanceof EntityPlayerMP) {
            byte flag = noClip ? (byte)(1 | (allowMouseClicks ? 2 : 0)) : (byte)0;
            player.field_70145_X = noClip;
            if (noClip) {
                player.getEntityData().func_74774_a(NarutomodModVariables.noClipFlag, flag);
            } else {
                player.getEntityData().func_82580_o(NarutomodModVariables.noClipFlag);
            }
            NarutomodMod.PACKET_HANDLER.sendTo((IMessage)new CustomDataMessage(player, flag), (EntityPlayerMP)player);
            NarutomodMod.PACKET_HANDLER.sendToAllTracking((IMessage)new CustomDataMessage(player, flag), player);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase target;
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (entity.getEntityData().func_74764_b(NarutomodModVariables.noClipFlag)) {
            entity.field_70145_X = ProcedureOnLivingUpdate.isNoClip((Entity)entity);
            if (entity.field_70145_X && !entity.func_189652_ae()) {
                entity.field_70181_x = world.func_175623_d(new BlockPos(entity.field_70165_t, entity.field_70163_u - 0.1, entity.field_70161_v)) || entity.func_70093_af() ? (entity.field_70181_x -= 0.01) : 0.0;
            }
        }
        double d = entity.getEntityData().func_74769_h(NarutomodModVariables.DeathAnimationTime);
        if (!world.field_72995_K && d > 0.0) {
            event.setCanceled(true);
            HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
            $_dependencies.put("entity", entity);
            $_dependencies.put("world", world);
            ProcedureDeathAnimations.executeProcedure($_dependencies);
            entity.getEntityData().func_74780_a(NarutomodModVariables.DeathAnimationTime, d -= 1.0);
            if (d <= 0.0) {
                ProcedureUtils.clearDeathAnimations(entity);
                if (entity instanceof EntityPlayer) {
                    entity.func_70097_a(ProcedureUtils.SPECIAL_DAMAGE, Float.MAX_VALUE);
                } else {
                    entity.func_70106_y();
                }
            }
        }
        if (entity.getEntityData().func_74764_b(NarutomodModVariables.InvulnerableTime)) {
            d = entity.getEntityData().func_74769_h(NarutomodModVariables.InvulnerableTime);
            if (d > 0.0) {
                entity.getEntityData().func_74780_a(NarutomodModVariables.InvulnerableTime, d - 1.0);
            } else {
                entity.getEntityData().func_82580_o(NarutomodModVariables.InvulnerableTime);
            }
        }
        if (entity.getEntityData().func_74764_b("FearEffect")) {
            int i = entity.getEntityData().func_74762_e("FearEffect");
            if (i > 0) {
                entity.getEntityData().func_74768_a("FearEffect", i - 1);
            } else {
                entity.getEntityData().func_82580_o("FearEffect");
            }
        }
        if (entity.getEntityData().func_74764_b("ForceExtinguish")) {
            int i = entity.getEntityData().func_74762_e("ForceExtinguish");
            if (i > 0) {
                entity.getEntityData().func_74768_a("ForceExtinguish", i - 1);
                entity.func_70066_B();
            } else {
                entity.getEntityData().func_82580_o("ForceExtinguish");
            }
        }
        if (entity.getEntityData().func_74764_b("UntargetableTicks")) {
            int i = entity.getEntityData().func_74762_e("UntargetableTicks");
            if (i > 0) {
                entity.getEntityData().func_74768_a("UntargetableTicks", i - 1);
            } else {
                entity.getEntityData().func_82580_o("UntargetableTicks");
            }
        }
        if (world.field_72995_K && entity.getEntityData().func_74764_b("GlowingTicks")) {
            int i = entity.getEntityData().func_74762_e("GlowingTicks");
            entity.func_184195_f(i > 0);
            if (i > 0) {
                ProcedureOnLivingUpdate.setGlowingFor((Entity)entity, i - 1);
            } else {
                entity.getEntityData().func_82580_o("GlowingTicks");
            }
        }
        if (entity instanceof EntityLiving && (target = ((EntityLiving)entity).func_70638_az()) != null && !target.func_70089_S()) {
            ((EntityLiving)entity).func_70624_b(null);
        }
    }

    public static void setGlowingFor(Entity entity, int ticks) {
        entity.getEntityData().func_74768_a("GlowingTicks", ticks);
    }

    public static void setUntargetable(Entity entity, int ticks) {
        if (entity.field_70170_p.field_72995_K) {
            ProcedureSync.EntityNBTTag.sendToServer(entity, "UntargetableTicks", ticks);
        } else {
            entity.getEntityData().func_74768_a("UntargetableTicks", ticks);
        }
    }

    public static boolean isUntargetable(Entity entity) {
        return entity.getEntityData().func_74762_e("UntargetableTicks") > 0;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderName(RenderLivingEvent.Specials.Pre event) {
        if (ProcedureOnLivingUpdate.isNoClip((Entity)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderLivingPre(RenderLivingEvent.Pre event) {
        if (event.getRenderer().func_177087_b() instanceof ModelBiped) {
            ModelBiped model = (ModelBiped)event.getRenderer().func_177087_b();
            if (event.getEntity().getEntityData().func_74767_n(NarutomodModVariables.forceBowPose)) {
                model.field_187076_m = ModelBiped.ArmPose.BOW_AND_ARROW;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onDeath(LivingDeathEvent event) {
        ProcedureUtils.clearDeathAnimations(event.getEntityLiving());
    }

    public static class CustomDataMessage
    implements IMessage {
        int id;
        byte flag;

        public CustomDataMessage() {
        }

        public CustomDataMessage(Entity entity, byte flagIn) {
            this.id = entity.func_145782_y();
            this.flag = flagIn;
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id);
            buf.writeByte((int)this.flag);
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readInt();
            this.flag = buf.readByte();
        }

        public static class Handler
        implements IMessageHandler<CustomDataMessage, IMessage> {
            @SideOnly(value=Side.CLIENT)
            public IMessage onMessage(CustomDataMessage message, MessageContext context) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    Entity player = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.id);
                    if (player instanceof EntityPlayer) {
                        if (message.flag == 0) {
                            player.getEntityData().func_82580_o(NarutomodModVariables.noClipFlag);
                            player.field_70145_X = false;
                        } else {
                            player.getEntityData().func_74774_a(NarutomodModVariables.noClipFlag, message.flag);
                            player.field_70145_X = true;
                        }
                    }
                });
                return null;
            }
        }
    }
}

