/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.procedure;

import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodModVariables;
import net.narutomod.PlayerTracker;
import net.narutomod.entity.EntitySusanooBase;
import net.narutomod.entity.EntitySusanooClothed;
import net.narutomod.entity.EntitySusanooSkeleton;
import net.narutomod.entity.EntitySusanooWinged;
import net.narutomod.item.ItemMangekyoSharinganEternal;
import net.narutomod.item.ItemRinnegan;
import net.narutomod.potion.PotionFeatherFalling;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class ProcedureSusanoo
extends ElementsNarutomodMod.ModElement {
    private static final String SUMMONED_SUSANOO = "summonedSusanooID";
    public static final double BASE_CHAKRA_USAGE = 500.0;

    public ProcedureSusanoo(ElementsNarutomodMod instance) {
        super(instance, 168);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new PlayerHook());
    }

    public static int getSummonedSusanooId(Entity entity) {
        return entity.getEntityData().func_74762_e(SUMMONED_SUSANOO);
    }

    public static void execute(EntityPlayer player) {
        World world = player.field_70170_p;
        boolean flag = player.func_184812_l_() || ProcedureUtils.hasItemInInventory(player, ItemRinnegan.helmet);
        ItemStack helmet = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        if (!player.getEntityData().func_74767_n("susanoo_activated")) {
            if (helmet.func_77942_o() && !helmet.func_77978_p().func_74767_n("sharingan_blinded") && PlayerTracker.getBattleXp(player) >= 2000.0 && Chakra.pathway(player).consume(500.0)) {
                player.getEntityData().func_74757_a("susanoo_activated", true);
                player.getEntityData().func_74780_a("susanoo_cd", NarutomodModVariables.world_tick + 2400.0);
                EntitySusanooSkeleton.EntityCustom entityCustom = new EntitySusanooSkeleton.EntityCustom(player);
                world.func_72838_d((Entity)entityCustom);
                player.getEntityData().func_74768_a(SUMMONED_SUSANOO, entityCustom.func_145782_y());
            }
        } else {
            double cooldown = player.getEntityData().func_74769_h("susanoo_ticks") * 0.25;
            cooldown *= ProcedureUtils.getCooldownModifier(player);
            player.getEntityData().func_82580_o("susanoo_activated");
            player.getEntityData().func_82580_o("susanoo_ticks");
            Entity entitySpawned = world.func_73045_a(ProcedureSusanoo.getSummonedSusanooId((Entity)player));
            player.getEntityData().func_82580_o(SUMMONED_SUSANOO);
            if (entitySpawned != null) {
                entitySpawned.func_70106_y();
            }
            if (!flag && helmet.func_77973_b() != ItemMangekyoSharinganEternal.helmet) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, (int)cooldown, 3));
                player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, (int)cooldown, 2));
            }
            player.func_70690_d(new PotionEffect(PotionFeatherFalling.potion, 60, 5));
        }
    }

    public static void executeProcedure(Map<String, Object> dependencies) {
        if (dependencies.get("entity") == null) {
            System.err.println("Failed to load dependency entity for procedure ProcedureSusanoo!");
            return;
        }
        if (dependencies.get("world") == null) {
            System.err.println("Failed to load dependency world for procedure ProcedureSusanoo!");
            return;
        }
        Entity entity = (Entity)dependencies.get("entity");
        if (!(entity instanceof EntityPlayer)) {
            System.err.println("Unauthorized calling of procedure ProcedureSusanoo! (entity not player)");
            return;
        }
        ProcedureSusanoo.execute((EntityPlayer)entity);
    }

    public static void upgrade(EntityPlayer player) {
        Entity susanoo = player.func_184187_bx();
        double playerXp = PlayerTracker.getBattleXp(player);
        if (susanoo instanceof EntitySusanooBase) {
            if (susanoo instanceof EntitySusanooSkeleton.EntityCustom) {
                boolean fullBody = ((EntitySusanooSkeleton.EntityCustom)susanoo).isFullBody();
                if (!fullBody && playerXp >= 5000.0) {
                    if (Chakra.pathway(player).consume(500.0)) {
                        susanoo.func_70106_y();
                        EntitySusanooSkeleton.EntityCustom entityCustom = new EntitySusanooSkeleton.EntityCustom(player, true);
                        player.field_70170_p.func_72838_d((Entity)entityCustom);
                        player.getEntityData().func_74768_a(SUMMONED_SUSANOO, entityCustom.func_145782_y());
                    }
                } else if (fullBody && playerXp >= 10000.0 && Chakra.pathway(player).consume(500.0)) {
                    susanoo.func_70106_y();
                    EntitySusanooClothed.EntityCustom entityCustom = new EntitySusanooClothed.EntityCustom((EntityLivingBase)player, false);
                    player.field_70170_p.func_72838_d((Entity)entityCustom);
                    player.getEntityData().func_74768_a(SUMMONED_SUSANOO, entityCustom.func_145782_y());
                }
            } else if (susanoo instanceof EntitySusanooClothed.EntityCustom) {
                boolean hasLegs = ((EntitySusanooClothed.EntityCustom)susanoo).hasLegs();
                if (hasLegs && playerXp >= 36000.0) {
                    if (Chakra.pathway(player).consume(500.0)) {
                        susanoo.func_70106_y();
                        EntitySusanooWinged.EntityCustom entityCustom = new EntitySusanooWinged.EntityCustom(player);
                        player.field_70170_p.func_72838_d((Entity)entityCustom);
                        player.getEntityData().func_74768_a(SUMMONED_SUSANOO, entityCustom.func_145782_y());
                    }
                } else if (!hasLegs && playerXp >= 20000.0 && Chakra.pathway(player).consume(500.0)) {
                    susanoo.func_70106_y();
                    EntitySusanooClothed.EntityCustom entityCustom = new EntitySusanooClothed.EntityCustom((EntityLivingBase)player, true);
                    player.field_70170_p.func_72838_d((Entity)entityCustom);
                    player.getEntityData().func_74768_a(SUMMONED_SUSANOO, entityCustom.func_145782_y());
                }
            }
        }
    }

    public class PlayerHook {
        private void checkAndRemove(EntityPlayer entity) {
            if (entity.getEntityData().func_74767_n("susanoo_activated")) {
                ProcedureSusanoo.execute(entity);
            }
        }

        @SubscribeEvent
        public void onPlayerChangeDimension(EntityTravelToDimensionEvent event) {
            if (event.getEntity() instanceof EntityPlayer) {
                this.checkAndRemove((EntityPlayer)event.getEntity());
            }
        }

        @SubscribeEvent
        public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
            this.checkAndRemove(event.player);
        }

        @SubscribeEvent
        public void onServerDisconnect(FMLNetworkEvent.ServerDisconnectionFromClientEvent event) {
            this.checkAndRemove((EntityPlayer)((NetHandlerPlayServer)event.getHandler()).field_147369_b);
        }
    }
}

