/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.procedure;

import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodMod;
import net.narutomod.Particles;
import net.narutomod.entity.EntityEarthBlocks;
import net.narutomod.entity.EntityLightningArc;
import net.narutomod.procedure.ProcedureOnLivingUpdate;

@ElementsNarutomodMod.ModElement.Tag
public class ProcedureSync
extends ElementsNarutomodMod.ModElement {
    public ProcedureSync(ElementsNarutomodMod instance) {
        super(instance, 536);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        this.elements.addNetworkMessage(SwingMainArm.Handler.class, SwingMainArm.class, Side.CLIENT);
        this.elements.addNetworkMessage(RemoveEntity.Handler.class, RemoveEntity.class, Side.CLIENT);
        this.elements.addNetworkMessage(MobAppearanceParticle.Handler.class, MobAppearanceParticle.class, Side.CLIENT);
        this.elements.addNetworkMessage(SetGlowing.Handler.class, SetGlowing.class, Side.CLIENT);
        this.elements.addNetworkMessage(ResetBoundingBox.ClientHandler.class, ResetBoundingBox.class, Side.CLIENT);
        this.elements.addNetworkMessage(ResetBoundingBox.ServerHandler.class, ResetBoundingBox.class, Side.SERVER);
        this.elements.addNetworkMessage(MotionPacket.ClientHandler.class, MotionPacket.class, Side.CLIENT);
        this.elements.addNetworkMessage(MotionPacket.ServerHandler.class, MotionPacket.class, Side.SERVER);
        this.elements.addNetworkMessage(EntityPositionAndRotation.ClientHandler.class, EntityPositionAndRotation.class, Side.CLIENT);
        this.elements.addNetworkMessage(EntityPositionAndRotation.ServerHandler.class, EntityPositionAndRotation.class, Side.SERVER);
        this.elements.addNetworkMessage(EntityState.Handler.class, EntityState.class, Side.CLIENT);
        this.elements.addNetworkMessage(EntityNBTTag.ServerHandler.class, EntityNBTTag.class, Side.SERVER);
        this.elements.addNetworkMessage(EntityNBTTag.ClientHandler.class, EntityNBTTag.class, Side.CLIENT);
        this.elements.addNetworkMessage(CPacketEarthBlocks.Handler.class, CPacketEarthBlocks.class, Side.SERVER);
        this.elements.addNetworkMessage(SPacketEarthBlocks.Handler.class, SPacketEarthBlocks.class, Side.CLIENT);
        this.elements.addNetworkMessage(CPacketVec3d.Handler.class, CPacketVec3d.class, Side.SERVER);
        this.elements.addNetworkMessage(RenderDistance.ServerHandler.class, RenderDistance.class, Side.SERVER);
        this.elements.addNetworkMessage(RenderDistance.ClientHandler.class, RenderDistance.class, Side.CLIENT);
        this.elements.addNetworkMessage(CPacketSpawnLightning.Handler.class, CPacketSpawnLightning.class, Side.SERVER);
        this.elements.addNetworkMessage(MultiPartsPacket.ServerHandler.class, MultiPartsPacket.class, Side.SERVER);
        this.elements.addNetworkMessage(MultiPartsPacket.ClientHandler.class, MultiPartsPacket.class, Side.CLIENT);
        this.elements.addNetworkMessage(MultiPartsSetPassengers.ClientHandler.class, MultiPartsSetPassengers.class, Side.CLIENT);
        this.elements.addNetworkMessage(SoundEffectMessage.Handler.class, SoundEffectMessage.class, Side.SERVER);
    }

    public static void writeString(ByteBuf buf, String str) {
        buf.writeInt(str.length());
        for (int i = 0; i < str.length(); ++i) {
            buf.writeChar((int)str.charAt(i));
        }
    }

    public static String readString(ByteBuf buf) {
        int len = buf.readInt();
        char[] tagArray = new char[len];
        for (int i = 0; i < len; ++i) {
            tagArray[i] = buf.readChar();
        }
        return new String(tagArray);
    }

    public static class SoundEffectMessage
    implements IMessage {
        double x;
        double y;
        double z;
        String domain;
        String path;
        String category;
        float volume;
        float pitch;

        public SoundEffectMessage() {
        }

        public SoundEffectMessage(double _x, double _y, double _z, SoundEvent sound, SoundCategory cat, float vol, float p) {
            this.x = _x;
            this.y = _y;
            this.z = _z;
            this.domain = sound.func_187503_a().func_110624_b();
            this.path = sound.func_187503_a().func_110623_a();
            this.category = cat.func_187948_a();
            this.volume = vol;
            this.pitch = p;
        }

        public static void sendToServer(double _x, double _y, double _z, SoundEvent sound, SoundCategory cat, float vol, float p) {
            NarutomodMod.PACKET_HANDLER.sendToServer((IMessage)new SoundEffectMessage(_x, _y, _z, sound, cat, vol, p));
        }

        public void toBytes(ByteBuf buf) {
            buf.writeDouble(this.x);
            buf.writeDouble(this.y);
            buf.writeDouble(this.z);
            ProcedureSync.writeString(buf, this.domain);
            ProcedureSync.writeString(buf, this.path);
            ProcedureSync.writeString(buf, this.category);
            buf.writeFloat(this.volume);
            buf.writeFloat(this.pitch);
        }

        public void fromBytes(ByteBuf buf) {
            this.x = buf.readDouble();
            this.y = buf.readDouble();
            this.z = buf.readDouble();
            this.domain = ProcedureSync.readString(buf);
            this.path = ProcedureSync.readString(buf);
            this.category = ProcedureSync.readString(buf);
            this.volume = buf.readFloat();
            this.pitch = buf.readFloat();
        }

        public static class Handler
        implements IMessageHandler<SoundEffectMessage, IMessage> {
            public IMessage onMessage(SoundEffectMessage message, MessageContext context) {
                EntityPlayerMP entity = context.getServerHandler().field_147369_b;
                entity.func_71121_q().func_152344_a(() -> entity.field_70170_p.func_184148_a(null, message.x, message.y, message.z, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(message.domain, message.path)), SoundCategory.func_187950_a((String)message.category), message.volume, message.pitch));
                return null;
            }
        }
    }

    public static class MultiPartsSetPassengers
    implements IMessage {
        int id;
        int partid;
        int passengers;
        int[] passengerIds;

        public MultiPartsSetPassengers() {
        }

        public MultiPartsSetPassengers(Entity entity, int partId) {
            this.id = entity.func_145782_y();
            Entity[] partentities = entity.func_70021_al();
            if (partentities == null) {
                throw new IllegalArgumentException("" + entity.getClass() + "not multi-part entity!");
            }
            for (Entity part : partentities) {
                if (part.func_145782_y() != partId) continue;
                this.partid = partId;
                List list = part.func_184188_bt();
                this.passengers = list.size();
                this.passengerIds = new int[this.passengers];
                for (int i = 0; i < this.passengers; ++i) {
                    this.passengerIds[i] = ((Entity)list.get(i)).func_145782_y();
                }
            }
            if (this.partid == 0) {
                System.err.println("Sending passengers for non-existing part");
            }
        }

        public static void sendToTracking(Entity entity, int partId) {
            NarutomodMod.PACKET_HANDLER.sendToAllTracking((IMessage)new MultiPartsSetPassengers(entity, partId), entity);
        }

        private static void setParts(@Nullable Entity entity, MultiPartsSetPassengers message) {
            Entity[] entityparts;
            if (entity instanceof IEntityMultiPart && (entityparts = entity.func_70021_al()) != null && entityparts.length > 0) {
                for (Entity part : entityparts) {
                    if (part.func_145782_y() != message.partid) continue;
                    for (int i : message.passengerIds) {
                        Entity entity1 = entity.field_70170_p.func_73045_a(i);
                        if (entity1 == null) continue;
                        entity1.func_184205_a(part, true);
                    }
                }
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id);
            buf.writeInt(this.partid);
            buf.writeInt(this.passengers);
            for (int i = 0; i < this.passengers; ++i) {
                buf.writeInt(this.passengerIds[i]);
            }
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readInt();
            this.partid = buf.readInt();
            this.passengers = buf.readInt();
            this.passengerIds = new int[this.passengers];
            for (int i = 0; i < this.passengers; ++i) {
                this.passengerIds[i] = buf.readInt();
            }
        }

        public static class ClientHandler
        implements IMessageHandler<MultiPartsSetPassengers, IMessage> {
            @SideOnly(value=Side.CLIENT)
            public IMessage onMessage(MultiPartsSetPassengers message, MessageContext context) {
                Minecraft mc = Minecraft.func_71410_x();
                mc.func_152344_a(() -> MultiPartsSetPassengers.setParts(mc.field_71441_e.func_73045_a(message.id), message));
                return null;
            }
        }
    }

    public static class MultiPartsPacket
    implements IMessage {
        int id;
        int parts;
        PositionRotationPacket[] pr;

        public MultiPartsPacket() {
        }

        public MultiPartsPacket(Entity entity) {
            this.id = entity.func_145782_y();
            Entity[] partentity = entity.func_70021_al();
            if (partentity == null) {
                throw new IllegalArgumentException("" + entity.getClass() + "not multi-part entity!");
            }
            this.parts = partentity.length;
            this.pr = new PositionRotationPacket[this.parts];
            for (int i = 0; i < this.parts; ++i) {
                this.pr[i] = new PositionRotationPacket(partentity[i].field_70165_t, partentity[i].field_70163_u, partentity[i].field_70161_v, partentity[i].field_70177_z, partentity[i].field_70125_A);
            }
        }

        public static void sendToTracking(Entity entity) {
            NarutomodMod.PACKET_HANDLER.sendToAllTracking((IMessage)new MultiPartsPacket(entity), entity);
        }

        public static void sendToServer(Entity entity) {
            NarutomodMod.PACKET_HANDLER.sendToServer((IMessage)new MultiPartsPacket(entity));
        }

        private static void setParts(@Nullable Entity entity, MultiPartsPacket message) {
            Entity[] entityparts;
            if (entity instanceof IEntityMultiPart && (entityparts = entity.func_70021_al()) != null && entityparts.length == message.parts) {
                for (int i = 0; i < message.parts; ++i) {
                    entityparts[i].func_70012_b(message.pr[i].posX, message.pr[i].posY, message.pr[i].posZ, message.pr[i].rotationYaw, message.pr[i].rotationPitch);
                }
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id);
            buf.writeInt(this.parts);
            for (int i = 0; i < this.parts; ++i) {
                this.pr[i].toBytes(buf);
            }
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readInt();
            this.parts = buf.readInt();
            this.pr = new PositionRotationPacket[this.parts];
            for (int i = 0; i < this.parts; ++i) {
                this.pr[i] = new PositionRotationPacket(buf);
            }
        }

        public static class ServerHandler
        implements IMessageHandler<MultiPartsPacket, IMessage> {
            public IMessage onMessage(MultiPartsPacket message, MessageContext context) {
                WorldServer world = context.getServerHandler().field_147369_b.func_71121_q();
                world.func_152344_a(() -> MultiPartsPacket.setParts(world.func_73045_a(message.id), message));
                return null;
            }
        }

        public static class ClientHandler
        implements IMessageHandler<MultiPartsPacket, IMessage> {
            @SideOnly(value=Side.CLIENT)
            public IMessage onMessage(MultiPartsPacket message, MessageContext context) {
                Minecraft mc = Minecraft.func_71410_x();
                mc.func_152344_a(() -> MultiPartsPacket.setParts(mc.field_71441_e.func_73045_a(message.id), message));
                return null;
            }
        }
    }

    public static class CPacketSpawnLightning
    implements IMessage {
        double x;
        double y;
        double z;
        double len;
        double speedx;
        double speedy;
        double speedz;
        int args;
        int[] parms;

        public CPacketSpawnLightning() {
        }

        public CPacketSpawnLightning(double cx, double cy, double cz, double l, double sx, double sy, double sz, int ... p) {
            this.x = cx;
            this.y = cy;
            this.z = cz;
            this.len = l;
            this.speedx = sx;
            this.speedy = sy;
            this.speedz = sz;
            this.args = p.length;
            this.parms = p;
        }

        public static void sendToServer(double cx, double cy, double cz, double l, double sx, double sy, double sz, int ... p) {
            NarutomodMod.PACKET_HANDLER.sendToServer((IMessage)new CPacketSpawnLightning(cx, cy, cz, l, sx, sy, sz, p));
        }

        public void toBytes(ByteBuf buf) {
            buf.writeDouble(this.x);
            buf.writeDouble(this.y);
            buf.writeDouble(this.z);
            buf.writeDouble(this.len);
            buf.writeDouble(this.speedx);
            buf.writeDouble(this.speedy);
            buf.writeDouble(this.speedz);
            buf.writeInt(this.args);
            for (int j = 0; j < this.args; ++j) {
                buf.writeInt(this.parms[j]);
            }
        }

        public void fromBytes(ByteBuf buf) {
            this.x = buf.readDouble();
            this.y = buf.readDouble();
            this.z = buf.readDouble();
            this.len = buf.readDouble();
            this.speedx = buf.readDouble();
            this.speedy = buf.readDouble();
            this.speedz = buf.readDouble();
            this.args = buf.readInt();
            this.parms = new int[this.args];
            for (int j = 0; j < this.args; ++j) {
                this.parms[j] = buf.readInt();
            }
        }

        public static class Handler
        implements IMessageHandler<CPacketSpawnLightning, IMessage> {
            public IMessage onMessage(CPacketSpawnLightning message, MessageContext context) {
                WorldServer world = context.getServerHandler().field_147369_b.func_71121_q();
                world.func_152344_a(() -> EntityLightningArc.spawnAsParticle((World)world, message.x, message.y, message.z, message.len, message.speedx, message.speedy, message.speedz, message.parms));
                return null;
            }
        }
    }

    public static class RenderDistance
    implements IMessage {
        int id;
        int chunks;
        int sendbackId;

        public RenderDistance() {
        }

        public RenderDistance(int entityId, int ch, int sendbackToEntityId) {
            this.id = entityId;
            this.chunks = ch;
            this.sendbackId = sendbackToEntityId;
        }

        public static void sendToSelf(EntityPlayerMP player, int chunksIn, @Nullable Entity sendbacktoEntity) {
            NarutomodMod.PACKET_HANDLER.sendTo((IMessage)new RenderDistance(player.func_145782_y(), chunksIn, sendbacktoEntity != null ? sendbacktoEntity.func_145782_y() : -1), player);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id);
            buf.writeInt(this.chunks);
            buf.writeInt(this.sendbackId);
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readInt();
            this.chunks = buf.readInt();
            this.sendbackId = buf.readInt();
        }

        public static interface IHandler {
            public void handleClientPacket(EntityPlayer var1, int var2);
        }

        public static class ServerHandler
        implements IMessageHandler<RenderDistance, IMessage> {
            public IMessage onMessage(RenderDistance message, MessageContext context) {
                EntityPlayerMP player = context.getServerHandler().field_147369_b;
                player.func_71121_q().func_152344_a(() -> {
                    Entity entity = player.field_70170_p.func_73045_a(message.id);
                    if (entity instanceof IHandler) {
                        ((IHandler)entity).handleClientPacket((EntityPlayer)player, message.chunks);
                    }
                });
                return null;
            }
        }

        public static class ClientHandler
        implements IMessageHandler<RenderDistance, IMessage> {
            @SideOnly(value=Side.CLIENT)
            public IMessage onMessage(RenderDistance message, MessageContext context) {
                Minecraft mc = Minecraft.func_71410_x();
                mc.func_152344_a(() -> {
                    if (message.sendbackId >= 0) {
                        NarutomodMod.PACKET_HANDLER.sendToServer((IMessage)new RenderDistance(message.sendbackId, mc.field_71474_y.field_151451_c, -1));
                    }
                    mc.field_71474_y.field_151451_c = message.chunks;
                });
                return null;
            }
        }
    }

    public static class CPacketVec3d
    implements IMessage {
        int id;
        double x;
        double y;
        double z;

        public CPacketVec3d() {
        }

        public CPacketVec3d(Entity entity, Vec3d vec) {
            this.id = entity.func_145782_y();
            this.x = vec.field_72450_a;
            this.y = vec.field_72448_b;
            this.z = vec.field_72449_c;
        }

        public static void sendToServer(Entity entity, Vec3d vec) {
            NarutomodMod.PACKET_HANDLER.sendToServer((IMessage)new CPacketVec3d(entity, vec));
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id);
            buf.writeDouble(this.x);
            buf.writeDouble(this.y);
            buf.writeDouble(this.z);
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readInt();
            this.x = buf.readDouble();
            this.y = buf.readDouble();
            this.z = buf.readDouble();
        }

        public static interface IHandler {
            public void handleClientPacket(Vec3d var1);
        }

        public static class Handler
        implements IMessageHandler<CPacketVec3d, IMessage> {
            public IMessage onMessage(CPacketVec3d message, MessageContext context) {
                WorldServer world = context.getServerHandler().field_147369_b.func_71121_q();
                world.func_152344_a(() -> {
                    Entity entity = world.func_73045_a(message.id);
                    if (entity instanceof IHandler) {
                        ((IHandler)entity).handleClientPacket(new Vec3d(message.x, message.y, message.z));
                    }
                });
                return null;
            }
        }
    }

    public static class CPacketEarthBlocks
    implements IMessage {
        public int op;
        public int id;
        public float amount;

        public CPacketEarthBlocks() {
        }

        public CPacketEarthBlocks(int operation, Entity entity, float amountIn) {
            this.op = operation;
            this.id = entity.func_145782_y();
            this.amount = amountIn;
        }

        public static void sendToServer(int operation, Entity entity) {
            CPacketEarthBlocks.sendToServer(operation, entity, 0.0f);
        }

        public static void sendToServer(int operation, Entity entity, float amountIn) {
            NarutomodMod.PACKET_HANDLER.sendToServer((IMessage)new CPacketEarthBlocks(operation, entity, amountIn));
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.op);
            buf.writeInt(this.id);
            buf.writeFloat(this.amount);
        }

        public void fromBytes(ByteBuf buf) {
            this.op = buf.readInt();
            this.id = buf.readInt();
            this.amount = buf.readFloat();
        }

        public static class Handler
        implements IMessageHandler<CPacketEarthBlocks, IMessage> {
            public IMessage onMessage(CPacketEarthBlocks message, MessageContext context) {
                EntityPlayerMP entity = context.getServerHandler().field_147369_b;
                entity.func_71121_q().func_152344_a(() -> {
                    Entity entity1 = entity.field_70170_p.func_73045_a(message.id);
                    if (entity1 instanceof EntityEarthBlocks.Base) {
                        ((EntityEarthBlocks.Base)entity1).handleClientPacket(entity, message);
                    }
                });
                return null;
            }
        }
    }

    public static class SPacketEarthBlocks
    implements IMessage {
        public int id;
        public int state;
        public int blocks;
        public double x;
        public double y;
        public double z;

        public SPacketEarthBlocks() {
        }

        public SPacketEarthBlocks(Entity entity, int total, Vec3d vec, IBlockState blockstate) {
            this.id = entity.func_145782_y();
            this.state = Block.func_176210_f((IBlockState)blockstate);
            this.blocks = total;
            this.x = vec.field_72450_a;
            this.y = vec.field_72448_b;
            this.z = vec.field_72449_c;
        }

        public static void sendToPlayer(EntityPlayerMP player, Entity entity, int total, Vec3d vec, IBlockState state) {
            NarutomodMod.PACKET_HANDLER.sendTo((IMessage)new SPacketEarthBlocks(entity, total, vec, state), player);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id);
            buf.writeInt(this.state);
            buf.writeInt(this.blocks);
            buf.writeDouble(this.x);
            buf.writeDouble(this.y);
            buf.writeDouble(this.z);
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readInt();
            this.state = buf.readInt();
            this.blocks = buf.readInt();
            this.x = buf.readDouble();
            this.y = buf.readDouble();
            this.z = buf.readDouble();
        }

        public static class Handler
        implements IMessageHandler<SPacketEarthBlocks, IMessage> {
            @SideOnly(value=Side.CLIENT)
            public IMessage onMessage(SPacketEarthBlocks message, MessageContext context) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.id);
                    if (entity instanceof EntityEarthBlocks.Base) {
                        ((EntityEarthBlocks.Base)entity).handleServerPacket(message);
                    }
                });
                return null;
            }
        }
    }

    public static class EntityNBTTag
    implements IMessage {
        int id;
        int dataType;
        String tag;
        int iData;
        double dData;
        boolean bData;

        public EntityNBTTag() {
        }

        public EntityNBTTag(Entity entity, String tagName) {
            this.setup(entity, tagName, 0);
        }

        public EntityNBTTag(Entity entity, String tagName, int data) {
            this.setup(entity, tagName, 1);
            this.iData = data;
        }

        public EntityNBTTag(Entity entity, String tagName, double data) {
            this.setup(entity, tagName, 2);
            this.dData = data;
        }

        public EntityNBTTag(Entity entity, String tagName, boolean data) {
            this.setup(entity, tagName, 3);
            this.bData = data;
        }

        private void setup(Entity entity, String tagName, int type) {
            this.id = entity.func_145782_y();
            this.tag = tagName;
            this.dataType = type;
        }

        public static void removeAndSync(Entity entity, String tagName) {
            entity.getEntityData().func_82580_o(tagName);
            EntityNBTTag.sendToTracking(entity, tagName);
        }

        public static void setAndSync(Entity entity, String tagName, int i) {
            entity.getEntityData().func_74768_a(tagName, i);
            EntityNBTTag.sendToTracking(entity, tagName, i);
        }

        public static void setAndSync(Entity entity, String tagName, double d) {
            entity.getEntityData().func_74780_a(tagName, d);
            EntityNBTTag.sendToTracking(entity, tagName, d);
        }

        public static void setAndSync(Entity entity, String tagName, boolean b) {
            entity.getEntityData().func_74757_a(tagName, b);
            EntityNBTTag.sendToTracking(entity, tagName, b);
        }

        public static void sendToSelf(EntityPlayerMP entity, String tagName) {
            NarutomodMod.PACKET_HANDLER.sendTo((IMessage)new EntityNBTTag((Entity)entity, tagName), entity);
        }

        public static void sendToSelf(EntityPlayerMP entity, String tagName, int i) {
            NarutomodMod.PACKET_HANDLER.sendTo((IMessage)new EntityNBTTag((Entity)entity, tagName, i), entity);
        }

        public static void sendToSelf(EntityPlayerMP entity, String tagName, double d) {
            NarutomodMod.PACKET_HANDLER.sendTo((IMessage)new EntityNBTTag((Entity)entity, tagName, d), entity);
        }

        public static void sendToSelf(EntityPlayerMP entity, String tagName, boolean b) {
            NarutomodMod.PACKET_HANDLER.sendTo((IMessage)new EntityNBTTag((Entity)entity, tagName, b), entity);
        }

        public static void sendToTracking(Entity entity, String tagName) {
            if (entity instanceof EntityPlayerMP) {
                EntityNBTTag.sendToSelf((EntityPlayerMP)entity, tagName);
            }
            NarutomodMod.PACKET_HANDLER.sendToAllTracking((IMessage)new EntityNBTTag(entity, tagName), entity);
        }

        public static void sendToTracking(Entity entity, String tagName, int i) {
            if (entity instanceof EntityPlayerMP) {
                EntityNBTTag.sendToSelf((EntityPlayerMP)entity, tagName, i);
            }
            NarutomodMod.PACKET_HANDLER.sendToAllTracking((IMessage)new EntityNBTTag(entity, tagName, i), entity);
        }

        public static void sendToTracking(Entity entity, String tagName, double d) {
            if (entity instanceof EntityPlayerMP) {
                EntityNBTTag.sendToSelf((EntityPlayerMP)entity, tagName, d);
            }
            NarutomodMod.PACKET_HANDLER.sendToAllTracking((IMessage)new EntityNBTTag(entity, tagName, d), entity);
        }

        public static void sendToTracking(Entity entity, String tagName, boolean b) {
            if (entity instanceof EntityPlayerMP) {
                EntityNBTTag.sendToSelf((EntityPlayerMP)entity, tagName, b);
            }
            NarutomodMod.PACKET_HANDLER.sendToAllTracking((IMessage)new EntityNBTTag(entity, tagName, b), entity);
        }

        public static void sendToServer(Entity entity, String tagName, int i) {
            NarutomodMod.PACKET_HANDLER.sendToServer((IMessage)new EntityNBTTag(entity, tagName, i));
        }

        public static void sendToServer(Entity entity, String tagName, double d) {
            NarutomodMod.PACKET_HANDLER.sendToServer((IMessage)new EntityNBTTag(entity, tagName, d));
        }

        public static void sendToServer(Entity entity, String tagName, boolean b) {
            NarutomodMod.PACKET_HANDLER.sendToServer((IMessage)new EntityNBTTag(entity, tagName, b));
        }

        private static void setDataTag(@Nullable Entity entity, EntityNBTTag message) {
            if (entity != null) {
                switch (message.dataType) {
                    case 0: {
                        entity.getEntityData().func_82580_o(message.tag);
                        break;
                    }
                    case 1: {
                        entity.getEntityData().func_74768_a(message.tag, message.iData);
                        break;
                    }
                    case 2: {
                        entity.getEntityData().func_74780_a(message.tag, message.dData);
                        break;
                    }
                    case 3: {
                        entity.getEntityData().func_74757_a(message.tag, message.bData);
                    }
                }
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id);
            buf.writeInt(this.dataType);
            ProcedureSync.writeString(buf, this.tag);
            buf.writeInt(this.iData);
            buf.writeDouble(this.dData);
            buf.writeBoolean(this.bData);
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readInt();
            this.dataType = buf.readInt();
            this.tag = ProcedureSync.readString(buf);
            this.iData = buf.readInt();
            this.dData = buf.readDouble();
            this.bData = buf.readBoolean();
        }

        public static class ServerHandler
        implements IMessageHandler<EntityNBTTag, IMessage> {
            public IMessage onMessage(EntityNBTTag message, MessageContext context) {
                WorldServer world = context.getServerHandler().field_147369_b.func_71121_q();
                world.func_152344_a(() -> EntityNBTTag.setDataTag(world.func_73045_a(message.id), message));
                return null;
            }
        }

        public static class ClientHandler
        implements IMessageHandler<EntityNBTTag, IMessage> {
            @SideOnly(value=Side.CLIENT)
            public IMessage onMessage(EntityNBTTag message, MessageContext context) {
                Minecraft mc = Minecraft.func_71410_x();
                mc.func_152344_a(() -> EntityNBTTag.setDataTag((Entity)(message.id == mc.field_71439_g.func_145782_y() ? mc.field_71439_g : mc.field_71441_e.func_73045_a(message.id)), message));
                return null;
            }
        }
    }

    public static class EntityState
    implements IMessage {
        int id;
        boolean onground;

        public EntityState() {
        }

        public EntityState(Entity entity) {
            this.id = entity.func_145782_y();
            this.onground = entity.field_70122_E;
        }

        public static void sendToTracking(Entity entity) {
            NarutomodMod.PACKET_HANDLER.sendToAllTracking((IMessage)new EntityState(entity), entity);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id);
            buf.writeBoolean(this.onground);
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readInt();
            this.onground = buf.readBoolean();
        }

        public static class Handler
        implements IMessageHandler<EntityState, IMessage> {
            @SideOnly(value=Side.CLIENT)
            public IMessage onMessage(EntityState message, MessageContext context) {
                Minecraft mc = Minecraft.func_71410_x();
                mc.func_152344_a(() -> {
                    Entity entity = mc.field_71441_e.func_73045_a(message.id);
                    if (entity != null) {
                        entity.field_70122_E = message.onground;
                    }
                });
                return null;
            }
        }
    }

    public static class EntityPositionAndRotation
    implements IMessage {
        int id;
        PositionRotationPacket prp;

        public EntityPositionAndRotation() {
        }

        public EntityPositionAndRotation(Entity entity) {
            this.id = entity.func_145782_y();
            this.prp = new PositionRotationPacket(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
        }

        public static void sendToTracking(Entity entity) {
            NarutomodMod.PACKET_HANDLER.sendToAllTracking((IMessage)new EntityPositionAndRotation(entity), entity);
        }

        public static void sendToSelf(EntityPlayerMP entity) {
            NarutomodMod.PACKET_HANDLER.sendTo((IMessage)new EntityPositionAndRotation((Entity)entity), entity);
        }

        public static void sendToServer(Entity entity) {
            NarutomodMod.PACKET_HANDLER.sendToServer((IMessage)new EntityPositionAndRotation(entity));
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id);
            this.prp.toBytes(buf);
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readInt();
            this.prp = new PositionRotationPacket(buf);
        }

        public static class ServerHandler
        implements IMessageHandler<EntityPositionAndRotation, IMessage> {
            public IMessage onMessage(EntityPositionAndRotation message, MessageContext context) {
                WorldServer world = context.getServerHandler().field_147369_b.func_71121_q();
                world.func_152344_a(() -> {
                    Entity entity = world.func_73045_a(message.id);
                    if (entity instanceof EntityPlayerMP) {
                        entity.func_184210_p();
                        ((EntityPlayerMP)entity).field_71135_a.func_147364_a(message.prp.posX, message.prp.posY, message.prp.posZ, message.prp.rotationYaw, message.prp.rotationPitch);
                    } else if (entity != null) {
                        entity.func_70012_b(message.prp.posX, message.prp.posY, message.prp.posZ, message.prp.rotationYaw, message.prp.rotationPitch);
                    }
                });
                return null;
            }
        }

        public static class ClientHandler
        implements IMessageHandler<EntityPositionAndRotation, IMessage> {
            @SideOnly(value=Side.CLIENT)
            public IMessage onMessage(EntityPositionAndRotation message, MessageContext context) {
                Minecraft mc = Minecraft.func_71410_x();
                mc.func_152344_a(() -> {
                    Entity entity = mc.field_71441_e.func_73045_a(message.id);
                    if (entity != null) {
                        entity.func_180426_a(message.prp.posX, message.prp.posY, message.prp.posZ, message.prp.rotationYaw, message.prp.rotationPitch, 3, false);
                    }
                });
                return null;
            }
        }
    }

    public static class PositionRotationPacket {
        double posX;
        double posY;
        double posZ;
        float rotationYaw;
        float rotationPitch;

        PositionRotationPacket() {
        }

        PositionRotationPacket(double x, double y, double z, float yaw, float pitch) {
            this.posX = x;
            this.posY = y;
            this.posZ = z;
            this.rotationYaw = yaw;
            this.rotationPitch = pitch;
        }

        PositionRotationPacket(ByteBuf buf) {
            this.posX = buf.readDouble();
            this.posY = buf.readDouble();
            this.posZ = buf.readDouble();
            this.rotationYaw = buf.readFloat();
            this.rotationPitch = buf.readFloat();
        }

        void toBytes(ByteBuf buf) {
            buf.writeDouble(this.posX);
            buf.writeDouble(this.posY);
            buf.writeDouble(this.posZ);
            buf.writeFloat(this.rotationYaw);
            buf.writeFloat(this.rotationPitch);
        }
    }

    public static class MotionPacket
    implements IMessage {
        int id;
        double mX;
        double mY;
        double mZ;

        public MotionPacket() {
        }

        public MotionPacket(Entity entity) {
            this.id = entity.func_145782_y();
            this.mX = entity.field_70159_w;
            this.mY = entity.field_70181_x;
            this.mZ = entity.field_70179_y;
        }

        public static void sendToTracking(Entity entity) {
            NarutomodMod.PACKET_HANDLER.sendToAllTracking((IMessage)new MotionPacket(entity), entity);
        }

        public static void sendToServer(Entity entity) {
            NarutomodMod.PACKET_HANDLER.sendToServer((IMessage)new MotionPacket(entity));
        }

        private static void setMotion(@Nullable Entity entity, MotionPacket message) {
            if (entity != null) {
                entity.field_70159_w = message.mX;
                entity.field_70181_x = message.mY;
                entity.field_70179_y = message.mZ;
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id);
            buf.writeDouble(this.mX);
            buf.writeDouble(this.mY);
            buf.writeDouble(this.mZ);
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readInt();
            this.mX = buf.readDouble();
            this.mY = buf.readDouble();
            this.mZ = buf.readDouble();
        }

        public static class ServerHandler
        implements IMessageHandler<MotionPacket, IMessage> {
            public IMessage onMessage(MotionPacket message, MessageContext context) {
                WorldServer world = context.getServerHandler().field_147369_b.func_71121_q();
                world.func_152344_a(() -> MotionPacket.setMotion(world.func_73045_a(message.id), message));
                return null;
            }
        }

        public static class ClientHandler
        implements IMessageHandler<MotionPacket, IMessage> {
            @SideOnly(value=Side.CLIENT)
            public IMessage onMessage(MotionPacket message, MessageContext context) {
                Minecraft.func_71410_x().func_152344_a(() -> MotionPacket.setMotion(Minecraft.func_71410_x().field_71441_e.func_73045_a(message.id), message));
                return null;
            }
        }
    }

    public static class ResetBoundingBox
    implements IMessage {
        int id;
        AxisAlignedBB aabb;
        float w;
        float h;

        public ResetBoundingBox() {
        }

        public ResetBoundingBox(Entity entity) {
            this.id = entity.func_145782_y();
            this.aabb = entity.func_174813_aQ();
            this.w = entity.field_70130_N;
            this.h = entity.field_70131_O;
        }

        public static void sendToTracking(Entity entity) {
            NarutomodMod.PACKET_HANDLER.sendToAllTracking((IMessage)new ResetBoundingBox(entity), entity);
        }

        public static void sendToPlayer(Entity entity, EntityPlayerMP player) {
            NarutomodMod.PACKET_HANDLER.sendTo((IMessage)new ResetBoundingBox(entity), player);
        }

        public static void sendToServer(Entity entity) {
            NarutomodMod.PACKET_HANDLER.sendToServer((IMessage)new ResetBoundingBox(entity));
        }

        private static void setBoundingBox(@Nullable Entity entity, ResetBoundingBox message) {
            if (entity != null) {
                entity.func_174826_a(message.aabb);
                entity.field_70130_N = message.w;
                entity.field_70131_O = message.h;
                entity.func_174829_m();
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id);
            buf.writeDouble(this.aabb.field_72340_a);
            buf.writeDouble(this.aabb.field_72338_b);
            buf.writeDouble(this.aabb.field_72339_c);
            buf.writeDouble(this.aabb.field_72336_d);
            buf.writeDouble(this.aabb.field_72337_e);
            buf.writeDouble(this.aabb.field_72334_f);
            buf.writeFloat(this.w);
            buf.writeFloat(this.h);
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readInt();
            double minX = buf.readDouble();
            double minY = buf.readDouble();
            double minZ = buf.readDouble();
            double maxX = buf.readDouble();
            double maxY = buf.readDouble();
            double maxZ = buf.readDouble();
            this.aabb = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
            this.w = buf.readFloat();
            this.h = buf.readFloat();
        }

        public static class ServerHandler
        implements IMessageHandler<ResetBoundingBox, IMessage> {
            public IMessage onMessage(ResetBoundingBox message, MessageContext context) {
                WorldServer world = context.getServerHandler().field_147369_b.func_71121_q();
                world.func_152344_a(() -> ResetBoundingBox.setBoundingBox(world.func_73045_a(message.id), message));
                return null;
            }
        }

        public static class ClientHandler
        implements IMessageHandler<ResetBoundingBox, IMessage> {
            @SideOnly(value=Side.CLIENT)
            public IMessage onMessage(ResetBoundingBox message, MessageContext context) {
                Minecraft.func_71410_x().func_152344_a(() -> ResetBoundingBox.setBoundingBox(Minecraft.func_71410_x().field_71441_e.func_73045_a(message.id), message));
                return null;
            }
        }
    }

    public static class SetGlowing
    implements IMessage {
        int id;
        int ticks;

        public SetGlowing() {
        }

        public SetGlowing(Entity entity, int glowTicks) {
            this.id = entity.func_145782_y();
            this.ticks = glowTicks;
        }

        public static void send(EntityPlayerMP player, Entity entity, int glowTicks) {
            NarutomodMod.PACKET_HANDLER.sendTo((IMessage)new SetGlowing(entity, glowTicks), player);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id);
            buf.writeInt(this.ticks);
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readInt();
            this.ticks = buf.readInt();
        }

        public static class Handler
        implements IMessageHandler<SetGlowing, IMessage> {
            @SideOnly(value=Side.CLIENT)
            public IMessage onMessage(SetGlowing message, MessageContext context) {
                Minecraft mc = Minecraft.func_71410_x();
                mc.func_152344_a(() -> {
                    Entity entity = mc.field_71441_e.func_73045_a(message.id);
                    if (entity != null) {
                        ProcedureOnLivingUpdate.setGlowingFor(entity, message.ticks);
                    }
                });
                return null;
            }
        }
    }

    public static class MobAppearanceParticle
    implements IMessage {
        int id;

        public MobAppearanceParticle() {
        }

        public MobAppearanceParticle(int entityId) {
            this.id = entityId;
        }

        public static void send(EntityPlayerMP entity, int entityId) {
            NarutomodMod.PACKET_HANDLER.sendTo((IMessage)new MobAppearanceParticle(entityId), entity);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id);
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readInt();
        }

        public static class Handler
        implements IMessageHandler<MobAppearanceParticle, IMessage> {
            @SideOnly(value=Side.CLIENT)
            public IMessage onMessage(MobAppearanceParticle message, MessageContext context) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                    if (player != null) {
                        player.field_70170_p.func_190523_a(Particles.Types.MOB_APPEARANCE.getID(), player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0, 0.0, 0.0, new int[]{message.id});
                    }
                });
                return null;
            }
        }
    }

    public static class RemoveEntity
    implements IMessage {
        int id;

        public RemoveEntity() {
        }

        public RemoveEntity(Entity entity) {
            this.id = entity.func_145782_y();
        }

        public static void send(Entity entity) {
            NarutomodMod.PACKET_HANDLER.sendToAllTracking((IMessage)new RemoveEntity(entity), entity);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id);
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readInt();
        }

        public static class Handler
        implements IMessageHandler<RemoveEntity, IMessage> {
            @SideOnly(value=Side.CLIENT)
            public IMessage onMessage(RemoveEntity message, MessageContext context) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    WorldClient world = Minecraft.func_71410_x().field_71441_e;
                    Entity entity = world.func_73045_a(message.id);
                    if (entity != null) {
                        world.func_72900_e(entity);
                    }
                });
                return null;
            }
        }
    }

    public static class SwingMainArm
    implements IMessage {
        int id;

        public SwingMainArm() {
        }

        public SwingMainArm(Entity entity) {
            this.id = entity.func_145782_y();
        }

        public static void send(EntityLivingBase entity) {
            if (entity instanceof EntityPlayerMP) {
                NarutomodMod.PACKET_HANDLER.sendTo((IMessage)new SwingMainArm((Entity)entity), (EntityPlayerMP)entity);
            } else {
                entity.func_184609_a(EnumHand.MAIN_HAND);
                NarutomodMod.PACKET_HANDLER.sendToAllTracking((IMessage)new SwingMainArm((Entity)entity), (Entity)entity);
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id);
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readInt();
        }

        public static class Handler
        implements IMessageHandler<SwingMainArm, IMessage> {
            @SideOnly(value=Side.CLIENT)
            public IMessage onMessage(SwingMainArm message, MessageContext context) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.id);
                    if (entity instanceof EntityLivingBase) {
                        ((EntityLivingBase)entity).func_184609_a(EnumHand.MAIN_HAND);
                    }
                });
                return null;
            }
        }
    }
}

