/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.world;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.block.BlockKamuiBlock;
import net.narutomod.procedure.ProcedureKamuiDimensionPlayerEntersDimension;

@ElementsNarutomodMod.ModElement.Tag
public class WorldKamuiDimension
extends ElementsNarutomodMod.ModElement {
    public static int DIMID = 3;
    public static final boolean NETHER_TYPE = false;
    public static DimensionType dtype;

    public WorldKamuiDimension(ElementsNarutomodMod instance) {
        super(instance, 115);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (DimensionManager.isDimensionRegistered((int)DIMID)) {
            DIMID = DimensionManager.getNextFreeDimId();
            System.err.println("Dimension ID for dimension kamuidimension is already registered. Falling back to ID: " + DIMID);
        }
        dtype = DimensionType.register((String)"kamuidimension", (String)"_kamuidimension", (int)DIMID, WorldProviderMod.class, (boolean)true);
        DimensionManager.registerDimension((int)DIMID, (DimensionType)dtype);
    }

    public static class BiomeProviderCustom
    extends BiomeProvider {
        private GenLayer genBiomes;
        private GenLayer biomeIndexLayer;
        private BiomeCache biomeCache = new BiomeCache((BiomeProvider)this);

        public BiomeProviderCustom() {
        }

        public BiomeProviderCustom(long seed) {
            GenLayer[] agenlayer = this.makeTheWorld(seed);
            this.genBiomes = agenlayer[0];
            this.biomeIndexLayer = agenlayer[1];
        }

        private GenLayer[] makeTheWorld(long seed) {
            GenLayerBiomesCustom biomes = new GenLayerBiomesCustom(1L);
            biomes = new GenLayerZoom(1000L, (GenLayer)biomes);
            biomes = new GenLayerZoom(1001L, (GenLayer)biomes);
            biomes = new GenLayerZoom(1002L, (GenLayer)biomes);
            biomes = new GenLayerZoom(1003L, (GenLayer)biomes);
            biomes = new GenLayerZoom(1004L, (GenLayer)biomes);
            biomes = new GenLayerZoom(1005L, (GenLayer)biomes);
            GenLayerVoronoiZoom genlayervoronoizoom = new GenLayerVoronoiZoom(10L, (GenLayer)biomes);
            biomes.func_75905_a(seed);
            genlayervoronoizoom.func_75905_a(seed);
            return new GenLayer[]{biomes, genlayervoronoizoom};
        }

        public BiomeProviderCustom(World world) {
            this(world.func_72905_C());
        }

        public void func_76938_b() {
            this.biomeCache.func_76838_a();
        }

        public Biome func_180631_a(BlockPos pos) {
            return this.func_180300_a(pos, null);
        }

        public Biome func_180300_a(BlockPos pos, Biome defaultBiome) {
            return this.biomeCache.func_180284_a(pos.func_177958_n(), pos.func_177952_p(), defaultBiome);
        }

        public Biome[] func_76933_b(Biome[] oldBiomeList, int x, int z, int width, int depth) {
            return this.func_76931_a(oldBiomeList, x, z, width, depth, true);
        }

        public Biome[] func_76937_a(Biome[] biomes, int x, int z, int width, int height) {
            IntCache.func_76446_a();
            if (biomes == null || biomes.length < width * height) {
                biomes = new Biome[width * height];
            }
            int[] aint = this.genBiomes.func_75904_a(x, z, width, height);
            try {
                for (int i = 0; i < width * height; ++i) {
                    biomes[i] = Biome.func_180276_a((int)aint[i], (Biome)Biomes.field_180279_ad);
                }
                return biomes;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("RawBiomeBlock");
                crashreportcategory.func_71507_a("biomes[] size", (Object)biomes.length);
                crashreportcategory.func_71507_a("x", (Object)x);
                crashreportcategory.func_71507_a("z", (Object)z);
                crashreportcategory.func_71507_a("w", (Object)width);
                crashreportcategory.func_71507_a("h", (Object)height);
                throw new ReportedException(crashreport);
            }
        }

        public Biome[] func_76931_a(@Nullable Biome[] listToReuse, int x, int z, int width, int length, boolean cacheFlag) {
            IntCache.func_76446_a();
            if (listToReuse == null || listToReuse.length < width * length) {
                listToReuse = new Biome[width * length];
            }
            if (cacheFlag && width == 16 && length == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
                Biome[] abiome = this.biomeCache.func_76839_e(x, z);
                System.arraycopy(abiome, 0, listToReuse, 0, width * length);
                return listToReuse;
            }
            int[] aint = this.biomeIndexLayer.func_75904_a(x, z, width, length);
            for (int i = 0; i < width * length; ++i) {
                listToReuse[i] = Biome.func_180276_a((int)aint[i], (Biome)Biomes.field_180279_ad);
            }
            return listToReuse;
        }

        public boolean func_76940_a(int x, int z, int radius, List<Biome> allowed) {
            IntCache.func_76446_a();
            int i = x - radius >> 2;
            int j = z - radius >> 2;
            int k = x + radius >> 2;
            int l = z + radius >> 2;
            int i1 = k - i + 1;
            int j1 = l - j + 1;
            int[] aint = this.genBiomes.func_75904_a(i, j, i1, j1);
            try {
                for (int k1 = 0; k1 < i1 * j1; ++k1) {
                    Biome biome = Biome.func_150568_d((int)aint[k1]);
                    if (allowed.contains(biome)) continue;
                    return false;
                }
                return true;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Layer");
                crashreportcategory.func_71507_a("Layer", (Object)this.genBiomes.toString());
                crashreportcategory.func_71507_a("x", (Object)x);
                crashreportcategory.func_71507_a("z", (Object)z);
                crashreportcategory.func_71507_a("radius", (Object)radius);
                crashreportcategory.func_71507_a("allowed", allowed);
                throw new ReportedException(crashreport);
            }
        }

        @Nullable
        public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random random) {
            IntCache.func_76446_a();
            int i = x - range >> 2;
            int j = z - range >> 2;
            int k = x + range >> 2;
            int l = z + range >> 2;
            int i1 = k - i + 1;
            int j1 = l - j + 1;
            int[] aint = this.genBiomes.func_75904_a(i, j, i1, j1);
            BlockPos blockpos = null;
            int k1 = 0;
            for (int l1 = 0; l1 < i1 * j1; ++l1) {
                int i2 = i + l1 % i1 << 2;
                int j2 = j + l1 / i1 << 2;
                Biome biome = Biome.func_150568_d((int)aint[l1]);
                if (!biomes.contains(biome) || blockpos != null && random.nextInt(k1 + 1) != 0) continue;
                blockpos = new BlockPos(i2, 0, j2);
                ++k1;
            }
            return blockpos;
        }
    }

    public static class GenLayerBiomesCustom
    extends GenLayer {
        private Biome[] allowedBiomes = new Biome[]{(Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation("void"))};

        public GenLayerBiomesCustom(long seed) {
            super(seed);
        }

        public int[] func_75904_a(int x, int z, int width, int depth) {
            int[] dest = IntCache.func_76445_a((int)(width * depth));
            for (int dz = 0; dz < depth; ++dz) {
                for (int dx = 0; dx < width; ++dx) {
                    this.func_75903_a(dx + x, dz + z);
                    dest[dx + dz * width] = Biome.func_185362_a((Biome)this.allowedBiomes[this.func_75902_a(this.allowedBiomes.length)]);
                }
            }
            return dest;
        }
    }

    public static class ChunkProviderModded
    implements IChunkGenerator {
        private static final IBlockState STONE = BlockKamuiBlock.block.func_176223_P();
        private static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
        private static final int SEALEVEL = 63;
        private final World world;
        private Random random;
        private final NoiseGeneratorSimplex islandNoise;
        private final NoiseGeneratorOctaves perlinnoise1;
        private final NoiseGeneratorOctaves perlinnoise2;
        private final NoiseGeneratorOctaves perlinnoise3;
        private final NoiseGeneratorPerlin height;
        private Biome[] biomesForGeneration;
        private double[] buffer;
        private double[] pnr;
        private double[] ar;
        private double[] br;
        private double[] depthbuff = new double[256];
        private WorldGenerator islandGen;

        public ChunkProviderModded(World worldIn, long seed) {
            worldIn.func_181544_b(63);
            this.world = worldIn;
            this.random = new Random(seed);
            this.perlinnoise1 = new NoiseGeneratorOctaves(this.random, 16);
            this.perlinnoise2 = new NoiseGeneratorOctaves(this.random, 16);
            this.perlinnoise3 = new NoiseGeneratorOctaves(this.random, 8);
            this.height = new NoiseGeneratorPerlin(this.random, 4);
            this.islandNoise = new NoiseGeneratorSimplex(this.random);
            this.islandGen = new WorldGenerator(){

                public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
                    float f = rand.nextInt(5) + 10;
                    int i = 0;
                    while ((float)(i + position.func_177956_o()) > 0.0f) {
                        for (int j = MathHelper.func_76141_d((float)(-f)); j <= MathHelper.func_76123_f((float)f); ++j) {
                            for (int k = MathHelper.func_76141_d((float)(-f)); k <= MathHelper.func_76123_f((float)f); ++k) {
                                this.func_175903_a(worldIn, position.func_177982_a(j, i, k), STONE);
                            }
                        }
                        --i;
                    }
                    return true;
                }
            };
        }

        public Chunk func_185932_a(int x, int z) {
            this.random.setSeed((long)x * 535358712L + (long)z * 347539041L);
            ChunkPrimer chunkprimer = new ChunkPrimer();
            this.setBlocksInChunk(x, z, chunkprimer);
            this.biomesForGeneration = this.world.func_72959_q().func_76937_a(this.biomesForGeneration, x * 16, z * 16, 16, 16);
            this.replaceBiomeBlocks(x, z, chunkprimer, this.biomesForGeneration);
            Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
            byte[] abyte = chunk.func_76605_m();
            for (int i = 0; i < abyte.length; ++i) {
                abyte[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
            }
            chunk.func_76603_b();
            return chunk;
        }

        public void func_185931_b(int x, int z) {
            BlockFalling.field_149832_M = true;
            int i = x * 16;
            int j = z * 16;
            BlockPos blockpos = new BlockPos(i, 0, j);
            float f = this.getIslandHeightValue(x, z, 1, 1);
            if (f < -10.0f && this.random.nextInt(4) == 0) {
                this.islandGen.func_180709_b(this.world, this.random, blockpos.func_177982_a(this.random.nextInt(16) + 8, 55 + this.random.nextInt(16), this.random.nextInt(16) + 8));
                if (this.random.nextInt(4) == 0) {
                    this.islandGen.func_180709_b(this.world, this.random, blockpos.func_177982_a(this.random.nextInt(16) + 8, 55 + this.random.nextInt(16), this.random.nextInt(16) + 8));
                }
            }
            BlockFalling.field_149832_M = false;
        }

        public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
            return Lists.newArrayList();
        }

        public void func_180514_a(Chunk chunkIn, int x, int z) {
        }

        public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
            return false;
        }

        public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
            return null;
        }

        public boolean func_185933_a(Chunk chunkIn, int x, int z) {
            return false;
        }

        private double[] getHeights(double[] p_185963_1_, int p_185963_2_, int p_185963_3_, int p_185963_4_, int p_185963_5_, int p_185963_6_, int p_185963_7_) {
            ChunkGeneratorEvent.InitNoiseField event = new ChunkGeneratorEvent.InitNoiseField((IChunkGenerator)this, p_185963_1_, p_185963_2_, p_185963_3_, p_185963_4_, p_185963_5_, p_185963_6_, p_185963_7_);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.getResult() == Event.Result.DENY) {
                return event.getNoisefield();
            }
            if (p_185963_1_ == null) {
                p_185963_1_ = new double[p_185963_5_ * p_185963_6_ * p_185963_7_];
            }
            double d0 = 684.412;
            double d1 = 684.412;
            this.pnr = this.perlinnoise3.func_76304_a(this.pnr, p_185963_2_, p_185963_3_, p_185963_4_, p_185963_5_, p_185963_6_, p_185963_7_, (d0 *= 2.0) / 80.0, 4.277575000000001, d0 / 80.0);
            this.ar = this.perlinnoise1.func_76304_a(this.ar, p_185963_2_, p_185963_3_, p_185963_4_, p_185963_5_, p_185963_6_, p_185963_7_, d0, 684.412, d0);
            this.br = this.perlinnoise2.func_76304_a(this.br, p_185963_2_, p_185963_3_, p_185963_4_, p_185963_5_, p_185963_6_, p_185963_7_, d0, 684.412, d0);
            int i = p_185963_2_ / 2;
            int j = p_185963_4_ / 2;
            int k = 0;
            for (int l = 0; l < p_185963_5_; ++l) {
                for (int i1 = 0; i1 < p_185963_7_; ++i1) {
                    float f = this.getIslandHeightValue(i, j, l, i1);
                    for (int j1 = 0; j1 < p_185963_6_; ++j1) {
                        double d2 = this.ar[k] / 512.0;
                        double d3 = this.br[k] / 512.0;
                        double d5 = (this.pnr[k] / 10.0 + 1.0) / 2.0;
                        double d4 = d5 < 0.0 ? d2 : (d5 > 1.0 ? d3 : d2 + (d3 - d2) * d5);
                        d4 -= 8.0;
                        d4 += (double)f;
                        int k1 = 2;
                        if (j1 > p_185963_6_ / 2 - k1) {
                            double d6 = (float)(j1 - (p_185963_6_ / 2 - k1)) / 64.0f;
                            d6 = MathHelper.func_151237_a((double)d6, (double)0.0, (double)1.0);
                            d4 = d4 * (1.0 - d6) + -3000.0 * d6;
                        }
                        if (j1 < (k1 = 8)) {
                            double d7 = (float)(k1 - j1) / ((float)k1 - 1.0f);
                            d4 = d4 * (1.0 - d7) + -30.0 * d7;
                        }
                        p_185963_1_[k] = d4;
                        ++k;
                    }
                }
            }
            return p_185963_1_;
        }

        private float getIslandHeightValue(int p_185960_1_, int p_185960_2_, int p_185960_3_, int p_185960_4_) {
            float f = p_185960_1_ * 2 + p_185960_3_;
            float f1 = p_185960_2_ * 2 + p_185960_4_;
            float f2 = 100.0f - MathHelper.func_76129_c((float)(f * f + f1 * f1)) * 8.0f;
            if (f2 > 80.0f) {
                f2 = 80.0f;
            }
            if (f2 < -100.0f) {
                f2 = -100.0f;
            }
            for (int i = -12; i <= 12; ++i) {
                for (int j = -12; j <= 12; ++j) {
                    long k = p_185960_1_ + i;
                    long l = p_185960_2_ + j;
                    if (k * k + l * l <= 4096L || !(this.islandNoise.func_151605_a((double)k, (double)l) < (double)-0.9f)) continue;
                    float f3 = (MathHelper.func_76135_e((float)k) * 3439.0f + MathHelper.func_76135_e((float)l) * 147.0f) % 13.0f + 9.0f;
                    f = p_185960_3_ - i * 2;
                    f1 = p_185960_4_ - j * 2;
                    float f4 = 100.0f - MathHelper.func_76129_c((float)(f * f + f1 * f1)) * f3;
                    if (f4 > 80.0f) {
                        f4 = 80.0f;
                    }
                    if (f4 < -100.0f) {
                        f4 = -100.0f;
                    }
                    if (!(f4 > f2)) continue;
                    f2 = f4;
                }
            }
            return f2;
        }

        public void setBlocksInChunk(int x, int z, ChunkPrimer primer) {
        }

        private void replaceBiomeBlocks(int x, int z, ChunkPrimer primer, Biome[] biomesIn) {
            this.depthbuff = this.height.func_151599_a(this.depthbuff, (double)(x * 16), (double)(z * 16), 16, 16, 0.0625, 0.0625, 1.0);
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    this.generateBiomeTerrain(this.world, this.random, primer, x * 16 + i, z * 16 + j, this.depthbuff[j + i * 16], biomesIn[j + i * 16]);
                }
            }
        }

        private void generateBiomeTerrain(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal, Biome biome) {
        }
    }

    public static class WorldProviderMod
    extends WorldProvider {
        public void func_76572_b() {
            this.field_76578_c = new BiomeProviderCustom(this.field_76579_a.func_72905_C());
            this.field_76576_e = false;
        }

        public void calculateInitialWeather() {
        }

        public void updateWeather() {
        }

        public boolean canDoLightning(Chunk chunk) {
            return false;
        }

        public boolean canDoRainSnowIce(Chunk chunk) {
            return false;
        }

        public DimensionType func_186058_p() {
            return dtype;
        }

        @SideOnly(value=Side.CLIENT)
        public Vec3d func_76562_b(float par1, float par2) {
            return new Vec3d(0.0, 0.0, 0.0);
        }

        public IChunkGenerator func_186060_c() {
            return new ChunkProviderModded(this.field_76579_a, this.field_76579_a.func_72905_C() - (long)DIMID);
        }

        public boolean func_76569_d() {
            return false;
        }

        public boolean func_76567_e() {
            return false;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_76568_b(int par1, int par2) {
            return false;
        }

        public WorldProvider.WorldSleepResult canSleepAt(EntityPlayer player, BlockPos pos) {
            return WorldProvider.WorldSleepResult.DENY;
        }

        protected void func_76556_a() {
            float f = 0.12f;
            for (int i = 0; i <= 15; ++i) {
                float f1 = 1.0f - (float)i / 15.0f;
                this.field_76573_f[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f) + f;
            }
        }

        public boolean func_177500_n() {
            return false;
        }

        public BlockPos getSpawnPoint() {
            WorldInfo info = this.field_76579_a.func_72912_H();
            BlockPos pos = new BlockPos(info.func_76079_c(), info.func_76075_d(), info.func_76074_e());
            pos = new BlockPos(info.func_76079_c(), 69, info.func_76074_e());
            this.setSpawnPoint(pos);
            return pos;
        }

        public void func_186061_a(EntityPlayerMP entity) {
            int x = (int)entity.field_70165_t;
            int y = (int)entity.field_70163_u;
            int z = (int)entity.field_70161_v;
            HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
            $_dependencies.put("entity", entity);
            $_dependencies.put("x", x);
            $_dependencies.put("z", z);
            $_dependencies.put("world", this.field_76579_a);
            ProcedureKamuiDimensionPlayerEntersDimension.executeProcedure($_dependencies);
        }
    }
}

