/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui.button;

import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookIcon;
import vazkii.patchouli.client.book.gui.GuiBook;

public class GuiButtonCategory
extends GuiButton {
    private static final int ANIM_TIME = 5;
    GuiBook parent;
    BookCategory category;
    BookIcon icon;
    String name;
    int u;
    int v;
    float timeHovered;

    public GuiButtonCategory(GuiBook parent, int x, int y, BookCategory category) {
        this(parent, x, y, category.getIcon(), category.getName());
        this.category = category;
    }

    public GuiButtonCategory(GuiBook parent, int x, int y, BookIcon icon, String name) {
        super(0, parent.bookLeft + x, parent.bookTop + y, 20, 20, "");
        this.parent = parent;
        this.u = x;
        this.v = y;
        this.icon = icon;
        this.name = name;
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (this.field_146124_l && this.field_146125_m) {
            boolean locked;
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            this.timeHovered = this.field_146123_n ? Math.min(5.0f, this.timeHovered + ClientTicker.delta) : Math.max(0.0f, this.timeHovered - ClientTicker.delta);
            float time = Math.max(0.0f, Math.min(5.0f, this.timeHovered + (this.field_146123_n ? partialTicks : -partialTicks)));
            float transparency = 0.5f - time / 5.0f * 0.5f;
            boolean bl = locked = this.category != null && this.category.isLocked();
            if (locked) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
                GuiBook.drawLock(this.parent.book, this.field_146128_h + 2, this.field_146129_i + 2);
            } else {
                this.icon.render(this.field_146128_h + 2, this.field_146129_i + 2);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)transparency);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)200.0f);
            GuiBook.drawFromTexture(this.parent.book, this.field_146128_h, this.field_146129_i, this.u, this.v, this.field_146120_f, this.field_146121_g);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.category != null && !this.category.isLocked()) {
                GuiBook.drawMarking(this.parent.book, this.field_146128_h, this.field_146129_i, 0, this.category.getReadState());
            }
            GlStateManager.func_179121_F();
            if (this.field_146123_n) {
                this.parent.setTooltip(locked ? TextFormatting.GRAY + I18n.func_135052_a((String)"patchouli.gui.lexicon.locked", (Object[])new Object[0]) : this.name);
            }
        }
    }

    public void func_146113_a(SoundHandler soundHandlerIn) {
        if (this.category != null && !this.category.isLocked()) {
            GuiBook.playBookFlipSound(this.parent.book);
        }
    }

    public BookCategory getCategory() {
        return this.category;
    }
}

