/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike;

import greymerk.roguelike.treasure.ChestPlacementException;
import greymerk.roguelike.treasure.Inventory;
import greymerk.roguelike.treasure.TreasureChest;
import greymerk.roguelike.treasure.TreasureManager;
import greymerk.roguelike.treasure.loot.ChestType;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntityChest;

public class TreasureChestEditor {
    private WorldEditor worldEditor;
    private TreasureManager treasureManager;
    private Random random;

    public TreasureChestEditor(WorldEditor worldEditor, Random random) {
        this.worldEditor = worldEditor;
        this.random = random;
        this.treasureManager = new TreasureManager(random);
    }

    public TreasureManager getTreasureManager() {
        return this.treasureManager;
    }

    public void createChests(int level, List<Coord> chestLocations, boolean isTrapped, ChestType ... chestTypes) {
        chestLocations.forEach(chestLocation -> this.createChest(level, (Coord)chestLocation, isTrapped, chestTypes));
    }

    public void createChest(int level, Coord chestLocation, boolean isTrapped, ChestType ... chestTypes) {
        if (this.isValidChestSpace(chestLocation, this.worldEditor)) {
            ChestType type = ChestType.chooseRandomType(this.random, chestTypes);
            this.safeGenerate(level, chestLocation, isTrapped, type);
        }
    }

    private void safeGenerate(int level, Coord chestLocation, boolean isTrapped, ChestType chestType) {
        try {
            this.generateTreasureChest(chestLocation, isTrapped, chestType, level);
        }
        catch (ChestPlacementException chestPlacementException) {
            // empty catch block
        }
    }

    public TreasureChest generateTreasureChest(Coord pos, boolean isTrapped, ChestType chestType, int level) throws ChestPlacementException {
        MetaBlock chestBlock = new MetaBlock((Block)(isTrapped ? Blocks.field_150447_bR : Blocks.field_150486_ae));
        boolean success = chestBlock.set(this.worldEditor, pos);
        if (!success) {
            throw new ChestPlacementException("Failed to place chest in world");
        }
        TileEntityChest tileEntityChest = (TileEntityChest)this.worldEditor.getTileEntity(pos);
        int seed = Objects.hash(pos.hashCode(), this.worldEditor.getSeed());
        TreasureChest treasureChest = new TreasureChest(chestType, level, tileEntityChest, seed, new Inventory(this.random, tileEntityChest));
        this.getTreasureManager().addChest(treasureChest);
        return treasureChest;
    }

    private boolean isValidChestSpace(Coord coord, WorldEditor worldEditor) {
        return worldEditor.isAirBlock(coord) && !worldEditor.isNonSolidBlock(coord) && worldEditor.treasureChestEditor.isNotNextToChest(coord, worldEditor);
    }

    private boolean isNotNextToChest(Coord coord, WorldEditor worldEditor) {
        return Arrays.stream(Cardinal.directions).noneMatch(dir -> this.isBesideChest(coord, (Cardinal)((Object)dir), worldEditor));
    }

    private boolean isBesideChest(Coord coord, Cardinal dir, WorldEditor worldEditor) {
        Coord otherCursor = coord.add(dir);
        return worldEditor.getBlock(otherCursor).func_177230_c() == Blocks.field_150486_ae;
    }
}

