/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.command.routes;

import greymerk.roguelike.command.CommandRouteBase;
import greymerk.roguelike.command.ICommandContext;
import greymerk.roguelike.command.MessageType;
import greymerk.roguelike.util.ArgumentParser;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.command.CommandBase;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class CommandRouteBiome
extends CommandRouteBase {
    @Override
    public void execute(ICommandContext context, List<String> args) {
        Coord pos;
        ArgumentParser ap = new ArgumentParser(args);
        WorldEditor editor = context.createEditor();
        if (!ap.hasEntry(0)) {
            pos = context.getPos();
        } else {
            int z;
            int x;
            try {
                x = CommandBase.func_175755_a((String)ap.get(0));
                z = CommandBase.func_175755_a((String)ap.get(1));
            }
            catch (NumberInvalidException e) {
                context.sendMessage("Failure: Invalid Coords: X Z", MessageType.ERROR);
                return;
            }
            pos = new Coord(x, 0, z);
        }
        context.sendMessage("Biome Information for " + pos.toString(), MessageType.SPECIAL);
        Biome biome = editor.getInfo(pos).getBiome();
        context.sendMessage(biome.func_185359_l(), MessageType.SPECIAL);
        Set biomeTypes = BiomeDictionary.getTypes((Biome)biome);
        String types = biomeTypes.stream().map(type -> type.getName() + " ").collect(Collectors.joining());
        context.sendMessage(types, MessageType.SPECIAL);
    }
}

