/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.config;

import com.google.common.collect.Lists;
import greymerk.roguelike.config.ConfigFile;
import greymerk.roguelike.config.INIParser;
import java.io.File;
import java.io.IOException;
import java.util.List;

public enum RogueConfig {
    DIMENSIONBL("dimensionBL", false, 0, 0.0, Lists.newArrayList()),
    DIMENSIONWL("dimensionWL", false, 0, 0.0, Lists.newArrayList((Object[])new Integer[]{0})),
    DONATURALSPAWN("doNaturalSpawn", true, 0, 0.0, null),
    ENCASE("encase", false, 0, 0.0, null),
    FURNITURE("furniture", true, 0, 0.0, null),
    GENEROUS("generous", true, 0, 0.0, null),
    LOOTING("looting", false, 0, 0.085, null),
    LOWERLIMIT("lowerLimit", false, 60, 0.0, null),
    MOBDROPS("mobDrops", false, 0, 0.0, null),
    PRECIOUSBLOCKS("preciousBlocks", true, 0, 0.0, null),
    RANDOM("random", false, 0, 0.0, null),
    ROGUESPAWNERS("rogueSpawners", true, 0, 0.0, null),
    SPAWNBUILTIN("doBuiltinSpawn", true, 0, 0.0, null),
    SPAWNCHANCE("spawnChance", false, 0, 1.0, null),
    SPAWNFREQUENCY("spawnFrequency", false, 10, 0.0, null),
    UPPERLIMIT("upperLimit", false, 100, 0.0, null);

    private final String name;
    private final Boolean defaultBoolean;
    private final Integer defaultInt;
    private final Double defaultDouble;
    private final List<Integer> defaultIntList;
    public static final String configDirName = "config/roguelike_dungeons";
    public static final String configFileName = "roguelike.cfg";
    public static boolean testing;
    private static ConfigFile instance;

    private RogueConfig(String name, Boolean defaultBoolean, Integer defaultInt, Double defaultDouble, List<Integer> defaultIntList) {
        this.name = name;
        this.defaultBoolean = defaultBoolean;
        this.defaultInt = defaultInt;
        this.defaultDouble = defaultDouble;
        this.defaultIntList = defaultIntList;
    }

    private static void setDefaults() {
        if (!instance.ContainsKey(RogueConfig.DONATURALSPAWN.name)) {
            RogueConfig.setBoolean(DONATURALSPAWN, RogueConfig.DONATURALSPAWN.defaultBoolean);
        }
        if (!instance.ContainsKey(RogueConfig.SPAWNFREQUENCY.name)) {
            RogueConfig.setInt(SPAWNFREQUENCY, RogueConfig.SPAWNFREQUENCY.defaultInt);
        }
        if (!instance.ContainsKey(RogueConfig.SPAWNCHANCE.name)) {
            RogueConfig.setDouble(SPAWNCHANCE, RogueConfig.SPAWNCHANCE.defaultDouble);
        }
        if (!instance.ContainsKey(RogueConfig.GENEROUS.name)) {
            RogueConfig.setBoolean(GENEROUS, RogueConfig.GENEROUS.defaultBoolean);
        }
        if (!instance.ContainsKey(RogueConfig.DIMENSIONWL.name)) {
            RogueConfig.setIntList(DIMENSIONWL, RogueConfig.DIMENSIONWL.defaultIntList);
        }
        if (!instance.ContainsKey(RogueConfig.DIMENSIONBL.name)) {
            RogueConfig.setIntList(DIMENSIONBL, RogueConfig.DIMENSIONBL.defaultIntList);
        }
        if (!instance.ContainsKey(RogueConfig.PRECIOUSBLOCKS.name)) {
            RogueConfig.setBoolean(PRECIOUSBLOCKS, RogueConfig.PRECIOUSBLOCKS.defaultBoolean);
        }
        if (!instance.ContainsKey(RogueConfig.LOOTING.name)) {
            RogueConfig.setDouble(LOOTING, RogueConfig.LOOTING.defaultDouble);
        }
        if (!instance.ContainsKey(RogueConfig.UPPERLIMIT.name)) {
            RogueConfig.setInt(UPPERLIMIT, RogueConfig.UPPERLIMIT.defaultInt);
        }
        if (!instance.ContainsKey(RogueConfig.LOWERLIMIT.name)) {
            RogueConfig.setInt(LOWERLIMIT, RogueConfig.LOWERLIMIT.defaultInt);
        }
        if (!instance.ContainsKey(RogueConfig.ROGUESPAWNERS.name)) {
            RogueConfig.setBoolean(ROGUESPAWNERS, RogueConfig.ROGUESPAWNERS.defaultBoolean);
        }
        if (!instance.ContainsKey(RogueConfig.ENCASE.name)) {
            RogueConfig.setBoolean(ENCASE, RogueConfig.ENCASE.defaultBoolean);
        }
        if (!instance.ContainsKey(RogueConfig.FURNITURE.name)) {
            RogueConfig.setBoolean(FURNITURE, RogueConfig.FURNITURE.defaultBoolean);
        }
        if (!instance.ContainsKey(RogueConfig.RANDOM.name)) {
            RogueConfig.setBoolean(RANDOM, RogueConfig.RANDOM.defaultBoolean);
        }
        if (!instance.ContainsKey(RogueConfig.SPAWNBUILTIN.name)) {
            RogueConfig.setBoolean(SPAWNBUILTIN, RogueConfig.SPAWNBUILTIN.defaultBoolean);
        }
    }

    public static double getDouble(RogueConfig option) {
        if (testing) {
            return option.defaultDouble;
        }
        RogueConfig.reload(false);
        return instance.GetDouble(option.name, option.defaultDouble);
    }

    public static void setDouble(RogueConfig option, double value) {
        RogueConfig.reload(false);
        instance.Set(option.name, value);
    }

    public static boolean getBoolean(RogueConfig option) {
        if (testing) {
            return option.defaultBoolean;
        }
        RogueConfig.reload(false);
        return instance.GetBoolean(option.name, option.defaultBoolean);
    }

    public static void setBoolean(RogueConfig option, Boolean value) {
        RogueConfig.reload(false);
        instance.Set(option.name, value);
    }

    public static int getInt(RogueConfig option) {
        if (testing) {
            return option.defaultInt;
        }
        RogueConfig.reload(false);
        return instance.GetInteger(option.name, option.defaultInt);
    }

    public static void setInt(RogueConfig option, int value) {
        RogueConfig.reload(false);
        instance.Set(option.name, value);
    }

    public static List<Integer> getIntList(RogueConfig option) {
        if (testing) {
            return option.defaultIntList;
        }
        RogueConfig.reload(false);
        return instance.GetListInteger(option.name, option.defaultIntList);
    }

    public static void setIntList(RogueConfig option, List<Integer> value) {
        RogueConfig.reload(false);
        instance.Set(option.name, value);
    }

    private static void init() {
        File cfile;
        if (testing) {
            return;
        }
        File configDir = new File(configDirName);
        if (!configDir.exists()) {
            configDir.mkdir();
        }
        if (!(cfile = new File("config/roguelike_dungeons/roguelike.cfg")).exists()) {
            try {
                cfile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            instance = new ConfigFile("config/roguelike_dungeons/roguelike.cfg", new INIParser());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        RogueConfig.setDefaults();
        try {
            instance.Write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reload(boolean force) {
        if (instance == null || force) {
            RogueConfig.init();
        }
    }

    static {
        testing = false;
        instance = null;
    }
}

