/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms.prototype;

import greymerk.roguelike.dungeon.Dungeon;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.treasure.loot.ChestType;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.IStair;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import greymerk.roguelike.worldgen.spawners.MobType;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class BrickRoom
extends DungeonBase {
    public BrickRoom(RoomSetting roomSetting) {
        super(roomSetting);
    }

    @Override
    public DungeonBase generate(WorldEditor editor, Random rand, LevelSettings settings, Coord origin, Cardinal[] entrances) {
        int x = origin.getX();
        int y = origin.getY();
        int z = origin.getZ();
        ITheme theme = settings.getTheme();
        IStair stair = theme.getPrimary().getStair();
        IBlockFactory blocks = theme.getPrimary().getWall();
        IBlockFactory pillar = theme.getPrimary().getPillar();
        MetaBlock air = BlockType.get(BlockType.AIR);
        RectSolid.fill(editor, rand, new Coord(x - 3, y, z - 3), new Coord(x + 3, y + 3, z + 3), air);
        RectSolid.fill(editor, rand, new Coord(x - 1, y + 4, z - 1), new Coord(x + 1, y + 4, z + 1), air);
        RectHollow.fill(editor, rand, new Coord(x - 4, y - 1, z - 4), new Coord(x + 4, y + 4, z + 4), blocks, false, true);
        RectSolid.fill(editor, rand, new Coord(x - 4, y - 1, z - 4), new Coord(x + 4, y - 1, z + 4), theme.getPrimary().getFloor(), false, true);
        Coord cursor = new Coord(x, y, z);
        cursor.translate(Cardinal.UP, 5);
        air.set(editor, cursor);
        cursor.translate(Cardinal.UP, 1);
        blocks.set(editor, rand, cursor);
        ArrayList<Coord> potentialChestLocations = new ArrayList<Coord>();
        for (Cardinal dir : Cardinal.directions) {
            cursor = new Coord(x, y, z);
            cursor.translate(dir, 1);
            cursor.translate(Cardinal.UP, 5);
            stair.setOrientation(dir.reverse(), true);
            stair.set(editor, rand, cursor, false, true);
            cursor.translate(dir.antiClockwise(), 1);
            blocks.set(editor, rand, cursor, false, true);
            cursor = new Coord(x, y, z);
            cursor.translate(dir, 2);
            cursor.translate(Cardinal.UP, 4);
            air.set(editor, cursor);
            cursor.translate(Cardinal.UP, 1);
            blocks.set(editor, rand, cursor, false, true);
            cursor = new Coord(x, y, z);
            cursor.translate(dir, 3);
            cursor.translate(dir.antiClockwise(), 3);
            Coord start = new Coord(cursor);
            cursor.translate(Cardinal.UP, 2);
            Coord end = new Coord(cursor);
            RectSolid.fill(editor, rand, start, end, pillar, true, true);
            cursor.translate(Cardinal.UP, 1);
            blocks.set(editor, rand, cursor);
            for (Cardinal orth : dir.orthogonal()) {
                cursor = new Coord(x, y, z);
                cursor.translate(dir, 3);
                cursor.translate(orth, 2);
                cursor.translate(Cardinal.UP, 3);
                stair.setOrientation(orth.reverse(), true);
                stair.set(editor, rand, cursor);
            }
            cursor = new Coord(x, y, z);
            cursor.translate(dir, 2);
            cursor.translate(dir.antiClockwise(), 2);
            cursor.translate(Cardinal.UP, 4);
            blocks.set(editor, rand, cursor, false, true);
            for (Cardinal orth : dir.orthogonal()) {
                cursor = new Coord(x, y, z);
                cursor.translate(Cardinal.UP, 4);
                cursor.translate(dir, 2);
                cursor.translate(orth, 1);
                stair.setOrientation(orth.reverse(), true);
                stair.set(editor, rand, cursor, false, true);
            }
            cursor = new Coord(x, y, z);
            cursor.translate(dir, 1);
            cursor.translate(dir.antiClockwise(), 1);
            cursor.translate(Cardinal.UP, 5);
            blocks.set(editor, rand, cursor, false, true);
            for (Cardinal orth : dir.orthogonal()) {
                cursor = new Coord(x, y, z);
                cursor.translate(dir, 3);
                cursor.translate(orth, 2);
                potentialChestLocations.add(cursor);
            }
        }
        List<Coord> chestLocations = BrickRoom.chooseRandomLocations(rand, 1, potentialChestLocations);
        int level = Dungeon.getLevel(origin.getY());
        editor.treasureChestEditor.createChests(level, chestLocations, false, this.getRoomSetting().getChestType().orElse(ChestType.chooseRandomType(rand, ChestType.COMMON_TREASURES)));
        Coord spawnerLocation = new Coord(x, y, z);
        this.generateSpawner(editor, rand, spawnerLocation, Dungeon.getLevel(origin.getY()), settings.getSpawners(), new MobType[0]);
        return this;
    }

    @Override
    public int getSize() {
        return 6;
    }
}

