/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms.prototype;

import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.treasure.loot.ChestType;
import greymerk.roguelike.worldgen.BlockWeightedRandom;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.IStair;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.blocks.Crops;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import greymerk.roguelike.worldgen.spawners.MobType;
import java.util.List;
import java.util.Random;

public class FortressRoom
extends DungeonBase {
    public FortressRoom(RoomSetting roomSetting) {
        super(roomSetting);
    }

    @Override
    public DungeonBase generate(WorldEditor editor, Random rand, LevelSettings levelSettings, Coord origin, Cardinal[] entrances) {
        ITheme theme = levelSettings.getTheme();
        IBlockFactory wall = theme.getPrimary().getWall();
        IStair stair = theme.getPrimary().getStair();
        IBlockFactory liquid = theme.getPrimary().getLiquid();
        MetaBlock air = BlockType.get(BlockType.AIR);
        BlockWeightedRandom netherwart = new BlockWeightedRandom();
        netherwart.addBlock(air, 3);
        netherwart.addBlock(Crops.get(Crops.NETHERWART), 1);
        Coord start = new Coord(origin);
        Coord end = new Coord(origin);
        start.translate(new Coord(-8, -1, -8));
        end.translate(new Coord(8, 6, 8));
        RectHollow.fill(editor, rand, start, end, wall, false, true);
        start = new Coord(origin);
        end = new Coord(origin);
        start.translate(new Coord(-4, 6, -4));
        end.translate(new Coord(4, 6, 4));
        RectSolid.fill(editor, rand, start, end, wall);
        start = new Coord(origin);
        end = new Coord(origin);
        start.translate(new Coord(-3, 7, -3));
        end.translate(new Coord(3, 7, 3));
        RectSolid.fill(editor, rand, start, end, wall);
        start = new Coord(origin);
        end = new Coord(origin);
        start.translate(new Coord(-2, 7, -2));
        end.translate(new Coord(2, 7, 2));
        RectSolid.fill(editor, rand, start, end, liquid);
        start = new Coord(origin);
        end = new Coord(origin);
        start.translate(new Coord(-4, -1, -4));
        end.translate(new Coord(4, -3, 4));
        RectSolid.fill(editor, rand, start, end, wall, false, true);
        start = new Coord(origin);
        end = new Coord(origin);
        start.translate(new Coord(-3, -2, -3));
        end.translate(new Coord(3, -2, 3));
        BlockType.get(BlockType.SOUL_SAND).fill(editor, rand, new RectSolid(start, end), false, true);
        start = new Coord(origin);
        end = new Coord(origin);
        start.translate(new Coord(-3, -1, -3));
        end.translate(new Coord(3, -1, 3));
        RectSolid.fill(editor, rand, start, end, netherwart, false, true);
        List<Coord> chests = new RectSolid(start, end).get();
        List<Coord> chestLocations = FortressRoom.chooseRandomLocations(rand, rand.nextInt(3) + 1, chests);
        editor.treasureChestEditor.createChests(levelSettings.getDifficulty(origin), chestLocations, false, this.getRoomSetting().getChestType().orElse(ChestType.chooseRandomType(rand, ChestType.RARE_TREASURES)));
        for (Cardinal dir : Cardinal.directions) {
            start = new Coord(origin);
            start.translate(Cardinal.UP, 5);
            start.translate(dir, 4);
            end = new Coord(start);
            start.translate(dir.antiClockwise(), 6);
            end.translate(dir.clockwise(), 6);
            RectSolid.fill(editor, rand, start, end, wall);
            start = new Coord(origin);
            start.translate(Cardinal.UP, 5);
            start.translate(dir, 6);
            end = new Coord(start);
            start.translate(dir.antiClockwise(), 6);
            end.translate(dir.clockwise(), 6);
            RectSolid.fill(editor, rand, start, end, wall);
            start = new Coord(origin);
            start.translate(Cardinal.DOWN);
            start.translate(dir, 4);
            end = new Coord(start);
            start.translate(dir.antiClockwise(), 2);
            end.translate(dir.clockwise(), 2);
            stair.setOrientation(dir.reverse(), false).fill(editor, rand, new RectSolid(start, end));
            Coord cursor = new Coord(origin);
            cursor.translate(dir, 4);
            cursor.translate(dir.antiClockwise(), 4);
            this.supportPillar(editor, rand, levelSettings, cursor);
            for (Cardinal o : dir.orthogonal()) {
                cursor = new Coord(origin);
                cursor.translate(dir, 7);
                cursor.translate(o, 2);
                this.pillar(editor, rand, levelSettings, cursor);
                cursor.translate(o);
                cursor.translate(o);
                cursor.translate(o);
                this.pillar(editor, rand, levelSettings, cursor);
            }
        }
        return this;
    }

    private void supportPillar(WorldEditor editor, Random rand, LevelSettings levelSettings, Coord origin) {
        Coord end;
        Coord start;
        ITheme theme = levelSettings.getTheme();
        IBlockFactory pillar = theme.getPrimary().getPillar();
        IStair stair = theme.getPrimary().getStair();
        MetaBlock lava = BlockType.get(BlockType.LAVA_FLOWING);
        for (Cardinal dir : Cardinal.directions) {
            start = new Coord(origin);
            start.translate(dir);
            end = new Coord(start);
            end.translate(Cardinal.UP, 5);
            RectSolid.fill(editor, rand, start, end, pillar);
            Coord cursor = new Coord(origin);
            cursor.translate(dir, 2);
            cursor.translate(Cardinal.UP, 4);
            stair.setOrientation(dir, true).set(editor, cursor);
        }
        start = new Coord(origin);
        end = new Coord(start);
        end.translate(Cardinal.UP, 5);
        RectSolid.fill(editor, rand, start, end, lava);
        List<Coord> core = new RectSolid(start, end).get();
        Coord spawnerLocation = core.get(rand.nextInt(core.size()));
        int difficulty = levelSettings.getDifficulty(spawnerLocation);
        this.generateSpawner(editor, rand, spawnerLocation, difficulty, levelSettings.getSpawners(), new MobType[0]);
    }

    private void pillar(WorldEditor editor, Random rand, LevelSettings settings, Coord origin) {
        ITheme theme = settings.getTheme();
        IBlockFactory wall = theme.getPrimary().getWall();
        IBlockFactory pillar = theme.getPrimary().getPillar();
        IStair stair = theme.getPrimary().getStair();
        Coord start = new Coord(origin);
        Coord end = new Coord(start);
        end.translate(Cardinal.UP, 5);
        RectSolid.fill(editor, rand, start, end, pillar);
        for (Cardinal dir : Cardinal.directions) {
            Coord cursor = new Coord(origin);
            cursor.translate(Cardinal.UP, 4);
            cursor.translate(dir);
            stair.setOrientation(dir, true).set(editor, rand, cursor, true, false);
            cursor.translate(Cardinal.UP);
            wall.set(editor, rand, cursor);
        }
    }

    @Override
    public int getSize() {
        return 10;
    }
}

