/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import greymerk.roguelike.dungeon.LevelGenerator;
import greymerk.roguelike.dungeon.base.RoomsSetting;
import greymerk.roguelike.dungeon.base.SecretsSetting;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.rooms.RoomSettingParser;
import greymerk.roguelike.dungeon.segment.SegmentGenerator;
import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import greymerk.roguelike.dungeon.settings.SettingsType;
import greymerk.roguelike.dungeon.settings.SpawnCriteria;
import greymerk.roguelike.dungeon.settings.TowerSettings;
import greymerk.roguelike.dungeon.settings.level.LevelsParser;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.theme.ThemeParser;
import greymerk.roguelike.treasure.loot.LootRuleManager;
import greymerk.roguelike.treasure.loot.LootRulesParser;
import greymerk.roguelike.treasure.loot.LootTableRule;
import greymerk.roguelike.worldgen.filter.Filter;
import java.util.ArrayList;
import java.util.List;

public class DungeonSettingsParser {
    public static DungeonSettings parseJson(String content) throws Exception {
        try {
            JsonObject parse;
            JsonParser jsonParser = new JsonParser();
            try {
                parse = (JsonObject)jsonParser.parse(content);
            }
            catch (JsonSyntaxException e) {
                Throwable cause = e.getCause();
                throw new Exception(cause.getMessage());
            }
            return DungeonSettingsParser.parseDungeonSettings(parse);
        }
        catch (Exception e) {
            throw new Exception("An unknown error occurred while parsing json: " + e.getClass().toString() + " " + e.getMessage());
        }
    }

    public static DungeonSettings parseDungeonSettings(JsonObject root) throws Exception {
        DungeonSettings dungeonSettings = new DungeonSettings();
        for (int i = 0; i < DungeonSettings.getMaxNumLevels(); ++i) {
            LevelSettings setting = new LevelSettings();
            dungeonSettings.getLevels().put(i, setting);
        }
        DungeonSettingsParser.parseId(root, dungeonSettings);
        DungeonSettingsParser.parseExclusive(root, dungeonSettings);
        DungeonSettingsParser.parseCriteria(root, dungeonSettings);
        DungeonSettingsParser.parseTower(root, dungeonSettings);
        DungeonSettingsParser.parseLootRules(root, dungeonSettings);
        DungeonSettingsParser.parseOverrides(root, dungeonSettings);
        DungeonSettingsParser.parseInherit(root, dungeonSettings);
        DungeonSettingsParser.parseLootTables(root, dungeonSettings);
        DungeonSettingsParser.parseRoomCount(root, dungeonSettings);
        DungeonSettingsParser.parseScatter(root, dungeonSettings);
        DungeonSettingsParser.parseLayouts(root, dungeonSettings);
        DungeonSettingsParser.parseSpawners(root, dungeonSettings);
        DungeonSettingsParser.parseRooms(root, dungeonSettings);
        DungeonSettingsParser.parseThemes(root, dungeonSettings);
        DungeonSettingsParser.parseSegments(root, dungeonSettings);
        DungeonSettingsParser.parseFilters(root, dungeonSettings);
        return dungeonSettings;
    }

    private static void parseId(JsonObject root, DungeonSettings dungeonSettings) throws Exception {
        if (!root.has("name")) {
            throw new Exception("Setting missing name");
        }
        if (root.has("namespace")) {
            String name = root.get("name").getAsString();
            String namespace = root.get("namespace").getAsString();
            dungeonSettings.setId(new SettingIdentifier(namespace, name));
        } else {
            dungeonSettings.setId(new SettingIdentifier(root.get("name").getAsString()));
        }
    }

    private static void parseExclusive(JsonObject root, DungeonSettings dungeonSettings) {
        if (root.has("exclusive")) {
            dungeonSettings.setExclusive(root.get("exclusive").getAsBoolean());
        }
    }

    private static void parseCriteria(JsonObject root, DungeonSettings dungeonSettings) {
        if (root.has("criteria")) {
            dungeonSettings.setSpawnCriteria(new SpawnCriteria(root.get("criteria").getAsJsonObject()));
        }
    }

    private static void parseTower(JsonObject root, DungeonSettings dungeonSettings) throws Exception {
        if (root.has("tower")) {
            dungeonSettings.setTowerSettings(new TowerSettings(root.get("tower")));
        }
    }

    private static void parseLootRules(JsonObject root, DungeonSettings dungeonSettings) throws Exception {
        if (root.has("loot_rules")) {
            LootRuleManager lootRuleManager = new LootRuleManager();
            lootRuleManager.addAll(new LootRulesParser().parseLootRules(root.get("loot_rules")));
            dungeonSettings.setLootRules(lootRuleManager);
        }
    }

    private static void parseOverrides(JsonObject root, DungeonSettings dungeonSettings) {
        if (root.has("overrides")) {
            JsonArray overrides = root.get("overrides").getAsJsonArray();
            for (JsonElement jsonElement : overrides) {
                if (jsonElement.isJsonNull()) continue;
                dungeonSettings.getOverrides().add(SettingsType.valueOf(jsonElement.getAsString()));
            }
        }
    }

    private static void parseInherit(JsonObject root, DungeonSettings dungeonSettings) {
        if (root.has("inherit")) {
            JsonArray inherit = root.get("inherit").getAsJsonArray();
            for (JsonElement jsonElement : inherit) {
                if (jsonElement.isJsonNull()) continue;
                dungeonSettings.getInherit().add(new SettingIdentifier(jsonElement.getAsString()));
            }
        }
    }

    private static void parseLootTables(JsonObject root, DungeonSettings dungeonSettings) throws Exception {
        if (root.has("loot_tables")) {
            JsonArray lootTables = root.get("loot_tables").getAsJsonArray();
            for (JsonElement jsonElement : lootTables) {
                if (jsonElement.isJsonNull()) continue;
                dungeonSettings.getLootTables().add(new LootTableRule(jsonElement.getAsJsonObject()));
            }
        }
    }

    private static void parseRoomCount(JsonObject root, DungeonSettings dungeonSettings) {
        if (root.has("num_rooms")) {
            JsonArray arr = root.get("num_rooms").getAsJsonArray();
            for (int i = 0; i < arr.size(); ++i) {
                JsonElement jsonElement = arr.get(i);
                if (jsonElement.isJsonNull()) continue;
                LevelSettings setting = dungeonSettings.getLevels().get(i);
                setting.setNumRooms(jsonElement.getAsInt());
            }
        }
    }

    private static void parseScatter(JsonObject root, DungeonSettings dungeonSettings) {
        if (root.has("scatter")) {
            JsonArray arr = root.get("scatter").getAsJsonArray();
            for (int i = 0; i < arr.size(); ++i) {
                JsonElement jsonElement = arr.get(i);
                if (jsonElement.isJsonNull()) continue;
                LevelSettings setting = dungeonSettings.getLevels().get(i);
                setting.setScatter(jsonElement.getAsInt());
            }
        }
    }

    private static void parseLayouts(JsonObject root, DungeonSettings dungeonSettings) {
        if (!root.has("layouts")) {
            return;
        }
        JsonArray layouts = root.get("layouts").getAsJsonArray();
        for (JsonElement jsonElement : layouts) {
            JsonObject layout;
            if (jsonElement.isJsonNull() || !(layout = jsonElement.getAsJsonObject()).has("level")) continue;
            List<Integer> levels = LevelsParser.parseLevelsIfPresent(layout);
            for (Integer level : levels) {
                if (!dungeonSettings.getLevels().containsKey(level)) continue;
                LevelSettings setting = dungeonSettings.getLevels().get(level);
                setting.setGenerator(LevelGenerator.valueOf(layout.get("type").getAsString().toUpperCase()));
            }
        }
    }

    private static void parseRooms(JsonObject root, DungeonSettings dungeonSettings) throws Exception {
        if (!root.has("rooms")) {
            return;
        }
        JsonArray roomArray = root.get("rooms").getAsJsonArray();
        for (int floorLevel : dungeonSettings.getLevels().keySet()) {
            RoomsSetting roomsSetting = new RoomsSetting();
            SecretsSetting secretsSetting = new SecretsSetting();
            for (JsonElement roomSettingElement : roomArray) {
                JsonObject roomSettingJson;
                RoomSetting roomSetting;
                if (roomSettingElement.isJsonNull() || !(roomSetting = RoomSettingParser.parse(roomSettingJson = roomSettingElement.getAsJsonObject())).isOnFloorLevel(floorLevel)) continue;
                if (roomSetting.isSecret()) {
                    secretsSetting.add(roomSetting);
                    continue;
                }
                roomsSetting.add(roomSetting);
            }
            LevelSettings level = dungeonSettings.getLevels().get(floorLevel);
            level.setRooms(roomsSetting);
            level.setSecrets(secretsSetting);
        }
    }

    private static void parseThemes(JsonObject root, DungeonSettings dungeonSettings) throws Exception {
        if (!root.has("themes")) {
            return;
        }
        JsonArray arr = root.get("themes").getAsJsonArray();
        for (JsonElement jsonElement : arr) {
            JsonObject entry;
            List<Integer> lvls;
            if (jsonElement.isJsonNull() || (lvls = LevelsParser.parseLevelsIfPresent(entry = jsonElement.getAsJsonObject())) == null) continue;
            for (int i : lvls) {
                if (!dungeonSettings.getLevels().containsKey(i)) continue;
                LevelSettings settings = dungeonSettings.getLevels().get(i);
                ITheme theme = ThemeParser.parse(entry);
                settings.setTheme(theme);
            }
        }
    }

    private static void parseSegments(JsonObject root, DungeonSettings dungeonSettings) {
        if (!root.has("segments")) {
            return;
        }
        JsonArray arr = root.get("segments").getAsJsonArray();
        for (int lvl : dungeonSettings.getLevels().keySet()) {
            boolean hasEntry = false;
            SegmentGenerator segments = new SegmentGenerator();
            for (JsonElement jsonElement : arr) {
                JsonObject entry;
                List<Integer> lvls;
                if (jsonElement.isJsonNull() || !(lvls = LevelsParser.parseLevelsIfPresent(entry = jsonElement.getAsJsonObject())).contains(lvl)) continue;
                hasEntry = true;
                segments.add(entry);
            }
            if (!hasEntry) continue;
            dungeonSettings.getLevels().get(lvl).setSegments(segments);
        }
    }

    private static void parseSpawners(JsonObject root, DungeonSettings dungeonSettings) throws Exception {
        if (!root.has("spawners")) {
            return;
        }
        JsonArray spawnersJson = root.get("spawners").getAsJsonArray();
        for (JsonElement spawnerJsonElement : spawnersJson) {
            if (spawnerJsonElement.isJsonNull()) continue;
            JsonObject spawnerJson = spawnerJsonElement.getAsJsonObject();
            List<Integer> lvls = LevelsParser.parseLevelsIfPresent(spawnerJson);
            for (int i : lvls) {
                if (!dungeonSettings.getLevels().containsKey(i)) continue;
                dungeonSettings.getLevels().get(i).getSpawners().parse(spawnerJson);
            }
        }
    }

    private static void parseFilters(JsonObject root, DungeonSettings dungeonSettings) {
        if (!root.has("filters")) {
            return;
        }
        JsonArray arr = root.get("filters").getAsJsonArray();
        for (JsonElement jsonElement : arr) {
            if (jsonElement.isJsonNull()) continue;
            JsonObject entry = jsonElement.getAsJsonObject();
            List<Integer> lvls = LevelsParser.parseLevelsIfPresent(entry);
            for (int i : lvls) {
                if (!dungeonSettings.getLevels().containsKey(i)) continue;
                String name = entry.get("name").getAsString();
                Filter type = Filter.valueOf(name.toUpperCase());
                LevelSettings level = dungeonSettings.getLevels().get(i);
                level.addFilter(type);
            }
        }
    }

    private static List<RoomSetting> parseRoomSettings(JsonArray roomArray) throws Exception {
        ArrayList roomSettings = Lists.newArrayList();
        for (JsonElement roomSettingElement : roomArray) {
            if (roomSettingElement.isJsonNull()) continue;
            JsonObject roomSettingJson = roomSettingElement.getAsJsonObject();
            roomSettings.add(RoomSettingParser.parse(roomSettingJson));
        }
        return roomSettings;
    }
}

