/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.treasure.loot.ChestType;
import greymerk.roguelike.treasure.loot.Loot;
import greymerk.roguelike.treasure.loot.rule.ForEachLootRule;
import greymerk.roguelike.treasure.loot.rule.LootRule;
import greymerk.roguelike.treasure.loot.rule.SingleUseLootRule;
import greymerk.roguelike.treasure.loot.rule.TypedForEachLootRule;
import greymerk.roguelike.treasure.loot.rule.TypedSingleUseLootRule;
import greymerk.roguelike.util.IWeighted;
import greymerk.roguelike.util.WeightedRandomizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.ItemStack;

public class LootRulesParser {
    public List<LootRule> parseLootRules(JsonElement jsonElement) throws Exception {
        ArrayList<LootRule> lootRules = new ArrayList<LootRule>();
        for (JsonElement ruleElement : jsonElement.getAsJsonArray()) {
            JsonObject rule;
            if (ruleElement.isJsonNull() || !(rule = ruleElement.getAsJsonObject()).has("loot")) continue;
            Optional<ChestType> chestType = rule.has("type") ? Optional.of(new ChestType(rule.get("type").getAsString())) : (rule.has("chestType") ? Optional.of(new ChestType(rule.get("chestType").getAsString())) : Optional.empty());
            JsonArray data = rule.get("loot").getAsJsonArray();
            WeightedRandomizer<ItemStack> items = new WeightedRandomizer<ItemStack>(1);
            for (JsonElement item : data) {
                if (item.isJsonNull()) continue;
                items.add(this.parseProvider(item.getAsJsonObject()));
            }
            ArrayList<Integer> levels = new ArrayList<Integer>();
            JsonElement levelElement = rule.get("level");
            if (levelElement.isJsonArray()) {
                JsonArray levelArray = levelElement.getAsJsonArray();
                for (JsonElement lvl : levelArray) {
                    if (lvl.isJsonNull()) continue;
                    levels.add(lvl.getAsInt());
                }
            } else {
                levels.add(rule.get("level").getAsInt());
            }
            boolean each = rule.get("each").getAsBoolean();
            int amount = rule.get("quantity").getAsInt();
            Iterator iterator = levels.iterator();
            while (iterator.hasNext()) {
                int level = (Integer)iterator.next();
                lootRules.add(this.newLootRule(items, amount, level, each, chestType));
            }
        }
        return lootRules;
    }

    private LootRule newLootRule(WeightedRandomizer<ItemStack> items, int amount, int level, boolean each, Optional<ChestType> chestType) {
        if (each && chestType.isPresent()) {
            return new TypedForEachLootRule(chestType.get(), items, level, amount);
        }
        if (each) {
            return new ForEachLootRule(items, level, amount);
        }
        if (chestType.isPresent()) {
            return new TypedSingleUseLootRule(chestType.get(), items, level, amount);
        }
        return new SingleUseLootRule(items, level, amount);
    }

    private IWeighted<ItemStack> parseProvider(JsonObject lootItem) throws Exception {
        int weight;
        int n = weight = lootItem.has("weight") ? lootItem.get("weight").getAsInt() : 1;
        if (lootItem.get("data").isJsonObject()) {
            JsonObject data = lootItem.get("data").getAsJsonObject();
            return Loot.get(data, weight);
        }
        JsonArray data = lootItem.get("data").getAsJsonArray();
        WeightedRandomizer<ItemStack> items = new WeightedRandomizer<ItemStack>(weight);
        for (JsonElement jsonElement : data) {
            if (jsonElement.isJsonNull()) continue;
            items.add(this.parseProvider(jsonElement.getAsJsonObject()));
        }
        return items;
    }
}

