/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.spawners;

import com.google.common.collect.Lists;
import greymerk.roguelike.worldgen.spawners.SpawnPotential;
import greymerk.roguelike.worldgen.spawners.Spawnable;
import greymerk.roguelike.worldgen.spawners.SpawnerSettings;
import java.util.Arrays;
import net.minecraft.nbt.NBTTagCompound;

public enum MobType {
    BAT("bat"),
    BLAZE("blaze"),
    CAVESPIDER("cave_spider"),
    CREEPER("creeper"),
    ENDERMAN("enderman"),
    GHAST("ghast"),
    LAVASLIME("magma_cube"),
    PIGZOMBIE("zombie_pigman"),
    PRIMEDTNT("tnt"),
    SILVERFISH("silverfish"),
    SKELETON("skeleton"),
    SLIME("slime"),
    SPIDER("spider"),
    WITCH("witch"),
    WITHERBOSS("wither"),
    WITHERSKELETON("wither_skeleton"),
    ZOMBIE("zombie");

    public static final MobType[] COMMON_MOBS;
    public static final MobType[] UNCOMMON_MOBS;
    public static final MobType[] RARE_MOBS;
    public static final MobType[] EPIC_MOBS;
    public static final MobType[] LEGENDARY_MOBS;
    public static final MobType[] HUMANOID_MOBS;
    public static final MobType[] UNDEAD_MOBS;
    public static final MobType[] NETHER_MOBS;
    private String name;

    private MobType(String name) {
        this.name = "minecraft:" + name;
    }

    public String getName() {
        return this.name;
    }

    public SpawnerSettings newSpawnerSetting() {
        return MobType.newSpawnerSetting(this);
    }

    public static SpawnerSettings newSpawnerSetting(MobType ... mobTypes) {
        SpawnerSettings spawnerSettings = new SpawnerSettings();
        Arrays.stream(mobTypes).map(spawner -> new SpawnPotential(spawner.getName(), true, 1, new NBTTagCompound())).map(spawnPotential -> new Spawnable(Lists.newArrayList((Object[])new SpawnPotential[]{spawnPotential}))).forEach(spawnable -> spawnerSettings.add((Spawnable)spawnable, 1));
        return spawnerSettings;
    }

    static {
        COMMON_MOBS = new MobType[]{SKELETON, SPIDER, ZOMBIE};
        UNCOMMON_MOBS = new MobType[]{CAVESPIDER, CREEPER};
        RARE_MOBS = new MobType[]{ENDERMAN, SLIME, WITCH};
        EPIC_MOBS = new MobType[]{WITHERBOSS};
        LEGENDARY_MOBS = new MobType[0];
        HUMANOID_MOBS = new MobType[]{SKELETON, WITCH, ZOMBIE};
        UNDEAD_MOBS = new MobType[]{SKELETON, ZOMBIE};
        NETHER_MOBS = new MobType[]{BLAZE, LAVASLIME, PIGZOMBIE, WITHERSKELETON};
    }
}

