/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.dawnoftimebuilder.blocks.DoTBBlocks;
import org.dawnoftimebuilder.blocks.IBlockFlowerGen;

public class DoTBWorldGen {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onWorldDecoration(DecorateBiomeEvent.Decorate event) {
        BlockPos pos;
        BlockPos blockPos = pos = event.getPlacementPos() != null ? event.getPlacementPos() : event.getChunkPos().func_180331_a(0, 0, 0);
        if ((event.getResult() == Event.Result.ALLOW || event.getResult() == Event.Result.DEFAULT) && event.getType() == DecorateBiomeEvent.Decorate.EventType.FLOWERS) {
            DoTBWorldGen.decorateWorldWith(event.getWorld(), pos, DoTBBlocks.rice, event.getRand());
            DoTBWorldGen.decorateWorldWith(event.getWorld(), pos, DoTBBlocks.camellia, event.getRand());
            DoTBWorldGen.decorateWorldWith(event.getWorld(), pos, DoTBBlocks.mulberry, event.getRand());
        }
    }

    private static void decorateWorldWith(World world, BlockPos pos, IBlockFlowerGen flower, Random rand) {
        ResourceLocation resource = world.func_180494_b(pos).getRegistryName();
        if (resource == null) {
            return;
        }
        if (flower.getAcceptedBiomes().contains(resource.func_110623_a())) {
            int dist = flower.getPatchSize();
            for (int i = 0; i < flower.getPatchQuantity(); ++i) {
                if (rand.nextInt(flower.getPatchChance()) != 0) continue;
                int x = pos.func_177958_n() + rand.nextInt(16) + 8;
                int z = pos.func_177952_p() + rand.nextInt(16) + 8;
                int j = 0;
                while ((double)j < Math.ceil((double)flower.getPatchDensity() * (rand.nextDouble() + 0.5))) {
                    int newZ;
                    int newX = x + rand.nextInt(dist * 2) - dist;
                    BlockPos newPos = DoTBWorldGen.getSurfacePos(world, newX, newZ = z + rand.nextInt(dist * 2) - dist);
                    if (newPos.func_177956_o() < 127) {
                        flower.spawnInWorld(world, newPos, rand);
                    }
                    ++j;
                }
            }
        }
    }

    private static BlockPos getSurfacePos(World world, int x, int z) {
        Chunk chunk = world.func_175726_f(new BlockPos(x, 0, z));
        for (int y = chunk.func_76625_h() + 16; y >= 0; --y) {
            BlockPos pos = new BlockPos(x, y, z);
            IBlockState state = chunk.func_177435_g(pos);
            if (state.func_177230_c() == Blocks.field_150350_a || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos) || state.func_177230_c().isFoliage((IBlockAccess)world, pos)) continue;
            return pos.func_177984_a();
        }
        return new BlockPos(x, 200, z);
    }
}

