/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.french;

import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.dawnoftimebuilder.DoTBUtils;
import org.dawnoftimebuilder.blocks.french.BlockOakShutters;
import org.dawnoftimebuilder.blocks.general.DoTBBlock;

public class BlockSmallOakShutters
extends DoTBBlock {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static final PropertyEnum<BlockOakShutters.EnumOpenPosition> OPEN = PropertyEnum.func_177709_a((String)"open", BlockOakShutters.EnumOpenPosition.class);
    private static final PropertyEnum<BlockOakShutters.EnumHingePosition> HINGE = PropertyEnum.func_177709_a((String)"hinge", BlockOakShutters.EnumHingePosition.class);
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB NORTH_FULL_RIGHT_AABB = new AxisAlignedBB(0.0, 0.0, 0.8125, 0.1875, 1.0, 1.0);
    private static final AxisAlignedBB NORTH_FULL_LEFT_AABB = new AxisAlignedBB(0.8125, 0.0, 0.8125, 1.0, 1.0, 1.0);

    public BlockSmallOakShutters() {
        super("small_oak_shutters", Material.field_151575_d);
        this.field_149783_u = true;
        this.setBurnable();
        this.func_149713_g(255);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(OPEN, (Comparable)((Object)BlockOakShutters.EnumOpenPosition.CLOSED)).func_177226_a(HINGE, (Comparable)((Object)BlockOakShutters.EnumHingePosition.LEFT)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        boolean hinge;
        boolean bl = hinge = (state = state.func_185899_b(source, pos)).func_177229_b(HINGE) == BlockOakShutters.EnumHingePosition.RIGHT;
        if (state.func_177229_b(OPEN) == BlockOakShutters.EnumOpenPosition.FULL) {
            return DoTBUtils.getRotatedAABB(hinge ? NORTH_FULL_RIGHT_AABB : NORTH_FULL_LEFT_AABB, (EnumFacing)state.func_177229_b((IProperty)FACING));
        }
        return DoTBUtils.getRotatedAABB(NORTH_AABB, state.func_177229_b(OPEN) == BlockOakShutters.EnumOpenPosition.CLOSED ? (EnumFacing)state.func_177229_b((IProperty)FACING) : (hinge ? ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176746_e() : ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176735_f()));
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_185899_b(world, pos).func_177229_b(OPEN) == BlockOakShutters.EnumOpenPosition.CLOSED ? 255 : 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return this.func_176201_c(worldIn.func_180495_p(pos)) < 8;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    private int getCloseSound() {
        return 1012;
    }

    private int getOpenSound() {
        return 1006;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return BlockPlanks.EnumType.OAK.func_181070_c();
    }

    private static BlockOakShutters.EnumOpenPosition getOpenPosition(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        pos = pos.func_177972_a(state.func_177229_b(HINGE) == BlockOakShutters.EnumHingePosition.LEFT ? ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176746_e() : ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176735_f());
        boolean bot = !(worldIn.func_180495_p(pos).func_177230_c() instanceof BlockSmallOakShutters) && !(worldIn.func_180495_p(pos).func_177230_c() instanceof BlockOakShutters) && worldIn.func_180495_p(pos).func_185890_d(worldIn, pos) == Block.field_185506_k;
        return bot ? BlockOakShutters.EnumOpenPosition.FULL : BlockOakShutters.EnumOpenPosition.HALF;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (state.func_177230_c() instanceof BlockSmallOakShutters) {
            state = state.func_177229_b(OPEN) != BlockOakShutters.EnumOpenPosition.CLOSED ? state.func_177226_a(OPEN, (Comparable)((Object)BlockOakShutters.EnumOpenPosition.CLOSED)) : state.func_177226_a(OPEN, (Comparable)((Object)BlockSmallOakShutters.getOpenPosition(state, (IBlockAccess)worldIn, pos)));
            worldIn.func_180501_a(pos, state, 10);
            worldIn.func_180498_a(playerIn, state.func_177229_b(OPEN) == BlockOakShutters.EnumOpenPosition.CLOSED ? this.getCloseSound() : this.getOpenSound(), pos, 0);
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing direction = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d();
        if (!BlockSmallOakShutters.canSupportShutters(worldIn, pos.func_177972_a(direction).func_177972_a(state.func_177229_b(HINGE) == BlockOakShutters.EnumHingePosition.LEFT ? direction.func_176735_f() : direction.func_176746_e()), direction, (BlockOakShutters.EnumHingePosition)((Object)state.func_177229_b(HINGE)))) {
            worldIn.func_175698_g(pos);
            if (!worldIn.field_72995_K) {
                this.func_176226_b(worldIn, pos, state, 0);
            }
        }
        if (state.func_177229_b(OPEN) != BlockOakShutters.EnumOpenPosition.CLOSED) {
            worldIn.func_180501_a(pos, state.func_177226_a(OPEN, (Comparable)((Object)BlockSmallOakShutters.getOpenPosition(state, (IBlockAccess)worldIn, pos))), 2);
        }
    }

    private static boolean canSupportShutters(World worldIn, BlockPos pos, EnumFacing direction, BlockOakShutters.EnumHingePosition hinge) {
        return worldIn.func_180495_p(pos).func_193401_d((IBlockAccess)worldIn, pos, direction) == BlockFaceShape.SOLID || worldIn.func_180495_p(pos).func_193401_d((IBlockAccess)worldIn, pos, hinge == BlockOakShutters.EnumHingePosition.LEFT ? direction.func_176735_f() : direction.func_176746_e()) == BlockFaceShape.SOLID;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        int i = facing.func_82601_c();
        int j = facing.func_82599_e();
        BlockOakShutters.EnumHingePosition hinge = this.canPlaceBlock(worldIn, pos, facing.func_176734_d(), i < 0 && hitZ < 0.5f || i > 0 && hitZ > 0.5f || j < 0 && hitX > 0.5f || j > 0 && hitX < 0.5f);
        return hinge != null ? this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a(HINGE, (Comparable)((Object)hinge)) : this.func_176223_P();
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return this.canPlaceBlock(worldIn, pos, side.func_176734_d(), false) != null;
    }

    private BlockOakShutters.EnumHingePosition canPlaceBlock(World worldIn, BlockPos pos, EnumFacing direction, boolean leftHinge) {
        if (direction.func_176740_k() != EnumFacing.Axis.Y) {
            boolean canSupportLeft = BlockSmallOakShutters.canSupportShutters(worldIn, pos.func_177972_a(direction).func_177972_a(direction.func_176735_f()), direction, BlockOakShutters.EnumHingePosition.LEFT);
            if (BlockSmallOakShutters.canSupportShutters(worldIn, pos.func_177972_a(direction).func_177972_a(direction.func_176746_e()), direction, BlockOakShutters.EnumHingePosition.RIGHT)) {
                if (canSupportLeft) {
                    return leftHinge ? BlockOakShutters.EnumHingePosition.LEFT : BlockOakShutters.EnumHingePosition.RIGHT;
                }
                return BlockOakShutters.EnumHingePosition.RIGHT;
            }
            if (canSupportLeft) {
                return BlockOakShutters.EnumHingePosition.LEFT;
            }
        }
        return null;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177229_b(OPEN) != BlockOakShutters.EnumOpenPosition.CLOSED ? state.func_177226_a(OPEN, (Comparable)((Object)BlockSmallOakShutters.getOpenPosition(state, worldIn, pos))) : state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING))).func_177231_a(HINGE);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(OPEN, (Comparable)((Object)((meta & 8) > 0 ? BlockOakShutters.EnumOpenPosition.HALF : BlockOakShutters.EnumOpenPosition.CLOSED))).func_177226_a(HINGE, (Comparable)((Object)((meta & 4) > 0 ? BlockOakShutters.EnumHingePosition.RIGHT : BlockOakShutters.EnumHingePosition.LEFT))).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)).func_176735_f());
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (state.func_177229_b(OPEN) != BlockOakShutters.EnumOpenPosition.CLOSED) {
            i |= 8;
        }
        if (state.func_177229_b(HINGE) == BlockOakShutters.EnumHingePosition.RIGHT) {
            i |= 4;
        }
        return i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176746_e().func_176736_b();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, HINGE, OPEN});
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }
}

