/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.general;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dawnoftimebuilder.blocks.IBlockCustomItem;
import org.dawnoftimebuilder.blocks.general.DoTBBlockTileEntity;
import org.dawnoftimebuilder.items.IItemCanBeDried;
import org.dawnoftimebuilder.items.general.DoTBItemDryer;
import org.dawnoftimebuilder.tileentity.DoTBTileEntityDryer;

public class DoTBBlockDryer
extends DoTBBlockTileEntity
implements IBlockCustomItem {
    public static final PropertyBool SIMPLE = PropertyBool.func_177716_a((String)"simple");
    private static final PropertyBool VERTICAL_CONNECTION = PropertyBool.func_177716_a((String)"vertical_connection");
    private static final AxisAlignedBB AABB_SIMPLE = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    private static final AxisAlignedBB AABB_DOUBLE = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);

    public DoTBBlockDryer(String name, Material materialIn, float hardness, SoundType sound) {
        super(name, materialIn, hardness, sound);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)SIMPLE, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)VERTICAL_CONNECTION, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new DoTBTileEntityDryer();
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SIMPLE, VERTICAL_CONNECTION});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)SIMPLE)).booleanValue()) {
            return state.func_177226_a((IProperty)VERTICAL_CONNECTION, (Comparable)Boolean.valueOf(false));
        }
        return state.func_177226_a((IProperty)VERTICAL_CONNECTION, (Comparable)Boolean.valueOf(worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof DoTBBlockDryer));
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && this.canBlockStay(worldIn, pos);
    }

    private boolean canBlockStay(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
        if (state.func_193401_d((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID) {
            return true;
        }
        if (state.func_177230_c() instanceof DoTBBlockDryer) {
            return (Boolean)state.func_177229_b((IProperty)SIMPLE) == false;
        }
        return false;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        IBlockState iblockstate;
        if (!this.canBlockStay(worldIn, pos) && !(iblockstate = worldIn.func_180495_p(pos)).func_177230_c().isAir(iblockstate, (IBlockAccess)worldIn, pos)) {
            worldIn.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)iblockstate));
            DoTBBlockDryer.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(Item.func_150898_a((Block)this), 1));
            if (!((Boolean)state.func_177229_b((IProperty)SIMPLE)).booleanValue()) {
                DoTBBlockDryer.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(Item.func_150898_a((Block)this), 1));
            }
            worldIn.func_175698_g(pos);
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)new ItemStack(Item.func_150898_a((Block)this), 1));
        if (!((Boolean)state.func_177229_b((IProperty)SIMPLE)).booleanValue()) {
            drops.add((Object)new ItemStack(Item.func_150898_a((Block)this), 1));
        }
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tE = worldIn.func_175625_s(pos);
        if (tE instanceof DoTBTileEntityDryer) {
            DoTBTileEntityDryer tileEntity = (DoTBTileEntityDryer)tE;
            tileEntity.dropOneItem(worldIn, pos);
            tileEntity.dropOneItem(worldIn, pos);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)SIMPLE) != false ? 0 : 1;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)SIMPLE, (Comparable)Boolean.valueOf(meta == 0));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileEntity;
        if (stack.func_82837_s() && (tileEntity = worldIn.func_175625_s(pos)) instanceof TileEntityDispenser) {
            ((TileEntityDispenser)tileEntity).func_190575_a(stack.func_82833_r());
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tE;
        if (!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots && (tE = worldIn.func_175625_s(pos)) instanceof DoTBTileEntityDryer) {
            int quantityNeeded;
            DoTBTileEntityDryer tileEntity = (DoTBTileEntityDryer)tE;
            if (playerIn.func_70093_af()) {
                return tileEntity.dropOneItem(worldIn, pos);
            }
            ItemStack itemstack = playerIn.func_184586_b(hand);
            Item item = itemstack.func_77973_b();
            if (item instanceof IItemCanBeDried && (quantityNeeded = ((IItemCanBeDried)item).getItemQuantity()) <= itemstack.func_190916_E()) {
                if (tileEntity.putUndriedItem((IItemCanBeDried)item, (Boolean)state.func_177229_b((IProperty)SIMPLE), worldIn, pos)) {
                    if (!playerIn.func_184812_l_()) {
                        itemstack.func_190918_g(quantityNeeded);
                    }
                    return true;
                }
                return false;
            }
            return tileEntity.dropOneDriedItem(worldIn, pos) >= 0;
        }
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (((Boolean)(state = this.func_176221_a(state, worldIn, pos)).func_177229_b((IProperty)SIMPLE)).booleanValue()) {
            return AABB_SIMPLE;
        }
        return (Boolean)state.func_177229_b((IProperty)VERTICAL_CONNECTION) != false ? field_185505_j : AABB_DOUBLE;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public Item getCustomItemBlock() {
        return (Item)new DoTBItemDryer(this).func_77655_b(this.func_149739_a()).setRegistryName(this.getRegistryName());
    }
}

