/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.general;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.dawnoftimebuilder.DoTBUtils;
import org.dawnoftimebuilder.blocks.general.DoTBBlock;
import org.dawnoftimebuilder.enums.EnumsBlock;

public class DoTBBlockEdge
extends DoTBBlock {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyEnum<EnumsBlock.EnumHalf> HALF = PropertyEnum.func_177709_a((String)"half", EnumsBlock.EnumHalf.class);
    private static final PropertyEnum<EnumsBlock.EnumStairsShape> SHAPE = PropertyEnum.func_177709_a((String)"shape", EnumsBlock.EnumStairsShape.class);
    private static final AxisAlignedBB AABB_QTR_BOT_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 0.5);
    private static final AxisAlignedBB AABB_OCT_BOT_NW = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 0.5, 0.5);

    public DoTBBlockEdge(String name, Material materialIn, float hardness, SoundType sound) {
        super(name, materialIn, hardness, sound);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(HALF, (Comparable)((Object)EnumsBlock.EnumHalf.BOTTOM)).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.STRAIGHT)));
        this.field_149783_u = true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, HALF, SHAPE});
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        if (!p_185477_7_) {
            state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        }
        for (AxisAlignedBB axisalignedbb : DoTBBlockEdge.getCollisionBoxList(state)) {
            DoTBBlockEdge.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)axisalignedbb);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return DoTBUtils.getMainAABB(DoTBBlockEdge.getCollisionBoxList(this.func_176221_a(state, source, pos)));
    }

    private static List<AxisAlignedBB> getCollisionBoxList(IBlockState state) {
        ArrayList list = Lists.newArrayList();
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumsBlock.EnumStairsShape shape = (EnumsBlock.EnumStairsShape)((Object)state.func_177229_b(SHAPE));
        double offsetY = state.func_177229_b(HALF) == EnumsBlock.EnumHalf.BOTTOM ? 0.0 : 0.5;
        switch (shape) {
            default: {
                list.add(DoTBUtils.getRotatedAABB(AABB_QTR_BOT_NORTH, facing).func_72317_d(0.0, offsetY, 0.0));
                break;
            }
            case OUTER_LEFT: {
                list.add(DoTBUtils.getRotatedAABB(AABB_OCT_BOT_NW, facing).func_72317_d(0.0, offsetY, 0.0));
                break;
            }
            case OUTER_RIGHT: {
                list.add(DoTBUtils.getRotatedAABB(AABB_OCT_BOT_NW, facing.func_176746_e()).func_72317_d(0.0, offsetY, 0.0));
                break;
            }
            case INNER_LEFT: {
                list.add(DoTBUtils.getRotatedAABB(AABB_QTR_BOT_NORTH, facing).func_72317_d(0.0, offsetY, 0.0));
                list.add(DoTBUtils.getRotatedAABB(AABB_OCT_BOT_NW, facing.func_176735_f()).func_72317_d(0.0, offsetY, 0.0));
                break;
            }
            case INNER_RIGHT: {
                list.add(DoTBUtils.getRotatedAABB(AABB_QTR_BOT_NORTH, facing).func_72317_d(0.0, offsetY, 0.0));
                list.add(DoTBUtils.getRotatedAABB(AABB_OCT_BOT_NW, facing.func_176734_d()).func_72317_d(0.0, offsetY, 0.0));
            }
        }
        return list;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a(SHAPE, (Comparable)((Object)DoTBBlockEdge.getSmallPlateShape(state, worldIn, pos)));
    }

    private static EnumsBlock.EnumStairsShape getSmallPlateShape(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumFacing adjacentFacing;
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        IBlockState adjacentState = worldIn.func_180495_p(pos.func_177972_a(facing));
        if (DoTBBlockEdge.isBlockEdge(adjacentState) && state.func_177229_b(HALF) == adjacentState.func_177229_b(HALF) && (adjacentFacing = (EnumFacing)adjacentState.func_177229_b((IProperty)FACING)).func_176740_k() != ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k() && DoTBBlockEdge.isDifferentBlockEdge(state, worldIn, pos, adjacentFacing.func_176734_d())) {
            if (adjacentFacing == facing.func_176735_f()) {
                return EnumsBlock.EnumStairsShape.OUTER_LEFT;
            }
            return EnumsBlock.EnumStairsShape.OUTER_RIGHT;
        }
        adjacentState = worldIn.func_180495_p(pos.func_177972_a(facing.func_176734_d()));
        if (DoTBBlockEdge.isBlockEdge(adjacentState) && state.func_177229_b(HALF) == adjacentState.func_177229_b(HALF) && (adjacentFacing = (EnumFacing)adjacentState.func_177229_b((IProperty)FACING)).func_176740_k() != ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k() && DoTBBlockEdge.isDifferentBlockEdge(state, worldIn, pos, adjacentFacing)) {
            if (adjacentFacing == facing.func_176735_f()) {
                return EnumsBlock.EnumStairsShape.INNER_LEFT;
            }
            return EnumsBlock.EnumStairsShape.INNER_RIGHT;
        }
        return EnumsBlock.EnumStairsShape.STRAIGHT;
    }

    private static boolean isDifferentBlockEdge(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing facing) {
        IBlockState adjacentState = worldIn.func_180495_p(pos.func_177972_a(facing));
        return !DoTBBlockEdge.isBlockEdge(adjacentState) || adjacentState.func_177229_b((IProperty)FACING) != state.func_177229_b((IProperty)FACING) || adjacentState.func_177229_b(HALF) != state.func_177229_b(HALF);
    }

    private static boolean isBlockEdge(IBlockState state) {
        return state.func_177230_c() instanceof DoTBBlockEdge;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
        iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.STRAIGHT));
        return facing != EnumFacing.DOWN && (facing == EnumFacing.UP || (double)hitY <= 0.5) ? iblockstate.func_177226_a(HALF, (Comparable)((Object)EnumsBlock.EnumHalf.BOTTOM)) : iblockstate.func_177226_a(HALF, (Comparable)((Object)EnumsBlock.EnumHalf.TOP));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (state.func_177229_b(HALF) == EnumsBlock.EnumHalf.TOP) {
            i = 4;
        }
        return i += ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P();
        if (meta >= 4) {
            iblockstate = iblockstate.func_177226_a(HALF, (Comparable)((Object)EnumsBlock.EnumHalf.TOP));
            meta -= 4;
        }
        return iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumsBlock.EnumStairsShape shape = (EnumsBlock.EnumStairsShape)((Object)state.func_177229_b(SHAPE));
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                if (enumfacing.func_176740_k() != EnumFacing.Axis.Z) break;
                switch (shape) {
                    case OUTER_LEFT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.OUTER_RIGHT));
                    }
                    case OUTER_RIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.OUTER_LEFT));
                    }
                    case INNER_RIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.INNER_LEFT));
                    }
                    case INNER_LEFT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.INNER_RIGHT));
                    }
                }
                return state.func_185907_a(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (enumfacing.func_176740_k() != EnumFacing.Axis.X) break;
                switch (shape) {
                    case OUTER_LEFT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.OUTER_RIGHT));
                    }
                    case OUTER_RIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.OUTER_LEFT));
                    }
                    case INNER_RIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.INNER_RIGHT));
                    }
                    case INNER_LEFT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.INNER_LEFT));
                    }
                    case STRAIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return state;
    }
}

