/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.general;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockWall;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.dawnoftimebuilder.DoTBUtils;
import org.dawnoftimebuilder.blocks.general.DoTBBlock;
import org.dawnoftimebuilder.blocks.general.DoTBBlockBeam;
import org.dawnoftimebuilder.blocks.general.DoTBBlockWall;
import org.dawnoftimebuilder.enums.EnumsBlock;

public class DoTBBlockSupportBeam
extends DoTBBlock {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.75, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB AABB_BEAM_X = new AxisAlignedBB(0.0, 0.25, 0.25, 1.0, 0.75, 0.75);
    private static final AxisAlignedBB AABB_BEAM_Z = new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 1.0);
    private static final AxisAlignedBB AABB_FOUR_PX = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.75, 0.625);
    private static final AxisAlignedBB AABB_EIGHT_PX = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.75, 0.75);
    private static final AxisAlignedBB AABB_TEN_PX = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.75, 0.8125);
    private static final PropertyEnum<EnumsBlock.EnumUnderConnection> UNDER = PropertyEnum.func_177709_a((String)"under", EnumsBlock.EnumUnderConnection.class);
    static final PropertyEnum<EnumsBlock.EnumHorizontalAxis> AXIS = PropertyEnum.func_177709_a((String)"axis", EnumsBlock.EnumHorizontalAxis.class);

    public DoTBBlockSupportBeam(String name, Material materialIn, float hardness, SoundType sound) {
        super(name, materialIn, hardness, sound);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(AXIS, (Comparable)((Object)EnumsBlock.EnumHorizontalAxis.AXIS_X)).func_177226_a(UNDER, (Comparable)((Object)EnumsBlock.EnumUnderConnection.NOTHING)));
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        if (!p_185477_7_) {
            state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        }
        for (AxisAlignedBB axisalignedbb : this.getCollisionBoxList(state)) {
            DoTBBlockSupportBeam.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)axisalignedbb);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return DoTBUtils.getMainAABB(this.getCollisionBoxList(this.func_176221_a(state, source, pos)));
    }

    public List<AxisAlignedBB> getCollisionBoxList(IBlockState state) {
        ArrayList list = Lists.newArrayList();
        list.add(AABB);
        list.add(state.func_177229_b(AXIS) == EnumsBlock.EnumHorizontalAxis.AXIS_X ? AABB_BEAM_X : AABB_BEAM_Z);
        switch ((EnumsBlock.EnumUnderConnection)((Object)state.func_177229_b(UNDER))) {
            case FOUR_PX: {
                list.add(AABB_FOUR_PX);
                break;
            }
            case EIGHT_PX: {
                list.add(AABB_EIGHT_PX);
                break;
            }
            case TEN_PX: {
                list.add(AABB_TEN_PX);
                break;
            }
        }
        return list;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXIS, UNDER});
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)((Object)(placer.func_174811_aO().func_176740_k() == EnumFacing.Axis.X ? EnumsBlock.EnumHorizontalAxis.AXIS_X : EnumsBlock.EnumHorizontalAxis.AXIS_Z)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        Block blockUnder = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (blockUnder instanceof BlockFence) {
            return state.func_177226_a(UNDER, (Comparable)((Object)EnumsBlock.EnumUnderConnection.FOUR_PX));
        }
        if (blockUnder instanceof BlockWall || blockUnder instanceof DoTBBlockWall) {
            return state.func_177226_a(UNDER, (Comparable)((Object)EnumsBlock.EnumUnderConnection.EIGHT_PX));
        }
        if (blockUnder instanceof DoTBBlockBeam && ((EnumFacing.Axis)worldIn.func_180495_p(pos.func_177977_b()).func_177229_b(DoTBBlockBeam.MAIN_AXIS)).func_176720_b()) {
            return state.func_177226_a(UNDER, (Comparable)((Object)EnumsBlock.EnumUnderConnection.TEN_PX));
        }
        return state.func_177226_a(UNDER, (Comparable)((Object)EnumsBlock.EnumUnderConnection.NOTHING));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP;
    }

    public boolean func_185481_k(IBlockState state) {
        return true;
    }

    public int func_176201_c(IBlockState state) {
        return state.func_177229_b(AXIS) == EnumsBlock.EnumHorizontalAxis.AXIS_X ? 0 : 8;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)((Object)(meta < 8 ? EnumsBlock.EnumHorizontalAxis.AXIS_X : EnumsBlock.EnumHorizontalAxis.AXIS_Z)));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return rot == Rotation.CLOCKWISE_180 ? state : state.func_177226_a(AXIS, (Comparable)((Object)(state.func_177229_b(AXIS) == EnumsBlock.EnumHorizontalAxis.AXIS_X ? EnumsBlock.EnumHorizontalAxis.AXIS_Z : EnumsBlock.EnumHorizontalAxis.AXIS_X)));
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing side) {
        switch (side) {
            case DOWN: {
                state = this.func_176221_a(state, worldIn, pos);
                switch ((EnumsBlock.EnumUnderConnection)((Object)state.func_177229_b(UNDER))) {
                    case FOUR_PX: {
                        return BlockFaceShape.CENTER;
                    }
                    case EIGHT_PX: 
                    case TEN_PX: {
                        return BlockFaceShape.CENTER_BIG;
                    }
                }
                return BlockFaceShape.UNDEFINED;
            }
            case UP: {
                return BlockFaceShape.SOLID;
            }
        }
        return BlockFaceShape.UNDEFINED;
    }
}

