/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.japanese;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.dawnoftimebuilder.blocks.IBlockFlowerGen;
import org.dawnoftimebuilder.blocks.general.DoTBBlockDoubleCrops;
import org.dawnoftimebuilder.entities.EntitySilkmoth;
import org.dawnoftimebuilder.enums.EnumsBlock;
import org.dawnoftimebuilder.items.DoTBItems;

public class BlockMulberry
extends DoTBBlockDoubleCrops
implements IBlockFlowerGen {
    private static final AxisAlignedBB AABB_LEVEL_0 = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.5, 0.625);
    private static final AxisAlignedBB AABB_LEVEL_1 = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    private static final AxisAlignedBB AABB_BOTTOM = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    private static final AxisAlignedBB AABB_LEVEL_2 = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.3125, 0.75);
    private static final AxisAlignedBB AABB_LEVEL_3 = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.6875, 1.0);
    private static final PropertyInteger AGE_LOWER = PropertyInteger.func_177719_a((String)"age", (int)0, (int)4);
    private static final PropertyBool CUT = PropertyBool.func_177716_a((String)"cut");

    public BlockMulberry() {
        super("mulberry", (Block)Blocks.field_150349_c);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)AGE_LOWER, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)CUT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)HALF, (Comparable)((Object)EnumsBlock.EnumHalf.BOTTOM)));
    }

    @Override
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        if (!worldIn.field_72995_K) {
            BlockPos spawnPos;
            int dayTime = (int)(worldIn.func_72820_D() % 23999L);
            int bound = 900;
            if (dayTime >= 12000) {
                if (dayTime <= 20000) {
                    bound /= 6;
                }
                if (dayTime <= 16000) {
                    bound /= 2;
                }
                if (dayTime <= 13800) {
                    bound /= 5;
                }
            }
            if (rand.nextInt(bound) == 0 && !this.isBottomCrop((IBlockAccess)worldIn, pos) && worldIn.func_180495_p(spawnPos = new BlockPos(pos.func_177958_n() - 3 + rand.nextInt(7), pos.func_177956_o() - 1 + rand.nextInt(3), pos.func_177952_p() - 3 + rand.nextInt(7))).func_185890_d((IBlockAccess)worldIn, spawnPos) == field_185506_k) {
                EntitySilkmoth entity = new EntitySilkmoth(worldIn);
                entity.func_70107_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() + 0.5, (double)spawnPos.func_177952_p() + 0.5);
                worldIn.func_72838_d((Entity)entity);
            }
        }
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177229_b((IProperty)HALF) == EnumsBlock.EnumHalf.TOP) {
            switch (this.func_185527_x(state)) {
                default: {
                    return AABB_LEVEL_2;
                }
                case 3: {
                    return (Boolean)state.func_177229_b((IProperty)CUT) != false ? field_185505_j : AABB_LEVEL_3;
                }
                case 4: 
            }
            return field_185505_j;
        }
        switch (this.func_185527_x(state)) {
            case 0: {
                return AABB_LEVEL_0;
            }
            case 1: {
                return AABB_LEVEL_1;
            }
        }
        return AABB_BOTTOM;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return this.func_185527_x(state) == 0 ? field_185506_k : this.func_185496_a(state, worldIn, pos);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE_LOWER, CUT, HALF});
    }

    @Override
    public int getAgeReachingTopBlock() {
        return 2;
    }

    protected PropertyInteger func_185524_e() {
        return AGE_LOWER;
    }

    @Override
    public IBlockState setAge(IBlockState state, int age) {
        return state.func_177226_a((IProperty)AGE_LOWER, (Comparable)Integer.valueOf(age));
    }

    public int func_185526_g() {
        return 4;
    }

    protected Item func_149866_i() {
        return DoTBItems.mulberry;
    }

    protected Item func_149865_P() {
        return DoTBItems.mulberry_leaves;
    }

    @Override
    public void getDoubleCropsDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand;
        drops.add((Object)new ItemStack(Items.field_151055_y, 1));
        drops.add((Object)new ItemStack(Items.field_151055_y, 1));
        for (int i = (int)Math.floor((double)((Integer)state.func_177229_b((IProperty)this.func_185524_e()) + 1) / 3.0); i > 0; --i) {
            drops.add((Object)new ItemStack(this.func_149865_P(), 1));
        }
        if (this.func_185525_y(state) && (rand = new Random()).nextInt(2) == 0) {
            drops.add((Object)new ItemStack(this.func_149866_i(), 1));
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.func_185525_y(state) && !worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {
            int i;
            boolean holdShears;
            ItemStack itemstack = playerIn.func_184586_b(hand);
            boolean bl = holdShears = itemstack.func_77973_b() == Items.field_151097_aZ;
            if (holdShears) {
                itemstack.func_77972_a(1, (EntityLivingBase)playerIn);
            }
            int n = i = holdShears ? 3 : 2;
            while (i > 0) {
                BlockMulberry.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(this.func_149865_P(), 1));
                --i;
            }
            Random rand = new Random();
            if (rand.nextInt(2) == 0) {
                BlockMulberry.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(this.func_149866_i(), 1));
            }
            worldIn.func_184133_a(null, pos, SoundEvents.field_187571_bR, SoundCategory.BLOCKS, 1.0f, 1.0f);
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE_LOWER, (Comparable)Integer.valueOf(3)).func_177226_a((IProperty)CUT, (Comparable)Boolean.valueOf(true)));
            if (state.func_177229_b((IProperty)HALF) == EnumsBlock.EnumHalf.BOTTOM) {
                worldIn.func_175656_a(pos.func_177984_a(), state.func_177226_a((IProperty)AGE_LOWER, (Comparable)Integer.valueOf(3)).func_177226_a((IProperty)CUT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)HALF, (Comparable)((Object)EnumsBlock.EnumHalf.TOP)));
            } else {
                worldIn.func_175656_a(pos.func_177977_b(), state.func_177226_a((IProperty)AGE_LOWER, (Comparable)Integer.valueOf(3)).func_177226_a((IProperty)CUT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)HALF, (Comparable)((Object)EnumsBlock.EnumHalf.BOTTOM)));
            }
            return true;
        }
        return false;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        if (meta >= 8) {
            state = state.func_177226_a((IProperty)HALF, (Comparable)((Object)EnumsBlock.EnumHalf.TOP));
            meta -= 8;
        }
        if (meta == 5) {
            state = state.func_177226_a((IProperty)CUT, (Comparable)Boolean.valueOf(true));
            meta = 3;
        }
        return state.func_177226_a((IProperty)AGE_LOWER, (Comparable)Integer.valueOf(meta));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int meta = this.func_185527_x(state);
        if (((Boolean)state.func_177229_b((IProperty)CUT)).booleanValue()) {
            meta = 5;
        }
        if (state.func_177229_b((IProperty)HALF) == EnumsBlock.EnumHalf.TOP) {
            meta += 8;
        }
        return meta;
    }

    @Override
    public List<String> getAcceptedBiomes() {
        return Arrays.asList("taiga_hills", "taiga", "redwood_taiga", "redwood_taiga_hills", "mutated_forest");
    }

    @Override
    public void spawnInWorld(World world, BlockPos pos, Random rand) {
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150349_c) {
            boolean canGrow;
            boolean bl = canGrow = world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150350_a;
            if (canGrow) {
                int age = rand.nextInt(5);
                world.func_180501_a(pos, this.func_185528_e(age).func_177226_a((IProperty)HALF, (Comparable)((Object)EnumsBlock.EnumHalf.BOTTOM)), 2);
                if (age >= this.getAgeReachingTopBlock()) {
                    world.func_180501_a(pos.func_177984_a(), this.func_185528_e(age).func_177226_a((IProperty)HALF, (Comparable)((Object)EnumsBlock.EnumHalf.TOP)), 2);
                }
            } else {
                world.func_175656_a(pos, this.func_185528_e(rand.nextInt(2)));
            }
        }
    }

    @Override
    public int getPatchSize() {
        return 6;
    }

    @Override
    public int getPatchChance() {
        return 30;
    }

    @Override
    public int getPatchQuantity() {
        return 2;
    }

    @Override
    public int getPatchDensity() {
        return 4;
    }
}

