/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.japanese;

import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.dawnoftimebuilder.blocks.DoTBBlocks;
import org.dawnoftimebuilder.blocks.general.DoTBBlock;

public class BlockSmallTatamiMat
extends DoTBBlock {
    private static final AxisAlignedBB CARPET_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);

    public BlockSmallTatamiMat() {
        super("small_tatami_mat", Material.field_151593_r);
        this.setBurnable();
        this.func_180632_j(this.field_176227_L.func_177621_b());
        this.func_149672_a(SoundType.field_185854_g);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CARPET_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && this.canBlockStay(worldIn, pos);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.tryMergingWithSprucePlanks(worldIn, pos);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkForDrop(worldIn, pos, state);
        this.tryMergingWithSprucePlanks(worldIn, pos);
    }

    private void tryMergingWithSprucePlanks(World worldIn, BlockPos pos) {
        IBlockState stateDown = worldIn.func_180495_p(pos.func_177977_b());
        Block blockDown = stateDown.func_177230_c();
        if (blockDown == Blocks.field_150344_f && stateDown.func_177229_b((IProperty)BlockPlanks.field_176383_a) == BlockPlanks.EnumType.SPRUCE) {
            worldIn.func_175698_g(pos);
            worldIn.func_175656_a(pos.func_177977_b(), DoTBBlocks.small_tatami_floor.func_176223_P());
        }
    }

    private void checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    private boolean canBlockStay(World worldIn, BlockPos pos) {
        IBlockState stateDown = worldIn.func_180495_p(pos.func_177977_b());
        return stateDown.func_193401_d((IBlockAccess)worldIn, pos, EnumFacing.UP) != BlockFaceShape.UNDEFINED && stateDown.func_177230_c() != DoTBBlocks.tatami_floor && stateDown.func_177230_c() != DoTBBlocks.small_tatami_floor;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing facing) {
        return facing == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }
}

