/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.client.gui.creative;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.dawnoftimebuilder.DawnOfTimeBuilder;
import org.dawnoftimebuilder.client.gui.creative.CreativeInventoryCategories;
import org.dawnoftimebuilder.client.gui.creative.GroupButtons;
import org.dawnoftimebuilder.client.gui.creative.PageButtons;

public class CreativeInventoryDrawEvent {
    private List<GroupButtons> buttons = new ArrayList<GroupButtons>();
    private PageButtons upArrow = null;
    private PageButtons downArrow = null;
    private CreativeInventoryCategories selectedCategory;
    private int page = 0;

    private int getMaxPages() {
        return (int)Math.ceil((double)CreativeInventoryCategories.values().length / 4.0);
    }

    private int getCurrentPage() {
        return this.page + 1;
    }

    @SubscribeEvent
    public void onDrawGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof GuiContainerCreative) {
            if (!this.buttons.isEmpty()) {
                event.getButtonList().removeAll(this.buttons);
                this.buttons.clear();
            }
            int leftPos = ((GuiContainerCreative)event.getGui()).getGuiLeft();
            int upPos = ((GuiContainerCreative)event.getGui()).getGuiTop();
            for (int i = 0; i < CreativeInventoryCategories.values().length; ++i) {
                int tabPosition = i % 4;
                int height = upPos + tabPosition * 28 + tabPosition * 2 + 10;
                GroupButtons button = new GroupButtons(44, leftPos - 31, height, 31, 28, CreativeInventoryCategories.values()[i]);
                this.buttons.add(button);
                event.getButtonList().add(button);
            }
            if (this.getMaxPages() > 1) {
                this.upArrow = new PageButtons(44, leftPos - 17, upPos, true);
                this.downArrow = new PageButtons(44, leftPos - 17, upPos + 130, false);
                event.getButtonList().add(this.upArrow);
                event.getButtonList().add(this.downArrow);
            }
        }
    }

    @SubscribeEvent
    public void onDrawGui(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.getGui() instanceof GuiContainerCreative) {
            GuiContainerCreative gui = (GuiContainerCreative)event.getGui();
            if (gui.func_147056_g() == DawnOfTimeBuilder.DOTB_TAB.func_78021_a()) {
                int startIndex;
                this.buttons.forEach(button -> {
                    button.field_146125_m = false;
                });
                for (int i = startIndex = 4 * this.page; i < startIndex + 4; ++i) {
                    if (i > this.buttons.size() - 1) continue;
                    GroupButtons button2 = this.buttons.get(i);
                    button2.field_146125_m = true;
                }
                if (this.upArrow != null) {
                    this.upArrow.field_146125_m = true;
                    this.downArrow.field_146125_m = true;
                    if (this.getCurrentPage() == 1) {
                        this.upArrow.field_146125_m = false;
                    }
                    if (this.getCurrentPage() == this.getMaxPages()) {
                        this.downArrow.field_146125_m = false;
                    }
                }
            } else {
                this.buttons.forEach(button -> {
                    button.field_146125_m = false;
                });
                if (this.upArrow != null) {
                    this.upArrow.field_146125_m = false;
                    this.downArrow.field_146125_m = false;
                }
            }
        }
    }

    @SubscribeEvent
    public void onClick(GuiScreenEvent.ActionPerformedEvent.Post event) {
        if (event.getGui() instanceof GuiContainerCreative) {
            if (event.getButton() instanceof GroupButtons) {
                GroupButtons button = (GroupButtons)event.getButton();
                this.buttons.forEach(GroupButtons::deSelect);
                button.setSelected();
                this.selectedCategory = button.getCategory();
                this.updateCreativeItems((GuiContainerCreative)event.getGui());
            } else if (event.getButton() instanceof PageButtons) {
                PageButtons buttons = (PageButtons)event.getButton();
                this.page = buttons.isUp() ? --this.page : ++this.page;
            }
        }
    }

    private void updateCreativeItems(GuiContainerCreative containerCreative) {
        if (containerCreative.func_147056_g() == DawnOfTimeBuilder.DOTB_TAB.func_78021_a()) {
            GuiContainerCreative.ContainerCreative creativeInv = (GuiContainerCreative.ContainerCreative)containerCreative.field_147002_h;
            creativeInv.field_148330_a.clear();
            if (this.selectedCategory != null) {
                this.selectedCategory.getItems().forEach(item -> item.func_150895_a(DawnOfTimeBuilder.DOTB_TAB, creativeInv.field_148330_a));
            }
            creativeInv.func_148329_a(0.0f);
        }
    }
}

