/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.entities;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.dawnoftimebuilder.registries.DoTBEntitiesRegistry;

public class EntityJapaneseDragon
extends EntityCreature {
    private static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(EntityJapaneseDragon.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ANGLE = EntityDataManager.func_187226_a(EntityJapaneseDragon.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ANIM_DURATION = EntityDataManager.func_187226_a(EntityJapaneseDragon.class, (DataSerializer)DataSerializers.field_187193_c);
    private float previousTickAge = 0.0f;
    private float animationLoop = 0.0f;

    public EntityJapaneseDragon(World worldIn) {
        super(worldIn);
        this.field_70765_h = new JapaneseDragonMoveHelper(this);
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.6f;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData data) {
        float size = (float)this.field_70146_Z.nextGaussian();
        size = size < 0.0f ? -1.0f / (size - 1.0f) : (float)(1.0 + Math.min((double)size * 0.5, 15.0));
        this.setDragonSize(size);
        this.field_70728_aV = (int)Math.ceil(100.0f * size);
        this.setAnimDuration(10.0f);
        return super.func_180482_a(difficulty, data);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(ANGLE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ANIM_DURATION, (Object)Float.valueOf(50.0f));
    }

    private void setDragonSize(float size) {
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(size));
    }

    public float getDragonSize() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
    }

    private float getSpeed() {
        return 0.4f + this.getDragonSize();
    }

    private void setHeadTargetAngle(float angle) {
        this.field_70180_af.func_187227_b(ANGLE, (Object)Float.valueOf(angle / 2.0f + this.getHeadTargetAngle() / 2.0f));
    }

    public float getHeadTargetAngle() {
        return ((Float)this.field_70180_af.func_187225_a(ANGLE)).floatValue();
    }

    private void setAnimDuration(float factor) {
        this.field_70180_af.func_187227_b(ANIM_DURATION, (Object)Float.valueOf(factor * (5.0f + this.getDragonSize())));
    }

    private float getAnimDuration() {
        return ((Float)this.field_70180_af.func_187225_a(ANIM_DURATION)).floatValue();
    }

    public float getAnimationLoop(float tickAge) {
        float f = (tickAge - this.previousTickAge) / this.getAnimDuration();
        this.previousTickAge = tickAge;
        this.animationLoop = (this.animationLoop + f) % 2.0f;
        return this.animationLoop;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        float size = compound.func_74760_g("JapaneseDragonSize");
        if (size > 0.0f) {
            this.setDragonSize(size);
            this.setAnimDuration(10.0f);
            this.field_70728_aV = (int)Math.ceil(100.0f * size);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74776_a("JapaneseDragonSize", this.getDragonSize());
        super.func_70014_b(compound);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIVerticalFlyUp(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIVerticalFlyDown(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AILongFly(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIWanderFly(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 20.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa < 5) {
            float size = this.getDragonSize();
            this.func_70105_a(size * 1.1f, size * 1.1f);
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public boolean func_189652_ae() {
        return true;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return DoTBEntitiesRegistry.LT_SILKMOTH;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(60.0 * (double)this.getDragonSize());
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0 + 2.0 * (double)this.getDragonSize());
    }

    protected float func_70599_aP() {
        return this.getDragonSize();
    }

    protected float func_70647_i() {
        return super.func_70647_i() * this.getDragonSize();
    }

    @Nullable
    public SoundEvent func_184639_G() {
        return this.field_70146_Z.nextInt(4) != 0 ? null : SoundEvents.field_187521_aK;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187526_aP;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187525_aO;
    }

    static class JapaneseDragonMoveHelper
    extends EntityMoveHelper {
        private final EntityJapaneseDragon parentEntity;

        JapaneseDragonMoveHelper(EntityJapaneseDragon dragon) {
            super((EntityLiving)dragon);
            this.parentEntity = dragon;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double distanceX = this.field_75646_b - this.parentEntity.field_70165_t;
                double distanceY = this.field_75647_c - this.parentEntity.field_70163_u;
                double distanceZ = this.field_75644_d - this.parentEntity.field_70161_v;
                double distance = distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ;
                if (distance < 1.0) {
                    this.stopMovement();
                    return;
                }
                distance = MathHelper.func_76133_a((double)distance);
                float rotation = (float)(MathHelper.func_181159_b((double)distanceZ, (double)distanceX) * 57.29577951308232) - 90.0f;
                this.parentEntity.field_70177_z = this.func_75639_a(this.parentEntity.field_70177_z, rotation, 90.0f);
                this.parentEntity.field_70159_w = (double)0.2f * MathHelper.func_151237_a((double)(distanceX / distance), (double)-1.0, (double)1.0) * this.field_75645_e * this.parentEntity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
                this.parentEntity.field_70181_x = (double)0.2f * MathHelper.func_151237_a((double)(distanceY / distance), (double)-1.0, (double)1.0) * this.field_75645_e * this.parentEntity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
                this.parentEntity.field_70179_y = (double)0.2f * MathHelper.func_151237_a((double)(distanceZ / distance), (double)-1.0, (double)1.0) * this.field_75645_e * this.parentEntity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
                double d = Math.asin(MathHelper.func_151237_a((double)(distanceY / distance), (double)-1.0, (double)1.0));
                this.parentEntity.setHeadTargetAngle((float)(d *= 1.0 - 1.0 / ((distance + 1.0) / 2.0)));
                if (!this.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, distance)) {
                    this.stopMovement();
                }
            }
        }

        private void stopMovement() {
            this.field_188491_h = EntityMoveHelper.Action.WAIT;
            this.parentEntity.func_191989_p(0.0f);
            this.parentEntity.func_70657_f(0.0f);
            this.parentEntity.setAnimDuration(14.0f);
        }

        private boolean isNotColliding(double x, double y, double z, double distance) {
            double d0 = (x - this.parentEntity.field_70165_t) / distance;
            double d1 = (y - this.parentEntity.field_70163_u) / distance;
            double d2 = (z - this.parentEntity.field_70161_v) / distance;
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            int i = 1;
            while ((double)i < distance) {
                if (!this.parentEntity.field_70170_p.func_184144_a((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_72317_d(d0, d1, d2)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    static class AILongFly
    extends EntityAIBase {
        private final EntityJapaneseDragon parentEntity;

        AILongFly(EntityJapaneseDragon dragon) {
            this.parentEntity = dragon;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            if (this.parentEntity.func_110167_bD()) {
                return false;
            }
            if (this.parentEntity.field_70163_u < 100.0) {
                return false;
            }
            if (this.parentEntity.func_70605_aq().field_188491_h != EntityMoveHelper.Action.WAIT) {
                return false;
            }
            BlockPos pos = new BlockPos(this.parentEntity.field_70165_t, this.parentEntity.field_70163_u, this.parentEntity.field_70161_v);
            return this.parentEntity.field_70170_p.func_175678_i(pos);
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            double newX = this.parentEntity.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 500.0f);
            double newZ = this.parentEntity.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 500.0f);
            this.parentEntity.func_70605_aq().func_75642_a(newX, this.parentEntity.field_70163_u, newZ, (double)(this.parentEntity.getSpeed() * 2.5f));
            this.parentEntity.setAnimDuration(5.0f);
        }
    }

    static class AIWanderFly
    extends EntityAIBase {
        private final EntityJapaneseDragon parentEntity;

        AIWanderFly(EntityJapaneseDragon dragon) {
            this.parentEntity = dragon;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double distanceZ;
            double distanceY;
            if (this.parentEntity.func_110167_bD()) {
                return false;
            }
            if (this.parentEntity.func_70654_ax() >= 100) {
                return false;
            }
            if (this.parentEntity.func_70681_au().nextInt(60) != 0) {
                return false;
            }
            EntityMoveHelper entitymovehelper = this.parentEntity.func_70605_aq();
            if (!entitymovehelper.func_75640_a()) {
                return true;
            }
            double distanceX = entitymovehelper.func_179917_d() - this.parentEntity.field_70165_t;
            double diagonalSquare = distanceX * distanceX + (distanceY = entitymovehelper.func_179919_e() - this.parentEntity.field_70163_u) * distanceY + (distanceZ = entitymovehelper.func_179918_f() - this.parentEntity.field_70161_v) * distanceZ;
            return diagonalSquare < 1.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            double newX = this.parentEntity.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double newZ = this.parentEntity.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            World world = this.parentEntity.field_70170_p;
            for (double newY = this.parentEntity.field_70163_u - 16.0; newY <= this.parentEntity.field_70163_u + 16.0; newY += 1.0) {
                BlockPos pos = new BlockPos(newX, newY, newZ);
                if (world.func_180495_p(pos).func_185890_d((IBlockAccess)world, pos) != Block.field_185506_k || world.func_180495_p(pos).func_185904_a().func_76224_d() || world.func_147447_a(new Vec3d(this.parentEntity.field_70165_t, this.parentEntity.field_70163_u, this.parentEntity.field_70161_v), new Vec3d(newX, newY + (double)this.parentEntity.getDragonSize(), newZ), true, true, false) != null) continue;
                this.parentEntity.func_70605_aq().func_75642_a(newX, newY + (double)this.parentEntity.getDragonSize(), newZ, (double)this.parentEntity.getSpeed());
                return;
            }
            this.parentEntity.func_70605_aq().func_75642_a(newX, this.parentEntity.field_70163_u, newZ, (double)this.parentEntity.getSpeed());
            this.parentEntity.setAnimDuration(10.0f);
        }
    }

    static class AIVerticalFlyDown
    extends EntityAIBase {
        private final EntityJapaneseDragon parentEntity;
        private int goalY = 100;

        AIVerticalFlyDown(EntityJapaneseDragon dragon) {
            this.parentEntity = dragon;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            if (this.parentEntity.func_110167_bD()) {
                return false;
            }
            if (this.parentEntity.field_70163_u < 100.0) {
                return false;
            }
            if (this.parentEntity.func_70681_au().nextInt(100) != 0) {
                return false;
            }
            World world = this.parentEntity.field_70170_p;
            BlockPos pos = new BlockPos(this.parentEntity.field_70165_t, 90.0, this.parentEntity.field_70161_v);
            if (world.func_180495_p(pos).func_185890_d((IBlockAccess)world, pos) == Block.field_185506_k && !world.func_180495_p(pos).func_185904_a().func_76224_d()) {
                return false;
            }
            int newY = world.func_175726_f(new BlockPos(this.parentEntity.field_70165_t, this.parentEntity.field_70163_u, this.parentEntity.field_70161_v)).func_76625_h();
            for (int y = newY + 16; y >= newY && world.func_180495_p(pos = new BlockPos(this.parentEntity.field_70165_t, (double)y, this.parentEntity.field_70161_v)).func_185890_d((IBlockAccess)world, pos) == Block.field_185506_k && !world.func_180495_p(pos).func_185904_a().func_76224_d(); --y) {
            }
            if ((double)(newY + 11) >= this.parentEntity.field_70163_u) {
                return false;
            }
            this.goalY = newY + 1;
            return true;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            this.parentEntity.func_70605_aq().func_75642_a(this.parentEntity.field_70165_t, (double)((float)this.goalY + this.parentEntity.getDragonSize()), this.parentEntity.field_70161_v, (double)this.parentEntity.getSpeed() * 1.2);
            this.parentEntity.setAnimDuration(8.0f);
        }
    }

    static class AIVerticalFlyUp
    extends EntityAIBase {
        private final EntityJapaneseDragon parentEntity;

        AIVerticalFlyUp(EntityJapaneseDragon dragon) {
            this.parentEntity = dragon;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            if (this.parentEntity.func_110167_bD()) {
                return false;
            }
            if (this.parentEntity.func_70654_ax() >= 100) {
                return false;
            }
            BlockPos pos = new BlockPos(this.parentEntity.field_70165_t, this.parentEntity.field_70163_u, this.parentEntity.field_70161_v);
            if (!this.parentEntity.field_70170_p.func_175678_i(pos)) {
                return false;
            }
            if (this.parentEntity.func_70681_au().nextInt(300) != 0) {
                return false;
            }
            if (this.parentEntity.func_70605_aq().field_188491_h == EntityMoveHelper.Action.WAIT && this.parentEntity.func_70681_au().nextInt(1000) == 0) {
                return true;
            }
            return this.parentEntity.field_70163_u < 100.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            this.parentEntity.func_70605_aq().func_75642_a(this.parentEntity.field_70165_t, 100.0 + 30.0 * this.parentEntity.func_70681_au().nextDouble(), this.parentEntity.field_70161_v, (double)this.parentEntity.getSpeed() * 1.2);
            this.parentEntity.setAnimDuration(8.0f);
        }
    }
}

