/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.entities;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.dawnoftimebuilder.blocks.japanese.BlockMulberry;
import org.dawnoftimebuilder.registries.DoTBEntitiesRegistry;

public class EntitySilkmoth
extends EntityAmbientCreature {
    private BlockPos rotationPos = new BlockPos(0, 0, 0);
    private boolean clockwise;
    private float distance;

    public EntitySilkmoth(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.3f, 0.3f);
        this.field_191988_bg = 0.5f;
        this.clockwise = this.field_70146_Z.nextBoolean();
        this.distance = 0.5f + 2.0f * this.field_70146_Z.nextFloat();
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.rotationPos = new BlockPos(compound.func_74762_e("SilkmothRotationX"), compound.func_74762_e("SilkmothRotationY"), compound.func_74762_e("SilkmothRotationZ"));
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("SilkmothRotationX", this.rotationPos.func_177958_n());
        compound.func_74768_a("SilkmothRotationY", this.rotationPos.func_177956_o());
        compound.func_74768_a("SilkmothRotationZ", this.rotationPos.func_177952_p());
        super.func_70014_b(compound);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            double alpha;
            if (this.field_70173_aa >= 24000 && !this.func_145818_k_()) {
                this.func_70106_y();
            }
            if (this.field_70173_aa < 5) {
                if (this.rotationPos.func_177958_n() == 0 && this.rotationPos.func_177956_o() == 0 && this.rotationPos.func_177952_p() == 0) {
                    this.rotationPos = new BlockPos(Math.floor(this.field_70165_t), Math.floor(this.field_70163_u), Math.floor(this.field_70161_v));
                }
            } else if (this.field_70146_Z.nextInt(1000) == 0) {
                this.changeRotationPos();
            }
            double x = this.field_70165_t - ((double)this.rotationPos.func_177958_n() + 0.5);
            double z = this.field_70161_v - ((double)this.rotationPos.func_177952_p() + 0.5);
            if (z == 0.0) {
                alpha = x > 0.0 ? 0.0 : Math.PI;
            } else {
                alpha = Math.atan(z / x);
                if (x > 0.0) {
                    alpha += Math.PI;
                }
            }
            double d = Math.sqrt(x * x + z * z);
            d = (double)(-this.distance * 2.0f) / (d + (double)this.distance) + 1.0;
            this.field_70159_w = this.field_70159_w * 0.5 + Math.cos(alpha += (this.clockwise ? d - 1.0 : 1.0 - d) * Math.PI / 2.0) * 0.15;
            this.field_70181_x = Math.sin((double)this.field_70173_aa / 20.0) * 0.05;
            this.field_70179_y = this.field_70179_y * 0.5 + Math.sin(alpha) * 0.15;
            this.field_70177_z = (float)MathHelper.func_76138_g((double)(180.0 * alpha / Math.PI - 90.0));
            this.field_70759_as = 0.0f;
            this.field_70125_A = (float)(-this.field_70181_x) * 5.0f * 90.0f;
        }
    }

    private void changeRotationPos() {
        int x = (int)this.field_70170_p.func_72820_D() % 23999;
        boolean isNight = x > 12000 && x < 23000;
        x = (int)this.field_70165_t - 5;
        int y = (int)this.field_70163_u - 1;
        int z = (int)this.field_70161_v - 5;
        ArrayList<BlockPos> listMulberry = new ArrayList<BlockPos>();
        ArrayList<BlockPos> listLight = new ArrayList<BlockPos>();
        for (int i = 0; i < 11; ++i) {
            for (int j = 0; j < 11; ++j) {
                for (int k = 0; k < 3; ++k) {
                    BlockPos pos = new BlockPos(x + i, y + k, z + j);
                    IBlockState state = this.field_70170_p.func_180495_p(pos);
                    if (state.func_177230_c() instanceof BlockMulberry) {
                        if (((BlockMulberry)state.func_177230_c()).isBottomCrop((IBlockAccess)this.field_70170_p, pos)) continue;
                        listMulberry.add(pos);
                        continue;
                    }
                    if (!isNight || state.getLightValue((IBlockAccess)this.field_70170_p, pos) < 14) continue;
                    listLight.add(pos);
                }
            }
        }
        this.rotationPos = !listLight.isEmpty() ? (BlockPos)listLight.get(this.field_70146_Z.nextInt(listLight.size())) : (!listMulberry.isEmpty() ? (BlockPos)listMulberry.get(this.field_70146_Z.nextInt(listMulberry.size())) : new BlockPos(x + this.field_70146_Z.nextInt(11), y + this.field_70146_Z.nextInt(3), z + this.field_70146_Z.nextInt(11)));
        this.distance = 0.5f + 2.0f * this.field_70146_Z.nextFloat();
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public boolean func_145773_az() {
        return true;
    }

    public float func_70047_e() {
        return this.field_70131_O / 2.0f;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return DoTBEntitiesRegistry.LT_SILKMOTH;
    }

    public boolean func_175446_cd() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3.0);
    }

    protected float func_70599_aP() {
        return 0.1f;
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.95f;
    }

    @Nullable
    public SoundEvent func_184639_G() {
        return this.field_70146_Z.nextInt(4) != 0 ? null : SoundEvents.field_187816_ej;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187822_em;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187820_el;
    }
}

